/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability.faults;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.WsrmProtocolUtils;
import weblogic.wsee.reliability.faults.IllegalRMVersionFaultMsg;
import weblogic.wsee.reliability.faults.InvalidAckFaultMsg;
import weblogic.wsee.reliability.faults.LastMessageNumExceededFaultMsg;
import weblogic.wsee.reliability.faults.MessageNumRolloverFaultMsg;
import weblogic.wsee.reliability.faults.SecurityMismatchFaultMsg;
import weblogic.wsee.reliability.faults.SequenceClosedFaultMsg;
import weblogic.wsee.reliability.faults.SequenceFaultException;
import weblogic.wsee.reliability.faults.SequenceFaultMsg;
import weblogic.wsee.reliability.faults.SequenceRefusedFaultMsg;
import weblogic.wsee.reliability.faults.SequenceTerminatedFaultMsg;
import weblogic.wsee.reliability.faults.UnknownSequenceFaultMsg;
import weblogic.wsee.reliability.faults.WSRMRequiredFaultMsg;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public class SequenceFaultMsgFactory {
    private static final SequenceFaultMsgFactory INSTANCE = new SequenceFaultMsgFactory();
    private final Map<QName, Class> faultClasses = new HashMap<QName, Class>();
    private final Map<Integer, QName> safCodeMapping = new HashMap<Integer, QName>();

    private SequenceFaultMsgFactory() {
    }

    public static SequenceFaultMsgFactory getInstance() {
        return INSTANCE;
    }

    public SequenceFaultMsg createSequenceFaultMsg(QName qName, WsrmConstants.RMVersion rMVersion) throws SequenceFaultException {
        Class clazz = this.faultClasses.get(qName);
        if (clazz == null) {
            throw new SequenceFaultException("unknown fault: " + qName);
        }
        try {
            Constructor constructor = clazz.getConstructor(WsrmConstants.RMVersion.class);
            return (SequenceFaultMsg)constructor.newInstance(new Object[]{rMVersion});
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError((Object)invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError((Object)instantiationException);
        }
    }

    public SequenceFaultMsg parseSoapFault(SOAPMessage sOAPMessage, WsrmConstants.RMVersion rMVersion) throws SequenceFaultException {
        return this.parseSoapFault(sOAPMessage, new WsrmConstants.RMVersion[]{rMVersion});
    }

    public SequenceFaultMsg parseSoapFault(SOAPMessage sOAPMessage) throws SequenceFaultException {
        return this.parseSoapFault(sOAPMessage, WsrmConstants.RMVersion.values());
    }

    /*
     * WARNING - void declaration
     */
    public SequenceFaultMsg parseSoapFault(SOAPMessage sOAPMessage, WsrmConstants.RMVersion[] rMVersionArray) throws SequenceFaultException {
        if (sOAPMessage == null) {
            throw new SequenceFaultException("SOAPMessage is null");
        }
        try {
            QName qName;
            Object object;
            SOAPHeader sOAPHeader = sOAPMessage.getSOAPHeader();
            if (sOAPHeader == null) {
                throw new SequenceFaultException("SOAPHeader is null");
            }
            SOAPEnvelope sOAPEnvelope = sOAPMessage.getSOAPPart().getEnvelope();
            String string = sOAPEnvelope.getNamespaceURI();
            WsrmConstants.SOAPVersion sOAPVersion = WsrmProtocolUtils.getSOAPVersionFromNamespaceUri(string);
            WsrmConstants.RMVersion rMVersion = null;
            if (sOAPVersion == WsrmConstants.SOAPVersion.SOAP_11) {
                Object object2;
                object = null;
                Element element = null;
                for (WsrmConstants.RMVersion object32 : rMVersionArray) {
                    object2 = this.getOptionalElementByTagNameNS((Element)sOAPHeader, WsrmConstants.Element.SEQUENCE_FAULT.getElementName(), object32);
                    if (object2 == null) continue;
                    object = object2;
                    rMVersion = object32;
                    element = this.getOptionalElementByTagNameNS((Element)object2, WsrmConstants.Element.FAULT_CODE.getElementName(), object32);
                }
                if (element == null) {
                    throw new SequenceFaultException("No valid WS-RM FaultCode element could be found for an WS-RM version");
                }
                String string2 = DOMUtils.getTextContent(element, true);
                int n = -1;
                if (string2 != null) {
                    n = string2.indexOf(":");
                }
                if (n < 0 || string2 == null) {
                    throw new SequenceFaultException("WS-RM FaultCode contained invalid content: " + (String)string2);
                }
                String string3 = string2.substring(0, n);
                String string4 = object.lookupNamespaceURI(string3);
                if (string4 == null || !string4.equals(rMVersion.getNamespaceUri())) {
                    throw new SequenceFaultException("WS-RM FaultCode contained subcode with unknown or incorrect namespace prefix: " + string3 + " mapped to namespace URI: " + string4);
                }
                object2 = string2.substring(n + 1);
                qName = new QName(rMVersion.getNamespaceUri(), (String)object2, string3);
            } else {
                void var14_23;
                object = sOAPMessage.getSOAPBody();
                SOAPFault sOAPFault = object.getFault();
                Iterator iterator = sOAPFault.getFaultSubcodes();
                if (!iterator.hasNext()) {
                    throw new SequenceFaultException("No fault code");
                }
                qName = (QName)iterator.next();
                WsrmConstants.RMVersion[] rMVersionArray2 = rMVersionArray;
                int n = rMVersionArray2.length;
                boolean bl = false;
                while (var14_23 < n) {
                    WsrmConstants.RMVersion rMVersion2 = rMVersionArray2[var14_23];
                    if (rMVersion2.getNamespaceUri().equals(qName.getNamespaceURI())) {
                        rMVersion = rMVersion2;
                        break;
                    }
                    ++var14_23;
                }
            }
            object = this.createSequenceFaultMsg(qName, rMVersion);
            ((SequenceFaultMsg)object).read(sOAPMessage);
            return object;
        }
        catch (DOMProcessingException dOMProcessingException) {
            throw new SequenceFaultException("DOMProcessingException", (Throwable)((Object)dOMProcessingException));
        }
        catch (SOAPException sOAPException) {
            throw new SequenceFaultException("SOAPException", sOAPException);
        }
    }

    private Element getOptionalElementByTagNameNS(Element element, String string, WsrmConstants.RMVersion rMVersion) throws DOMProcessingException {
        return DOMUtils.getOptionalElementByTagNameNS(element, rMVersion.getNamespaceUri(), string);
    }

    public QName getSAFResultCodeMapping(int n) {
        return this.safCodeMapping.get(n);
    }

    private void addSAFResultCodeMapping(int n, QName qName) {
        this.safCodeMapping.put(n, qName);
    }

    private void addFaultClass(QName qName, Class clazz) {
        this.faultClasses.put(qName, clazz);
    }

    static {
        for (WsrmConstants.RMVersion rMVersion : WsrmConstants.RMVersion.values()) {
            INSTANCE.addSAFResultCodeMapping(6, new UnknownSequenceFaultMsg(rMVersion).getSubCodeQName());
            INSTANCE.addSAFResultCodeMapping(7, new SequenceRefusedFaultMsg(rMVersion).getSubCodeQName());
            INSTANCE.addSAFResultCodeMapping(5, new SequenceTerminatedFaultMsg(rMVersion).getSubCodeQName());
            INSTANCE.addFaultClass(new UnknownSequenceFaultMsg(rMVersion).getSubCodeQName(), UnknownSequenceFaultMsg.class);
            INSTANCE.addFaultClass(new SequenceRefusedFaultMsg(rMVersion).getSubCodeQName(), SequenceRefusedFaultMsg.class);
            INSTANCE.addFaultClass(new MessageNumRolloverFaultMsg(rMVersion).getSubCodeQName(), MessageNumRolloverFaultMsg.class);
            INSTANCE.addFaultClass(new LastMessageNumExceededFaultMsg(rMVersion).getSubCodeQName(), LastMessageNumExceededFaultMsg.class);
            INSTANCE.addFaultClass(new SequenceTerminatedFaultMsg(rMVersion).getSubCodeQName(), SequenceTerminatedFaultMsg.class);
            INSTANCE.addFaultClass(new SequenceClosedFaultMsg(rMVersion).getSubCodeQName(), SequenceClosedFaultMsg.class);
            INSTANCE.addFaultClass(new InvalidAckFaultMsg(rMVersion).getSubCodeQName(), InvalidAckFaultMsg.class);
            INSTANCE.addFaultClass(new IllegalRMVersionFaultMsg(rMVersion).getSubCodeQName(), IllegalRMVersionFaultMsg.class);
            INSTANCE.addFaultClass(new SecurityMismatchFaultMsg(rMVersion).getSubCodeQName(), SecurityMismatchFaultMsg.class);
            INSTANCE.addFaultClass(new WSRMRequiredFaultMsg(rMVersion).getSubCodeQName(), WSRMRequiredFaultMsg.class);
        }
    }
}

