/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability.faults;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.faults.SequenceFaultException;
import weblogic.wsee.reliability.faults.SequenceFaultMsgType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WsrmFaultMsg {
    private WsrmConstants.RMVersion rmVersion;
    protected WsrmConstants.FaultCode code;
    protected String subCode;
    protected String reason;
    protected SequenceFaultMsgType type;

    protected WsrmFaultMsg(WsrmConstants.RMVersion rMVersion, WsrmConstants.FaultCode faultCode, String string, String string2, SequenceFaultMsgType sequenceFaultMsgType) {
        this.rmVersion = rMVersion;
        this.code = faultCode;
        this.subCode = string;
        this.reason = string2;
        this.type = sequenceFaultMsgType;
    }

    public WsrmConstants.RMVersion getRmVersion() {
        return this.rmVersion;
    }

    public WsrmConstants.FaultCode getCode() {
        return this.code;
    }

    public String getCodeQualifiedName(WsrmConstants.SOAPVersion sOAPVersion) {
        return this.code.getCodeQualifiedName(sOAPVersion);
    }

    public QName getCodeQName(WsrmConstants.SOAPVersion sOAPVersion) {
        return this.code.getCodeQName(sOAPVersion);
    }

    public String getCodeLocalName(WsrmConstants.SOAPVersion sOAPVersion) {
        return this.code.getCodeLocalName(sOAPVersion);
    }

    public String getSubCodeQualifiedName() {
        return this.rmVersion.getPrefix() + ":" + this.subCode;
    }

    public QName getSubCodeQName() {
        return new QName(this.rmVersion.getNamespaceUri(), this.subCode, this.rmVersion.getPrefix());
    }

    public String getSubCodeLocalName() {
        return this.subCode;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String string) {
        this.reason = string;
    }

    public SequenceFaultMsgType getType() {
        return this.type;
    }

    public static QName getSubCodeQName(Class clazz, WsrmConstants.RMVersion rMVersion) {
        try {
            Field field = clazz.getField("SUBCODE_LOCAL_NAME");
            String string = (String)field.get(null);
            return new QName(rMVersion.getNamespaceUri(), string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString(), exception);
        }
    }

    public static List<QName> getSubCodeQNames(Class clazz) {
        try {
            ArrayList<QName> arrayList = new ArrayList<QName>();
            for (WsrmConstants.RMVersion rMVersion : WsrmConstants.RMVersion.values()) {
                arrayList.add(WsrmFaultMsg.getSubCodeQName(clazz, rMVersion));
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString(), exception);
        }
    }

    public abstract void read(SOAPMessage var1) throws SequenceFaultException;

    public abstract void write(SOAPMessage var1) throws SequenceFaultException;

    public abstract void readDetail(Element var1) throws SequenceFaultException;

    public abstract void writeDetail(Element var1) throws SequenceFaultException;

    public String toString() {
        return this.reason;
    }
}

