/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability.handshake;

import java.util.HashMap;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.w3c.dom.Element;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.message.MsgHeaderException;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.handshake.HandshakeMsgException;
import weblogic.wsee.reliability.handshake.SequenceOffer;
import weblogic.wsee.reliability.handshake.WsrmHandshakeMsg;
import weblogic.xml.crypto.wss.SecurityTokenReferenceImpl;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;
import weblogic.xml.dom.marshal.MarshalException;

public final class CreateSequenceMsg
extends WsrmHandshakeMsg {
    private EndpointReference acksTo;
    private Duration expires;
    private SequenceOffer offer;
    private SecurityTokenReference str;

    public CreateSequenceMsg(WsrmConstants.RMVersion rMVersion) {
        super(WsrmConstants.Element.CREATE_SEQUENCE.getElementName(), rMVersion);
    }

    public EndpointReference getAcksTo() {
        return this.acksTo;
    }

    public void setAcksTo(EndpointReference endpointReference) {
        this.acksTo = endpointReference;
    }

    public Duration getExpires() {
        return this.expires;
    }

    public void setExpires(Duration duration) {
        this.expires = duration;
    }

    public SequenceOffer getOffer() {
        return this.offer;
    }

    public void setOffer(SequenceOffer sequenceOffer) {
        this.offer = sequenceOffer;
    }

    public void setSecurityTokenReference(SecurityTokenReference securityTokenReference) {
        this.str = securityTokenReference;
    }

    public SecurityTokenReference getSecurityTokenReference() {
        return this.str;
    }

    public void read(Element element) throws HandshakeMsgException {
        block10: {
            try {
                Element element2;
                Element element3;
                Element element4 = DOMUtils.getElementByTagNameNS(element, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.ACKS_TO.getElementName());
                this.acksTo = new EndpointReference();
                this.acksTo.read(element4);
                String string = DOMUtils.getOptionalValueByTagNameNS(element, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.EXPIRES.getElementName());
                if (string != null && !string.equals("P0S")) {
                    try {
                        this.expires = DatatypeFactory.newInstance().newDuration(string);
                    }
                    catch (DatatypeConfigurationException datatypeConfigurationException) {
                        throw new HandshakeMsgException(datatypeConfigurationException.getMessage());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new HandshakeMsgException(illegalArgumentException.getMessage());
                    }
                }
                if ((element3 = DOMUtils.getOptionalElementByTagNameNS(element, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.OFFER.getElementName())) != null) {
                    this.offer = new SequenceOffer(this.getRmVersion());
                    this.offer.read(element3);
                }
                if ((element2 = DOMUtils.getOptionalElementByTagNameNS(element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "SecurityTokenReference")) == null) break block10;
                try {
                    this.str = SecurityTokenReferenceImpl.createAndUnmarshal(element2);
                }
                catch (MarshalException marshalException) {
                    throw new HandshakeMsgException(marshalException.getMessage(), marshalException);
                }
            }
            catch (DOMProcessingException dOMProcessingException) {
                throw new HandshakeMsgException("Could not parse create sequence message", (Throwable)((Object)dOMProcessingException));
            }
            catch (MsgHeaderException msgHeaderException) {
                throw new HandshakeMsgException("Could not parse create sequence message", msgHeaderException);
            }
        }
    }

    public void write(Element element) throws HandshakeMsgException {
        if (this.acksTo == null) {
            throw new HandshakeMsgException("AcksTo is not set in create sequence message");
        }
        Element element2 = element.getOwnerDocument().createElementNS(this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.ACKS_TO.getQualifiedName(this.getRmVersion()));
        this.acksTo.write(element2);
        element.appendChild(element2);
        if (this.expires != null) {
            DOMUtils.addValueNS(element, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.EXPIRES.getQualifiedName(this.getRmVersion()), this.expires.toString());
        }
        if (this.offer != null) {
            Element element3 = element.getOwnerDocument().createElementNS(this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.OFFER.getQualifiedName(this.getRmVersion()));
            this.offer.write(element3);
            element.appendChild(element3);
        }
        if (this.str != null) {
            try {
                this.str.marshal(element, null, new HashMap());
            }
            catch (MarshalException marshalException) {
                throw new HandshakeMsgException(marshalException.getMessage(), marshalException);
            }
        }
    }
}

