/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability.handshake;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.w3c.dom.Element;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.handshake.HandshakeMsgException;
import weblogic.wsee.reliability.handshake.SequenceAccept;
import weblogic.wsee.reliability.handshake.WsrmHandshakeMsg;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class CreateSequenceResponseMsg
extends WsrmHandshakeMsg {
    private String sequenceId;
    private Duration expires;
    private WsrmConstants.IncompleteSequenceBehavior incompleteSequenceBehavior;
    private SequenceAccept accept;

    public CreateSequenceResponseMsg(WsrmConstants.RMVersion rMVersion) {
        super(WsrmConstants.Element.CREATE_SEQUENCE_RESPONSE.getElementName(), rMVersion);
    }

    public String getSequenceId() {
        return this.sequenceId;
    }

    public void setSequenceId(String string) {
        this.sequenceId = string;
    }

    public Duration getExpires() {
        return this.expires;
    }

    public void setExpires(Duration duration) {
        this.expires = duration;
    }

    public WsrmConstants.IncompleteSequenceBehavior getIncompleteSequenceBehavior() {
        return this.incompleteSequenceBehavior;
    }

    public void setIncompleteSequenceBehavior(WsrmConstants.IncompleteSequenceBehavior incompleteSequenceBehavior) {
        this.incompleteSequenceBehavior = incompleteSequenceBehavior;
    }

    public SequenceAccept getAccept() {
        return this.accept;
    }

    public void setAccept(SequenceAccept sequenceAccept) {
        this.accept = sequenceAccept;
    }

    public void read(Element element) throws HandshakeMsgException {
        try {
            Element element2;
            Element element3;
            this.sequenceId = DOMUtils.getValueByTagNameNS(element, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.IDENTIFIER.getElementName());
            String string = DOMUtils.getOptionalValueByTagNameNS(element, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.EXPIRES.getElementName());
            if (string != null && !string.equals("P0S")) {
                try {
                    this.expires = DatatypeFactory.newInstance().newDuration(string);
                }
                catch (DatatypeConfigurationException datatypeConfigurationException) {
                    throw new HandshakeMsgException(datatypeConfigurationException.getMessage());
                }
            }
            if ((element3 = DOMUtils.getOptionalElementByTagNameNS(element, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.ACCEPT.getElementName())) != null) {
                this.accept = new SequenceAccept(this.getRmVersion());
                this.accept.read(element3);
            }
            if (this.getRmVersion().isLaterThanOrEqualTo(WsrmConstants.RMVersion.RM_11) && (element2 = DOMUtils.getOptionalElementByTagNameNS(element, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.INCOMPLETE_SEQUENCE_BEHAVIOR.getElementName())) != null) {
                String string2 = DOMUtils.getTextContent(element2, true);
                this.incompleteSequenceBehavior = WsrmConstants.IncompleteSequenceBehavior.valueOf(string2);
            }
        }
        catch (DOMProcessingException dOMProcessingException) {
            throw new HandshakeMsgException("Could not parse create sequence response message", (Throwable)((Object)dOMProcessingException));
        }
    }

    public void write(Element element) throws HandshakeMsgException {
        Element element2;
        if (this.sequenceId == null) {
            throw new HandshakeMsgException("Sequence ID is not set");
        }
        DOMUtils.addValueNS(element, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.IDENTIFIER.getQualifiedName(this.getRmVersion()), this.sequenceId);
        if (this.expires != null) {
            DOMUtils.addValueNS(element, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.EXPIRES.getQualifiedName(this.getRmVersion()), this.expires.toString());
        }
        if (this.getRmVersion().isLaterThanOrEqualTo(WsrmConstants.RMVersion.RM_11) && this.incompleteSequenceBehavior != null) {
            element2 = element.getOwnerDocument().createElementNS(this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.INCOMPLETE_SEQUENCE_BEHAVIOR.getQualifiedName(this.getRmVersion()));
            DOMUtils.addTextData(element2, this.incompleteSequenceBehavior.name());
            element.appendChild(element2);
        }
        if (this.accept != null) {
            element2 = element.getOwnerDocument().createElementNS(this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.ACCEPT.getQualifiedName(this.getRmVersion()));
            this.accept.write(element2);
            element.appendChild(element2);
        }
    }
}

