/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability.handshake;

import org.w3c.dom.Element;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.handshake.HandshakeMsgException;
import weblogic.wsee.reliability.handshake.WsrmHandshakeMsg;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public abstract class EndOfLifeSequenceMsg
extends WsrmHandshakeMsg {
    private String sequenceId;
    private long lastMsgNumber = -1L;

    protected EndOfLifeSequenceMsg(WsrmConstants.RMVersion rMVersion, String string, String string2) {
        super(string, rMVersion);
        this.sequenceId = string2;
    }

    protected EndOfLifeSequenceMsg(WsrmConstants.RMVersion rMVersion, String string) {
        this(rMVersion, string, null);
    }

    public String getSequenceId() {
        return this.sequenceId;
    }

    public long getLastMsgNumber() {
        return this.lastMsgNumber;
    }

    public void setLastMsgNumber(long l) {
        this.lastMsgNumber = l;
    }

    public void read(Element element) throws HandshakeMsgException {
        try {
            String string;
            this.sequenceId = DOMUtils.getValueByTagNameNS(element, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.IDENTIFIER.getElementName());
            if (this.getRmVersion().isLaterThanOrEqualTo(WsrmConstants.RMVersion.RM_11) && (string = DOMUtils.getOptionalValueByTagNameNS(element, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.LAST_MSG_NUMBER.getElementName())) != null) {
                this.lastMsgNumber = Long.parseLong(string);
            }
        }
        catch (DOMProcessingException dOMProcessingException) {
            throw new HandshakeMsgException("Could not parse terminate sequence message", (Throwable)((Object)dOMProcessingException));
        }
    }

    public void write(Element element) throws HandshakeMsgException {
        if (this.sequenceId == null) {
            throw new HandshakeMsgException("Sequence ID is not set");
        }
        DOMUtils.addNamespaceDeclaration(element, "wsu", "http://schemas.xmlsoap.org/ws/2002/07/utility");
        DOMUtils.addValueNS(element, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.IDENTIFIER.getQualifiedName(this.getRmVersion()), this.sequenceId);
        if (this.getRmVersion().isLaterThanOrEqualTo(WsrmConstants.RMVersion.RM_11) && this.lastMsgNumber > 0L) {
            DOMUtils.addValueNS(element, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.LAST_MSG_NUMBER.getQualifiedName(this.getRmVersion()), Long.toString(this.lastMsgNumber));
        }
    }
}

