/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability.handshake;

import org.w3c.dom.Element;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.message.MsgHeaderException;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.handshake.HandshakeMsgException;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class SequenceAccept {
    private WsrmConstants.RMVersion rmVersion;
    private EndpointReference acksTo = null;

    public SequenceAccept(WsrmConstants.RMVersion rMVersion) {
        this.rmVersion = rMVersion;
    }

    public WsrmConstants.RMVersion getRmVersion() {
        return this.rmVersion;
    }

    public void setAcksTo(EndpointReference endpointReference) {
        this.acksTo = endpointReference;
    }

    public EndpointReference getAcksTo() {
        return this.acksTo;
    }

    public void read(Element element) throws HandshakeMsgException {
        try {
            Element element2 = DOMUtils.getElementByTagNameNS(element, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.ACKS_TO.getElementName());
            this.acksTo = new EndpointReference();
            this.acksTo.read(element2);
        }
        catch (DOMProcessingException dOMProcessingException) {
            throw new HandshakeMsgException("Could not parse create sequence response/accept message", (Throwable)((Object)dOMProcessingException));
        }
        catch (MsgHeaderException msgHeaderException) {
            throw new HandshakeMsgException("Could not parse create sequence response/accept message", msgHeaderException);
        }
    }

    public void write(Element element) throws HandshakeMsgException {
        if (this.acksTo == null) {
            throw new HandshakeMsgException("AcksTo is not set in the accept element of create sequence response message");
        }
        Element element2 = element.getOwnerDocument().createElementNS(this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.ACKS_TO.getQualifiedName(this.getRmVersion()));
        this.acksTo.write(element2);
        element.appendChild(element2);
    }
}

