/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability.handshake;

import org.w3c.dom.Element;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.handshake.HandshakeMsgException;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class SequenceOffer {
    private WsrmConstants.RMVersion rmVersion;
    private String sequenceId = null;
    private String expires = null;
    private EndpointReference endpoint;
    private WsrmConstants.IncompleteSequenceBehavior incompleteSequenceBehavior;

    public SequenceOffer(WsrmConstants.RMVersion rMVersion) {
        this.rmVersion = rMVersion;
    }

    public WsrmConstants.RMVersion getRmVersion() {
        return this.rmVersion;
    }

    public void setSequenceId(String string) {
        this.sequenceId = string;
    }

    public String getSequenceId() {
        return this.sequenceId;
    }

    public void setExpires(String string) {
        this.expires = string;
    }

    public String getExpires() {
        return this.expires;
    }

    public EndpointReference getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(EndpointReference endpointReference) {
        this.endpoint = endpointReference;
    }

    public WsrmConstants.IncompleteSequenceBehavior getIncompleteSequenceBehavior() {
        return this.incompleteSequenceBehavior;
    }

    public void setIncompleteSequenceBehavior(WsrmConstants.IncompleteSequenceBehavior incompleteSequenceBehavior) {
        this.incompleteSequenceBehavior = incompleteSequenceBehavior;
    }

    public void read(Element element) throws HandshakeMsgException {
        try {
            this.sequenceId = DOMUtils.getValueByTagNameNS(element, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.IDENTIFIER.getElementName());
            String string = DOMUtils.getOptionalValueByTagNameNS(element, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.EXPIRES.getElementName());
            if (string != null && !string.equals("P0S")) {
                this.expires = string;
            }
            if (this.getRmVersion().isLaterThanOrEqualTo(WsrmConstants.RMVersion.RM_11)) {
                Element element2 = DOMUtils.getElementByTagNameNS(element, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.ENDPOINT.getElementName());
                this.endpoint = new EndpointReference();
                this.endpoint.read(element2);
                Element element3 = DOMUtils.getOptionalElementByTagNameNS(element, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.INCOMPLETE_SEQUENCE_BEHAVIOR.getElementName());
                if (element3 != null) {
                    String string2 = DOMUtils.getTextContent(element3, true);
                    this.incompleteSequenceBehavior = WsrmConstants.IncompleteSequenceBehavior.valueOf(string2);
                }
            }
        }
        catch (DOMProcessingException dOMProcessingException) {
            throw new HandshakeMsgException("Could not parse create sequence/offer message", (Throwable)((Object)dOMProcessingException));
        }
    }

    public void write(Element element) throws HandshakeMsgException {
        Element element2;
        if (this.sequenceId == null) {
            throw new HandshakeMsgException("Sequence ID is not set in the offer element of create sequence message");
        }
        DOMUtils.addValueNS(element, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.IDENTIFIER.getQualifiedName(this.getRmVersion()), this.sequenceId);
        if (this.getRmVersion().isLaterThanOrEqualTo(WsrmConstants.RMVersion.RM_11)) {
            if (this.endpoint == null) {
                throw new HandshakeMsgException("Endpoint is not set in create sequence Offer element");
            }
            element2 = element.getOwnerDocument().createElementNS(this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.ENDPOINT.getQualifiedName(this.getRmVersion()));
            this.endpoint.write(element2);
            element.appendChild(element2);
        }
        if (this.expires != null) {
            DOMUtils.addValueNS(element, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.EXPIRES.getQualifiedName(this.getRmVersion()), this.expires);
        }
        if (this.getRmVersion().isLaterThanOrEqualTo(WsrmConstants.RMVersion.RM_11) && this.incompleteSequenceBehavior != null) {
            element2 = element.getOwnerDocument().createElementNS(this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.INCOMPLETE_SEQUENCE_BEHAVIOR.getQualifiedName(this.getRmVersion()));
            DOMUtils.addTextData(element2, this.incompleteSequenceBehavior.name());
            element.appendChild(element2);
        }
    }
}

