/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability.handshake;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.handshake.HandshakeMsgException;
import weblogic.wsee.util.ToStringWriter;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public abstract class WsrmHandshakeMsg {
    private String elementName;
    private WsrmConstants.RMVersion rmVersion;
    private boolean mustUnderstand;
    private String role;

    protected WsrmHandshakeMsg(String string, WsrmConstants.RMVersion rMVersion) {
        this.elementName = string;
        this.rmVersion = rMVersion;
    }

    public String getElementName() {
        return this.elementName;
    }

    public WsrmConstants.RMVersion getRmVersion() {
        return this.rmVersion;
    }

    public QName getQName() {
        return new QName(this.rmVersion.getNamespaceUri(), this.elementName, this.rmVersion.getPrefix());
    }

    public abstract void read(Element var1) throws HandshakeMsgException;

    public abstract void write(Element var1) throws HandshakeMsgException;

    public Element writeMsg(SOAPMessage sOAPMessage) throws HandshakeMsgException {
        SOAPBody sOAPBody;
        if (sOAPMessage == null) {
            throw new HandshakeMsgException("Null SOAP message");
        }
        try {
            sOAPBody = sOAPMessage.getSOAPBody();
        }
        catch (SOAPException sOAPException) {
            throw new HandshakeMsgException("Error getting SOAP body", sOAPException);
        }
        if (sOAPBody == null) {
            throw new HandshakeMsgException("Null SOAP message body");
        }
        QName qName = this.getQName();
        Element element = sOAPBody.getOwnerDocument().createElementNS(qName.getNamespaceURI(), qName.getPrefix() + ":" + qName.getLocalPart());
        DOMUtils.addNamespaceDeclaration((Element)sOAPBody, qName.getPrefix(), qName.getNamespaceURI());
        this.write(element);
        sOAPBody.appendChild(element);
        boolean bl = false;
        if (this.getRole() != null) {
            DOMUtils.addNamespaceDeclaration(element, "soap", "http://schemas.xmlsoap.org/soap/envelope/");
            bl = true;
            element.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "actor", this.getRole());
        }
        if (this.isMustUnderstand()) {
            if (!bl) {
                DOMUtils.addNamespaceDeclaration(element, "soap", "http://schemas.xmlsoap.org/soap/envelope/");
            }
            element.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "soap:mustUnderstand", "1");
        }
        return element;
    }

    public Element readMsg(SOAPMessage sOAPMessage) throws HandshakeMsgException {
        Element element;
        SOAPBody sOAPBody;
        if (sOAPMessage == null) {
            throw new HandshakeMsgException("Null SOAP message");
        }
        try {
            sOAPBody = sOAPMessage.getSOAPBody();
        }
        catch (SOAPException sOAPException) {
            throw new HandshakeMsgException("Error getting SOAP body", sOAPException);
        }
        if (sOAPBody == null) {
            throw new HandshakeMsgException("Null SOAP message body");
        }
        QName qName = this.getQName();
        try {
            element = DOMUtils.getElementByTagNameNS((Element)sOAPBody, qName.getNamespaceURI(), qName.getLocalPart());
        }
        catch (DOMProcessingException dOMProcessingException) {
            throw new HandshakeMsgException("Error reading the handshake message", (Throwable)((Object)dOMProcessingException));
        }
        this.read(element);
        return element;
    }

    public void setMustUnderstand(boolean bl) {
        this.mustUnderstand = bl;
    }

    public boolean isMustUnderstand() {
        return this.mustUnderstand;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String string) {
        this.role = string;
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.writeField("role", this.role);
        toStringWriter.writeField("mustUnderstand", this.mustUnderstand);
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }
}

