/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability.handshake;

import java.util.Arrays;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import weblogic.messaging.saf.SAFConversationInfo;
import weblogic.messaging.saf.SAFException;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.message.MsgHeaders;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.runtime.PolicyContext;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.WsrmHandler;
import weblogic.wsee.reliability.WsrmHelper;
import weblogic.wsee.reliability.WsrmProtocolUtils;
import weblogic.wsee.reliability.WsrmSAFManager;
import weblogic.wsee.reliability.WsrmSAFManagerFactory;
import weblogic.wsee.reliability.WsrmSAFReceivingManager;
import weblogic.wsee.reliability.WsrmSecurityContext;
import weblogic.wsee.reliability.WsrmSequenceContext;
import weblogic.wsee.reliability.faults.CreateSequenceRefusedFaultMsg;
import weblogic.wsee.reliability.faults.IllegalRMVersionFaultException;
import weblogic.wsee.reliability.faults.IllegalRMVersionFaultMsg;
import weblogic.wsee.reliability.faults.SequenceFaultException;
import weblogic.wsee.reliability.faults.SequenceFaultMsg;
import weblogic.wsee.reliability.faults.SequenceFaultMsgFactory;
import weblogic.wsee.reliability.faults.SequenceFaultMsgType;
import weblogic.wsee.reliability.faults.UnknownSequenceFaultException;
import weblogic.wsee.reliability.faults.UnknownSequenceFaultMsg;
import weblogic.wsee.reliability.handshake.CloseSequenceMsg;
import weblogic.wsee.reliability.handshake.CloseSequenceResponseMsg;
import weblogic.wsee.reliability.handshake.CreateSequenceMsg;
import weblogic.wsee.reliability.handshake.CreateSequenceResponseMsg;
import weblogic.wsee.reliability.handshake.HandshakeMsgException;
import weblogic.wsee.reliability.handshake.SAFConversationInfoNotFoundException;
import weblogic.wsee.reliability.handshake.TerminateSequenceMsg;
import weblogic.wsee.reliability.handshake.TerminateSequenceResponseMsg;
import weblogic.wsee.reliability.handshake.WsrmHandshakeMsg;
import weblogic.wsee.reliability.headers.AckRequestedHeader;
import weblogic.wsee.reliability.headers.AcknowledgementHeader;
import weblogic.wsee.reliability.headers.SequenceHeader;
import weblogic.wsee.reliability.policy.WsrmPolicyRuntimeHandler;
import weblogic.wsee.reliability.policy.WsrmPolicyServiceRuntimeHandler;
import weblogic.wsee.security.WssServerPolicyHandler;
import weblogic.wsee.security.policy.assertions.SecurityPolicyAssertionFactory;
import weblogic.wsee.security.wssc.base.sct.SCTokenBase;
import weblogic.wsee.security.wssc.sct.SCCredential;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfoFactory;
import weblogic.wsee.security.wssp.handlers.PostWssServerPolicyHandler;
import weblogic.wsee.util.AddressingUtil;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.wss.SecurityTokenHelper;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;

public class WsrmServerHandshakeHandler
extends WsrmHandler {
    private static final boolean verbose = Verbose.isVerbose(WsrmServerHandshakeHandler.class);
    private NormalizedExpression cachedEndptPolicy = null;

    public boolean handleRequest(MessageContext messageContext) {
        if (!(messageContext instanceof SOAPMessageContext)) {
            return true;
        }
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        MsgHeaders msgHeaders = wlMessageContext.getHeaders();
        if (msgHeaders == null) {
            return true;
        }
        try {
            this.cachedEndptPolicy = PolicyContext.getEndpointPolicy(messageContext);
        }
        catch (PolicyException policyException) {
            throw new JAXRPCException(policyException.getMessage());
        }
        try {
            boolean bl;
            if (this.handleTerminateSequenceResponseMsg(sOAPMessageContext)) {
                AddressingUtil.confirmOneway((WlMessageContext)sOAPMessageContext);
                return false;
            }
            if (this.handleAckMsg(msgHeaders, sOAPMessageContext) && !(bl = this.checkIsPiggyback(sOAPMessageContext, WsrmConstants.Action.ACK))) {
                AddressingUtil.confirmOneway((WlMessageContext)sOAPMessageContext);
                return bl;
            }
            if (this.handleAckRequestedMsg(msgHeaders, sOAPMessageContext)) {
                bl = this.checkIsPiggyback(sOAPMessageContext, WsrmConstants.Action.ACK_REQUESTED);
                if (!bl) {
                    AddressingUtil.confirmOneway((WlMessageContext)sOAPMessageContext);
                }
                return bl;
            }
            if (this.handleCreateSequenceMsg(sOAPMessageContext)) {
                return false;
            }
            if (this.handleCreateSequenceResponseMsg(sOAPMessageContext)) {
                AddressingUtil.confirmOneway((WlMessageContext)sOAPMessageContext);
                return false;
            }
            if (this.handleCloseSequenceMsg(sOAPMessageContext)) {
                return false;
            }
            if (this.handleCloseSequenceResponseMsg(sOAPMessageContext)) {
                AddressingUtil.confirmOneway((WlMessageContext)sOAPMessageContext);
                return false;
            }
            if (this.handleTerminateSequenceMsg(sOAPMessageContext)) {
                return false;
            }
            if (this.handleEmptyLastMsg(msgHeaders, sOAPMessageContext)) {
                return false;
            }
            if (this.handleRMFault(sOAPMessageContext)) {
                AddressingUtil.confirmOneway((WlMessageContext)sOAPMessageContext);
                return false;
            }
        }
        catch (IllegalRMVersionFaultException illegalRMVersionFaultException) {
            if (verbose) {
                Verbose.logException(illegalRMVersionFaultException);
            }
            WsrmServerHandshakeHandler.sendIllegalRMVersionFault(illegalRMVersionFaultException, sOAPMessageContext);
            return false;
        }
        catch (UnknownSequenceFaultException unknownSequenceFaultException) {
            if (verbose) {
                Verbose.logException(unknownSequenceFaultException);
            }
            WsrmServerHandshakeHandler.sendUnknownSequenceFault(unknownSequenceFaultException, sOAPMessageContext);
            return false;
        }
        catch (SAFConversationInfoNotFoundException sAFConversationInfoNotFoundException) {
            if (verbose) {
                Verbose.logException((Throwable)((Object)sAFConversationInfoNotFoundException));
            }
            return false;
        }
        return true;
    }

    public static NormalizedExpression getAsyncResponseEndpointSecurityPolicy(boolean bl, String string) {
        try {
            return WsrmServerHandshakeHandler.getRMSequenceContext(bl, string).getWsrmSecurityContext().getSecurityPolicy();
        }
        catch (PolicyException policyException) {
            if (verbose) {
                Verbose.logException(policyException);
            }
            throw new JAXRPCException((Throwable)policyException);
        }
    }

    private boolean checkIsPiggyback(SOAPMessageContext sOAPMessageContext, WsrmConstants.Action action) {
        String string = (String)sOAPMessageContext.getProperty("weblogic.wsee.addressing.Action");
        return WsrmProtocolUtils.getActionVersion(action, string) == null;
    }

    private boolean handleEmptyLastMsg(MsgHeaders msgHeaders, SOAPMessageContext sOAPMessageContext) throws IllegalRMVersionFaultException {
        String string = (String)sOAPMessageContext.getProperty("weblogic.wsee.addressing.Action");
        WsrmConstants.RMVersion rMVersion = WsrmProtocolUtils.getActionVersion(WsrmConstants.Action.LAST_MESSAGE, string);
        if (rMVersion == null) {
            return false;
        }
        SequenceHeader sequenceHeader = (SequenceHeader)msgHeaders.getHeader(SequenceHeader.TYPE);
        if (sequenceHeader == null) {
            throw new JAXRPCException("No sequence header found for last message");
        }
        String string2 = sequenceHeader.getSequenceId();
        WsrmSequenceContext wsrmSequenceContext = WsrmServerHandshakeHandler.checkRMVersionMatchWithCreateSequence(false, string2, rMVersion, (MessageContext)sOAPMessageContext, this.cachedEndptPolicy);
        if (wsrmSequenceContext.isSecureWithSSL()) {
            WsrmServerHandshakeHandler.validateSSLSessionId(wsrmSequenceContext.getWsrmSecurityContext(), (WlMessageContext)sOAPMessageContext);
        }
        if (wsrmSequenceContext.isSecure()) {
            if (!this.validateSecurityPolicy((MessageContext)sOAPMessageContext, false, string2)) {
                return true;
            }
            WsrmServerHandshakeHandler.validateCredential(false, string2, wsrmSequenceContext.getRmVersion(), (MessageContext)sOAPMessageContext);
        }
        WsrmSAFManagerFactory.getWsrmSAFReceivingManager().deliver(sequenceHeader, sOAPMessageContext);
        return true;
    }

    private boolean handleAckMsg(MsgHeaders msgHeaders, SOAPMessageContext sOAPMessageContext) throws IllegalRMVersionFaultException {
        AcknowledgementHeader acknowledgementHeader = (AcknowledgementHeader)msgHeaders.getHeader(AcknowledgementHeader.TYPE);
        if (acknowledgementHeader != null) {
            WsrmSequenceContext wsrmSequenceContext;
            WsrmConstants.RMVersion rMVersion = acknowledgementHeader.getRmVersion();
            String string = acknowledgementHeader.getSequenceId();
            if (verbose) {
                Verbose.log("Acknowledgement received with ID: " + string);
            }
            if ((wsrmSequenceContext = WsrmServerHandshakeHandler.checkRMVersionMatchWithCreateSequence(true, string, rMVersion, (MessageContext)sOAPMessageContext, this.cachedEndptPolicy)).isSecureWithSSL()) {
                WsrmServerHandshakeHandler.validateSSLSessionId(wsrmSequenceContext.getWsrmSecurityContext(), (WlMessageContext)sOAPMessageContext);
            }
            if (wsrmSequenceContext.isSecure()) {
                if (!this.validateSecurityPolicy((MessageContext)sOAPMessageContext, true, string, false)) {
                    return true;
                }
                WsrmServerHandshakeHandler.validateCredential(true, string, wsrmSequenceContext.getRmVersion(), (MessageContext)sOAPMessageContext);
            }
            WsrmSAFManagerFactory.getWsrmSAFSendingManager().handleAck(acknowledgementHeader, sOAPMessageContext, false);
            return true;
        }
        return false;
    }

    private boolean handleAckRequestedMsg(MsgHeaders msgHeaders, SOAPMessageContext sOAPMessageContext) throws IllegalRMVersionFaultException {
        AckRequestedHeader ackRequestedHeader = (AckRequestedHeader)msgHeaders.getHeader(AckRequestedHeader.TYPE);
        if (ackRequestedHeader != null) {
            WsrmConstants.RMVersion rMVersion;
            WsrmSequenceContext wsrmSequenceContext;
            String string = ackRequestedHeader.getSequenceId();
            if (verbose) {
                Verbose.log("Acknowledgement requested");
            }
            if ((wsrmSequenceContext = WsrmServerHandshakeHandler.checkRMVersionMatchWithCreateSequence(false, string, rMVersion = ackRequestedHeader.getRmVersion(), (MessageContext)sOAPMessageContext, this.cachedEndptPolicy)).isSecureWithSSL()) {
                WsrmServerHandshakeHandler.validateSSLSessionId(wsrmSequenceContext.getWsrmSecurityContext(), (WlMessageContext)sOAPMessageContext);
            }
            if (wsrmSequenceContext.isSecure()) {
                if (!this.validateSecurityPolicy((MessageContext)sOAPMessageContext, false, string)) {
                    return true;
                }
                WsrmServerHandshakeHandler.validateCredential(false, string, wsrmSequenceContext.getRmVersion(), (MessageContext)sOAPMessageContext);
            }
            WsrmSAFManagerFactory.getWsrmSAFReceivingManager().ackRequested(string, sOAPMessageContext);
            return true;
        }
        return false;
    }

    private boolean handleCreateSequenceMsg(SOAPMessageContext sOAPMessageContext) throws IllegalRMVersionFaultException {
        Object object;
        String string = (String)sOAPMessageContext.getProperty("weblogic.wsee.addressing.Action");
        WsrmConstants.RMVersion rMVersion = WsrmProtocolUtils.getActionVersion(WsrmConstants.Action.CREATE_SEQUENCE, string);
        if (rMVersion == null) {
            return false;
        }
        this.checkAllowedRMVersionsForEndpoint("New", rMVersion);
        try {
            new WsrmPolicyRuntimeHandler().processRequest((MessageContext)sOAPMessageContext, this.cachedEndptPolicy, rMVersion);
        }
        catch (PolicyException policyException) {
            throw new JAXRPCException(policyException.toString(), (Throwable)policyException);
        }
        sOAPMessageContext.setProperty("weblogic.wsee.wsrm.RMVersion", (Object)rMVersion);
        boolean bl = this.isMessageSecured();
        if (bl) {
            sOAPMessageContext.setProperty("weblogic.wsee.policy.effectiveRequestPolicy", (Object)this.cachedEndptPolicy);
            object = this.isMessageSecuredWssp10() ? new WssServerPolicyHandler() : new PostWssServerPolicyHandler();
            if (!object.handleRequest((MessageContext)sOAPMessageContext)) {
                if (verbose) {
                    this.printThrowableOnContext((MessageContext)sOAPMessageContext);
                }
                return true;
            }
        }
        object = new CreateSequenceMsg(rMVersion);
        try {
            ((WsrmHandshakeMsg)object).readMsg(sOAPMessageContext.getMessage());
        }
        catch (HandshakeMsgException handshakeMsgException) {
            this.createSequenceRefused(sOAPMessageContext, rMVersion, handshakeMsgException);
            return true;
        }
        if (verbose) {
            Verbose.log("Sequence creation requested");
        }
        WsrmSecurityContext wsrmSecurityContext = new WsrmSecurityContext((MessageContext)sOAPMessageContext);
        try {
            wsrmSecurityContext.setSCCredential(this.getSCCredential((CreateSequenceMsg)object, (MessageContext)sOAPMessageContext));
        }
        catch (JAXRPCException jAXRPCException) {
            this.createSequenceRefused(sOAPMessageContext, rMVersion, (Exception)((Object)jAXRPCException));
            return true;
        }
        try {
            WsrmSAFManagerFactory.getWsrmSAFReceivingManager().createSequence(sOAPMessageContext, (CreateSequenceMsg)object);
        }
        catch (JAXRPCException jAXRPCException) {
            this.createSequenceRefused(sOAPMessageContext, rMVersion, (Exception)((Object)jAXRPCException));
        }
        catch (SAFException sAFException) {
            this.createSequenceRefused(sOAPMessageContext, rMVersion, sAFException);
        }
        return true;
    }

    private void checkAllowedRMVersionsForEndpoint(String string, WsrmConstants.RMVersion rMVersion) throws IllegalRMVersionFaultException {
        WsrmProtocolUtils.checkRMVersion(string, rMVersion, this.cachedEndptPolicy);
    }

    private void createSequenceRefused(SOAPMessageContext sOAPMessageContext, WsrmConstants.RMVersion rMVersion, Exception exception) {
        if (verbose) {
            Verbose.logException(exception);
        }
        WsrmHelper.sendFault(sOAPMessageContext, new CreateSequenceRefusedFaultMsg(exception, rMVersion), null);
    }

    private boolean handleCreateSequenceResponseMsg(SOAPMessageContext sOAPMessageContext) throws IllegalRMVersionFaultException {
        Object object;
        String string = (String)sOAPMessageContext.getProperty("weblogic.wsee.addressing.Action");
        WsrmConstants.RMVersion rMVersion = WsrmProtocolUtils.getActionVersion(WsrmConstants.Action.CREATE_SEQUENCE_RESPONSE, string);
        if (rMVersion == null) {
            return false;
        }
        String string2 = (String)sOAPMessageContext.getProperty("weblogic.wsee.addressing.RelatesTo");
        if (string2 == null) {
            throw new JAXRPCException("No related create sequence message found");
        }
        WsrmSequenceContext wsrmSequenceContext = WsrmServerHandshakeHandler.checkRMVersionMatchWithCreateSequence(true, string2, rMVersion, (MessageContext)sOAPMessageContext, this.cachedEndptPolicy);
        if (wsrmSequenceContext.isSecure()) {
            object = WsrmServerHandshakeHandler.getAsyncResponseEndpointSecurityPolicy(true, string2);
            sOAPMessageContext.setProperty("weblogic.wsee.policy.effectiveRequestPolicy", object);
            sOAPMessageContext.setProperty("weblogic.wsee.policy.effectiveResponsePolicy", object);
            sOAPMessageContext.setProperty("weblogic.wsee.wssc.sct", (Object)wsrmSequenceContext.getWsrmSecurityContext().getSCCredential());
            if (!AsyncUtil.getWssClientHandler(wsrmSequenceContext).handleResponse((MessageContext)sOAPMessageContext)) {
                if (verbose) {
                    this.printThrowableOnContext((MessageContext)sOAPMessageContext);
                }
                return true;
            }
            WsrmServerHandshakeHandler.validateCredential(true, string2, rMVersion, (MessageContext)sOAPMessageContext);
        }
        object = new CreateSequenceResponseMsg(rMVersion);
        try {
            ((WsrmHandshakeMsg)object).readMsg(sOAPMessageContext.getMessage());
        }
        catch (HandshakeMsgException handshakeMsgException) {
            if (verbose) {
                Verbose.logException(handshakeMsgException);
            }
            throw new JAXRPCException("HandshakeMsgException", (Throwable)handshakeMsgException);
        }
        if (verbose) {
            Verbose.log("Sequence creation response");
        }
        WsrmSAFManagerFactory.getWsrmSAFSendingManager().createSequenceResponse(sOAPMessageContext, (CreateSequenceResponseMsg)object);
        return true;
    }

    public static WsrmSequenceContext checkRMVersionMatchWithCreateSequence(boolean bl, String string, WsrmConstants.RMVersion rMVersion, MessageContext messageContext, NormalizedExpression normalizedExpression) throws IllegalRMVersionFaultException, UnknownSequenceFaultException {
        SAFConversationInfo sAFConversationInfo = WsrmSAFManager.getConversationInfo(bl, string, true);
        if (sAFConversationInfo == null) {
            throw new UnknownSequenceFaultException(string, rMVersion);
        }
        WsrmSequenceContext wsrmSequenceContext = (WsrmSequenceContext)sAFConversationInfo.getContext();
        if (rMVersion != wsrmSequenceContext.getRmVersion()) {
            throw new IllegalRMVersionFaultException(string, rMVersion, Arrays.asList(wsrmSequenceContext.getRmVersion()));
        }
        messageContext.setProperty("weblogic.wsee.wsrm.RMVersion", (Object)wsrmSequenceContext.getRmVersion());
        try {
            new WsrmPolicyServiceRuntimeHandler().processRequest(messageContext, normalizedExpression, wsrmSequenceContext.getRmVersion());
        }
        catch (PolicyException policyException) {
            throw new JAXRPCException(policyException.toString(), (Throwable)policyException);
        }
        return wsrmSequenceContext;
    }

    public static void sendIllegalRMVersionFault(IllegalRMVersionFaultException illegalRMVersionFaultException, SOAPMessageContext sOAPMessageContext) {
        IllegalRMVersionFaultMsg illegalRMVersionFaultMsg = new IllegalRMVersionFaultMsg(illegalRMVersionFaultException.getActual(), illegalRMVersionFaultException.getAllowed());
        illegalRMVersionFaultMsg.setSequenceId(illegalRMVersionFaultException.getSequenceId());
        WsrmHelper.sendFault(sOAPMessageContext, illegalRMVersionFaultMsg, null);
    }

    public static void sendUnknownSequenceFault(UnknownSequenceFaultException unknownSequenceFaultException, SOAPMessageContext sOAPMessageContext) {
        if (verbose) {
            Verbose.logException(unknownSequenceFaultException);
        }
        UnknownSequenceFaultMsg unknownSequenceFaultMsg = new UnknownSequenceFaultMsg(unknownSequenceFaultException.getRMVersion());
        unknownSequenceFaultMsg.setSequenceId(unknownSequenceFaultException.getSequenceId());
        WsrmHelper.sendFault(sOAPMessageContext, unknownSequenceFaultMsg, null);
    }

    public static boolean isRMSequenceSecure(boolean bl, String string) {
        return WsrmServerHandshakeHandler.getRMSequenceContext(bl, string).getWsrmSecurityContext().isSecureWithWssc();
    }

    public static WsrmSequenceContext getRMSequenceContext(boolean bl, String string) {
        SAFConversationInfo sAFConversationInfo = WsrmSAFManager.getConversationInfo(bl, string, false);
        return (WsrmSequenceContext)sAFConversationInfo.getContext();
    }

    private boolean handleCloseSequenceMsg(SOAPMessageContext sOAPMessageContext) throws IllegalRMVersionFaultException {
        WsrmSequenceContext wsrmSequenceContext;
        String string;
        CloseSequenceMsg closeSequenceMsg;
        String string2 = (String)sOAPMessageContext.getProperty("weblogic.wsee.addressing.Action");
        WsrmConstants.RMVersion rMVersion = WsrmProtocolUtils.getActionVersion(WsrmConstants.Action.CLOSE_SEQUENCE, string2);
        if (rMVersion == null) {
            return false;
        }
        try {
            closeSequenceMsg = new CloseSequenceMsg(rMVersion);
            closeSequenceMsg.readMsg(sOAPMessageContext.getMessage());
            string = closeSequenceMsg.getSequenceId();
        }
        catch (HandshakeMsgException handshakeMsgException) {
            if (verbose) {
                Verbose.logException(handshakeMsgException);
            }
            throw new JAXRPCException("HandshakeMsgException", (Throwable)handshakeMsgException);
        }
        if (verbose) {
            Verbose.log("Sequence " + string + " closure requested");
        }
        if ((wsrmSequenceContext = WsrmServerHandshakeHandler.checkRMVersionMatchWithCreateSequence(false, string, rMVersion, (MessageContext)sOAPMessageContext, this.cachedEndptPolicy)).isSecureWithSSL()) {
            WsrmServerHandshakeHandler.validateSSLSessionId(wsrmSequenceContext.getWsrmSecurityContext(), (WlMessageContext)sOAPMessageContext);
        }
        if (wsrmSequenceContext.isSecure()) {
            if (!this.validateSecurityPolicy((MessageContext)sOAPMessageContext, false, string)) {
                return true;
            }
            WsrmServerHandshakeHandler.validateCredential(false, string, wsrmSequenceContext.getRmVersion(), (MessageContext)sOAPMessageContext);
        }
        WsrmSAFManagerFactory.getWsrmSAFReceivingManager().closeSequence((WlMessageContext)sOAPMessageContext, closeSequenceMsg);
        return true;
    }

    private boolean handleCloseSequenceResponseMsg(SOAPMessageContext sOAPMessageContext) throws IllegalRMVersionFaultException {
        WsrmSequenceContext wsrmSequenceContext;
        String string;
        CloseSequenceResponseMsg closeSequenceResponseMsg;
        String string2 = (String)sOAPMessageContext.getProperty("weblogic.wsee.addressing.Action");
        WsrmConstants.RMVersion rMVersion = WsrmProtocolUtils.getActionVersion(WsrmConstants.Action.CLOSE_SEQUENCE_RESPONSE, string2);
        if (rMVersion == null) {
            return false;
        }
        try {
            closeSequenceResponseMsg = new CloseSequenceResponseMsg(rMVersion);
            closeSequenceResponseMsg.readMsg(sOAPMessageContext.getMessage());
            string = closeSequenceResponseMsg.getSequenceId();
        }
        catch (HandshakeMsgException handshakeMsgException) {
            if (verbose) {
                Verbose.logException(handshakeMsgException);
            }
            throw new JAXRPCException("HandshakeMsgException", (Throwable)handshakeMsgException);
        }
        if (verbose) {
            Verbose.log("Sequence " + string + " close response received");
        }
        if ((wsrmSequenceContext = WsrmServerHandshakeHandler.checkRMVersionMatchWithCreateSequence(true, string, rMVersion, (MessageContext)sOAPMessageContext, this.cachedEndptPolicy)).isSecureWithSSL()) {
            WsrmServerHandshakeHandler.validateSSLSessionId(wsrmSequenceContext.getWsrmSecurityContext(), (WlMessageContext)sOAPMessageContext);
        }
        if (wsrmSequenceContext.isSecure()) {
            if (!this.validateSecurityPolicy((MessageContext)sOAPMessageContext, true, string)) {
                return true;
            }
            WsrmServerHandshakeHandler.validateCredential(false, string, wsrmSequenceContext.getRmVersion(), (MessageContext)sOAPMessageContext);
        }
        WsrmSAFManagerFactory.getWsrmSAFSendingManager().handleCloseSequenceResponse(closeSequenceResponseMsg);
        return true;
    }

    private boolean handleTerminateSequenceMsg(SOAPMessageContext sOAPMessageContext) throws IllegalRMVersionFaultException {
        WsrmSequenceContext wsrmSequenceContext;
        String string;
        TerminateSequenceMsg terminateSequenceMsg;
        String string2 = (String)sOAPMessageContext.getProperty("weblogic.wsee.addressing.Action");
        WsrmConstants.RMVersion rMVersion = WsrmProtocolUtils.getActionVersion(WsrmConstants.Action.TERMINATE_SEQUENCE, string2);
        if (rMVersion == null) {
            return false;
        }
        try {
            terminateSequenceMsg = new TerminateSequenceMsg(rMVersion);
            terminateSequenceMsg.readMsg(sOAPMessageContext.getMessage());
            string = terminateSequenceMsg.getSequenceId();
        }
        catch (HandshakeMsgException handshakeMsgException) {
            if (verbose) {
                Verbose.logException(handshakeMsgException);
            }
            throw new JAXRPCException("HandshakeMsgException", (Throwable)handshakeMsgException);
        }
        if (verbose) {
            Verbose.log("Sequence " + string + " termination requested");
        }
        if ((wsrmSequenceContext = WsrmServerHandshakeHandler.checkRMVersionMatchWithCreateSequence(false, string, rMVersion, (MessageContext)sOAPMessageContext, this.cachedEndptPolicy)).isSecureWithSSL()) {
            WsrmServerHandshakeHandler.validateSSLSessionId(wsrmSequenceContext.getWsrmSecurityContext(), (WlMessageContext)sOAPMessageContext);
        }
        if (wsrmSequenceContext.isSecure()) {
            if (!this.validateSecurityPolicy((MessageContext)sOAPMessageContext, false, string)) {
                return true;
            }
            WsrmServerHandshakeHandler.validateCredential(false, string, wsrmSequenceContext.getRmVersion(), (MessageContext)sOAPMessageContext);
        }
        WsrmSAFManagerFactory.getWsrmSAFReceivingManager().terminateSequence((WlMessageContext)sOAPMessageContext, terminateSequenceMsg);
        return true;
    }

    private boolean handleTerminateSequenceResponseMsg(SOAPMessageContext sOAPMessageContext) {
        String string;
        String string2 = (String)sOAPMessageContext.getProperty("weblogic.wsee.addressing.Action");
        WsrmConstants.RMVersion rMVersion = WsrmProtocolUtils.getActionVersion(WsrmConstants.Action.TERMINATE_SEQUENCE_RESPONSE, string2);
        if (rMVersion == null) {
            return false;
        }
        try {
            TerminateSequenceResponseMsg terminateSequenceResponseMsg = new TerminateSequenceResponseMsg(rMVersion);
            terminateSequenceResponseMsg.readMsg(sOAPMessageContext.getMessage());
            string = terminateSequenceResponseMsg.getSequenceId();
        }
        catch (HandshakeMsgException handshakeMsgException) {
            if (verbose) {
                Verbose.logException(handshakeMsgException);
            }
            throw new JAXRPCException("HandshakeMsgException", (Throwable)handshakeMsgException);
        }
        if (verbose) {
            Verbose.log("Sequence " + string + " termination response received");
        }
        return true;
    }

    private boolean handleRMFault(SOAPMessageContext sOAPMessageContext) throws IllegalRMVersionFaultException {
        if (sOAPMessageContext.getProperty("weblogic.wsee.ignore.fault") != null) {
            try {
                SequenceFaultMsg sequenceFaultMsg = SequenceFaultMsgFactory.getInstance().parseSoapFault(sOAPMessageContext.getMessage());
                SequenceFaultMsgType sequenceFaultMsgType = sequenceFaultMsg.getType();
                if (UnknownSequenceFaultMsg.TYPE.equals(sequenceFaultMsgType)) {
                    WsrmSAFManagerFactory.getWsrmSAFReceivingManager().handleFault(sequenceFaultMsg);
                    return true;
                }
                String string = sequenceFaultMsg.getSequenceId();
                WsrmSequenceContext wsrmSequenceContext = WsrmServerHandshakeHandler.checkRMVersionMatchWithCreateSequence(false, string, sequenceFaultMsg.getRmVersion(), (MessageContext)sOAPMessageContext, this.cachedEndptPolicy);
                if (wsrmSequenceContext.isSecureWithSSL()) {
                    WsrmServerHandshakeHandler.validateSSLSessionId(wsrmSequenceContext.getWsrmSecurityContext(), (WlMessageContext)sOAPMessageContext);
                }
                if (wsrmSequenceContext.isSecure()) {
                    if (!this.validateSecurityPolicy((MessageContext)sOAPMessageContext, false, string)) {
                        return true;
                    }
                    WsrmServerHandshakeHandler.validateCredential(false, string, wsrmSequenceContext.getRmVersion(), (MessageContext)sOAPMessageContext);
                }
                WsrmSAFManagerFactory.getWsrmSAFReceivingManager().handleFault(sequenceFaultMsg);
                return true;
            }
            catch (SequenceFaultException sequenceFaultException) {
                return false;
            }
        }
        return false;
    }

    private SCCredential getSCCredential(CreateSequenceMsg createSequenceMsg, MessageContext messageContext) {
        SecurityTokenReference securityTokenReference = createSequenceMsg.getSecurityTokenReference();
        if (securityTokenReference == null) {
            return null;
        }
        SecurityToken[] securityTokenArray = SecurityTokenHelper.findSecurityTokenByType(WSSecurityContext.getSecurityContext(messageContext), securityTokenReference.getValueType());
        if (securityTokenArray.length != 1) {
            throw new JAXRPCException("Can not find any security token of type: " + securityTokenReference.getValueType() + " in CreateSequenceMessage");
        }
        if (!(securityTokenArray[0] instanceof SCTokenBase)) {
            throw new JAXRPCException("At least one SecurityToken was found in CreateSequenceMessage but none was of a recognized SCToken version.");
        }
        return ((SCTokenBase)securityTokenArray[0]).getCredential();
    }

    public static void validateCredential(boolean bl, String string, WsrmConstants.RMVersion rMVersion, MessageContext messageContext) {
        SAFConversationInfo sAFConversationInfo = WsrmSAFManager.getConversationInfo(bl, string, true);
        if (sAFConversationInfo == null && !bl) {
            UnknownSequenceFaultMsg unknownSequenceFaultMsg = new UnknownSequenceFaultMsg(rMVersion);
            unknownSequenceFaultMsg.setSequenceId(string);
            SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
            WsrmHelper.sendFault(sOAPMessageContext, unknownSequenceFaultMsg, null);
            throw new SAFConversationInfoNotFoundException("No sequence information found");
        }
        WsrmServerHandshakeHandler.validateCredential(sAFConversationInfo, messageContext);
    }

    public static void validateCredential(SAFConversationInfo sAFConversationInfo, MessageContext messageContext) {
        WsrmSequenceContext wsrmSequenceContext = (WsrmSequenceContext)sAFConversationInfo.getContext();
        WsrmSecurityContext wsrmSecurityContext = wsrmSequenceContext.getWsrmSecurityContext();
        if (wsrmSecurityContext.isSecureWithWssc()) {
            WsrmServerHandshakeHandler.checkSCCredential(wsrmSecurityContext, messageContext);
        }
    }

    private static void checkSCCredential(WsrmSecurityContext wsrmSecurityContext, MessageContext messageContext) {
        SCCredential sCCredential = (SCCredential)messageContext.getProperty("weblogic.wsee.wssc.sct");
        if (sCCredential == null) {
            return;
        }
        if (wsrmSecurityContext == null) {
            return;
        }
        SCCredential sCCredential2 = wsrmSecurityContext.getSCCredential();
        if (sCCredential2 == null) {
            return;
        }
        if (!sCCredential2.equals(sCCredential)) {
            throw new JAXRPCException("Incoming STR does not match reliable sequence's SCT, incoming: " + (sCCredential == null ? null : sCCredential.getIdentifier()) + " stored: " + sCCredential2.getIdentifier());
        }
    }

    private boolean validateSecurityPolicy(MessageContext messageContext, boolean bl, String string) {
        return this.validateSecurityPolicy(messageContext, bl, string, true);
    }

    private boolean validateSecurityPolicy(MessageContext messageContext, boolean bl, String string, boolean bl2) {
        if (this.isMessageSecured()) {
            messageContext.setProperty("weblogic.wsee.policy.effectiveRequestPolicy", (Object)this.cachedEndptPolicy);
        } else {
            messageContext.setProperty("weblogic.wsee.policy.effectiveRequestPolicy", (Object)WsrmServerHandshakeHandler.getAsyncResponseEndpointSecurityPolicy(bl, string));
        }
        boolean bl3 = bl2 ? AsyncUtil.getWssServerPolicyHandler(WsrmServerHandshakeHandler.getRMSequenceContext(bl, string)).handleRequest(messageContext) : AsyncUtil.getWssServerPolicyHandler(WsrmServerHandshakeHandler.getRMSequenceContext(bl, string)).handleResponse(messageContext);
        if (!bl3 && verbose) {
            this.printThrowableOnContext(messageContext);
        }
        return bl3;
    }

    private boolean isMessageSecured() {
        return this.isMessageSecuredWssp10() || this.isMessageSecuredWssp12();
    }

    private boolean isMessageSecuredWssp10() {
        return SecurityPolicyAssertionFactory.isWSTEnabled(this.cachedEndptPolicy);
    }

    private boolean isMessageSecuredWssp12() {
        return SecurityPolicyAssertionInfoFactory.hasWsTrustPolicy(this.cachedEndptPolicy);
    }

    private void printThrowableOnContext(MessageContext messageContext) {
        Throwable throwable = WlMessageContext.narrow(messageContext).getFault();
        if (throwable != null) {
            Verbose.logException(throwable);
        }
    }

    public static void validateSSLSessionId(WsrmSecurityContext wsrmSecurityContext, WlMessageContext wlMessageContext) {
        if (wsrmSecurityContext != null && wsrmSecurityContext.isSecureWithSSL()) {
            byte[] byArray;
            if (verbose) {
                Verbose.say("");
                Verbose.say("&&&&&&&&&&&&&&&&&& Validating SSL/TLS Session &&&&&&&&&&&&&&&");
            }
            if ((byArray = WsrmSAFReceivingManager.getForcedSSLSessionId(wlMessageContext)) == null) {
                byArray = WsrmSAFReceivingManager.getSSLSessionId(wlMessageContext);
            }
            byte[] byArray2 = wsrmSecurityContext.getSSLSessionId();
            if (verbose) {
                Verbose.say("    Expected: " + WsrmServerHandshakeHandler.dumpByteArray(byArray2));
                Verbose.say("    Actual:   " + WsrmServerHandshakeHandler.dumpByteArray(byArray));
                Verbose.say("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
                Verbose.say("");
            }
            if (byArray == null || !Arrays.equals(byArray, byArray2)) {
                throw new JAXRPCException("Improper SSL session ID found on incoming request. Expected " + WsrmServerHandshakeHandler.dumpByteArray(byArray2) + " but got " + WsrmServerHandshakeHandler.dumpByteArray(byArray));
            }
        }
    }

    private static String dumpByteArray(byte[] byArray) {
        return WsrmSAFReceivingManager.dumpByteArray(byArray);
    }
}

