/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability.headers;

import javax.xml.namespace.QName;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import weblogic.wsee.message.MsgHeaderException;
import weblogic.wsee.message.MsgHeaderType;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.headers.WsrmHeader;
import weblogic.wsee.reliability2.compat.SimpleElement;

public class AckRequestedHeader
extends WsrmHeader {
    private static final long serialVersionUID = -354937597205280227L;
    public static final String LOCAL_NAME = WsrmConstants.Element.ACK_REQUESTED.getElementName();
    public static final MsgHeaderType TYPE = new MsgHeaderType();
    private String sequenceId = null;
    private long messageNumber = 0L;
    private boolean numSet = false;

    public AckRequestedHeader() {
        this(WsrmConstants.RMVersion.latest());
    }

    public AckRequestedHeader(WsrmConstants.RMVersion rMVersion) {
        super(rMVersion, LOCAL_NAME);
    }

    public MsgHeaderType getType() {
        return TYPE;
    }

    public String getSequenceId() {
        return this.sequenceId;
    }

    public void setSequenceId(String string) {
        this.sequenceId = string;
    }

    public long getMessageNumber() {
        return this.messageNumber;
    }

    public void setMessageNumber(long l) {
        this.messageNumber = l;
        this.numSet = true;
    }

    public void readFromSimpleElement(SimpleElement simpleElement) throws MsgHeaderException {
        super.setRmVersionFromSimpleElement(simpleElement);
        String string = null;
        try {
            this.sequenceId = SimpleElement.getContentForChild(simpleElement, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.IDENTIFIER.getElementName());
            string = SimpleElement.getOptionalContentForChild(simpleElement, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.MESSAGE_NUMBER.getElementName());
            if (string != null) {
                this.messageNumber = Long.parseLong(string);
                if (this.messageNumber <= 0L) {
                    throw new MsgHeaderException("Message Number is not a positive number: " + this.messageNumber);
                }
                this.numSet = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new MsgHeaderException("Message number format error: " + string, numberFormatException);
        }
    }

    public SimpleElement writeToSimpleElement() throws MsgHeaderException {
        QName qName = this.getName();
        SimpleElement simpleElement = new SimpleElement(qName);
        if (this.sequenceId == null) {
            throw new MsgHeaderException("Sequence ID is not set");
        }
        SimpleElement.addChild(simpleElement, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.IDENTIFIER.getQualifiedName(this.getRmVersion()), this.sequenceId);
        if (this.numSet) {
            if (this.messageNumber <= 0L) {
                throw new MsgHeaderException("Message number is not positive");
            }
            SimpleElement.addChild(simpleElement, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.MESSAGE_NUMBER.getQualifiedName(this.getRmVersion()), Long.toString(this.messageNumber));
        }
        return simpleElement;
    }

    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        QName qName = this.getName();
        String string = qName.getNamespaceURI();
        String string2 = qName.getLocalPart();
        contentHandler.startPrefixMapping("", string);
        contentHandler.startElement(string, string2, string2, EMPTY_ATTS);
        this.writeToIdentifierSubElement(contentHandler, this.sequenceId);
        if (this.numSet) {
            this.writeToMessageNumberSubElement(contentHandler, this.messageNumber);
        }
        contentHandler.endElement(string, string2, string2);
    }
}

