/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability.headers;

import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import weblogic.wsee.message.MsgHeaderException;
import weblogic.wsee.message.MsgHeaderType;
import weblogic.wsee.reliability.MessageRange;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.headers.WsrmHeader;
import weblogic.wsee.reliability2.compat.SimpleElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcknowledgementHeader
extends WsrmHeader {
    private static final long serialVersionUID = 3068970050564544792L;
    public static final String LOCAL_NAME = WsrmConstants.Element.ACK.getElementName();
    public static final MsgHeaderType TYPE = new MsgHeaderType();
    private SortedSet<MessageRange> ranges = new TreeSet<MessageRange>();
    private boolean none;
    private boolean finalFlag;
    private String sequenceId;
    private long nack = 0L;
    private boolean nackSet = false;

    public AcknowledgementHeader() {
        this(WsrmConstants.RMVersion.latest());
    }

    public AcknowledgementHeader(WsrmConstants.RMVersion rMVersion) {
        super(rMVersion, LOCAL_NAME);
    }

    @Override
    public MsgHeaderType getType() {
        return TYPE;
    }

    public String getSequenceId() {
        return this.sequenceId;
    }

    public void setSequenceId(String string) {
        this.sequenceId = string;
    }

    public void setNack(long l) {
        this.nack = l;
        this.nackSet = true;
    }

    public long getNack() {
        return this.nack;
    }

    public void acknowledgeMessages(long l, long l2) {
        this.ranges.add(new MessageRange(l, l2));
    }

    public void clear() {
        this.ranges.clear();
    }

    public Iterator listMessageRanges() {
        return this.ranges.iterator();
    }

    public void setAcknowledgementRanges(SortedSet<MessageRange> sortedSet) {
        this.ranges = sortedSet;
    }

    public SortedSet<MessageRange> getAcknowledgementRanges() {
        return this.ranges;
    }

    public boolean isAcknowledged(int n) {
        Iterator iterator = this.listMessageRanges();
        while (iterator.hasNext()) {
            MessageRange messageRange = (MessageRange)iterator.next();
            if ((long)n < messageRange.lowerBounds || (long)n > messageRange.upperBounds) continue;
            return true;
        }
        return false;
    }

    public boolean getNone() {
        return this.none;
    }

    public void setNone(boolean bl) {
        this.none = bl;
    }

    public boolean getFinal() {
        return this.finalFlag;
    }

    public void setFinal(boolean bl) {
        this.finalFlag = bl;
    }

    @Override
    public void readFromSimpleElement(SimpleElement simpleElement) throws MsgHeaderException {
        super.setRmVersionFromSimpleElement(simpleElement);
        this.sequenceId = SimpleElement.getContentForChild(simpleElement, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.IDENTIFIER.getElementName());
        String string = SimpleElement.getOptionalContentForChild(simpleElement, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.NACK.getElementName());
        if (string != null) {
            try {
                this.nack = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MsgHeaderException("Nack number format error: " + string, numberFormatException);
            }
            if (this.nack <= 0L) {
                throw new MsgHeaderException("Nack is not a positive number: " + this.nack);
            }
            this.nackSet = true;
        }
        List<SimpleElement> list = simpleElement.getChildren(this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.ACK_RANGE.getElementName());
        int n = list.size();
        if (string != null && n > 0) {
            throw new MsgHeaderException("Nack and AcknowledgementRange cannot coexist");
        }
        for (SimpleElement simpleElement2 : list) {
            long l;
            long l2;
            String string2 = simpleElement2.getAttr(null, WsrmConstants.Element.LOWER.getElementName());
            if (string2 == null) {
                throw new MsgHeaderException("No lower bound specified in AcknowledgementRange");
            }
            try {
                l2 = Long.parseLong(string2);
                if (l2 <= 0L) {
                    throw new MsgHeaderException("AcknowledgementRange lower bound is not a positive message number: " + l2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new MsgHeaderException("AcknowledgementRange lower bound number format error: " + string2, numberFormatException);
            }
            String string3 = simpleElement2.getAttr(null, WsrmConstants.Element.UPPER.getElementName());
            if (string3 == null) {
                throw new MsgHeaderException("No upper bound specified in AcknowledgementRange");
            }
            try {
                l = Long.parseLong(string3);
                if (l <= 0L) {
                    throw new MsgHeaderException("AcknowledgementRange upper bound is not a positive message number: " + l);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new MsgHeaderException("AcknowledgementRange upper bound number format error: " + string3, numberFormatException);
            }
            if (l < l2) {
                throw new MsgHeaderException("AcknowledgementRange upper bound is lower than lower bound: upper = " + l + " lower = " + l2);
            }
            this.acknowledgeMessages(l2, l);
        }
        if (this.getRmVersion().isLaterThanOrEqualTo(WsrmConstants.RMVersion.RM_11)) {
            SimpleElement simpleElement2;
            SimpleElement simpleElement3 = SimpleElement.getOptionalChild(simpleElement, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.NONE.getElementName());
            if (simpleElement3 != null) {
                if (this.ranges.size() > 0) {
                    throw new MsgHeaderException("Cannot have None element *and* AcknowledgementRange elements in a SequenceAcknowledgement header");
                }
                this.setNone(true);
            }
            if ((simpleElement2 = SimpleElement.getOptionalChild(simpleElement, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.FINAL.getElementName())) != null) {
                this.setFinal(true);
            }
        }
    }

    @Override
    public SimpleElement writeToSimpleElement() throws MsgHeaderException {
        try {
            return this.writeToSimpleElementOrContentHandler(null);
        }
        catch (SAXException sAXException) {
            throw new MsgHeaderException(sAXException.getMessage());
        }
    }

    @Override
    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        try {
            this.writeToSimpleElementOrContentHandler(contentHandler);
        }
        catch (MsgHeaderException msgHeaderException) {
            throw new SAXException(msgHeaderException);
        }
    }

    private SimpleElement writeToSimpleElementOrContentHandler(ContentHandler contentHandler) throws MsgHeaderException, SAXException {
        String string;
        String string2;
        Object object;
        Object object2;
        boolean bl = contentHandler == null;
        QName qName = this.getName();
        String string3 = qName.getNamespaceURI();
        String string4 = qName.getLocalPart();
        SimpleElement simpleElement = null;
        if (bl) {
            simpleElement = new SimpleElement(qName);
        } else {
            contentHandler.startPrefixMapping("", string3);
            contentHandler.startElement(string3, string4, string4, EMPTY_ATTS);
        }
        if (this.sequenceId == null) {
            String string5 = "Sequence ID is not set";
            if (bl) {
                throw new MsgHeaderException(string5);
            }
            throw new SAXException(string5);
        }
        if (bl) {
            SimpleElement.addChild(simpleElement, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.IDENTIFIER.getQualifiedName(this.getRmVersion()), this.sequenceId);
        } else {
            this.writeToIdentifierSubElement(contentHandler, this.sequenceId);
        }
        boolean bl2 = this.nackSet;
        long l = this.nack;
        if (!this.listMessageRanges().hasNext() && this.getRmVersion() == WsrmConstants.RMVersion.RM_10 && !bl2) {
            bl2 = true;
            l = 1L;
        }
        if (bl2) {
            if (l <= 0L) {
                throw new MsgHeaderException("Nack is not a positive number: " + l);
            }
            if (this.ranges.size() > 0) {
                throw new MsgHeaderException("Nack and AcknowledgementRange cannot coexist");
            }
            String string6 = Long.toString(l);
            if (bl) {
                SimpleElement.addChild(simpleElement, string3, WsrmConstants.Element.NACK.getQualifiedName(this.getRmVersion()), string6);
            } else {
                object2 = WsrmConstants.Element.NACK.getQName(this.getRmVersion());
                object = ((QName)object2).getNamespaceURI();
                string2 = ((QName)object2).getLocalPart();
                contentHandler.startElement((String)object, string2, string2, EMPTY_ATTS);
                contentHandler.characters(string6.toCharArray(), 0, string6.length());
                contentHandler.endElement((String)object, string2, string2);
            }
        }
        boolean bl3 = false;
        object2 = this.listMessageRanges();
        while (object2.hasNext()) {
            Object object3;
            bl3 = true;
            object = (MessageRange)object2.next();
            if (((MessageRange)object).lowerBounds <= 0L) {
                throw new MsgHeaderException("AcknowledgementRange lower bound is not a positive message number: " + ((MessageRange)object).lowerBounds);
            }
            if (((MessageRange)object).upperBounds <= 0L) {
                throw new MsgHeaderException("AcknowledgementRange upper bound is not a positive message number: " + ((MessageRange)object).upperBounds);
            }
            if (((MessageRange)object).upperBounds < ((MessageRange)object).lowerBounds) {
                throw new MsgHeaderException("AcknowledgementRange upper bound is lower than lower bound: upper = " + ((MessageRange)object).upperBounds + " lower = " + ((MessageRange)object).lowerBounds);
            }
            string2 = Long.toString(((MessageRange)object).lowerBounds);
            string = Long.toString(((MessageRange)object).upperBounds);
            if (bl) {
                object3 = SimpleElement.createChild(simpleElement, string3, WsrmConstants.Element.ACK_RANGE.getQualifiedName(this.getRmVersion()));
                ((SimpleElement)object3).setAttr(null, WsrmConstants.Element.LOWER.getElementName(), string2);
                ((SimpleElement)object3).setAttr(null, WsrmConstants.Element.UPPER.getElementName(), string);
                continue;
            }
            object3 = new AttributesImpl();
            ((AttributesImpl)object3).addAttribute(string3, WsrmConstants.Element.LOWER.getElementName(), WsrmConstants.Element.LOWER.getQualifiedName(this.getRmVersion()), "messageNumberType", string2);
            ((AttributesImpl)object3).addAttribute(string3, WsrmConstants.Element.UPPER.getElementName(), WsrmConstants.Element.UPPER.getQualifiedName(this.getRmVersion()), "messageNumberType", string);
            QName qName2 = WsrmConstants.Element.ACK_RANGE.getQName(this.getRmVersion());
            String string7 = qName2.getNamespaceURI();
            String string8 = qName2.getLocalPart();
            contentHandler.startElement(string7, string8, string8, (Attributes)object3);
            contentHandler.endElement(string7, string8, string8);
        }
        if (this.getRmVersion().isLaterThanOrEqualTo(WsrmConstants.RMVersion.RM_11)) {
            if (this.none || !bl3) {
                if (this.ranges.size() > 0) {
                    throw new MsgHeaderException("Cannot have None element *and* AcknowledgementRange elements in a SequenceAcknowledgement header");
                }
                if (bl) {
                    SimpleElement.addChild(simpleElement, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.NONE.getQualifiedName(this.getRmVersion()), "");
                } else {
                    object = WsrmConstants.Element.NONE.getQName(this.getRmVersion());
                    string2 = ((QName)object).getNamespaceURI();
                    string = ((QName)object).getLocalPart();
                    contentHandler.startElement(string2, string, string, EMPTY_ATTS);
                    contentHandler.endElement(string2, string, string);
                }
            }
            if (this.finalFlag) {
                if (bl) {
                    SimpleElement.addChild(simpleElement, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.FINAL.getQualifiedName(this.getRmVersion()), "");
                } else {
                    object = WsrmConstants.Element.FINAL.getQName(this.getRmVersion());
                    string2 = ((QName)object).getNamespaceURI();
                    string = ((QName)object).getLocalPart();
                    contentHandler.startElement(string2, string, string, EMPTY_ATTS);
                    contentHandler.endElement(string2, string, string);
                }
            }
        }
        if (!bl) {
            contentHandler.endElement(string3, string4, string4);
        }
        return simpleElement;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Sequence ID: ").append(this.sequenceId);
        if (this.nackSet) {
            stringBuffer.append(" Nack is ").append(this.nack);
        } else {
            Iterator iterator = this.listMessageRanges();
            while (iterator.hasNext()) {
                MessageRange messageRange = (MessageRange)iterator.next();
                stringBuffer.append(" (");
                stringBuffer.append(messageRange.lowerBounds);
                stringBuffer.append("-");
                stringBuffer.append(messageRange.upperBounds);
                stringBuffer.append(")");
            }
        }
        if (this.getRmVersion().isLaterThanOrEqualTo(WsrmConstants.RMVersion.RM_11)) {
            stringBuffer.append("\nNone=" + this.none);
            stringBuffer.append("\nFinal=" + this.finalFlag);
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

