/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability.headers;

import com.bea.xbean.util.XsTypeConverter;
import java.util.Calendar;
import javax.xml.namespace.QName;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import weblogic.wsee.message.MsgHeaderException;
import weblogic.wsee.message.MsgHeaderType;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.headers.WsrmHeader;
import weblogic.wsee.reliability2.compat.SimpleElement;

public class SequenceHeader
extends WsrmHeader {
    private static final long serialVersionUID = 7442405656574388775L;
    public static final String LOCAL_NAME = WsrmConstants.Element.SEQUENCE.getElementName();
    public static final MsgHeaderType TYPE = new MsgHeaderType();
    private boolean lastMessage = false;
    private String sequenceId = null;
    private long messageNumber = 0L;
    private Calendar expires;

    public SequenceHeader() {
        this(WsrmConstants.RMVersion.latest());
    }

    public SequenceHeader(WsrmConstants.RMVersion rMVersion) {
        this(rMVersion, null, 0L);
    }

    public SequenceHeader(WsrmConstants.RMVersion rMVersion, String string, long l) {
        this(rMVersion, string, l, false);
    }

    public SequenceHeader(WsrmConstants.RMVersion rMVersion, String string, long l, boolean bl) {
        super(rMVersion, LOCAL_NAME);
        this.sequenceId = string;
        this.messageNumber = l;
        this.lastMessage = bl;
        this.setMustUnderstand(true);
    }

    public MsgHeaderType getType() {
        return TYPE;
    }

    public String getSequenceId() {
        return this.sequenceId;
    }

    public void setSequenceId(String string) {
        this.sequenceId = string;
    }

    public long getMessageNumber() {
        return this.messageNumber;
    }

    public void setMessageNumber(long l) {
        this.messageNumber = l;
    }

    public void setLastMessage(boolean bl) {
        if (this.getRmVersion() != WsrmConstants.RMVersion.RM_10) {
            throw new IllegalStateException("Cannot set Sequence/LastMessage in Sequence header for WS-RM versions past version 1.0. WS-RM version in use is " + (Object)((Object)this.getRmVersion()) + ". Use CloseSequence message instead");
        }
        this.lastMessage = bl;
    }

    public boolean isLastMessage() {
        if (this.getRmVersion() != WsrmConstants.RMVersion.RM_10) {
            throw new IllegalStateException("Cannot use Sequence/LastMessage from Sequence header for WS-RM versions past version 1.0. WS-RM version in use is " + (Object)((Object)this.getRmVersion()) + ". Use CloseSequence message instead");
        }
        return this.lastMessage;
    }

    public Calendar getExpires() {
        return this.expires;
    }

    public void setExpires(Calendar calendar) {
        this.expires = calendar;
    }

    public void readFromSimpleElement(SimpleElement simpleElement) throws MsgHeaderException {
        super.setRmVersionFromSimpleElement(simpleElement);
        this.sequenceId = SimpleElement.getContentForChild(simpleElement, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.IDENTIFIER.getElementName());
        String string = SimpleElement.getContentForChild(simpleElement, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.MESSAGE_NUMBER.getElementName());
        this.messageNumber = Long.parseLong(string);
        SimpleElement simpleElement2 = SimpleElement.getOptionalChild(simpleElement, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.LAST_MESSAGE.getElementName());
        if (simpleElement2 != null && this.getRmVersion() != WsrmConstants.RMVersion.RM_10) {
            throw new MsgHeaderException("Found Sequence/LastMessage in incoming Sequence header. Cannot use Sequence/LastMessage for WS-RM versions past version 1.0. WS-RM version in use is " + (Object)((Object)this.getRmVersion()) + ". Use CloseSequence message instead");
        }
        this.lastMessage = simpleElement2 != null;
        String string2 = SimpleElement.getOptionalContentForChild(simpleElement, "http://schemas.xmlsoap.org/ws/2002/07/utility", "Expires");
        if (string2 != null) {
            this.expires = XsTypeConverter.lexDateTime((CharSequence)string2);
        }
    }

    public SimpleElement writeToSimpleElement() throws MsgHeaderException {
        QName qName = this.getName();
        SimpleElement simpleElement = new SimpleElement(qName);
        if (this.sequenceId == null) {
            throw new MsgHeaderException("Sequence ID is not set");
        }
        SimpleElement.addChild(simpleElement, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.IDENTIFIER.getQualifiedName(this.getRmVersion()), this.sequenceId);
        SimpleElement.addChild(simpleElement, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.MESSAGE_NUMBER.getQualifiedName(this.getRmVersion()), Long.toString(this.messageNumber));
        if (this.lastMessage && this.getRmVersion() == WsrmConstants.RMVersion.RM_10) {
            SimpleElement.addChild(simpleElement, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.LAST_MESSAGE.getQualifiedName(this.getRmVersion()), "");
        }
        if (this.expires != null) {
            SimpleElement.addChild(simpleElement, "http://schemas.xmlsoap.org/ws/2002/07/utility", "wsu:Expires", XsTypeConverter.printDateTime((Calendar)this.expires));
        }
        return simpleElement;
    }

    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        QName qName = this.getName();
        String string = qName.getNamespaceURI();
        String string2 = qName.getLocalPart();
        contentHandler.startPrefixMapping("", string);
        contentHandler.startElement(string, string2, string2, EMPTY_ATTS);
        this.writeToIdentifierSubElement(contentHandler, this.sequenceId);
        this.writeToMessageNumberSubElement(contentHandler, this.messageNumber);
        contentHandler.endElement(string, string2, string2);
    }
}

