/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability.headers;

import javax.xml.namespace.QName;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import weblogic.wsee.message.MsgHeaderException;
import weblogic.wsee.message.MsgHeaderType;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.headers.WsrmHeader;
import weblogic.wsee.reliability2.compat.SimpleElement;

public class TestSequenceSSLHeader
extends WsrmHeader {
    private static final long serialVersionUID = -5994213896810460482L;
    public static final String LOCAL_NAME = WsrmConstants.Element.TEST_SEQUENCE_SSL.getElementName();
    public static final MsgHeaderType TYPE = new MsgHeaderType();
    private String sslSessionId;

    public TestSequenceSSLHeader() {
        this(WsrmConstants.RMVersion.latest());
    }

    public TestSequenceSSLHeader(WsrmConstants.RMVersion rMVersion) {
        super(rMVersion, LOCAL_NAME);
    }

    public MsgHeaderType getType() {
        return TYPE;
    }

    public String getSSLSessionId() {
        return this.sslSessionId;
    }

    public void setSSLSessionId(String string) {
        this.sslSessionId = string;
    }

    public void readFromSimpleElement(SimpleElement simpleElement) throws MsgHeaderException {
        String string;
        super.setRmVersionFromSimpleElement(simpleElement);
        this.sslSessionId = string = SimpleElement.getContentForChild(simpleElement, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.TEST_SEQUENCE_SSL_SESSION_ID.getElementName());
    }

    public SimpleElement writeToSimpleElement() throws MsgHeaderException {
        QName qName = this.getName();
        SimpleElement simpleElement = new SimpleElement(qName);
        if (this.sslSessionId != null) {
            SimpleElement.addChild(simpleElement, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.TEST_SEQUENCE_SSL_SESSION_ID.getQualifiedName(this.getRmVersion()), this.sslSessionId);
        }
        return simpleElement;
    }

    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        QName qName = this.getName();
        String string = qName.getNamespaceURI();
        String string2 = qName.getLocalPart();
        contentHandler.startPrefixMapping("", string);
        contentHandler.startElement(string, string2, string2, EMPTY_ATTS);
        QName qName2 = WsrmConstants.Element.TEST_SEQUENCE_SSL_SESSION_ID.getQName(this.getRmVersion());
        String string3 = qName2.getNamespaceURI();
        String string4 = qName2.getLocalPart();
        contentHandler.startElement(string3, string4, string4, EMPTY_ATTS);
        contentHandler.characters(this.getSSLSessionId().toCharArray(), 0, this.getSSLSessionId().length());
        contentHandler.endElement(string3, string4, string4);
        contentHandler.endElement(string, string2, string2);
    }
}

