/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability.headers;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability2.compat.CommonHeader;
import weblogic.wsee.reliability2.compat.SimpleElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WsrmHeader
extends CommonHeader {
    private static final long serialVersionUID = -2300983151778747402L;
    private WsrmConstants.RMVersion rmVersion;

    protected WsrmHeader(WsrmConstants.RMVersion rMVersion, String string) {
        super(new QName(rMVersion.getNamespaceUri(), string, rMVersion.getPrefix()));
        this.setRmVersion(rMVersion);
    }

    public WsrmConstants.RMVersion getRmVersion() {
        return this.rmVersion;
    }

    protected void setRmVersion(WsrmConstants.RMVersion rMVersion) {
        this.rmVersion = rMVersion;
        super.setName(new QName(rMVersion.getNamespaceUri(), this.getName().getLocalPart(), rMVersion.getPrefix()));
    }

    @Override
    public void setNamespaceUri(String string) {
        WsrmConstants.RMVersion rMVersion = WsrmConstants.RMVersion.forNamespaceUri(string);
        this.setRmVersion(rMVersion);
    }

    public static QName getQName(Class clazz, WsrmConstants.RMVersion rMVersion) {
        try {
            Field field = clazz.getField("LOCAL_NAME");
            String string = (String)field.get(null);
            return new QName(rMVersion.getNamespaceUri(), string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString(), exception);
        }
    }

    public static List<QName> getQNames(Class clazz) {
        try {
            ArrayList<QName> arrayList = new ArrayList<QName>();
            for (WsrmConstants.RMVersion rMVersion : WsrmConstants.RMVersion.values()) {
                arrayList.add(WsrmHeader.getQName(clazz, rMVersion));
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString(), exception);
        }
    }

    protected void setRmVersionFromSimpleElement(SimpleElement simpleElement) {
        String string = simpleElement.getName().getNamespaceURI();
        WsrmConstants.RMVersion rMVersion = WsrmConstants.RMVersion.forNamespaceUri(string);
        this.setRmVersion(rMVersion);
    }

    protected void writeToIdentifierSubElement(ContentHandler contentHandler, String string) throws SAXException {
        QName qName = WsrmConstants.Element.IDENTIFIER.getQName(this.getRmVersion());
        String string2 = qName.getNamespaceURI();
        String string3 = qName.getLocalPart();
        contentHandler.startElement(string2, string3, string3, EMPTY_ATTS);
        contentHandler.characters(string.toCharArray(), 0, string.length());
        contentHandler.endElement(string2, string3, string3);
    }

    protected void writeToMessageNumberSubElement(ContentHandler contentHandler, long l) throws SAXException {
        QName qName = WsrmConstants.Element.MESSAGE_NUMBER.getQName(this.getRmVersion());
        String string = qName.getNamespaceURI();
        String string2 = qName.getLocalPart();
        contentHandler.startElement(string, string2, string2, EMPTY_ATTS);
        String string3 = Long.toString(l);
        contentHandler.characters(string3.toCharArray(), 0, string3.length());
        contentHandler.endElement(string, string2, string2);
    }
}

