/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability.headers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import weblogic.wsee.message.MsgHeader;
import weblogic.wsee.message.MsgHeaderException;
import weblogic.wsee.message.MsgHeaderFactoryIntf;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.headers.AckRequestedHeader;
import weblogic.wsee.reliability.headers.AcknowledgementHeader;
import weblogic.wsee.reliability.headers.SequenceHeader;
import weblogic.wsee.reliability.headers.TestSequenceSSLHeader;
import weblogic.wsee.reliability.headers.UsesSequenceSSLHeader;
import weblogic.wsee.reliability.headers.UsesSequenceSTRHeader;
import weblogic.wsee.reliability.headers.WsrmHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsrmMsgHeaderFactory
implements MsgHeaderFactoryIntf {
    private Map<QName, Class<? extends WsrmHeader>> headerClasses = new HashMap<QName, Class<? extends WsrmHeader>>();
    private static Set<Class> needFillQNameHeaders = new HashSet<Class>();

    public WsrmMsgHeaderFactory() {
        for (WsrmConstants.RMVersion rMVersion : WsrmConstants.RMVersion.values()) {
            this.addMsgHeaderClass(WsrmHeader.getQName(AcknowledgementHeader.class, rMVersion), AcknowledgementHeader.class);
            this.addMsgHeaderClass(WsrmHeader.getQName(AckRequestedHeader.class, rMVersion), AckRequestedHeader.class);
            this.addMsgHeaderClass(WsrmHeader.getQName(SequenceHeader.class, rMVersion), SequenceHeader.class);
            needFillQNameHeaders.add(AcknowledgementHeader.class);
            needFillQNameHeaders.add(AckRequestedHeader.class);
            needFillQNameHeaders.add(SequenceHeader.class);
            if (!rMVersion.isLaterThanOrEqualTo(WsrmConstants.RMVersion.RM_11)) continue;
            this.addMsgHeaderClass(WsrmHeader.getQName(UsesSequenceSTRHeader.class, rMVersion), UsesSequenceSTRHeader.class);
            this.addMsgHeaderClass(WsrmHeader.getQName(UsesSequenceSSLHeader.class, rMVersion), UsesSequenceSSLHeader.class);
            this.addMsgHeaderClass(WsrmHeader.getQName(TestSequenceSSLHeader.class, rMVersion), TestSequenceSSLHeader.class);
            needFillQNameHeaders.add(UsesSequenceSTRHeader.class);
            needFillQNameHeaders.add(UsesSequenceSSLHeader.class);
            needFillQNameHeaders.add(TestSequenceSSLHeader.class);
        }
    }

    @Override
    public MsgHeader createMsgHeader(QName qName) throws MsgHeaderException {
        try {
            Class<? extends WsrmHeader> clazz = this.headerClasses.get(qName);
            if (clazz != null) {
                MsgHeader msgHeader = clazz.newInstance();
                if (needFillQNameHeaders.contains(clazz)) {
                    ((WsrmHeader)msgHeader).setNamespaceUri(qName.getNamespaceURI());
                }
                return msgHeader;
            }
            return null;
        }
        catch (MsgHeaderException msgHeaderException) {
            throw msgHeaderException;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MsgHeaderException("Could not build header for " + qName, illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new MsgHeaderException("Could not build header for " + qName, instantiationException);
        }
    }

    private void addMsgHeaderClass(QName qName, Class<? extends WsrmHeader> clazz) {
        this.headerClasses.put(qName, clazz);
    }

    public Class<? extends WsrmHeader> getHeaderClass(QName qName) {
        return this.headerClasses.get(qName);
    }

    public QName getHeaderQName(Class<? extends WsrmHeader> clazz, WsrmConstants.RMVersion rMVersion) {
        for (QName qName : this.headerClasses.keySet()) {
            if (!clazz.isAssignableFrom(this.headerClasses.get(qName))) continue;
            return new QName(rMVersion.getNamespaceUri(), qName.getLocalPart());
        }
        return null;
    }
}

