/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability.policy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyAssertion;
import weblogic.wsee.policy.framework.PolicyAssertionFactory;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.runtime.PolicyContext;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.policy.AcknowledgementInterval;
import weblogic.wsee.reliability.policy.BaseRetransmissionInterval;
import weblogic.wsee.reliability.policy.ExponentialBackoff;
import weblogic.wsee.reliability.policy.InactivityTimeout;
import weblogic.wsee.reliability.policy.RMAssertion;
import weblogic.wsee.reliability.policy.SequenceExpires;
import weblogic.wsee.reliability.policy.SequenceQOS;
import weblogic.wsee.reliability.policy11.RM11Assertion;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.ws.WsPort;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReliabilityPolicyAssertionsFactory
extends PolicyAssertionFactory {
    public static final String RM_POLICY_NS_URI = "http://schemas.xmlsoap.org/ws/2004/03/rm";

    @Override
    public PolicyAssertion createAssertion(Node node) throws PolicyException {
        assert (1 == node.getNodeType());
        Element element = (Element)node;
        try {
            if (weblogic.wsee.policy.framework.DOMUtils.equalsQName(element, RMAssertion.RM_ASSERTION)) {
                return this.createRM10Assertion(element);
            }
            if (weblogic.wsee.policy.framework.DOMUtils.equalsQName(element, RM11Assertion.NAME)) {
                return this.createRM11Assertion(element);
            }
            return null;
        }
        catch (DOMProcessingException dOMProcessingException) {
            throw new PolicyException((Throwable)((Object)dOMProcessingException));
        }
    }

    private PolicyAssertion createRM10Assertion(Element element) throws DOMProcessingException, PolicyException {
        Object object;
        Element element2;
        Element element3;
        Element element4;
        Object object2;
        RMAssertion rMAssertion = new RMAssertion();
        Element element5 = DOMUtils.getOptionalElementByTagNameNS(element, InactivityTimeout.INACTIVITY_TIMEOUT.getNamespaceURI(), InactivityTimeout.INACTIVITY_TIMEOUT.getLocalPart());
        if (element5 != null) {
            object2 = this.getRequiredAttributeValue(element5, InactivityTimeout.INACTIVITY_TIMEOUT, InactivityTimeout.MILLISECONDS_ATTRIBUTE);
            long l = Long.parseLong((String)object2);
            if (l <= 0L) {
                throw new PolicyException("Value of attribute '" + InactivityTimeout.MILLISECONDS_ATTRIBUTE + "' must be positive");
            }
            rMAssertion.setInactivityTimeout(new InactivityTimeout(l));
        }
        if ((object2 = DOMUtils.getOptionalElementByTagNameNS(element, AcknowledgementInterval.ACKNOWLEDGEMENT_INTERVAL.getNamespaceURI(), AcknowledgementInterval.ACKNOWLEDGEMENT_INTERVAL.getLocalPart())) != null) {
            String string = this.getRequiredAttributeValue((Element)object2, AcknowledgementInterval.ACKNOWLEDGEMENT_INTERVAL, AcknowledgementInterval.MILLISECONDS_ATTRIBUTE);
            long l = Long.parseLong(string);
            if (l <= 0L) {
                throw new PolicyException("Value of attribute '" + AcknowledgementInterval.MILLISECONDS_ATTRIBUTE + "' must be positive");
            }
            rMAssertion.setAckInterval(new AcknowledgementInterval(l));
        }
        if ((element4 = DOMUtils.getOptionalElementByTagNameNS(element, BaseRetransmissionInterval.BASE_RETRANSMISSION_INTERVAL.getNamespaceURI(), BaseRetransmissionInterval.BASE_RETRANSMISSION_INTERVAL.getLocalPart())) != null) {
            String string = this.getRequiredAttributeValue(element4, BaseRetransmissionInterval.BASE_RETRANSMISSION_INTERVAL, BaseRetransmissionInterval.MILLISECONDS_ATTRIBUTE);
            long l = Long.parseLong(string);
            if (l <= 0L) {
                throw new PolicyException("Value of attribute '" + BaseRetransmissionInterval.MILLISECONDS_ATTRIBUTE + "' must be positive");
            }
            rMAssertion.setBaseRetransmissionInterval(new BaseRetransmissionInterval(l));
        }
        if ((element3 = DOMUtils.getOptionalElementByTagNameNS(element, ExponentialBackoff.EXPONENTIAL_BACKOFF.getNamespaceURI(), ExponentialBackoff.EXPONENTIAL_BACKOFF.getLocalPart())) != null) {
            rMAssertion.setExponentialBackoff(new ExponentialBackoff());
        }
        if ((element2 = DOMUtils.getOptionalElementByTagNameNS(element, SequenceExpires.SEQUENCE_EXPIRES.getNamespaceURI(), SequenceExpires.SEQUENCE_EXPIRES.getLocalPart())) != null) {
            object = this.getRequiredAttributeValue(element2, SequenceExpires.SEQUENCE_EXPIRES, SequenceExpires.EXPIRES_ATTRIBUTE);
            rMAssertion.setSeqExpires(new SequenceExpires((String)object));
        }
        if ((object = DOMUtils.getOptionalElementByTagNameNS(element, SequenceQOS.SEQUENCE_QOS.getNamespaceURI(), SequenceQOS.SEQUENCE_QOS.getLocalPart())) != null) {
            String string = this.getRequiredAttributeValue((Element)object, SequenceQOS.SEQUENCE_QOS, SequenceQOS.QOS_ATTRIBUTE);
            rMAssertion.setSeqQos(new SequenceQOS(string));
        }
        return rMAssertion;
    }

    private PolicyAssertion createRM11Assertion(Element element) throws DOMProcessingException, PolicyException {
        RM11Assertion rM11Assertion = new RM11Assertion();
        rM11Assertion.read(element);
        return rM11Assertion;
    }

    public static boolean hasRMPolicy(WsPort wsPort, PolicyServer policyServer, Map map) throws PolicyException {
        boolean bl = false;
        Iterator iterator = wsPort.getEndpoint().getMethods();
        while (iterator.hasNext()) {
            WsMethod wsMethod = (WsMethod)iterator.next();
            NormalizedExpression normalizedExpression = PolicyContext.getRequestEffectivePolicy(wsPort, wsMethod, policyServer, map);
            if (!ReliabilityPolicyAssertionsFactory.hasRMPolicy(normalizedExpression)) continue;
            bl = true;
        }
        return bl;
    }

    public static boolean hasRMPolicy(NormalizedExpression normalizedExpression) {
        return normalizedExpression.containsPolicyAssertion(RMAssertion.class) || normalizedExpression.containsPolicyAssertion(RM11Assertion.class);
    }

    public static List<WsrmConstants.RMVersion> getRMPolicyVersions(NormalizedExpression normalizedExpression) {
        ArrayList<WsrmConstants.RMVersion> arrayList = new ArrayList<WsrmConstants.RMVersion>();
        if (normalizedExpression.containsPolicyAssertion(RMAssertion.class)) {
            arrayList.add(WsrmConstants.RMVersion.RM_10);
        }
        if (normalizedExpression.containsPolicyAssertion(RM11Assertion.class)) {
            arrayList.add(WsrmConstants.RMVersion.RM_11);
        }
        return arrayList;
    }

    public static RM11Assertion copyRM11Assertion(RM11Assertion rM11Assertion) {
        RM11Assertion rM11Assertion2 = new RM11Assertion();
        rM11Assertion2.setOptional(rM11Assertion.isOptional());
        rM11Assertion2.setDeliveryAssurance(rM11Assertion.getDeliveryAssurance());
        rM11Assertion2.setPolicyNamespaceUri(rM11Assertion.getPolicyNamespaceUri());
        rM11Assertion2.setPolicySubject(rM11Assertion.getPolicySubject());
        rM11Assertion2.setSequenceSTR(rM11Assertion.getSequenceSTR());
        rM11Assertion2.setSequenceTransportSecurity(rM11Assertion.getSequenceTransportSecurity());
        return rM11Assertion2;
    }

    public static RMAssertion copyRMAssertion(RMAssertion rMAssertion) {
        RMAssertion rMAssertion2 = new RMAssertion();
        rMAssertion2.setAckInterval(rMAssertion.getAckInterval());
        rMAssertion2.setBaseRetransmissionInterval(rMAssertion.getBaseRetransmissionInterval());
        rMAssertion2.setExponentialBackoff(rMAssertion.getExponentialBackoff());
        rMAssertion2.setInactivityTimeout(rMAssertion.getInactivityTimeout());
        rMAssertion2.setOptional(rMAssertion.isOptional());
        rMAssertion2.setPolicyNamespaceUri(rMAssertion.getPolicyNamespaceUri());
        rMAssertion2.setPolicySubject(rMAssertion.getPolicySubject());
        rMAssertion2.setSeqExpires(rMAssertion.getSeqExpires());
        rMAssertion2.setSeqQos(rMAssertion.getSeqQos());
        return rMAssertion2;
    }

    public static boolean hasSSLTLSPolicy(NormalizedExpression normalizedExpression) {
        RM11Assertion rM11Assertion = (RM11Assertion)normalizedExpression.getPolicyAssertion(RM11Assertion.class);
        if (rM11Assertion != null) {
            return rM11Assertion.getSequenceTransportSecurity() != null;
        }
        return false;
    }

    private String getRequiredAttributeValue(Element element, QName qName, QName qName2) throws PolicyException {
        String string = weblogic.wsee.policy.framework.DOMUtils.getAttributeValueAsString(element, qName2);
        if (string == null) {
            throw new PolicyException("Required attribute '" + qName2 + "' is missing from the '" + qName + "' assertion");
        }
        return string;
    }

    static {
        ReliabilityPolicyAssertionsFactory.registerAssertion(RMAssertion.RM_ASSERTION, RMAssertion.class.getName());
        ReliabilityPolicyAssertionsFactory.registerAssertion(RM11Assertion.NAME, RM11Assertion.class.getName());
    }
}

