/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability.policy;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.rpc.handler.HandlerInfo;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.handler.HandlerList;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.provider.ClientConfigurationHandler;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.reliability.WsrmClientHandler;
import weblogic.wsee.reliability.WsrmPreprocessHandler;
import weblogic.wsee.reliability.policy.ReliabilityPolicyAssertionsFactory;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsService;
import weblogic.wsee.ws.init.WsDeploymentContext;

public class WsrmClientConfigHandler
implements ClientConfigurationHandler {
    private static final boolean verbose = Verbose.isVerbose(WsrmClientConfigHandler.class);
    private static final List BEFORE_PREPROCESS = Arrays.asList((Object[])new String[]{"ADDRESSING_HANDLER", "CONVERSATION_GET_ID_HANDLER"});
    private static final List AFTER_PREPROCESS = Arrays.asList((Object[])new String[]{"CODEC_HANDLER"});
    private static final List BEFORE_RELIABILITY = Arrays.asList((Object[])new String[]{"SECURITY_HANDLER", "CONNECTION_HANDLER"});
    private static final List AFTER_RELIABILITY = Arrays.asList((Object[])new String[]{"ASYNC_HANDLER"});

    public void process(WsDeploymentContext wsDeploymentContext) throws PolicyException {
        WsService wsService = wsDeploymentContext.getWsService();
        if (verbose) {
            Verbose.log("Calling WsrmClientConfigHandler");
        }
        PolicyServer policyServer = wsService.getPolicyServer();
        Iterator<WsPort> iterator = wsService.getPorts();
        while (iterator.hasNext()) {
            WsPort wsPort = iterator.next();
            if (!ReliabilityPolicyAssertionsFactory.hasRMPolicy(wsPort, policyServer, policyServer.getCachedPolicies())) continue;
            if (verbose) {
                Verbose.log("WSRM enabled for port " + wsPort.getWsdlPort().getName());
            }
            HandlerList handlerList = wsPort.getInternalHandlerList();
            HandlerInfo handlerInfo = new HandlerInfo(WsrmPreprocessHandler.class, new HashMap(), null);
            HandlerInfo handlerInfo2 = new HandlerInfo(WsrmClientHandler.class, new HashMap(), null);
            try {
                handlerList.lenientInsert("WSRM_PREPROCESS_HANDLER", handlerInfo, AFTER_PREPROCESS, BEFORE_PREPROCESS);
                handlerList.lenientInsert("RELIABILITY_HANDLER", handlerInfo2, AFTER_RELIABILITY, BEFORE_RELIABILITY);
            }
            catch (HandlerException handlerException) {
                throw new PolicyException("Failed to register handler", handlerException);
            }
        }
    }
}

