/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability.policy;

import java.util.StringTokenizer;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyAssertion;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.util.PolicySelectionHelper;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.policy.AcknowledgementInterval;
import weblogic.wsee.reliability.policy.BaseRetransmissionInterval;
import weblogic.wsee.reliability.policy.ExponentialBackoff;
import weblogic.wsee.reliability.policy.InactivityTimeout;
import weblogic.wsee.reliability.policy.RMAssertion;
import weblogic.wsee.reliability.policy.SequenceExpires;
import weblogic.wsee.reliability.policy.SequenceQOS;
import weblogic.wsee.reliability.policy11.DeliveryAssurance;
import weblogic.wsee.reliability.policy11.RM11Assertion;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfoFactory;
import weblogic.wsee.util.Verbose;

public class WsrmPolicyRuntimeHandler
extends GenericHandler {
    private static final boolean verbose = Verbose.isVerbose(WsrmPolicyRuntimeHandler.class);
    public static final String WSRM_POLICY_PROCESSED_PROPERTY = "weblogic.wsee.reliability.WsrmPolicyProcessed";

    public boolean processRequest(MessageContext messageContext, NormalizedExpression normalizedExpression) throws PolicyException, JAXRPCException {
        return this.processRequest(messageContext, normalizedExpression, null);
    }

    public boolean processRequest(MessageContext messageContext, NormalizedExpression normalizedExpression, WsrmConstants.RMVersion rMVersion) throws PolicyException, JAXRPCException {
        if (messageContext.containsProperty(WSRM_POLICY_PROCESSED_PROPERTY)) {
            if (verbose) {
                Verbose.log("Skipping WS-RM policy processing, as it has already been performed on this message");
            }
            return true;
        }
        messageContext.setProperty(WSRM_POLICY_PROCESSED_PROPERTY, (Object)"true");
        PolicySelectionHelper policySelectionHelper = new PolicySelectionHelper(normalizedExpression, messageContext);
        if (!policySelectionHelper.hasReliabilityPolicyAssertion()) {
            return false;
        }
        PolicyAssertion[] policyAssertionArray = policySelectionHelper.getReliabilityPolicyAssertion();
        if (policyAssertionArray == null) {
            return false;
        }
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        boolean bl = false;
        for (int i = 0; i < policyAssertionArray.length; ++i) {
            if (rMVersion != null && rMVersion.isLaterThanOrEqualTo(WsrmConstants.RMVersion.RM_11) && policyAssertionArray[i] instanceof RM11Assertion || rMVersion == null && policyAssertionArray[i] instanceof RM11Assertion) {
                this.processRM11Request((RM11Assertion)policyAssertionArray[i], normalizedExpression, wlMessageContext);
                bl = true;
                break;
            }
            if ((rMVersion == null || rMVersion != WsrmConstants.RMVersion.RM_10 || !(policyAssertionArray[i] instanceof RMAssertion)) && (rMVersion != null || !(policyAssertionArray[i] instanceof RMAssertion))) continue;
            this.processRM10Request((RMAssertion)policyAssertionArray[i], wlMessageContext);
            bl = true;
            break;
        }
        if (!bl) {
            throw new UnsupportedOperationException("Couldn't find any known RM Assertion");
        }
        return true;
    }

    private void processRM11Request(RM11Assertion rM11Assertion, NormalizedExpression normalizedExpression, WlMessageContext wlMessageContext) throws PolicyException {
        wlMessageContext.setProperty("weblogic.wsee.wsrm.RMVersion", (Object)WsrmConstants.RMVersion.latest());
        if (!rM11Assertion.getOptional()) {
            wlMessageContext.setProperty("weblogic.wsee.rm.mandatory", "true");
        }
        this.handleRM11SequenceSTR(rM11Assertion, normalizedExpression, wlMessageContext);
        this.handleRM11SequenceTranportSecurity(rM11Assertion, normalizedExpression, wlMessageContext);
        this.handleRM11DeliveryAssurance(rM11Assertion, wlMessageContext);
    }

    private void handleRM11DeliveryAssurance(RM11Assertion rM11Assertion, WlMessageContext wlMessageContext) {
        DeliveryAssurance deliveryAssurance = rM11Assertion.getDeliveryAssurance();
        if (deliveryAssurance == null) {
            return;
        }
        wlMessageContext.setProperty("weblogic.wsee.user.defined.qos", "true");
        if (deliveryAssurance.getInOrder() != null) {
            wlMessageContext.setProperty("weblogic.wsee.qos.inorder", "true");
        }
        if (deliveryAssurance.getExactlyOnce() != null) {
            wlMessageContext.setProperty("weblogic.wsee.qos.delivery", new Integer(1));
        } else if (deliveryAssurance.getAtMostOnce() != null) {
            wlMessageContext.setProperty("weblogic.wsee.qos.delivery", new Integer(3));
        } else if (deliveryAssurance.getAtLeastOnce() != null) {
            wlMessageContext.setProperty("weblogic.wsee.qos.delivery", new Integer(2));
        }
    }

    private void handleRM11SequenceTranportSecurity(RM11Assertion rM11Assertion, NormalizedExpression normalizedExpression, WlMessageContext wlMessageContext) throws PolicyException {
        if (rM11Assertion.getSequenceTransportSecurity() != null) {
            wlMessageContext.setProperty("weblogic.wsee.wsrm.SequenceTransportSecurity", "true");
            boolean bl = false;
            if (!SecurityPolicyAssertionInfoFactory.hasTransportSecurityPolicy(normalizedExpression)) {
                bl = true;
            }
            if (bl) {
                throw new PolicyException("SequenceTransportSecurity set in WS-RM policy, but no SSL/TLS (HTTPS) policy is configured to support this on this service");
            }
        }
    }

    private void handleRM11SequenceSTR(RM11Assertion rM11Assertion, NormalizedExpression normalizedExpression, WlMessageContext wlMessageContext) throws PolicyException {
        if (rM11Assertion.getSequenceSTR() != null) {
            wlMessageContext.setProperty("weblogic.wsee.wsrm.SequenceSTR", "true");
            if (!SecurityPolicyAssertionInfoFactory.hasWsTrustPolicy(normalizedExpression)) {
                throw new PolicyException("SequenceSTR set in WS-RM policy, but no WS-Trust policy is configured to support this on this service");
            }
        }
    }

    private void processRM10Request(RMAssertion rMAssertion, WlMessageContext wlMessageContext) throws PolicyException {
        wlMessageContext.setProperty("weblogic.wsee.wsrm.RMVersion", (Object)WsrmConstants.RMVersion.RM_10);
        if (!rMAssertion.getOptional()) {
            wlMessageContext.setProperty("weblogic.wsee.rm.mandatory", "true");
        }
        this.handleRM10InactivityTimeout(rMAssertion, wlMessageContext);
        this.handleRM10BaseRetransmissionInterval(rMAssertion, wlMessageContext);
        this.handleRM10AcknowledgementInterval(rMAssertion, wlMessageContext);
        this.handleRM10ExponentialBackoff(rMAssertion, wlMessageContext);
        this.handleRM10SequenceExpiration(rMAssertion, wlMessageContext);
        this.handleRM10SequenceQOS(rMAssertion, wlMessageContext);
    }

    private void handleRM10SequenceQOS(RMAssertion rMAssertion, WlMessageContext wlMessageContext) throws PolicyException {
        SequenceQOS sequenceQOS = rMAssertion.getSeqQos();
        if (sequenceQOS != null) {
            this.parseRM10QOS(sequenceQOS, wlMessageContext);
        }
    }

    private void handleRM10SequenceExpiration(RMAssertion rMAssertion, WlMessageContext wlMessageContext) {
        SequenceExpires sequenceExpires = rMAssertion.getSeqExpires();
        if (sequenceExpires != null) {
            wlMessageContext.setProperty("weblogic.wsee.wsrm.SequenceExpiration", sequenceExpires.getExpires());
            if (verbose) {
                Verbose.log("Sequence expires at " + sequenceExpires.getExpires());
            }
        }
    }

    private void handleRM10ExponentialBackoff(RMAssertion rMAssertion, WlMessageContext wlMessageContext) {
        ExponentialBackoff exponentialBackoff = rMAssertion.getExponentialBackoff();
        if (exponentialBackoff != null) {
            wlMessageContext.setProperty("weblogic.wsee.wsrm.RetransmissionExponentialBackoff", new Boolean(true));
            if (verbose) {
                Verbose.log("ExponentialBackoff is set to true");
            }
        }
    }

    private void handleRM10AcknowledgementInterval(RMAssertion rMAssertion, WlMessageContext wlMessageContext) {
        AcknowledgementInterval acknowledgementInterval = rMAssertion.getAckInterval();
        if (acknowledgementInterval != null) {
            long l = acknowledgementInterval.getInterval();
            wlMessageContext.setProperty("weblogic.wsee.wsrm.AcknowledgementInterval", this.createDurationFromMillis(l).toString());
            if (verbose) {
                Verbose.log("AcknowledgementInterval is " + l + " msec");
            }
        }
    }

    private void handleRM10BaseRetransmissionInterval(RMAssertion rMAssertion, WlMessageContext wlMessageContext) {
        BaseRetransmissionInterval baseRetransmissionInterval = rMAssertion.getBaseRetransmissionInterval();
        if (baseRetransmissionInterval != null) {
            long l = baseRetransmissionInterval.getInterval();
            Duration duration = this.createDurationFromMillis(l);
            wlMessageContext.setProperty("weblogic.wsee.wsrm.BaseRetransmissionInterval", duration.toString());
            if (verbose) {
                Verbose.log("BaseRetransmissionInterval is " + l + " msec");
            }
        }
    }

    private void handleRM10InactivityTimeout(RMAssertion rMAssertion, WlMessageContext wlMessageContext) {
        InactivityTimeout inactivityTimeout = rMAssertion.getInactivityTimeout();
        if (inactivityTimeout != null) {
            long l = inactivityTimeout.getTimeout();
            wlMessageContext.setProperty("weblogic.wsee.wsrm.InactivityTimeout", this.createDurationFromMillis(l).toString());
            if (verbose) {
                Verbose.log("InactivityTimeout is " + l + " msec");
            }
        }
    }

    private Duration createDurationFromMillis(long l) {
        try {
            return DatatypeFactory.newInstance().newDuration(l);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw new RuntimeException(datatypeConfigurationException.toString(), datatypeConfigurationException);
        }
    }

    private void parseRM10QOS(SequenceQOS sequenceQOS, WlMessageContext wlMessageContext) throws PolicyException {
        RM10QosInfo rM10QosInfo = WsrmPolicyRuntimeHandler.parseRM10QOS(sequenceQOS);
        if (rM10QosInfo.safQoS >= 0) {
            wlMessageContext.setProperty("weblogic.wsee.user.defined.qos", "true");
            wlMessageContext.setProperty("weblogic.wsee.qos.delivery", rM10QosInfo.safQoS);
        }
        if (rM10QosInfo.inOrder) {
            wlMessageContext.setProperty("weblogic.wsee.qos.inorder", "true");
        }
    }

    public static RM10QosInfo parseRM10QOS(SequenceQOS sequenceQOS) throws PolicyException {
        RM10QosInfo rM10QosInfo = new RM10QosInfo();
        if (sequenceQOS == null) {
            return rM10QosInfo;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(sequenceQOS.getQos());
        boolean bl = false;
        boolean bl2 = false;
        while (stringTokenizer.hasMoreTokens()) {
            rM10QosInfo.userDefinedQoS = true;
            String string = stringTokenizer.nextToken();
            if ("InOrder".equalsIgnoreCase(string)) {
                if (bl) {
                    throw new PolicyException("InOrder QOS is set more than once");
                }
                bl = true;
                rM10QosInfo.inOrder = true;
                continue;
            }
            if ("ExactlyOnce".equalsIgnoreCase(string)) {
                if (bl2) {
                    throw new PolicyException("Delivery QOS is set more than once");
                }
                bl2 = true;
                rM10QosInfo.safQoS = new Integer(1);
                continue;
            }
            if ("AtMostOnce".equalsIgnoreCase(string)) {
                if (bl2) {
                    throw new PolicyException("Delivery QOS is set more than once");
                }
                bl2 = true;
                rM10QosInfo.safQoS = new Integer(3);
                continue;
            }
            if ("AtLeastOnce".equalsIgnoreCase(string)) {
                if (bl2) {
                    throw new PolicyException("Delivery QOS is set more than once");
                }
                bl2 = true;
                rM10QosInfo.safQoS = new Integer(2);
                continue;
            }
            throw new PolicyException("Unsupported Quality of Service specified: " + string);
        }
        return rM10QosInfo;
    }

    public QName[] getHeaders() {
        return new QName[0];
    }

    public static class RM10QosInfo {
        public boolean userDefinedQoS;
        public boolean inOrder;
        public int safQoS = -1;
    }
}

