/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability.policy;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.rpc.handler.HandlerInfo;
import weblogic.messaging.saf.SAFEndpoint;
import weblogic.messaging.saf.internal.SAFManagerImpl;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.buffer.BufferManager;
import weblogic.wsee.cluster.ForwardingHandler;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.handler.HandlerList;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.provider.ServiceConfigurationHandler;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.reliability.WsrmEndpointManager;
import weblogic.wsee.reliability.WsrmSAFEndpoint;
import weblogic.wsee.reliability.WsrmServerConfigHandler;
import weblogic.wsee.reliability.WsrmServerHandler;
import weblogic.wsee.reliability.handshake.WsrmServerHandshakeHandler;
import weblogic.wsee.reliability.policy.ReliabilityPolicyAssertionsFactory;
import weblogic.wsee.server.ServerUtil;
import weblogic.wsee.server.jms.WsDispatchMessageListener;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsService;
import weblogic.wsee.ws.init.WsDeploymentContext;
import weblogic.wsee.ws.init.WsDeploymentException;

public class WsrmServiceConfigHandler
implements ServiceConfigurationHandler {
    private static final boolean verbose = Verbose.isVerbose(WsrmServiceConfigHandler.class);
    private static final List BEFORE_CONFIG = Arrays.asList((Object[])new String[]{"WSRM_HANDSHAKE_HANDLER"});
    private static final List AFTER_CONFIG = Arrays.asList((Object[])new String[]{"ADDRESSING_HANDLER", "SECURITY_HANDLER", "FORWARDING_HANDLER"});
    private static final List BEFORE_HANDSHAKE = Arrays.asList((Object[])new String[]{"OPERATION_LOOKUP_HANDLER"});
    private static final List AFTER_HANDSHAKE = Arrays.asList((Object[])new String[]{"ADDRESSING_HANDLER", "SECURITY_HANDLER", "FORWARDING_HANDLER"});
    private static final List BEFORE_RELIABILITY = Arrays.asList((Object[])new String[]{"ONE_WAY_HANDLER"});
    private static final List AFTER_RELIABILITY = Arrays.asList((Object[])new String[]{"OPERATION_LOOKUP_HANDLER", "SECURITY_SERVER_POLICY_HANDLER"});
    private static final List BEFORE_FORWARDING = Arrays.asList((Object[])new String[]{"SECURITY_HANDLER", "SECURITY_SERVER_POLICY_HANDLER", "RELIABILITY_HANDLER", "ADDRESSING_HANDLER"});
    private static final List AFTER_FORWARDING = Arrays.asList((Object[])new String[]{"CONNECTION_HANDLER"});

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(WsDeploymentContext wsDeploymentContext) throws PolicyException {
        WsService wsService = wsDeploymentContext.getWsService();
        WsrmEndpointManager wsrmEndpointManager = (WsrmEndpointManager)SAFManagerImpl.getManager().getEndpointManager(2);
        assert (wsrmEndpointManager != null);
        PolicyServer policyServer = wsService.getPolicyServer();
        Iterator<WsPort> iterator = wsService.getPorts();
        while (iterator.hasNext()) {
            WsPort wsPort = iterator.next();
            if (!ReliabilityPolicyAssertionsFactory.hasRMPolicy(wsPort, policyServer, policyServer.getCachedPolicies())) continue;
            if (verbose) {
                Verbose.log("WSRM enabled for port " + wsPort.getWsdlPort().getName());
            }
            this.insertHandlers(wsPort);
            Class clazz = wsPort.getEndpoint().getJwsClass();
            ServerUtil.QueueInfo queueInfo = ServerUtil.getBufferQueueInfo(clazz);
            StringBuffer stringBuffer = new StringBuffer();
            WsDispatchMessageListener wsDispatchMessageListener = new WsDispatchMessageListener(wsPort);
            boolean bl = true;
            for (int i = 0; i < wsDeploymentContext.getServiceURIs().length; ++i) {
                String string = wsDeploymentContext.getContextPath();
                String string2 = wsDeploymentContext.getServiceURIs()[i];
                String string3 = AsyncUtil.calculateServiceTargetURI(string, string2);
                BufferManager bufferManager = BufferManager.instance();
                Object object = bufferManager;
                synchronized (object) {
                    if (bufferManager.getMessageListener(string3) != null) {
                        bl = false;
                        continue;
                    }
                    bufferManager.addMessageListener(string3, wsDispatchMessageListener);
                }
                wsDeploymentContext.addBufferTargetURI(string3);
                bufferManager.setTargetQueue(string3, queueInfo);
                object = new WsrmSAFEndpoint(string3);
                if (verbose) {
                    Verbose.log("Adding endpoint at " + string3);
                }
                wsrmEndpointManager.addEndpoint(string3, (SAFEndpoint)object);
                if (stringBuffer.length() == 0) {
                    stringBuffer.append(AsyncUtil.getAsyncSelector(string3));
                    continue;
                }
                stringBuffer.append(" OR (" + AsyncUtil.getAsyncSelector(string3) + ")");
            }
            if (!bl) continue;
            if (verbose) {
                Verbose.log("Set up dynamic MDB to queue: " + queueInfo.getQueueName());
            }
            try {
                AsyncUtil.setupDynamicMDB(wsDeploymentContext, stringBuffer.toString(), queueInfo.getQueueName(), queueInfo.getMdbRunAsPrincipalName(), "weblogic.wsee.server.jms.MdbWS", 180);
            }
            catch (WsDeploymentException wsDeploymentException) {
                throw new PolicyException(wsDeploymentException);
            }
        }
    }

    private void insertHandlers(WsPort wsPort) throws PolicyException {
        HandlerList handlerList = wsPort.getInternalHandlerList();
        HandlerInfo handlerInfo = new HandlerInfo(WsrmServerHandler.class, new HashMap(), null);
        HandlerInfo handlerInfo2 = new HandlerInfo(WsrmServerConfigHandler.class, new HashMap(), null);
        HandlerInfo handlerInfo3 = new HandlerInfo(WsrmServerHandshakeHandler.class, new HashMap(), null);
        HandlerInfo handlerInfo4 = new HandlerInfo(ForwardingHandler.class, new HashMap(), null);
        try {
            handlerList.lenientInsert("WSRM_CONFIG_HANDLER", handlerInfo2, AFTER_CONFIG, BEFORE_CONFIG);
            handlerList.lenientInsert("WSRM_HANDSHAKE_HANDLER", handlerInfo3, AFTER_HANDSHAKE, BEFORE_HANDSHAKE);
            handlerList.lenientInsert("RELIABILITY_HANDLER", handlerInfo, AFTER_RELIABILITY, BEFORE_RELIABILITY);
            handlerList.lenientInsert("FORWARDING_HANDLER", handlerInfo4, AFTER_FORWARDING, BEFORE_FORWARDING);
        }
        catch (HandlerException handlerException) {
            throw new PolicyException("Failed to register handler", handlerException);
        }
    }
}

