/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability.policy11;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.util.PolicyHelper;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.policy11.AtLeastOnce;
import weblogic.wsee.reliability.policy11.AtMostOnce;
import weblogic.wsee.reliability.policy11.ExactlyOnce;
import weblogic.wsee.reliability.policy11.InOrder;
import weblogic.wsee.wsdl.WsdlWriter;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public class DeliveryAssurance
implements Externalizable {
    public static final long serialVersionUID = 1L;
    public static final QName NAME = new QName(WsrmConstants.RMVersion.latest().getPolicyNamespaceUri(), "DeliveryAssurance");
    private AtLeastOnce _atLeastOnce;
    private AtMostOnce _atMostOnce;
    private ExactlyOnce _exactlyOnce;
    private InOrder _inOrder;

    public AtLeastOnce getAtLeastOnce() {
        return this._atLeastOnce;
    }

    public void setAtLeastOnce(AtLeastOnce atLeastOnce) {
        this._atLeastOnce = atLeastOnce;
    }

    public AtMostOnce getAtMostOnce() {
        return this._atMostOnce;
    }

    public void setAtMostOnce(AtMostOnce atMostOnce) {
        this._atMostOnce = atMostOnce;
    }

    public ExactlyOnce getExactlyOnce() {
        return this._exactlyOnce;
    }

    public void setExactlyOnce(ExactlyOnce exactlyOnce) {
        this._exactlyOnce = exactlyOnce;
    }

    public InOrder getInOrder() {
        return this._inOrder;
    }

    public void setInOrder(InOrder inOrder) {
        this._inOrder = inOrder;
    }

    public Element serialize(Document document) throws PolicyException {
        Element element = weblogic.wsee.policy.framework.DOMUtils.createElement(NAME, document);
        if (this._atLeastOnce != null) {
            element.appendChild(this._atLeastOnce.serialize(document));
        }
        if (this._atMostOnce != null) {
            element.appendChild(this._atMostOnce.serialize(document));
        }
        if (this._exactlyOnce != null) {
            element.appendChild(this._exactlyOnce.serialize(document));
        }
        if (this._inOrder != null) {
            element.appendChild(this._inOrder.serialize(document));
        }
        return element;
    }

    protected void write(Element element, WsdlWriter wsdlWriter) {
        Element element2 = wsdlWriter.addChild(element, NAME.getLocalPart(), NAME.getNamespaceURI());
        element2 = PolicyHelper.hasWsp15NamespaceUri(element) ? wsdlWriter.addChild(element2, "Policy", "http://www.w3.org/ns/ws-policy") : wsdlWriter.addChild(element2, "Policy", "http://schemas.xmlsoap.org/ws/2004/09/policy");
        if (this._atLeastOnce != null) {
            this._atLeastOnce.write(element2, wsdlWriter);
        }
        if (this._atMostOnce != null) {
            this._atMostOnce.write(element2, wsdlWriter);
        }
        if (this._exactlyOnce != null) {
            this._exactlyOnce.write(element2, wsdlWriter);
        }
        if (this._inOrder != null) {
            this._inOrder.write(element2, wsdlWriter);
        }
    }

    protected void read(Element element) throws DOMProcessingException, PolicyException {
        Element element2;
        Element element3;
        Element element4;
        Element element5 = DOMUtils.getOptionalElementByTagNameNS(element, "http://schemas.xmlsoap.org/ws/2004/09/policy", "Policy");
        if (element5 != null) {
            this.read(element5);
            return;
        }
        element5 = DOMUtils.getOptionalElementByTagNameNS(element, "http://www.w3.org/ns/ws-policy", "Policy");
        if (element5 != null) {
            this.read(element5);
            return;
        }
        Element element6 = DOMUtils.getOptionalElementByTagNameNS(element, AtLeastOnce.NAME.getNamespaceURI(), AtLeastOnce.NAME.getLocalPart());
        if (element6 != null) {
            this._atLeastOnce = new AtLeastOnce();
            this._atLeastOnce.read(element6);
        }
        if ((element4 = DOMUtils.getOptionalElementByTagNameNS(element, AtMostOnce.NAME.getNamespaceURI(), AtMostOnce.NAME.getLocalPart())) != null) {
            this._atMostOnce = new AtMostOnce();
            this._atMostOnce.read(element4);
        }
        if ((element3 = DOMUtils.getOptionalElementByTagNameNS(element, ExactlyOnce.NAME.getNamespaceURI(), ExactlyOnce.NAME.getLocalPart())) != null) {
            this._exactlyOnce = new ExactlyOnce();
            this._exactlyOnce.read(element3);
        }
        if ((element2 = DOMUtils.getOptionalElementByTagNameNS(element, InOrder.NAME.getNamespaceURI(), InOrder.NAME.getLocalPart())) != null) {
            this._inOrder = new InOrder();
            this._inOrder.read(element2);
        }
        this.validate();
    }

    public void validate() throws PolicyException {
        boolean bl = false;
        if (this._atLeastOnce != null && (this._atMostOnce != null || this._exactlyOnce != null)) {
            bl = true;
        }
        if (this._atMostOnce != null && (this._atLeastOnce != null || this._exactlyOnce != null)) {
            bl = true;
        }
        if (this._exactlyOnce != null && (this._atMostOnce != null || this._atLeastOnce != null)) {
            bl = true;
        }
        if (bl) {
            throw new PolicyException("Only one of AtLeastOnce, AtMostOnce, and ExactlyOnce can be specified under DeliveryAssurance");
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof DeliveryAssurance)) {
            return false;
        }
        DeliveryAssurance deliveryAssurance = (DeliveryAssurance)object;
        boolean bl = this.compareObjects(this._atLeastOnce, deliveryAssurance._atLeastOnce);
        bl &= this.compareObjects(this._atMostOnce, deliveryAssurance._atMostOnce);
        bl &= this.compareObjects(this._exactlyOnce, deliveryAssurance._exactlyOnce);
        return bl &= this.compareObjects(this._inOrder, deliveryAssurance._inOrder);
    }

    private boolean compareObjects(Object object, Object object2) {
        if (object == null && object2 != null) {
            return false;
        }
        if (object2 == null && object != null) {
            return false;
        }
        if (object == null && object2 == null) {
            return true;
        }
        if (object != null) {
            return object.equals(object2);
        }
        return false;
    }

    public int hashCode() {
        int n = NAME.hashCode();
        if (this._atLeastOnce != null) {
            n += this._atLeastOnce.hashCode();
        }
        if (this._atMostOnce != null) {
            n += this._atMostOnce.hashCode();
        }
        if (this._exactlyOnce != null) {
            n += this._exactlyOnce.hashCode();
        }
        if (this._inOrder != null) {
            n += this._inOrder.hashCode();
        }
        return n;
    }

    public QName getName() {
        return NAME;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        if (n == 1) {
            this._atLeastOnce = new AtLeastOnce();
            this._atLeastOnce.readExternal(objectInput);
        }
        if ((n = objectInput.readInt()) == 1) {
            this._atMostOnce = new AtMostOnce();
            this._atMostOnce.readExternal(objectInput);
        }
        if ((n = objectInput.readInt()) == 1) {
            this._exactlyOnce = new ExactlyOnce();
            this._exactlyOnce.readExternal(objectInput);
        }
        if ((n = objectInput.readInt()) == 1) {
            this._inOrder = new InOrder();
            this._inOrder.readExternal(objectInput);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this._atLeastOnce != null) {
            objectOutput.writeInt(1);
            this._atLeastOnce.writeExternal(objectOutput);
        } else {
            objectOutput.writeInt(0);
        }
        if (this._atMostOnce != null) {
            objectOutput.writeInt(1);
            this._atMostOnce.writeExternal(objectOutput);
        } else {
            objectOutput.writeInt(0);
        }
        if (this._exactlyOnce != null) {
            objectOutput.writeInt(1);
            this._exactlyOnce.writeExternal(objectOutput);
        } else {
            objectOutput.writeInt(0);
        }
        if (this._inOrder != null) {
            objectOutput.writeInt(1);
            this._inOrder.writeExternal(objectOutput);
        } else {
            objectOutput.writeInt(0);
        }
    }
}

