/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability.policy11;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weblogic.wsee.policy.framework.PolicyAssertion;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.util.PolicyHelper;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.policy11.DeliveryAssurance;
import weblogic.wsee.reliability.policy11.SequenceSTR;
import weblogic.wsee.reliability.policy11.SequenceTransportSecurity;
import weblogic.wsee.wsdl.WsdlWriter;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public class RM11Assertion
extends PolicyAssertion
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public static final QName NAME = new QName(WsrmConstants.RMVersion.latest().getPolicyNamespaceUri(), "RMAssertion");
    private SequenceSTR _sequenceSTR;
    private SequenceTransportSecurity _sequenceTransportSecurity;
    private DeliveryAssurance _deliveryAssurance;

    public SequenceSTR getSequenceSTR() {
        return this._sequenceSTR;
    }

    public void setSequenceSTR(SequenceSTR sequenceSTR) {
        this._sequenceSTR = sequenceSTR;
    }

    public SequenceTransportSecurity getSequenceTransportSecurity() {
        return this._sequenceTransportSecurity;
    }

    public void setSequenceTransportSecurity(SequenceTransportSecurity sequenceTransportSecurity) {
        this._sequenceTransportSecurity = sequenceTransportSecurity;
    }

    public DeliveryAssurance getDeliveryAssurance() {
        return this._deliveryAssurance;
    }

    public void setDeliveryAssurance(DeliveryAssurance deliveryAssurance) {
        this._deliveryAssurance = deliveryAssurance;
    }

    public Element serialize(Document document) throws PolicyException {
        Element element = weblogic.wsee.policy.framework.DOMUtils.createElement(NAME, document);
        if (this.optional) {
            PolicyHelper.addOptionalAttribute(element, this.getPolicyNamespaceUri());
        }
        if (this._sequenceSTR != null) {
            element.appendChild(this._sequenceSTR.serialize(document));
        }
        if (this._sequenceTransportSecurity != null) {
            element.appendChild(this._sequenceTransportSecurity.serialize(document));
        }
        if (this._deliveryAssurance != null) {
            element.appendChild(this._deliveryAssurance.serialize(document));
        }
        return element;
    }

    protected void write(Element element, WsdlWriter wsdlWriter) {
        Element element2 = wsdlWriter.addChild(element, NAME.getLocalPart(), NAME.getNamespaceURI());
        if (this.optional) {
            PolicyHelper.addOptionalAttribute(element2, null);
        }
        element2 = PolicyHelper.hasWsp15NamespaceUri(element) ? wsdlWriter.addChild(element2, "Policy", "http://www.w3.org/ns/ws-policy") : wsdlWriter.addChild(element2, "Policy", "http://schemas.xmlsoap.org/ws/2004/09/policy");
        if (this._sequenceSTR != null) {
            this._sequenceSTR.write(element2, wsdlWriter);
        }
        if (this._sequenceTransportSecurity != null) {
            this._sequenceTransportSecurity.write(element2, wsdlWriter);
        }
        if (this._deliveryAssurance != null) {
            this._deliveryAssurance.write(element2, wsdlWriter);
        }
    }

    public void read(Element element) throws DOMProcessingException, PolicyException {
        Element element2;
        Element element3;
        Element element4 = DOMUtils.getOptionalElementByTagNameNS(element, "http://schemas.xmlsoap.org/ws/2004/09/policy", "Policy");
        if (element4 != null) {
            this.read(element4);
            return;
        }
        element4 = DOMUtils.getOptionalElementByTagNameNS(element, "http://www.w3.org/ns/ws-policy", "Policy");
        if (element4 != null) {
            this.read(element4);
            return;
        }
        Element element5 = DOMUtils.getOptionalElementByTagNameNS(element, SequenceSTR.NAME.getNamespaceURI(), SequenceSTR.NAME.getLocalPart());
        if (element5 != null) {
            this._sequenceSTR = new SequenceSTR();
            this._sequenceSTR.read(element5);
        }
        if ((element3 = DOMUtils.getOptionalElementByTagNameNS(element, SequenceTransportSecurity.NAME.getNamespaceURI(), SequenceTransportSecurity.NAME.getLocalPart())) != null) {
            this._sequenceTransportSecurity = new SequenceTransportSecurity();
            this._sequenceTransportSecurity.read(element3);
        }
        if ((element2 = DOMUtils.getOptionalElementByTagNameNS(element, DeliveryAssurance.NAME.getNamespaceURI(), DeliveryAssurance.NAME.getLocalPart())) != null) {
            this._deliveryAssurance = new DeliveryAssurance();
            this._deliveryAssurance.read(element2);
        }
        this.validate();
    }

    public void validate() throws PolicyException {
        if (this._sequenceSTR != null && this._sequenceTransportSecurity != null) {
            throw new PolicyException("Only one of SequenceSTR and SequenceTransportSecurity can be specified under RMAssertion");
        }
        if (this._deliveryAssurance != null) {
            this._deliveryAssurance.validate();
        }
    }

    private boolean checkEqual(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        return object2.equals(object);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof RM11Assertion) {
            RM11Assertion rM11Assertion = (RM11Assertion)object;
            if (!this.checkEqual(this._sequenceSTR, rM11Assertion._sequenceSTR)) {
                return false;
            }
            if (!this.checkEqual(this._sequenceTransportSecurity, rM11Assertion._sequenceTransportSecurity)) {
                return false;
            }
            return this.checkEqual(this._deliveryAssurance, rM11Assertion._deliveryAssurance);
        }
        return false;
    }

    public int hashCode() {
        return NAME.hashCode() + (this._sequenceSTR != null ? this._sequenceSTR.hashCode() : 0) + (this._sequenceTransportSecurity != null ? this._sequenceTransportSecurity.hashCode() : 0) + (this._deliveryAssurance != null ? this._deliveryAssurance.hashCode() : 0);
    }

    public QName getName() {
        return NAME;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        int n = objectInput.readInt();
        if (n == 1) {
            this._sequenceSTR = new SequenceSTR();
            this._sequenceSTR.readExternal(objectInput);
        }
        if ((n = objectInput.readInt()) == 1) {
            this._sequenceTransportSecurity = new SequenceTransportSecurity();
            this._sequenceTransportSecurity.readExternal(objectInput);
        }
        if ((n = objectInput.readInt()) == 1) {
            this._deliveryAssurance = new DeliveryAssurance();
            this._deliveryAssurance.readExternal(objectInput);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        if (this._sequenceSTR != null) {
            objectOutput.writeInt(1);
            this._sequenceSTR.writeExternal(objectOutput);
        } else {
            objectOutput.writeInt(0);
        }
        if (this._sequenceTransportSecurity != null) {
            objectOutput.writeInt(1);
            this._sequenceTransportSecurity.writeExternal(objectOutput);
        } else {
            objectOutput.writeInt(0);
        }
        if (this._deliveryAssurance != null) {
            objectOutput.writeInt(1);
            this._deliveryAssurance.writeExternal(objectOutput);
        } else {
            objectOutput.writeInt(0);
        }
    }
}

