/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2;

import java.security.AccessController;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.wsee.WseeCoreLogger;
import weblogic.wsee.monitoring.WseeWsrmRuntimeMBeanImpl;
import weblogic.wsee.reliability2.exception.WsrmException;
import weblogic.wsee.reliability2.sequence.DestinationSequenceManager;
import weblogic.wsee.reliability2.sequence.SourceSequenceManager;

public class ReliabilityService {
    private static RuntimeAccess _runtimeAccess;

    public static void startup() throws WsrmException {
        SourceSequenceManager.getInstance();
        DestinationSequenceManager.getInstance();
        try {
            ServerRuntimeMBean serverRuntimeMBean = _runtimeAccess.getServerRuntime();
            if (serverRuntimeMBean != null && serverRuntimeMBean.getWseeWsrmRuntime() == null) {
                WseeWsrmRuntimeMBeanImpl wseeWsrmRuntimeMBeanImpl = new WseeWsrmRuntimeMBeanImpl(serverRuntimeMBean.getName(), serverRuntimeMBean);
                wseeWsrmRuntimeMBeanImpl.register();
                serverRuntimeMBean.setWseeWsrmRuntime(wseeWsrmRuntimeMBeanImpl);
            }
        }
        catch (Exception exception) {
            throw new WsrmException(exception.toString(), exception);
        }
    }

    public static void shutdown() {
        ServerRuntimeMBean serverRuntimeMBean = _runtimeAccess.getServerRuntime();
        WseeWsrmRuntimeMBeanImpl wseeWsrmRuntimeMBeanImpl = (WseeWsrmRuntimeMBeanImpl)serverRuntimeMBean.getWseeWsrmRuntime();
        if (wseeWsrmRuntimeMBeanImpl != null) {
            serverRuntimeMBean.setWseeWsrmRuntime(null);
            try {
                wseeWsrmRuntimeMBeanImpl.unregister();
            }
            catch (Exception exception) {
                WseeCoreLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            }
        }
    }

    static {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        _runtimeAccess = ManagementService.getRuntimeAccess(authenticatedSubject);
    }
}

