/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.api;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SequenceState {
    NEW,
    CREATING,
    CREATED,
    LAST_MESSAGE_PENDING,
    LAST_MESSAGE,
    CLOSING,
    CLOSED,
    TERMINATING,
    TERMINATED;

    private static final Logger LOGGER;
    private List<SequenceState> _validNextStates;

    private void setValidNextStates(SequenceState[] sequenceStateArray) {
        this._validNextStates = Arrays.asList(sequenceStateArray);
    }

    public boolean isValidTransition(SequenceState sequenceState) {
        if (!this._validNextStates.contains((Object)sequenceState)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Sequence state transition from " + this.name() + " to " + sequenceState.name() + " is not valid. Ignoring");
            }
            return false;
        }
        return true;
    }

    public static boolean isTerminalState(SequenceState sequenceState) {
        return sequenceState == TERMINATING || sequenceState == TERMINATED;
    }

    public static boolean isClosedState(SequenceState sequenceState) {
        return sequenceState == CLOSING || sequenceState == CLOSED;
    }

    static {
        LOGGER = Logger.getLogger(SequenceState.class.getName());
        NEW.setValidNextStates(new SequenceState[]{CREATING});
        CREATING.setValidNextStates(new SequenceState[]{CREATED, NEW});
        CREATED.setValidNextStates(new SequenceState[]{LAST_MESSAGE_PENDING, CLOSING, TERMINATING});
        LAST_MESSAGE_PENDING.setValidNextStates(new SequenceState[]{LAST_MESSAGE});
        LAST_MESSAGE.setValidNextStates(new SequenceState[]{CREATED, TERMINATED});
        CLOSING.setValidNextStates(new SequenceState[]{CLOSED, CREATED, TERMINATING});
        CLOSED.setValidNextStates(new SequenceState[]{TERMINATING});
        TERMINATING.setValidNextStates(new SequenceState[]{TERMINATED, CREATED, CLOSING});
        TERMINATED.setValidNextStates(new SequenceState[0]);
    }
}

