/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.api_internal;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.wsee.WseeRmLogger;
import weblogic.wsee.reliability2.api_internal.WsrmLifecycleEvent;
import weblogic.wsee.reliability2.api_internal.WsrmLifecycleEventListener;

public class WsrmLifecycleEventListenerRegistry {
    private static final Logger LOGGER = Logger.getLogger(WsrmLifecycleEventListenerRegistry.class.getName());
    private static final WsrmLifecycleEventListenerRegistry _instance = new WsrmLifecycleEventListenerRegistry();
    private List<WsrmLifecycleEventListener> _listenerList = new ArrayList<WsrmLifecycleEventListener>();

    public static WsrmLifecycleEventListenerRegistry getInstance() {
        return _instance;
    }

    private WsrmLifecycleEventListenerRegistry() {
    }

    public void addListener(WsrmLifecycleEventListener wsrmLifecycleEventListener) {
        this._listenerList.add(wsrmLifecycleEventListener);
    }

    public void removeListener(WsrmLifecycleEventListener wsrmLifecycleEventListener) {
        this._listenerList.remove(wsrmLifecycleEventListener);
    }

    public void clearListeners() {
        this._listenerList.clear();
    }

    public void notifyEventType(WsrmLifecycleEvent.Type type) {
        WsrmLifecycleEventListener[] wsrmLifecycleEventListenerArray;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Notifying listeners of event: " + (Object)((Object)type));
        }
        for (WsrmLifecycleEventListener wsrmLifecycleEventListener : wsrmLifecycleEventListenerArray = this._listenerList.toArray(new WsrmLifecycleEventListener[this._listenerList.size()])) {
            try {
                wsrmLifecycleEventListener.onEventType(type);
            }
            catch (Exception exception) {
                WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            }
        }
    }
}

