/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.compat;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.bind.api.Bridge;
import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.message.StringHeader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import weblogic.wsee.message.MsgHeader;
import weblogic.wsee.message.MsgHeaderException;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability2.compat.SimpleElement;
import weblogic.wsee.reliability2.compat.SimpleElementSerializer;
import weblogic.wsee.reliability2.exception.WsrmException;
import weblogic.wsee.util.WLMessageFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonHeader
extends MsgHeader
implements Header {
    private static final long serialVersionUID = 1L;
    private QName _qName;
    private transient Header _jaxwsHeader;
    protected static final AttributesImpl EMPTY_ATTS = new AttributesImpl();

    protected CommonHeader(QName qName) {
        this.setName(qName);
    }

    protected void setupJaxwsHeader() {
        this._jaxwsHeader = new StringHeader(this._qName, "");
    }

    @Override
    public QName getName() {
        return this._qName;
    }

    protected void setName(QName qName) {
        this._qName = qName;
        this.setupJaxwsHeader();
    }

    public void setNamespaceUri(String string) {
        this.setName(new QName(string, this._qName.getLocalPart(), this._qName.getPrefix()));
    }

    public abstract SimpleElement writeToSimpleElement() throws MsgHeaderException;

    protected void commonWriteToSimpleElement(String string, SOAPVersion sOAPVersion, SimpleElement simpleElement) {
        QName qName = new QName(sOAPVersion.nsUri, "mustUnderstand", string);
        if (this.isMustUnderstand()) {
            simpleElement.setAttr(qName, SOAPVersion.SOAP_11 == sOAPVersion ? "1" : "true");
        }
    }

    public abstract void readFromSimpleElement(SimpleElement var1) throws MsgHeaderException;

    protected void commonReadFromSimpleElement(SimpleElement simpleElement) {
        for (WsrmConstants.SOAPVersion sOAPVersion : WsrmConstants.SOAPVersion.values()) {
            String string = sOAPVersion.getNamespaceUri();
            QName qName = new QName(string, "mustUnderstand");
            String string2 = simpleElement.getAttr(qName);
            if (string2 == null) continue;
            if (sOAPVersion == WsrmConstants.SOAPVersion.SOAP_11) {
                int n = Integer.parseInt(string2);
                this.setMustUnderstand(n == 1);
                break;
            }
            boolean bl = Boolean.parseBoolean(string2);
            this.setMustUnderstand(bl);
            break;
        }
    }

    public static SimpleElement getTopParent(SimpleElement simpleElement) {
        SimpleElement simpleElement2 = simpleElement;
        while (simpleElement2 != null) {
            SimpleElement simpleElement3 = simpleElement2;
            if ((simpleElement2 = simpleElement2.getParent()) != null) continue;
            simpleElement2 = simpleElement3;
            break;
        }
        return simpleElement2;
    }

    @Override
    public void read(Element element) {
        try {
            SimpleElement simpleElement = SimpleElementSerializer.deserialize(element);
            this.readFromSimpleElement(simpleElement);
            this.commonReadFromSimpleElement(simpleElement);
        }
        catch (Exception exception) {
            throw new MsgHeaderException(exception.toString(), exception);
        }
    }

    public void read(XMLStreamReader xMLStreamReader) {
        try {
            if (xMLStreamReader.getEventType() != 1) {
                xMLStreamReader.nextTag();
            }
            SimpleElement simpleElement = SimpleElementSerializer.deserialize(xMLStreamReader);
            this.readFromSimpleElement(simpleElement);
            this.commonReadFromSimpleElement(simpleElement);
        }
        catch (Exception exception) {
            throw new MsgHeaderException(exception.toString(), exception);
        }
    }

    @Override
    public void write(Element element) {
        try {
            String string;
            SimpleElement simpleElement = this.writeToSimpleElement();
            String string2 = this.getCurrentSoapEnvelopeNamespace();
            if (string2 == null) {
                string2 = WsrmConstants.SOAPVersion.SOAP_11.getNamespaceUri();
            }
            if ((string = element.lookupPrefix(string2)) == null) {
                string = "soap";
            }
            SOAPVersion sOAPVersion = string2 != null ? SOAPVersion.fromNsUri((String)string2) : SOAPVersion.SOAP_11;
            this.commonWriteToSimpleElement(string, sOAPVersion, simpleElement);
            SimpleElementSerializer.serialize(simpleElement, element);
        }
        catch (Exception exception) {
            throw new MsgHeaderException(exception.toString(), exception);
        }
    }

    public void write(XMLStreamWriter xMLStreamWriter) {
        try {
            String string = null;
            SOAPVersion sOAPVersion = null;
            for (SOAPVersion sOAPVersion2 : SOAPVersion.values()) {
                string = xMLStreamWriter.getNamespaceContext().getPrefix(sOAPVersion2.nsUri);
                if (string == null) continue;
                sOAPVersion = sOAPVersion2;
                break;
            }
            if (string == null) {
                string = "soap";
                sOAPVersion = SOAPVersion.SOAP_11;
            }
            SimpleElement simpleElement = this.writeToSimpleElement();
            this.commonWriteToSimpleElement(string, sOAPVersion, simpleElement);
            SimpleElementSerializer.serialize(simpleElement, xMLStreamWriter);
        }
        catch (Exception exception) {
            throw new MsgHeaderException(exception.toString(), exception);
        }
    }

    public boolean isIgnorable(@NotNull SOAPVersion sOAPVersion, @NotNull Set<String> set) {
        return this._jaxwsHeader.isIgnorable(sOAPVersion, set);
    }

    @NotNull
    public String getRole(@NotNull SOAPVersion sOAPVersion) {
        return this._jaxwsHeader.getRole(sOAPVersion);
    }

    public boolean isRelay() {
        return this._jaxwsHeader.isRelay();
    }

    @NotNull
    public String getNamespaceURI() {
        return this.getName().getNamespaceURI();
    }

    @NotNull
    public String getLocalPart() {
        return this.getName().getLocalPart();
    }

    @Nullable
    public String getAttribute(@NotNull String string, @NotNull String string2) {
        SimpleElement simpleElement = this.writeToSimpleElement();
        return simpleElement.getAttr(string, string2);
    }

    @Nullable
    public String getAttribute(@NotNull QName qName) {
        SimpleElement simpleElement = this.writeToSimpleElement();
        return simpleElement.getAttr(qName);
    }

    public XMLStreamReader readHeader() throws XMLStreamException {
        MutableXMLStreamBuffer mutableXMLStreamBuffer = new MutableXMLStreamBuffer();
        XMLStreamWriter xMLStreamWriter = mutableXMLStreamBuffer.createFromXMLStreamWriter();
        this.writeTo(xMLStreamWriter);
        return mutableXMLStreamBuffer.readAsXMLStreamReader();
    }

    public <T> T readAsJAXB(Unmarshaller unmarshaller) throws JAXBException {
        return (T)this._jaxwsHeader.readAsJAXB(unmarshaller);
    }

    public <T> T readAsJAXB(Bridge<T> bridge) throws JAXBException {
        return (T)this._jaxwsHeader.readAsJAXB(bridge);
    }

    @NotNull
    public WSEndpointReference readAsEPR(AddressingVersion addressingVersion) throws XMLStreamException {
        return this._jaxwsHeader.readAsEPR(addressingVersion);
    }

    public void writeTo(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        this.write(xMLStreamWriter);
    }

    public void writeTo(SOAPMessage sOAPMessage) throws SOAPException {
        this.writeToParent((Element)sOAPMessage.getSOAPHeader());
    }

    public abstract void writeTo(ContentHandler var1, ErrorHandler var2) throws SAXException;

    @NotNull
    public String getStringContent() {
        throw new IllegalStateException("Not implemented");
    }

    public static WSEndpointReference addHeadersToEPR(WSEndpointReference wSEndpointReference, HeaderList headerList) throws WsrmException {
        wSEndpointReference.addReferenceParameters(headerList);
        List<Element> list = CommonHeader.getElementListFromHeaderList(headerList);
        wSEndpointReference = new WSEndpointReference(wSEndpointReference.getVersion(), wSEndpointReference.getAddress(), wSEndpointReference.getMetaData().getServiceName(), wSEndpointReference.getMetaData().getPortName(), wSEndpointReference.getMetaData().getPortTypeName(), null, wSEndpointReference.getMetaData().getWsdliLocation(), list);
        return wSEndpointReference;
    }

    private static List<Element> getElementListFromHeaderList(HeaderList headerList) throws WsrmException {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        try {
            MessageFactory messageFactory = WLMessageFactory.getInstance().getMessageFactory(false);
            SOAPMessage sOAPMessage = messageFactory.createMessage();
            for (Header header : headerList) {
                header.writeTo(sOAPMessage);
            }
            NodeList nodeList = sOAPMessage.getSOAPHeader().getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                arrayList.add((Element)nodeList.item(i));
            }
        }
        catch (Exception exception) {
            throw new WsrmException(exception.toString(), exception);
        }
        return arrayList;
    }
}

