/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.compat;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.ws.api.streaming.XMLStreamWriterFactory;
import com.sun.xml.ws.message.StringHeader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.faults.WsrmFaultMsg;
import weblogic.wsee.reliability.handshake.WsrmHandshakeMsg;
import weblogic.wsee.reliability.headers.WsrmHeader;
import weblogic.wsee.reliability2.compat.SOAPActionHeader;
import weblogic.wsee.reliability2.headers.WsrmHeaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rpc2WsUtil {
    public static Message createMessageFromFaultMessage(WsrmFaultMsg wsrmFaultMsg, AddressingVersion addressingVersion, SOAPVersion sOAPVersion) throws SOAPException {
        String string = sOAPVersion == SOAPVersion.SOAP_12 ? "SOAP 1.2 Protocol" : "SOAP 1.1 Protocol";
        MessageFactory messageFactory = MessageFactory.newInstance((String)string);
        SOAPMessage sOAPMessage = messageFactory.createMessage();
        wsrmFaultMsg.write(sOAPMessage);
        Message message = Messages.create((SOAPMessage)sOAPMessage);
        String string2 = wsrmFaultMsg.getRmVersion().getNamespaceUri() + "/fault";
        StringHeader stringHeader = new StringHeader(addressingVersion.actionTag, string2);
        message.getHeaders().add((Header)stringHeader);
        return message;
    }

    public static String getSOAPActionFromHandshakeMessage(WsrmHandshakeMsg wsrmHandshakeMsg) {
        String string = WsrmConstants.Action.valueOfElementName(wsrmHandshakeMsg.getElementName()).getActionURI(wsrmHandshakeMsg.getRmVersion());
        return string;
    }

    public static Message createMessageFromHandshakeMessage(WsrmHandshakeMsg wsrmHandshakeMsg, AddressingVersion addressingVersion, SOAPVersion sOAPVersion) throws SOAPException {
        String string = sOAPVersion == SOAPVersion.SOAP_12 ? "SOAP 1.2 Protocol" : "SOAP 1.1 Protocol";
        MessageFactory messageFactory = MessageFactory.newInstance((String)string);
        SOAPMessage sOAPMessage = messageFactory.createMessage();
        wsrmHandshakeMsg.writeMsg(sOAPMessage);
        Message message = Messages.create((SOAPMessage)sOAPMessage);
        String string2 = Rpc2WsUtil.getSOAPActionFromHandshakeMessage(wsrmHandshakeMsg);
        SOAPActionHeader sOAPActionHeader = new SOAPActionHeader(addressingVersion.actionTag, string2, sOAPVersion);
        sOAPActionHeader.setMustUnderstand(true);
        message.getHeaders().addOrReplace((Header)sOAPActionHeader);
        return message;
    }

    public static void serializeHeaderList(@NotNull List<Header> list, @NotNull ObjectOutputStream objectOutputStream) throws IOException {
        try {
            ArrayList<QName> arrayList = new ArrayList<QName>(list.size());
            ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>(list.size());
            for (Object object : list) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                arrayList.add(new QName(object.getNamespaceURI(), object.getLocalPart()));
                XMLStreamWriter xMLStreamWriter = XMLStreamWriterFactory.create((OutputStream)byteArrayOutputStream, (String)"UTF-8");
                object.writeTo(xMLStreamWriter);
                xMLStreamWriter.flush();
                xMLStreamWriter.close();
                XMLStreamWriterFactory.recycle((XMLStreamWriter)xMLStreamWriter);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                arrayList2.add(byArray);
            }
            objectOutputStream.writeObject(arrayList);
            Iterator<Object> iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                Object object;
                object = (byte[])iterator.next();
                objectOutputStream.writeInt(((Header)object).length);
                objectOutputStream.write((byte[])object);
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.toString(), exception);
        }
    }

    @NotNull
    public static List<Header> deserializeHeaderList(@NotNull ObjectInputStream objectInputStream, @NotNull SOAPVersion sOAPVersion) throws IOException, ClassNotFoundException {
        List list = (List)objectInputStream.readObject();
        ArrayList<Header> arrayList = new ArrayList<Header>(list.size());
        for (QName qName : list) {
            int n = objectInputStream.readInt();
            byte[] byArray = new byte[n];
            objectInputStream.readFully(byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            XMLStreamReader xMLStreamReader = XMLStreamReaderFactory.create(null, (InputStream)byteArrayInputStream, (String)"UTF-8", (boolean)false);
            WsrmHeader wsrmHeader = WsrmHeaderFactory.getInstance().createHeader(qName);
            try {
                if (wsrmHeader == null) {
                    wsrmHeader = Headers.create((SOAPVersion)sOAPVersion, (XMLStreamReader)xMLStreamReader);
                } else {
                    wsrmHeader.read(xMLStreamReader);
                }
                xMLStreamReader.close();
                XMLStreamReaderFactory.recycle((XMLStreamReader)xMLStreamReader);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new IOException(xMLStreamException.toString(), xMLStreamException);
            }
            byteArrayInputStream.close();
            arrayList.add(wsrmHeader);
        }
        return arrayList;
    }
}

