/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.compat;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.message.StringHeader;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SOAPActionHeader
extends StringHeader {
    private boolean _mustUnderstand;
    private SOAPVersion _soapVersion;

    public SOAPActionHeader(QName qName, String string, SOAPVersion sOAPVersion) {
        super(qName, string);
        this._soapVersion = sOAPVersion;
    }

    public void setMustUnderstand(boolean bl) {
        this._mustUnderstand = bl;
    }

    @Nullable
    public String getAttribute(@NotNull String string, @NotNull String string2) {
        String string3 = null;
        if (string != null && "mustUnderstand".equals(string2)) {
            string3 = string.equals(SOAPVersion.SOAP_11.nsUri) ? (this._mustUnderstand ? "1" : "0") : Boolean.toString(this._mustUnderstand);
        }
        if (string3 == null) {
            string3 = super.getAttribute(string, string2);
        }
        return string3;
    }

    protected void writeAttributes(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        String string = xMLStreamWriter.getNamespaceContext().getPrefix(this._soapVersion.nsUri);
        if (string == null) {
            string = "soap";
            xMLStreamWriter.writeNamespace(string, this._soapVersion.nsUri);
        }
        xMLStreamWriter.writeAttribute(string, this._soapVersion.nsUri, "mustUnderstand", this.getAttribute(this._soapVersion.nsUri, "mustUnderstand"));
    }

    public void writeTo(SOAPMessage sOAPMessage) throws SOAPException {
        SOAPHeader sOAPHeader = sOAPMessage.getSOAPHeader();
        SOAPHeaderElement sOAPHeaderElement = sOAPHeader.addHeaderElement(this.name);
        if (this._mustUnderstand) {
            sOAPHeaderElement.addNamespaceDeclaration("soap", this._soapVersion.nsUri);
            sOAPHeaderElement.addAttribute(new QName(this._soapVersion.nsUri, "mustUnderstand", "soap"), this.getAttribute(this._soapVersion.nsUri, "mustUnderstand"));
        }
        sOAPHeaderElement.addTextNode(this.value);
    }

    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        String string = this.name.getNamespaceURI();
        String string2 = this.name.getLocalPart();
        contentHandler.startPrefixMapping("", string);
        AttributesImpl attributesImpl = new AttributesImpl();
        if (this._mustUnderstand) {
            contentHandler.startPrefixMapping("soap", this._soapVersion.nsUri);
            attributesImpl.addAttribute(this._soapVersion.nsUri, "mustUnderstand", "soap:mustUnderstand", "string", this.getAttribute(this._soapVersion.nsUri, "mustUnderstand"));
            contentHandler.endPrefixMapping("soap");
        }
        contentHandler.startElement(string, string2, string2, attributesImpl);
        contentHandler.characters(this.value.toCharArray(), 0, this.value.length());
        contentHandler.endElement(string, string2, string2);
    }
}

