/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.compat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleElement {
    SimpleElement _parent;
    QName _name;
    List<SimpleElement> _children;
    Map<QName, List<SimpleElement>> _childNameToChildListMap;
    Map<QName, String> _attrNameToValueMap;
    StringBuffer _content;

    public SimpleElement(QName qName) {
        this._name = qName;
        this._children = new ArrayList<SimpleElement>();
        this._childNameToChildListMap = new HashMap<QName, List<SimpleElement>>();
        this._attrNameToValueMap = new HashMap<QName, String>();
        this._content = null;
    }

    public QName getName() {
        return this._name;
    }

    public SimpleElement getParent() {
        return this._parent;
    }

    void setParent(SimpleElement simpleElement) {
        this._parent = simpleElement;
    }

    public List<SimpleElement> getChildren() {
        return new ArrayList<SimpleElement>(this._children);
    }

    public Map<QName, List<SimpleElement>> getChildNameToChildMap() {
        return new HashMap<QName, List<SimpleElement>>(this._childNameToChildListMap);
    }

    public SimpleElement getChild(QName qName) {
        return this.getChild(qName, false);
    }

    public List<SimpleElement> getChildren(QName qName) {
        if (!this._childNameToChildListMap.containsKey(qName)) {
            return new ArrayList<SimpleElement>();
        }
        return this._childNameToChildListMap.get(qName);
    }

    public SimpleElement getChild(QName qName, boolean bl) {
        if (!this._childNameToChildListMap.containsKey(qName)) {
            if (bl) {
                throw new IllegalStateException("Required child " + qName + " not found in parent element " + this._name);
            }
            return null;
        }
        return this._childNameToChildListMap.get(qName).get(0);
    }

    public String getContentForChild(QName qName) {
        try {
            return this.getContentForChild(qName, false);
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
            return null;
        }
    }

    public String getContentForChild(QName qName, boolean bl) throws IllegalStateException {
        SimpleElement simpleElement = this.getChild(qName, bl);
        String string = null;
        if (simpleElement != null) {
            string = simpleElement.getContent();
        }
        return string;
    }

    public void addChild(SimpleElement simpleElement) {
        simpleElement.setParent(this);
        this._children.add(simpleElement);
        List<SimpleElement> list = this._childNameToChildListMap.get(simpleElement._name);
        if (list == null) {
            list = new ArrayList<SimpleElement>();
            this._childNameToChildListMap.put(simpleElement._name, list);
        }
        list.add(simpleElement);
    }

    public Map<QName, String> getAttrs() {
        return new HashMap<QName, String>(this._attrNameToValueMap);
    }

    public void setAttr(QName qName, String string) {
        this._attrNameToValueMap.put(qName, string);
    }

    public void setAttr(String string, String string2, String string3) {
        QName qName = SimpleElement.getQName(string, string2);
        this.setAttr(qName, string3);
    }

    public String getAttr(QName qName) {
        return this._attrNameToValueMap.get(qName);
    }

    public String getContent() {
        return this._content != null ? this._content.toString() : null;
    }

    public void setContent(String string) {
        this._content = string != null ? new StringBuffer(string) : null;
    }

    public void addContent(String string) {
        if (string != null) {
            if (this._content == null) {
                this._content = new StringBuffer();
            }
            this._content.append(string);
        }
    }

    public static String getContentForChild(SimpleElement simpleElement, String string, String string2) {
        QName qName = SimpleElement.getQName(string, string2);
        return simpleElement.getContentForChild(qName, true);
    }

    public static String getOptionalContentForChild(SimpleElement simpleElement, String string, String string2) {
        QName qName = SimpleElement.getQName(string, string2);
        return simpleElement.getContentForChild(qName, false);
    }

    public List<SimpleElement> getChildren(String string, String string2) {
        QName qName = SimpleElement.getQName(string, string2);
        return this.getChildren(qName);
    }

    public static SimpleElement getChild(SimpleElement simpleElement, String string, String string2) {
        QName qName = SimpleElement.getQName(string, string2);
        return simpleElement.getChild(qName, true);
    }

    public static SimpleElement getOptionalChild(SimpleElement simpleElement, String string, String string2) {
        QName qName = SimpleElement.getQName(string, string2);
        return simpleElement.getChild(qName, false);
    }

    public String getAttr(String string, String string2) {
        QName qName = SimpleElement.getQName(string, string2);
        return this.getAttr(qName);
    }

    public static void addChild(SimpleElement simpleElement, String string, String string2, String string3) {
        SimpleElement simpleElement2 = SimpleElement.createChild(simpleElement, string, string2);
        new SimpleElement(new QName(string, string2));
        simpleElement2.setContent(string3);
    }

    public static SimpleElement createChild(SimpleElement simpleElement, String string, String string2) {
        QName qName = SimpleElement.getQName(string, string2);
        SimpleElement simpleElement2 = new SimpleElement(qName);
        simpleElement.addChild(simpleElement2);
        return simpleElement2;
    }

    private static QName getQName(String string, String string2) {
        int n = string2.indexOf(":");
        QName qName = n > 0 ? new QName(string, string2.substring(n + 1), string2.substring(0, n)) : new QName(string, string2);
        return qName;
    }
}

