/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.compat;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.Holder;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.wsee.jaxws.util.WriterUtil;
import weblogic.wsee.reliability2.compat.SimpleElement;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleElementSerializer {
    private static final Logger LOGGER = Logger.getLogger(SimpleElementSerializer.class.getName());

    public static void serialize(SimpleElement simpleElement, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        Holder holder = new Holder((Object)0);
        SimpleElementSerializer.serialize(simpleElement, xMLStreamWriter, (Holder<Integer>)holder);
    }

    public static void serialize(SimpleElement simpleElement, XMLStreamWriter xMLStreamWriter, Holder<Integer> holder) throws XMLStreamException {
        String string;
        QName qName;
        block18: {
            qName = simpleElement.getName();
            try {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Writing start element: " + qName);
                }
                if ((string = WriterUtil.getBoundNamespace(xMLStreamWriter, qName.getNamespaceURI())) == null) {
                    string = WriterUtil.selectPrefix(xMLStreamWriter, qName.getPrefix(), qName.getNamespaceURI(), holder);
                    xMLStreamWriter.writeStartElement(string, qName.getLocalPart(), qName.getNamespaceURI());
                    xMLStreamWriter.writeNamespace(string, qName.getNamespaceURI());
                } else {
                    xMLStreamWriter.writeStartElement(qName.getNamespaceURI(), qName.getLocalPart());
                }
            }
            catch (XMLStreamException xMLStreamException) {
                if (!LOGGER.isLoggable(Level.FINE)) break block18;
                LOGGER.fine("*** Failed attempt to write element with name: " + qName);
                LOGGER.log(Level.FINE, xMLStreamException.toString(), xMLStreamException);
            }
        }
        if (simpleElement.getContent() != null) {
            string = simpleElement.getContent();
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Writing characters: " + string);
            }
            xMLStreamWriter.writeCharacters(string);
        } else {
            Object object;
            boolean bl = false;
            Map<QName, String> map = simpleElement.getAttrs();
            if (map != null) {
                for (Map.Entry object22 : map.entrySet()) {
                    String string2;
                    object = (QName)object22.getKey();
                    if ("http://www.w3.org/2000/xmlns/".equals(((QName)object).getNamespaceURI())) {
                        WriterUtil.writeNamespace(xMLStreamWriter, (String)object22.getValue(), ((QName)object).getLocalPart());
                        continue;
                    }
                    String string3 = ((QName)object).getNamespaceURI();
                    String string4 = ((QName)object).getLocalPart();
                    if (string3 == null) {
                        string3 = "";
                        string4 = ((QName)object).getLocalPart();
                    }
                    if (string4.startsWith("xmlns:")) {
                        if (!bl) {
                            bl = true;
                            string2 = qName.getPrefix();
                            if (string2 != null && !"".equals(string2)) {
                                WriterUtil.writeNamespace(xMLStreamWriter, qName.getNamespaceURI(), string2);
                            }
                        }
                        WriterUtil.writeNamespace(xMLStreamWriter, (String)object22.getValue(), string4.substring(6));
                        continue;
                    }
                    if (string3.length() == 0) {
                        xMLStreamWriter.writeAttribute(string4, (String)object22.getValue());
                        continue;
                    }
                    string2 = WriterUtil.getBoundNamespace(xMLStreamWriter, string3);
                    if (string2 == null) {
                        string2 = WriterUtil.selectPrefix(xMLStreamWriter, ((QName)object).getPrefix(), string3, holder);
                        xMLStreamWriter.writeNamespace(string2, string3);
                        xMLStreamWriter.writeAttribute(string2, string3, string4, (String)object22.getValue());
                        continue;
                    }
                    xMLStreamWriter.writeAttribute(string3, string4, (String)object22.getValue());
                }
            }
            List<SimpleElement> list = simpleElement.getChildren();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (SimpleElement)iterator.next();
                SimpleElementSerializer.serialize((SimpleElement)object, xMLStreamWriter, holder);
            }
        }
        xMLStreamWriter.writeEndElement();
    }

    public static void serialize(SimpleElement simpleElement, Element element) {
        if (simpleElement.getContent() != null) {
            DOMUtils.addTextData(element, simpleElement.getContent());
        } else {
            Object object;
            Map<QName, String> map = simpleElement.getAttrs();
            for (QName object22 : map.keySet()) {
                object = map.get(object22);
                String string = object22.getNamespaceURI();
                if (string != null && string.length() > 0) {
                    String string2 = object22.getPrefix() != null ? object22.getPrefix() + ":" + object22.getLocalPart() : object22.getLocalPart();
                    element.setAttributeNS(string, string2, (String)object);
                    continue;
                }
                element.setAttribute(object22.getLocalPart(), (String)object);
            }
            List<SimpleElement> list = simpleElement.getChildren();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (SimpleElement)iterator.next();
                SimpleElementSerializer.serializeChild((SimpleElement)object, element);
            }
        }
    }

    private static void serializeChild(SimpleElement simpleElement, Element element) {
        QName qName = simpleElement.getName();
        String string = qName.getPrefix() != null ? qName.getPrefix() + ":" + qName.getLocalPart() : qName.getLocalPart();
        Element element2 = DOMUtils.addValueNS(element, qName.getNamespaceURI(), string, simpleElement.getContent() != null ? simpleElement.getContent() : "");
        if (simpleElement.getContent() == null) {
            Object object;
            Map<QName, String> map = simpleElement.getAttrs();
            for (QName object22 : map.keySet()) {
                object = map.get(object22);
                String string2 = object22.getNamespaceURI();
                if (string2 != null && string2.length() > 0) {
                    element2.setAttributeNS(string2, object22.getLocalPart(), (String)object);
                    continue;
                }
                element2.setAttribute(object22.getLocalPart(), (String)object);
            }
            List<SimpleElement> list = simpleElement.getChildren();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (SimpleElement)iterator.next();
                SimpleElementSerializer.serializeChild((SimpleElement)object, element2);
            }
        }
    }

    public static SimpleElement deserialize(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        Object object;
        int n;
        SimpleElement simpleElement = new SimpleElement(xMLStreamReader.getName());
        int n2 = xMLStreamReader.getAttributeCount();
        for (n = 0; n < n2; ++n) {
            QName qName = xMLStreamReader.getAttributeName(n);
            if (SimpleElementSerializer.isNamespaceDecl(qName.getPrefix())) continue;
            object = xMLStreamReader.getAttributeValue(n);
            simpleElement.setAttr(qName, (String)object);
        }
        n = 1;
        while (xMLStreamReader.hasNext() && n > 0) {
            int n3 = xMLStreamReader.next();
            switch (n3) {
                case 1: {
                    ++n;
                    object = SimpleElementSerializer.deserialize(xMLStreamReader);
                    simpleElement.addChild((SimpleElement)object);
                    break;
                }
                case 4: {
                    simpleElement.addContent(xMLStreamReader.getText());
                    break;
                }
                case 10: {
                    QName qName = xMLStreamReader.getName();
                    xMLStreamReader.next();
                    String string = xMLStreamReader.getText();
                    simpleElement.setAttr(qName, string);
                    break;
                }
                case 2: {
                    --n;
                }
            }
        }
        return simpleElement;
    }

    public static SimpleElement deserialize(Element element) throws DOMProcessingException {
        Object object;
        QName qName = SimpleElementSerializer.getQNameFromDOMNode(element);
        SimpleElement simpleElement = new SimpleElement(qName);
        NodeList nodeList = element.getChildNodes();
        block4: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            switch (node.getNodeType()) {
                case 3: {
                    object = node.getNodeValue();
                    if (object == null || ((String)object).length() <= 0) continue block4;
                    simpleElement.addContent((String)object);
                    continue block4;
                }
                case 1: {
                    Element element2 = (Element)node;
                    SimpleElement simpleElement2 = SimpleElementSerializer.deserialize(element2);
                    simpleElement.addChild(simpleElement2);
                }
            }
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                object = (Attr)namedNodeMap.item(i);
                if (SimpleElementSerializer.isNamespaceDecl(object.getPrefix())) continue;
                qName = SimpleElementSerializer.getQNameFromDOMNode((Node)object);
                simpleElement.setAttr(qName, object.getValue());
            }
        }
        return simpleElement;
    }

    private static QName getQNameFromDOMNode(Node node) {
        QName qName;
        if (node.getPrefix() != null) {
            qName = new QName(node.getNamespaceURI(), node.getLocalName(), node.getPrefix());
        } else {
            String string = node.getLocalName();
            if (string == null) {
                string = node.getNodeName();
            }
            qName = new QName(node.getNamespaceURI(), string);
        }
        return qName;
    }

    private static boolean isNamespaceDecl(String string) {
        return string != null && string.equals("xmlns");
    }
}

