/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.headers;

import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Packet;
import javax.xml.namespace.QName;
import weblogic.wsee.message.MsgHeaderException;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.headers.WsrmHeader;
import weblogic.wsee.reliability.headers.WsrmMsgHeaderFactory;
import weblogic.wsee.reliability2.exception.WsrmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsrmHeaderFactory {
    private static final WsrmHeaderFactory _instance = new WsrmHeaderFactory();
    private WsrmMsgHeaderFactory _headerFactory = new WsrmMsgHeaderFactory();

    public static WsrmHeaderFactory getInstance() {
        return _instance;
    }

    private WsrmHeaderFactory() {
    }

    public <T extends WsrmHeader> T createEmptyWsrmHeader(Class<T> clazz, WsrmConstants.RMVersion rMVersion) {
        QName qName = WsrmHeader.getQName(clazz, rMVersion);
        return (T)this.createHeader(qName);
    }

    public <T extends WsrmHeader> T createWsrmHeaderFromHeader(Class<T> clazz, Header header) throws WsrmException {
        try {
            WsrmHeader wsrmHeader = (WsrmHeader)clazz.newInstance();
            wsrmHeader.read(header.readHeader());
            return (T)wsrmHeader;
        }
        catch (MsgHeaderException msgHeaderException) {
            throw msgHeaderException;
        }
        catch (Exception exception) {
            throw new MsgHeaderException("Could not build header for " + clazz, exception);
        }
    }

    public WsrmHeader createHeader(QName qName) {
        WsrmHeader wsrmHeader = (WsrmHeader)this._headerFactory.createMsgHeader(qName);
        return wsrmHeader;
    }

    public <T extends WsrmHeader> T getHeaderFromPacket(Class<T> clazz, Packet packet) throws WsrmException {
        Header header = null;
        for (WsrmConstants.RMVersion rMVersion : WsrmConstants.RMVersion.values()) {
            QName qName = this._headerFactory.getHeaderQName(clazz, rMVersion);
            header = packet.getMessage().getHeaders().get(qName, true);
            if (header != null) break;
        }
        if (header == null) {
            return null;
        }
        try {
            T exception = WsrmHeaderFactory.getInstance().createWsrmHeaderFromHeader(clazz, header);
            return exception;
        }
        catch (Exception exception) {
            throw new WsrmException(exception.toString(), exception);
        }
    }
}

