/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.policy;

import com.sun.istack.Nullable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import weblogic.wsee.policy.deployment.WsdlPolicySubject;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyAssertion;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.framework.PolicyMath;
import weblogic.wsee.policy.runtime.PolicyContext;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.reliability.WsrmSecurityContext;
import weblogic.wsee.reliability.policy.RMAssertion;
import weblogic.wsee.reliability.policy11.RM11Assertion;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlPort;

public class WsrmPolicyHelper {
    @Nullable
    private WsPort _port;

    public WsrmPolicyHelper(WsPort wsPort) {
        this._port = wsPort;
    }

    @Nullable
    private PolicyServer getPolicyServer() {
        if (this._port == null) {
            return null;
        }
        return this._port.getEndpoint().getService().getPolicyServer();
    }

    private Map getKnownPolicies() {
        PolicyServer policyServer = this.getPolicyServer();
        if (policyServer != null) {
            return policyServer.getCachedPolicies();
        }
        return new HashMap();
    }

    public boolean hasRMPolicy() throws PolicyException {
        if (this._port == null) {
            return false;
        }
        boolean bl = false;
        Iterator iterator = this._port.getEndpoint().getMethods();
        while (iterator.hasNext()) {
            WsMethod wsMethod = (WsMethod)iterator.next();
            NormalizedExpression normalizedExpression = PolicyContext.getRequestEffectivePolicy(this._port, wsMethod, this.getPolicyServer(), this.getKnownPolicies());
            if (!WsrmPolicyHelper.hasRMPolicy(normalizedExpression)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean hasRMPolicy(NormalizedExpression normalizedExpression) {
        return normalizedExpression != null && (normalizedExpression.containsPolicyAssertion(RMAssertion.class) || normalizedExpression.containsPolicyAssertion(RM11Assertion.class));
    }

    public WsrmSecurityContext createSecurityContext(PolicyAssertion policyAssertion) throws PolicyException {
        NormalizedExpression normalizedExpression = this.getEndpointPolicy();
        if (normalizedExpression == null) {
            throw new IllegalStateException("No RM policy, so can't create WsrmSecurityContext");
        }
        boolean bl = false;
        if (policyAssertion instanceof RM11Assertion) {
            bl = ((RM11Assertion)policyAssertion).getSequenceTransportSecurity() != null;
        }
        return new WsrmSecurityContext(normalizedExpression, bl);
    }

    @Nullable
    public NormalizedExpression getEndpointPolicy() throws PolicyException {
        if (this._port == null) {
            return null;
        }
        return WsdlPolicySubject.getEndpointPolicySubject(this.getPolicyServer(), this._port.getWsdlPort(), this.getKnownPolicies());
    }

    @Nullable
    public NormalizedExpression getResponseEffectivePolicy(String string) throws PolicyException {
        if (this._port == null) {
            return null;
        }
        WsMethod wsMethod = this._port.getEndpoint().getMethod(string);
        if (wsMethod == null) {
            return WsdlPolicySubject.getEndpointPolicySubject(this.getPolicyServer(), this._port.getWsdlPort(), this.getKnownPolicies());
        }
        NormalizedExpression normalizedExpression = wsMethod.getCachedEffectiveOutboundPolicy();
        QName qName = wsMethod.getOperationName();
        if (normalizedExpression == null) {
            WsdlPort wsdlPort = this._port.getWsdlPort();
            WsdlOperation wsdlOperation = wsdlPort.getPortType().getOperations().get(qName);
            WsdlBindingOperation wsdlBindingOperation = wsdlPort.getBinding().getOperations().get(qName);
            normalizedExpression = WsrmPolicyHelper.getResponseEffectivePolicy(wsdlPort, wsdlOperation, wsdlBindingOperation, this.getPolicyServer(), this.getKnownPolicies());
            wsMethod.setCachedEffectiveOutboundPolicy(normalizedExpression);
        }
        return normalizedExpression;
    }

    private static NormalizedExpression getResponseEffectivePolicy(WsdlPort wsdlPort, WsdlOperation wsdlOperation, WsdlBindingOperation wsdlBindingOperation, PolicyServer policyServer, Map map) throws PolicyException {
        NormalizedExpression normalizedExpression = WsdlPolicySubject.getMessagePolicySubject(policyServer, wsdlOperation.getOutput(), wsdlBindingOperation.getOutput(), wsdlOperation.getOutputPolicyUris(), map);
        normalizedExpression = PolicyMath.merge(normalizedExpression, WsdlPolicySubject.getOperationPolicySubject(policyServer, wsdlOperation, wsdlBindingOperation, map));
        normalizedExpression = PolicyMath.merge(normalizedExpression, WsdlPolicySubject.getEndpointPolicySubject(policyServer, wsdlPort, map));
        return normalizedExpression;
    }

    @Nullable
    public NormalizedExpression getRequestEffectivePolicy(String string) throws PolicyException {
        if (this._port == null) {
            return null;
        }
        WsMethod wsMethod = this._port.getEndpoint().getMethod(string);
        if (wsMethod == null) {
            return WsdlPolicySubject.getEndpointPolicySubject(this.getPolicyServer(), this._port.getWsdlPort(), this.getKnownPolicies());
        }
        NormalizedExpression normalizedExpression = wsMethod.getCachedEffectiveInboundPolicy();
        QName qName = wsMethod.getOperationName();
        if (normalizedExpression == null) {
            WsdlPort wsdlPort = this._port.getWsdlPort();
            WsdlOperation wsdlOperation = wsdlPort.getPortType().getOperations().get(qName);
            WsdlBindingOperation wsdlBindingOperation = wsdlPort.getBinding().getOperations().get(qName);
            normalizedExpression = WsrmPolicyHelper.getRequestEffectivePolicy(wsdlPort, wsdlOperation, wsdlBindingOperation, this.getPolicyServer(), this.getKnownPolicies());
            wsMethod.setCachedEffectiveInboundPolicy(normalizedExpression);
        }
        return normalizedExpression;
    }

    private static NormalizedExpression getRequestEffectivePolicy(WsdlPort wsdlPort, WsdlOperation wsdlOperation, WsdlBindingOperation wsdlBindingOperation, PolicyServer policyServer, Map map) throws PolicyException {
        NormalizedExpression normalizedExpression = WsdlPolicySubject.getMessagePolicySubject(policyServer, wsdlOperation.getInput(), wsdlBindingOperation.getInput(), wsdlOperation.getInputPolicyUris(), map);
        normalizedExpression = PolicyMath.merge(normalizedExpression, WsdlPolicySubject.getOperationPolicySubject(policyServer, wsdlOperation, wsdlBindingOperation, map));
        normalizedExpression = PolicyMath.merge(normalizedExpression, WsdlPolicySubject.getEndpointPolicySubject(policyServer, wsdlPort, map));
        return normalizedExpression;
    }
}

