/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.property;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import weblogic.j2ee.descriptor.wl.PortComponentBean;
import weblogic.j2ee.descriptor.wl.ReliabilityConfigBean;
import weblogic.kernel.KernelStatus;
import weblogic.management.configuration.WebServiceMBean;
import weblogic.management.configuration.WebServiceReliabilityMBean;
import weblogic.wsee.config.WebServiceMBeanFactory;
import weblogic.wsee.jaxws.buffer.BufferingConfig;
import weblogic.wsee.jaxws.config.BasePropertyAccessor;
import weblogic.wsee.jaxws.config.MapPropertyAccessor;
import weblogic.wsee.jaxws.config.PerClientPropertyAccessor;
import weblogic.wsee.jaxws.config.PerServicePropertyAccessor;
import weblogic.wsee.jaxws.config.Property;
import weblogic.wsee.jaxws.config.PropertyContainer;
import weblogic.wsee.jaxws.config.PropertySource;
import weblogic.wsee.jaxws.config.VmWidePropertyAccessor;
import weblogic.wsee.jaxws.framework.ConfigUtil;
import weblogic.wsee.jaxws.framework.policy.PolicyPropertyBag;
import weblogic.wsee.jaxws.persistence.PersistenceConfig;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyAssertion;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.util.PolicySelectionPreference;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.policy.AcknowledgementInterval;
import weblogic.wsee.reliability.policy.BaseRetransmissionInterval;
import weblogic.wsee.reliability.policy.ExponentialBackoff;
import weblogic.wsee.reliability.policy.InactivityTimeout;
import weblogic.wsee.reliability.policy.RMAssertion;
import weblogic.wsee.reliability.policy.SequenceExpires;
import weblogic.wsee.reliability.policy.WsrmPolicyRuntimeHandler;
import weblogic.wsee.reliability.policy11.RM11Assertion;
import weblogic.wsee.reliability2.api.WsrmClientInitFeature;
import weblogic.wsee.reliability2.policy.WsrmPolicyHelper;
import weblogic.wsee.reliability2.policy.WsrmPolicySelectionHelper;
import weblogic.wsee.reliability2.property.WsrmPropertyBag;
import weblogic.wsee.reliability2.sequence.DeliveryAssurance;
import weblogic.wsee.reliability2.tube.WsrmTubelineDeploymentListener;
import weblogic.wsee.ws.WsPort;

public class WsrmConfig {
    @Nullable
    public static Source getSource(@NotNull ClientTubeAssemblerContext clientTubeAssemblerContext, @Nullable Packet packet, boolean bl) {
        return WsrmConfig.getSource((Destination)null, clientTubeAssemblerContext, packet, bl);
    }

    @Nullable
    public static Source getSource(@Nullable ServerTubeAssemblerContext serverTubeAssemblerContext, @Nullable ClientTubeAssemblerContext clientTubeAssemblerContext, @Nullable Packet packet, boolean bl) {
        Destination destination = WsrmConfig.getDestination(serverTubeAssemblerContext, packet, bl);
        return WsrmConfig.getSource(destination, clientTubeAssemblerContext, packet, bl);
    }

    @Nullable
    public static Destination getDestination(@Nullable ServerTubeAssemblerContext serverTubeAssemblerContext, @Nullable Packet packet, boolean bl) {
        Object object;
        WsPort wsPort;
        NormalizedExpression normalizedExpression = null;
        if (serverTubeAssemblerContext != null) {
            wsPort = WsrmTubelineDeploymentListener.getWsPort(serverTubeAssemblerContext);
            object = serverTubeAssemblerContext.getWsdlModel();
            try {
                normalizedExpression = WsrmConfig.getEffectivePolicyForPacket(packet, false, bl, wsPort, object);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString(), exception);
            }
        }
        wsPort = packet != null ? PolicyPropertyBag.propertySetRetriever.getFromPacket(packet).getPolicySelectionPreference() : null;
        object = packet != null ? packet.invocationProperties : null;
        ReliabilityConfigBean reliabilityConfigBean = null;
        if (serverTubeAssemblerContext != null) {
            reliabilityConfigBean = WsrmConfig.getServiceRmConfigBean(serverTubeAssemblerContext);
        }
        BufferingConfig.Service service2 = BufferingConfig.getServiceConfig(serverTubeAssemblerContext, packet);
        AllProps allProps = new AllProps(service2.getPersistenceConfig(), normalizedExpression, (PolicySelectionPreference)((Object)wsPort), null, null, (Map<String, Object>)object, reliabilityConfigBean, null);
        return new Destination(service2, allProps);
    }

    @Nullable
    public static Destination getDestination(@NotNull ClientTubeAssemblerContext clientTubeAssemblerContext, @Nullable Packet packet, boolean bl) {
        Source source = WsrmConfig.getSource(clientTubeAssemblerContext, packet, bl);
        source.getAllProps().setPropertySource(PropertySource.EFFECTIVECLIENT_CONFIG);
        Map map = packet != null ? packet.invocationProperties : null;
        BufferingConfig.Service service2 = BufferingConfig.getServiceConfig(clientTubeAssemblerContext, packet);
        AllProps allProps = new AllProps(service2.getPersistenceConfig(), null, null, null, null, map, null, source.getAllProps());
        return new Destination(service2, allProps);
    }

    @Nullable
    private static Source getSource(@Nullable Destination destination, @Nullable ClientTubeAssemblerContext clientTubeAssemblerContext, @Nullable Packet packet, boolean bl) {
        NormalizedExpression normalizedExpression;
        if (destination != null) {
            destination.getAllProps().setPropertySource(PropertySource.EFFECTIVESERVICE_CONFIG);
        }
        Map<String, Object> map = ConfigUtil.getServiceRefPropsForClient(clientTubeAssemblerContext);
        WsrmClientInitFeature wsrmClientInitFeature = null;
        if (clientTubeAssemblerContext != null) {
            wsrmClientInitFeature = (WsrmClientInitFeature)clientTubeAssemblerContext.getBinding().getFeature(WsrmClientInitFeature.class);
        }
        WsPort wsPort = null;
        if (clientTubeAssemblerContext != null) {
            wsPort = WsrmTubelineDeploymentListener.getWsPort(clientTubeAssemblerContext);
        }
        WSDLPort wSDLPort = null;
        if (clientTubeAssemblerContext != null) {
            wSDLPort = clientTubeAssemblerContext.getWsdlModel();
        }
        try {
            normalizedExpression = WsrmConfig.getEffectivePolicyForPacket(packet, true, bl, wsPort, wSDLPort);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString(), exception);
        }
        PersistenceConfig.Client client = PersistenceConfig.getClientConfig(clientTubeAssemblerContext);
        AllProps allProps = new AllProps(client, normalizedExpression, null, wsrmClientInitFeature, map, packet != null ? packet.invocationProperties : null, null, destination != null ? destination.getAllProps() : null);
        return new Source(allProps);
    }

    private static ReliabilityConfigBean getServiceRmConfigBean(@Nullable ServerTubeAssemblerContext serverTubeAssemblerContext) {
        ReliabilityConfigBean reliabilityConfigBean;
        if (serverTubeAssemblerContext == null) {
            return null;
        }
        WsPort wsPort = WsrmTubelineDeploymentListener.getWsPort(serverTubeAssemblerContext);
        PortComponentBean portComponentBean = wsPort.getPortComponent();
        ReliabilityConfigBean reliabilityConfigBean2 = reliabilityConfigBean = portComponentBean != null ? portComponentBean.getReliabilityConfig() : null;
        if (reliabilityConfigBean != null && !reliabilityConfigBean.isCustomized()) {
            reliabilityConfigBean = null;
        }
        return reliabilityConfigBean;
    }

    private static NormalizedExpression getEffectivePolicyForPacket(@Nullable Packet packet, boolean bl, boolean bl2, @Nullable WsPort wsPort, @Nullable WSDLPort wSDLPort) throws PolicyException {
        WSDLBoundOperation wSDLBoundOperation;
        if (wsPort == null) {
            return null;
        }
        WsrmPolicyHelper wsrmPolicyHelper = new WsrmPolicyHelper(wsPort);
        if (packet == null) {
            return wsrmPolicyHelper.getEndpointPolicy();
        }
        WsrmPropertyBag wsrmPropertyBag = WsrmPropertyBag.propertySetRetriever.getFromPacket(packet);
        WSDLBoundOperation wSDLBoundOperation2 = wSDLBoundOperation = wSDLPort != null ? packet.getMessage().getOperation(wSDLPort) : null;
        String string = wSDLBoundOperation != null ? wSDLBoundOperation.getName().getLocalPart() : (!bl ? (bl2 ? wsrmPropertyBag.getInboundWsdlOperationName() : wsrmPropertyBag.getOutboundWsdlOperationName()) : (bl2 ? wsrmPropertyBag.getOutboundWsdlOperationName() : wsrmPropertyBag.getInboundWsdlOperationName()));
        if (string != null) {
            NormalizedExpression normalizedExpression = bl2 ? wsrmPolicyHelper.getResponseEffectivePolicy(string) : wsrmPolicyHelper.getRequestEffectivePolicy(string);
            return normalizedExpression;
        }
        return wsrmPolicyHelper.getEndpointPolicy();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FeaturePropertyAccessor
    extends BasePropertyAccessor {
        public FeaturePropertyAccessor(Class<? extends Serializable> clazz, WsrmClientInitFeature wsrmClientInitFeature) {
            super(PropertySource.FEATURE, clazz, (Object)wsrmClientInitFeature);
        }

        public FeaturePropertyAccessor(WsrmClientInitFeature wsrmClientInitFeature) {
            super(PropertySource.FEATURE, (Object)wsrmClientInitFeature);
        }
    }

    private static class RM10SequenceExpiresAccessor
    extends RM10PolicyPropertyAccessor {
        public RM10SequenceExpiresAccessor(RMAssertion rMAssertion) {
            super(rMAssertion, String.class);
        }

        public Object getAssertionValue() {
            SequenceExpires sequenceExpires = this._rmAssertion.getSeqExpires();
            return sequenceExpires != null ? sequenceExpires.getExpires() : null;
        }
    }

    private static class RM10InactivityTimeoutAccessor
    extends RM10PolicyPropertyAccessor {
        public RM10InactivityTimeoutAccessor(RMAssertion rMAssertion) {
            super(rMAssertion, String.class);
        }

        public Object getAssertionValue() {
            InactivityTimeout inactivityTimeout = this._rmAssertion.getInactivityTimeout();
            if (inactivityTimeout != null) {
                long l = inactivityTimeout.getTimeout();
                Duration duration = this.createDurationFromMillis(l);
                return duration.toString();
            }
            return null;
        }
    }

    private static class RM10BaseRetransmissionIntervalAccessor
    extends RM10PolicyPropertyAccessor {
        public RM10BaseRetransmissionIntervalAccessor(RMAssertion rMAssertion) {
            super(rMAssertion, String.class);
        }

        public Object getAssertionValue() {
            BaseRetransmissionInterval baseRetransmissionInterval = this._rmAssertion.getBaseRetransmissionInterval();
            if (baseRetransmissionInterval != null) {
                long l = baseRetransmissionInterval.getInterval();
                Duration duration = this.createDurationFromMillis(l);
                return duration.toString();
            }
            return null;
        }
    }

    private static class RM10AcknowledgementIntervalAccessor
    extends RM10PolicyPropertyAccessor {
        public RM10AcknowledgementIntervalAccessor(RMAssertion rMAssertion) {
            super(rMAssertion, String.class);
        }

        public Object getAssertionValue() {
            AcknowledgementInterval acknowledgementInterval = this._rmAssertion.getAckInterval();
            if (acknowledgementInterval != null) {
                long l = acknowledgementInterval.getInterval();
                Duration duration = this.createDurationFromMillis(l);
                return duration.toString();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RM10ExponentialBackoffAccessor
    extends RM10PolicyPropertyAccessor {
        public RM10ExponentialBackoffAccessor(RMAssertion rMAssertion) {
            super(rMAssertion, Boolean.class);
        }

        @Override
        public Class<? extends Serializable> getValueClass() {
            return Boolean.class;
        }

        @Override
        public Object getAssertionValue() {
            ExponentialBackoff exponentialBackoff = this._rmAssertion.getExponentialBackoff();
            return exponentialBackoff != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class RM10PolicyPropertyAccessor
    extends BasePropertyAccessor {
        protected RMAssertion _rmAssertion;

        public RM10PolicyPropertyAccessor(RMAssertion rMAssertion, Class<? extends Serializable> clazz) {
            super(PropertySource.SERVICE_POLICY, clazz, null);
            this._rmAssertion = rMAssertion;
        }

        protected abstract Object getAssertionValue();

        @Override
        public Object getValue() {
            return this._rmAssertion != null ? this.getAssertionValue() : null;
        }

        protected Duration createDurationFromMillis(long l) {
            try {
                return DatatypeFactory.newInstance().newDuration(l);
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new RuntimeException(datatypeConfigurationException.toString(), datatypeConfigurationException);
            }
        }
    }

    private static class RMAssertionPolicyPropertyAccessor
    extends BasePropertyAccessor {
        @Nullable
        private NormalizedExpression _policy;
        @Nullable
        private WsrmClientInitFeature _feature;
        @Nullable
        private PolicySelectionPreference _policyPref;

        public RMAssertionPolicyPropertyAccessor(@Nullable NormalizedExpression normalizedExpression, @Nullable WsrmClientInitFeature wsrmClientInitFeature, @Nullable PolicySelectionPreference policySelectionPreference) {
            super(PropertySource.SERVICE_POLICY, PolicyAssertion.class, null);
            this._policy = normalizedExpression;
            this._feature = wsrmClientInitFeature;
            this._policyPref = policySelectionPreference;
        }

        public Object getValue() {
            if (this._policy == null) {
                return null;
            }
            WsrmPolicySelectionHelper wsrmPolicySelectionHelper = new WsrmPolicySelectionHelper(this._policy);
            wsrmPolicySelectionHelper.setForceWsrm10Policy(this._feature != null && this._feature.isForceWsrm10());
            wsrmPolicySelectionHelper.setPolicySelectionPreference(this._policyPref);
            PolicyAssertion[] policyAssertionArray = wsrmPolicySelectionHelper.getReliabilityPolicyAssertions();
            if (policyAssertionArray != null && policyAssertionArray.length > 0) {
                return policyAssertionArray[0];
            }
            return null;
        }
    }

    private static class ContainerDefaultPropertyAccessor
    extends BasePropertyAccessor {
        public ContainerDefaultPropertyAccessor(AllProps allProps) {
            super(allProps != null ? allProps.getPropertySource() : PropertySource.DEFAULT_VALUE, allProps);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AllProps
    extends PropertyContainer {
        @Nullable
        protected PropertySource _propertySource;
        @NotNull
        protected PersistenceConfig.Common _persistConfig;
        protected NormalizedExpression _policy;
        protected PolicySelectionPreference _policyPref;
        protected WsrmClientInitFeature _feature;
        protected Map<String, Object> _serviceRefProps;
        protected Map<String, Object> _packetInvokeProps;
        protected Property<PolicyAssertion> _rmAssertion;
        protected Property<String> _inactivityTimeout;
        protected Property<String> _sequenceExpiration;
        protected Property<String> _baseRetransmissionInterval;
        protected Property<Boolean> _retransmissionExponentialBackoff;
        protected Property<Boolean> _nonBufferedSource;
        protected Property<String> _acknowledgementInterval;
        protected Property<Boolean> _nonBufferedDestination;

        @Override
        protected List<Property> getPropertyFields() {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(this._rmAssertion);
            arrayList.add(this._inactivityTimeout);
            arrayList.add(this._sequenceExpiration);
            arrayList.add(this._baseRetransmissionInterval);
            arrayList.add(this._retransmissionExponentialBackoff);
            arrayList.add(this._nonBufferedSource);
            arrayList.add(this._acknowledgementInterval);
            arrayList.add(this._nonBufferedDestination);
            return arrayList;
        }

        public AllProps(@NotNull PersistenceConfig.Common common, @Nullable NormalizedExpression normalizedExpression, @Nullable PolicySelectionPreference policySelectionPreference, @Nullable WsrmClientInitFeature wsrmClientInitFeature, @Nullable Map<String, Object> map, @Nullable Map<String, Object> map2, @Nullable ReliabilityConfigBean reliabilityConfigBean, @Nullable AllProps allProps) {
            if (wsrmClientInitFeature != null && !wsrmClientInitFeature.isCustomized()) {
                wsrmClientInitFeature = null;
            }
            if (reliabilityConfigBean != null && !reliabilityConfigBean.isCustomized()) {
                reliabilityConfigBean = null;
            }
            this._persistConfig = common;
            this._policy = normalizedExpression;
            this._policyPref = policySelectionPreference;
            this._feature = wsrmClientInitFeature;
            this._serviceRefProps = map;
            this._packetInvokeProps = map2;
            WebServiceMBean webServiceMBean = WebServiceMBeanFactory.getInstance();
            WebServiceReliabilityMBean webServiceReliabilityMBean = webServiceMBean.getWebServiceReliability();
            this._rmAssertion = new Property<Object>("RmAssertion", PolicyAssertion.class, null, new RMAssertionPolicyPropertyAccessor(normalizedExpression, wsrmClientInitFeature, policySelectionPreference), new ContainerDefaultPropertyAccessor(allProps));
            PolicyAssertion policyAssertion = this.getRmAssertion();
            RMAssertion rMAssertion = policyAssertion instanceof RMAssertion ? (RMAssertion)policyAssertion : null;
            this._inactivityTimeout = new Property<String>("InactivityTimeout", String.class, "P0DT600S", new MapPropertyAccessor("weblogic.wsee.wsrm.InactivityTimeout", map2), new FeaturePropertyAccessor(wsrmClientInitFeature), new PerClientPropertyAccessor("weblogic.wsee.wsrm.InactivityTimeout", map), new PerServicePropertyAccessor(reliabilityConfigBean), new ContainerDefaultPropertyAccessor(allProps), new RM10InactivityTimeoutAccessor(rMAssertion), new VmWidePropertyAccessor(webServiceReliabilityMBean));
            this._sequenceExpiration = new Property<String>("SequenceExpiration", String.class, "P1D", new MapPropertyAccessor("weblogic.wsee.wsrm.SequenceExpiration", map2), new FeaturePropertyAccessor(wsrmClientInitFeature), new PerClientPropertyAccessor("weblogic.wsee.wsrm.SequenceExpiration", map), new PerServicePropertyAccessor(reliabilityConfigBean), new ContainerDefaultPropertyAccessor(allProps), new RM10SequenceExpiresAccessor(rMAssertion), new VmWidePropertyAccessor(webServiceReliabilityMBean));
            this._baseRetransmissionInterval = new Property<String>("BaseRetransmissionInterval", String.class, "P0DT8S", new MapPropertyAccessor("weblogic.wsee.wsrm.BaseRetransmissionInterval", map2), new FeaturePropertyAccessor(wsrmClientInitFeature), new PerClientPropertyAccessor("weblogic.wsee.wsrm.BaseRetransmissionInterval", map), new PerServicePropertyAccessor(reliabilityConfigBean), new ContainerDefaultPropertyAccessor(allProps), new RM10BaseRetransmissionIntervalAccessor(rMAssertion), new VmWidePropertyAccessor(webServiceReliabilityMBean));
            this._retransmissionExponentialBackoff = new Property<Boolean>("RetransmissionExponentialBackoff", Boolean.class, false, new MapPropertyAccessor("weblogic.wsee.wsrm.RetransmissionExponentialBackoff", map2), new FeaturePropertyAccessor(wsrmClientInitFeature), new PerClientPropertyAccessor("weblogic.wsee.wsrm.RetransmissionExponentialBackoff", map), new PerServicePropertyAccessor(reliabilityConfigBean), new ContainerDefaultPropertyAccessor(allProps), new RM10ExponentialBackoffAccessor(rMAssertion), new VmWidePropertyAccessor(webServiceReliabilityMBean));
            this._nonBufferedSource = new Property<Boolean>("NonBufferedSource", Boolean.class, false, new MapPropertyAccessor("weblogic.wsee.wsrm.NonBufferedSource", map2), new FeaturePropertyAccessor(Boolean.class, wsrmClientInitFeature), new PerClientPropertyAccessor("weblogic.wsee.wsrm.NonBufferedSource", map), new PerServicePropertyAccessor(reliabilityConfigBean), new ContainerDefaultPropertyAccessor(allProps), new VmWidePropertyAccessor(webServiceReliabilityMBean));
            this._acknowledgementInterval = new Property<String>("AcknowledgementInterval", String.class, "P0DT3S", new MapPropertyAccessor("weblogic.wsee.wsrm.AcknowledgementInterval", map2), new FeaturePropertyAccessor(wsrmClientInitFeature), new PerClientPropertyAccessor("weblogic.wsee.wsrm.AcknowledgementInterval", map), new PerServicePropertyAccessor(reliabilityConfigBean), new ContainerDefaultPropertyAccessor(allProps), new RM10AcknowledgementIntervalAccessor(rMAssertion), new VmWidePropertyAccessor(webServiceReliabilityMBean));
            this._nonBufferedDestination = new Property<Boolean>("NonBufferedDestination", Boolean.class, false, new MapPropertyAccessor("weblogic.wsee.wsrm.NonBufferedDestination", map2), new FeaturePropertyAccessor(wsrmClientInitFeature), new PerClientPropertyAccessor("weblogic.wsee.wsrm.NonBufferedDestination", map), new PerServicePropertyAccessor(reliabilityConfigBean), new ContainerDefaultPropertyAccessor(allProps), new VmWidePropertyAccessor(webServiceReliabilityMBean));
        }

        public PropertySource getPropertySource() {
            return this._propertySource;
        }

        public void setPropertySource(PropertySource propertySource) {
            this._propertySource = propertySource;
        }

        public PersistenceConfig.Common getPersistenceConfig() {
            return this._persistConfig;
        }

        public PolicyAssertion getRmAssertion() {
            return this._rmAssertion.getValue();
        }

        public boolean isReliable() {
            return this.getRmAssertion() != null;
        }

        public WsrmConstants.RMVersion getRmVersion() {
            PolicyAssertion policyAssertion = this.getRmAssertion();
            if (policyAssertion == null) {
                return null;
            }
            if (policyAssertion instanceof RMAssertion) {
                return WsrmConstants.RMVersion.RM_10;
            }
            return WsrmConstants.RMVersion.latest();
        }

        public DeliveryAssurance getDeliveryAssurance() {
            DeliveryAssurance deliveryAssurance;
            PolicyAssertion policyAssertion = this.getRmAssertion();
            if (policyAssertion instanceof RMAssertion) {
                WsrmConstants.DeliveryQOS deliveryQOS;
                WsrmPolicyRuntimeHandler.RM10QosInfo rM10QosInfo;
                RMAssertion rMAssertion = (RMAssertion)policyAssertion;
                try {
                    rM10QosInfo = WsrmPolicyRuntimeHandler.parseRM10QOS(rMAssertion.getSeqQos());
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.toString(), exception);
                }
                switch (rM10QosInfo.safQoS) {
                    case 2: {
                        deliveryQOS = WsrmConstants.DeliveryQOS.AtLeastOnce;
                        break;
                    }
                    case 3: {
                        deliveryQOS = WsrmConstants.DeliveryQOS.AtMostOnce;
                        break;
                    }
                    default: {
                        deliveryQOS = WsrmConstants.DeliveryQOS.ExactlyOnce;
                    }
                }
                deliveryAssurance = new DeliveryAssurance(deliveryQOS, rM10QosInfo.inOrder);
            } else if (policyAssertion instanceof RM11Assertion) {
                RM11Assertion rM11Assertion = (RM11Assertion)policyAssertion;
                weblogic.wsee.reliability.policy11.DeliveryAssurance deliveryAssurance2 = rM11Assertion.getDeliveryAssurance();
                WsrmConstants.DeliveryQOS deliveryQOS = deliveryAssurance2 != null ? (deliveryAssurance2.getAtLeastOnce() != null ? WsrmConstants.DeliveryQOS.AtLeastOnce : (deliveryAssurance2.getAtMostOnce() != null ? WsrmConstants.DeliveryQOS.AtMostOnce : WsrmConstants.DeliveryQOS.ExactlyOnce)) : WsrmConstants.DeliveryQOS.ExactlyOnce;
                boolean bl = rM11Assertion.getDeliveryAssurance() == null || rM11Assertion.getDeliveryAssurance().getInOrder() != null;
                deliveryAssurance = new DeliveryAssurance(deliveryQOS, bl);
            } else {
                deliveryAssurance = new DeliveryAssurance(WsrmConstants.DeliveryQOS.ExactlyOnce, true);
            }
            return deliveryAssurance;
        }

        public String getInactivityTimeout() {
            return this._inactivityTimeout.getValue();
        }

        public String getSequenceExpiration() {
            return this._sequenceExpiration.getValue();
        }

        public PersistenceConfig.Common getPersistConfig() {
            return this._persistConfig;
        }

        public String getBaseRetransmissionInterval() {
            return this._baseRetransmissionInterval.getValue();
        }

        public Boolean getRetransmissionExponentialBackoff() {
            return this._retransmissionExponentialBackoff.getValue();
        }

        public Boolean getNonBufferedSource() {
            return this._nonBufferedSource.getValue();
        }

        public String getAcknowledgementInterval() {
            return this._acknowledgementInterval.getValue();
        }

        public Boolean isNonBufferedDestination() {
            return this._nonBufferedDestination.getValue();
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append("\nPersistenceConfig:\n");
            stringBuffer.append(this.getPersistenceConfig().toString());
            return stringBuffer.toString();
        }
    }

    public static class Destination
    extends Common {
        private BufferingConfig.Service _bufConfig;

        public Destination(@NotNull BufferingConfig.Service service2, @NotNull AllProps allProps) {
            super(allProps);
            this._bufConfig = service2;
        }

        public boolean isNonBufferedDestination() {
            return !KernelStatus.isServer() || this._allProps.isNonBufferedDestination() != false;
        }

        public String getAcknowledgementInterval() {
            return this._allProps.getAcknowledgementInterval();
        }

        public BufferingConfig.Service getBufferingConfig() {
            return this._bufConfig;
        }

        public PersistenceConfig.Common getPersistenceConfig() {
            return this._allProps.getPersistenceConfig();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append("\nBufferingConfig:\n\n");
            stringBuffer.append(this.getBufferingConfig().toString());
            return stringBuffer.toString();
        }
    }

    public static class Source
    extends Common {
        private Source(@NotNull AllProps allProps) {
            super(allProps);
        }

        public String getBaseRetransmissionInterval() {
            return this._allProps.getBaseRetransmissionInterval();
        }

        public Boolean getRetransmissionExponentialBackoff() {
            return this._allProps.getRetransmissionExponentialBackoff();
        }

        public Boolean isNonBufferedSource() {
            return this._allProps.getNonBufferedSource();
        }
    }

    public static class Common {
        protected AllProps _allProps;

        public Common(AllProps allProps) {
            this._allProps = allProps;
        }

        public AllProps getAllProps() {
            return this._allProps;
        }

        public PersistenceConfig.Common getPersistenceConfig() {
            return this._allProps.getPersistenceConfig();
        }

        public PolicyAssertion getRmAssertion() {
            return this._allProps.getRmAssertion();
        }

        public boolean isReliable() {
            return this._allProps.isReliable();
        }

        public WsrmConstants.RMVersion getRmVersion() {
            return this._allProps.getRmVersion();
        }

        public DeliveryAssurance getDeliveryAssurance() {
            return this._allProps.getDeliveryAssurance();
        }

        public String getInactivityTimeout() {
            return this._allProps.getInactivityTimeout();
        }

        public String getSequenceExpiration() {
            return this._allProps.getSequenceExpiration();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getSimpleName());
            stringBuffer.append(":\n");
            stringBuffer.append(this._allProps.toString());
            return stringBuffer.toString();
        }
    }
}

