/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.property;

import com.sun.istack.Nullable;
import com.sun.xml.ws.api.message.Packet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import weblogic.wsee.jaxws.framework.InvocationPropertySet;
import weblogic.wsee.jaxws.persistence.PacketPersistencePropertyBag;
import weblogic.wsee.jaxws.spi.ClientInstance;
import weblogic.wsee.jaxws.spi.ClientInstanceIdentity;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability2.tube.WsrmClientRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsrmInvocationPropertyBag
extends InvocationPropertySet
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String key = WsrmInvocationPropertyBag.class.getName();
    public static final String RM_VERSION = "weblogic.wsee.wsrm.RMVersion";
    public static final String FORCE_WSRM_1_0_CLIENT = "weblogic.wsee.reliability.forceWSRM10Client";
    public static final String SEQUENCE_ID = "weblogic.wsee.reliability2.SequenceID";
    public static final String CLIENT_RUNTIME = "weblogic.wsee.reliability2.WsrmClientRuntime";
    public static final String MOST_RECENT_MSG_NUM = "weblogic.wsee.reliability2.MostRecentMsgNum";
    public static final String FINAL_MSG_FLAG = "weblogic.wsee.reliability2.FinalMessageFlag";
    public static final String LOGICAL_STORE_NAME = "weblogic.wsee.reliability2.LogicalStoreName";
    public static final Set<String> PERSISTENT_PROP_NAMES = new HashSet<String>();

    public static WsrmInvocationPropertyBag getFromPacket(Packet packet) {
        return WsrmInvocationPropertyBag.getFromMap(packet.invocationProperties);
    }

    public static WsrmInvocationPropertyBag getFromMap(Map<String, Object> map) {
        WsrmInvocationPropertyBag wsrmInvocationPropertyBag = (WsrmInvocationPropertyBag)map.get(key);
        if (wsrmInvocationPropertyBag == null) {
            wsrmInvocationPropertyBag = new WsrmInvocationPropertyBag(map);
            map.put(key, wsrmInvocationPropertyBag);
        }
        return wsrmInvocationPropertyBag;
    }

    public WsrmInvocationPropertyBag() {
        super(new Packet());
        this.initProps();
    }

    public WsrmInvocationPropertyBag(Packet packet) {
        super(packet);
        WsrmInvocationPropertyBag.internalFlagPersistentPropsOnPacket(packet);
        this.initProps();
    }

    public static void flagPersistentPropsOnPacket(Packet packet) {
        if (!packet.invocationProperties.containsKey(key)) {
            packet.invocationProperties.put(key, new WsrmInvocationPropertyBag(packet));
        }
        WsrmInvocationPropertyBag.internalFlagPersistentPropsOnPacket(packet);
    }

    private static void internalFlagPersistentPropsOnPacket(Packet packet) {
        PacketPersistencePropertyBag packetPersistencePropertyBag = PacketPersistencePropertyBag.propertySetRetriever.getFromPacket(packet);
        Set<String> set = packetPersistencePropertyBag.getPersistableInvocationPropertyNames();
        set.add(key);
    }

    public WsrmInvocationPropertyBag(Map<String, Object> map) {
        this._invocationProps = map;
        this.initProps();
    }

    private void initProps() {
        WsrmClientRuntime wsrmClientRuntime = new WsrmClientRuntime(this.getClientInstanceRef());
        wsrmClientRuntime.internalSetSequenceId(this.getSequenceId());
        this.setWsrmClientRuntime(wsrmClientRuntime);
    }

    public void accept(WsrmInvocationPropertyBag wsrmInvocationPropertyBag) {
        this._invocationProps.putAll(wsrmInvocationPropertyBag._invocationProps);
    }

    public void clear() {
        this._invocationProps.clear();
        this.initProps();
    }

    public boolean getForceWsrm10Client() {
        Boolean bl = (Boolean)this._invocationProps.get(FORCE_WSRM_1_0_CLIENT);
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        return bl;
    }

    public void setForceWsrm10Client(boolean bl) {
        this._invocationProps.put(FORCE_WSRM_1_0_CLIENT, bl);
    }

    public WsrmConstants.RMVersion getWsrmVersion() {
        WsrmConstants.RMVersion rMVersion = (WsrmConstants.RMVersion)((Object)this._invocationProps.get(RM_VERSION));
        if (rMVersion == null) {
            rMVersion = WsrmConstants.RMVersion.latest();
        }
        return rMVersion;
    }

    public void setLogicalStoreName(String string) {
        this._invocationProps.put(LOGICAL_STORE_NAME, string);
    }

    public void setWsrmVersion(WsrmConstants.RMVersion rMVersion) {
        this._invocationProps.put(RM_VERSION, rMVersion);
    }

    public String getSequenceId() {
        return (String)this._invocationProps.get(SEQUENCE_ID);
    }

    public void setSequenceId(String string) {
        this.internalSetSequenceId(string);
        WsrmClientRuntime wsrmClientRuntime = this.getWsrmClientRuntime();
        if (wsrmClientRuntime != null) {
            wsrmClientRuntime.internalSetSequenceId(string);
        }
    }

    public void internalSetSequenceId(String string) {
        this._invocationProps.put(SEQUENCE_ID, string);
    }

    @Nullable
    public ClientInstanceIdentity getClientInstanceId() {
        WeakReference<ClientInstance> weakReference = this.getClientInstanceRef();
        return weakReference != null ? ((ClientInstance)weakReference.get()).getId() : null;
    }

    @Nullable
    private WeakReference<ClientInstance> getClientInstanceRef() {
        return (WeakReference)this._invocationProps.get("weblogic.wsee.jaxws.spi.ClientInstanceWeakRef");
    }

    private WsrmClientRuntime getWsrmClientRuntime() {
        return (WsrmClientRuntime)this._invocationProps.get(CLIENT_RUNTIME);
    }

    public void setWsrmClientRuntime(WsrmClientRuntime wsrmClientRuntime) {
        this._invocationProps.put(CLIENT_RUNTIME, wsrmClientRuntime);
    }

    public long getMostRecentMsgNum() {
        Long l = (Long)this._invocationProps.get(MOST_RECENT_MSG_NUM);
        if (l == null) {
            l = Long.MIN_VALUE;
        }
        return l;
    }

    public void setMostRecentMsgNum(long l) {
        this._invocationProps.put(MOST_RECENT_MSG_NUM, l);
    }

    public boolean getFinalMsgFlag() {
        Boolean bl = (Boolean)this._invocationProps.get(FINAL_MSG_FLAG);
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        return bl;
    }

    public void setFinalMsgFlag(boolean bl) {
        this._invocationProps.put(FINAL_MSG_FLAG, bl);
    }

    public boolean containsProp(String string) {
        return this._invocationProps.containsKey(string);
    }

    public Object getProp(String string) {
        return this._invocationProps.get(string);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject("10.3.6");
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        for (String string : PERSISTENT_PROP_NAMES) {
            Serializable serializable = (Serializable)this.getProp(string);
            hashMap.put(string, serializable);
        }
        objectOutputStream.writeObject(hashMap);
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.readObject();
        this._invocationProps = new HashMap();
        Map map = (Map)objectInputStream.readObject();
        for (String string : map.keySet()) {
            this._invocationProps.put(string, map.get(string));
        }
        objectInputStream.defaultReadObject();
        this.initProps();
    }

    static {
        PERSISTENT_PROP_NAMES.add(RM_VERSION);
        PERSISTENT_PROP_NAMES.add(FORCE_WSRM_1_0_CLIENT);
        PERSISTENT_PROP_NAMES.add(SEQUENCE_ID);
        PERSISTENT_PROP_NAMES.add(MOST_RECENT_MSG_NUM);
        PERSISTENT_PROP_NAMES.add(FINAL_MSG_FLAG);
    }
}

