/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.saf;

import com.sun.xml.ws.addressing.WsaPropertyBag;
import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.PropertySet;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.WSEndpoint;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.wsee.jaxws.client.async.AsyncTransportProvider;
import weblogic.wsee.jaxws.persistence.PersistentMessage;
import weblogic.wsee.jaxws.persistence.PersistentMessageFactory;
import weblogic.wsee.jaxws.tubeline.TubelineSpliceFactory;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability2.exception.WsrmException;
import weblogic.wsee.reliability2.property.WsrmPropertyBag;
import weblogic.wsee.reliability2.sequence.DestinationMessageInfo;
import weblogic.wsee.reliability2.sequence.DestinationSequence;
import weblogic.wsee.reliability2.sequence.DestinationSequenceManager;
import weblogic.wsee.reliability2.tube.WsrmTubeUtils;
import weblogic.wsee.util.Verbose;

public class BufferMdbListener
implements MessageListener {
    private static final Logger LOGGER = Logger.getLogger(BufferMdbListener.class.getName());
    private WSEndpoint _endpoint;
    private TubelineSpliceFactory.DispatchFactory _dispatchFactory;
    private boolean _forResponse;

    public BufferMdbListener(WSEndpoint wSEndpoint, TubelineSpliceFactory.DispatchFactory dispatchFactory, boolean bl) {
        this._endpoint = wSEndpoint;
        this._dispatchFactory = dispatchFactory;
        this._forResponse = bl;
    }

    public void onMessage(Message message) {
        try {
            PersistentMessage persistentMessage;
            String string;
            block11: {
                if (message instanceof ObjectMessage) {
                    Serializable serializable = ((ObjectMessage)message).getObject();
                    if (!(serializable instanceof PersistentMessage)) {
                        throw new WsrmException("Wrong object message received, expected type: weblogic.wsee.jaxws.persistence.PersistentMessage");
                    }
                    string = message.getStringProperty("ASYNC_URI");
                    persistentMessage = (PersistentMessage)serializable;
                    try {
                        int n = message.getIntProperty("JMSXDeliveryCount");
                        persistentMessage.getContext().getPropertyMap().put("weblogic.wsee.buffer.BufferedMessageJmsDeliveryCount", Integer.valueOf(n));
                    }
                    catch (Exception exception) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            Verbose.logException(exception);
                            break block11;
                        }
                        exception.printStackTrace();
                    }
                } else {
                    throw new WsrmException("Wrong message type, only allow object message");
                }
            }
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            PrivilegedExceptionAction<NullObject> privilegedExceptionAction = new PrivilegedExceptionAction<NullObject>(){

                @Override
                public NullObject run() throws Exception {
                    BufferMdbListener.this.deliver(string, persistentMessage);
                    return null;
                }
            };
            PersistentMessageFactory.getInstance().runActionInContext(persistentMessage.getContext(), authenticatedSubject, privilegedExceptionAction);
        }
        catch (RuntimeException runtimeException) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, runtimeException.toString(), runtimeException);
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, throwable.toString(), throwable);
            }
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    public void deliver(String string, PersistentMessage persistentMessage) throws Exception {
        WSEndpointReference wSEndpointReference;
        Object object;
        Dispatch<Packet> dispatch;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Dispatching buffered message on endpoint with target URI: " + string);
        }
        Packet packet = WsrmTubeUtils.createPacketFromPersistentMessage(persistentMessage, this._endpoint.getBinding().getAddressingVersion(), this._endpoint.getBinding().getSOAPVersion());
        WsrmPropertyBag wsrmPropertyBag = WsrmPropertyBag.propertySetRetriever.getFromPacket(packet);
        DestinationMessageInfo destinationMessageInfo = wsrmPropertyBag.getDestMessageInfoFromRequest();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("** Beginning to process buffered message with msg id " + destinationMessageInfo.getMessageId() + " seq " + destinationMessageInfo.getSequenceId() + " and message number " + destinationMessageInfo.getMessageNum());
        }
        DestinationSequence destinationSequence = DestinationSequenceManager.getInstance().getSequence(WsrmConstants.RMVersion.latest(), destinationMessageInfo.getSequenceId(), false);
        destinationMessageInfo = (DestinationMessageInfo)destinationSequence.getRequestByMessageId(destinationMessageInfo.getMessageId());
        destinationMessageInfo.setInProcess();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("** Writing IN PROCESS destination message info for msg " + destinationMessageInfo.getMessageId() + " seq " + destinationMessageInfo.getSequenceId() + " and message number " + destinationMessageInfo.getMessageNum());
        }
        DestinationSequenceManager.getInstance().updateSequence(destinationSequence);
        if (LOGGER.isLoggable(Level.FINE)) {
            dispatch = AsyncTransportProvider.dumpPersistentContextContextProps(packet.persistentContext);
            LOGGER.fine("Dispatching buffered " + (this._forResponse ? "*response* " : " ") + "message with action " + packet.soapAction + " msg number " + destinationMessageInfo.getMessageNum() + " msg id " + destinationMessageInfo.getMessageId() + " seq id " + destinationMessageInfo.getSequenceId() + " persistentContext: " + dispatch);
        }
        packet.addSatellite((PropertySet)new WsaPropertyBag(destinationSequence.getAddressingVersion(), destinationSequence.getSoapVersion(), packet));
        if (this._forResponse) {
            object = this._endpoint.getBinding().getAddressingVersion();
            if (object == null) {
                object = AddressingVersion.W3C;
            }
            wSEndpointReference = object.anonymousEpr;
            dispatch = this._dispatchFactory.createResponseDispatch(wSEndpointReference, Packet.class, Service.Mode.MESSAGE);
        } else {
            dispatch = this._dispatchFactory.createDispatch(Packet.class, Service.Mode.MESSAGE);
        }
        packet.endpointAddress = new EndpointAddress(destinationSequence.getHostEpr().getAddress());
        packet.endpoint = this._endpoint;
        dispatch.getRequestContext().put("weblogic.wsee.jaxws.async.PersistentContext", packet.persistentContext);
        if (LOGGER.isLoggable(Level.FINE)) {
            object = AsyncTransportProvider.dumpPersistentContextContextProps((Map)dispatch.getRequestContext().get("weblogic.wsee.jaxws.async.PersistentContext"));
            LOGGER.fine("Set RequestContext's persistent context for " + (this._forResponse ? "*response* " : " ") + "msg id " + destinationMessageInfo.getMessageId() + " seq id " + destinationMessageInfo.getSequenceId() + " persistentContext: " + (String)object);
        }
        object = (Packet)dispatch.invoke((Object)packet);
        if (!this._forResponse && object != null && object.getMessage() != null && (wSEndpointReference = packet.getMessage().getHeaders().getReplyTo(destinationSequence.getAddressingVersion(), destinationSequence.getSoapVersion())) != null && !wSEndpointReference.isAnonymous()) {
            Dispatch<Packet> dispatch2;
            if (LOGGER.isLoggable(Level.FINE)) {
                dispatch2 = (Dispatch<Packet>)object.get((Object)"com.sun.xml.ws.api.addressing.messageId");
                LOGGER.fine("Dispatching response to buffered " + (this._forResponse ? "*response* " : " ") + "msg id " + destinationMessageInfo.getMessageId() + " response msg id " + dispatch2);
            }
            dispatch2 = this._dispatchFactory.createResponseDispatch(wSEndpointReference, Packet.class, Service.Mode.PAYLOAD);
            dispatch2.invokeOneWay(object);
        }
    }

    public class NullObject {
    }
}

