/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.saf;

import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.server.WSEndpoint;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.application.ApplicationAccess;
import weblogic.application.internal.ApplicationContextImpl;
import weblogic.messaging.saf.SAFEndpoint;
import weblogic.messaging.saf.internal.SAFManagerImpl;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.buffer.BufferManager;
import weblogic.wsee.buffer2.api.common.BufferingFeature;
import weblogic.wsee.buffer2.api.common.BufferingManager;
import weblogic.wsee.buffer2.exception.BufferingException;
import weblogic.wsee.buffer2.spi.BufferingProvider;
import weblogic.wsee.buffer2.spi.BufferingProviderManager;
import weblogic.wsee.jaxws.framework.jaxrpc.EnvironmentFactory;
import weblogic.wsee.jaxws.framework.jaxrpc.JAXRPCEnvironmentFeature;
import weblogic.wsee.jaxws.spi.WLSEndpoint;
import weblogic.wsee.jaxws.tubeline.TubelineSpliceFactory;
import weblogic.wsee.reliability2.property.WsrmConfig;
import weblogic.wsee.reliability2.saf.BufferMdbListener;
import weblogic.wsee.reliability2.saf.WsrmSAFEndpoint;
import weblogic.wsee.reliability2.saf.WsrmSAFEndpointManager;
import weblogic.wsee.server.ServerUtil;
import weblogic.wsee.ws.init.WsDeploymentContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferUtil {
    private static final Logger LOGGER = Logger.getLogger(BufferUtil.class.getName());
    private static final AuthenticatedSubject _kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final Object mdbPoolCreationLock = new Object();

    public static BufferingFeature setupBufferingFeature(ServerTubeAssemblerContext serverTubeAssemblerContext, WSEndpoint wSEndpoint, TubelineSpliceFactory.DispatchFactory dispatchFactory, boolean bl, WsrmConfig.Destination destination) throws BufferingException {
        if (destination.isNonBufferedDestination()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("setupBufferingFeature:  RM Destination is non-buffered.  Skip BufferingSetup.");
            }
            return null;
        }
        BufferingProviderManager.App_Server_Platform app_Server_Platform = BufferingProviderManager.App_Server_Platform.WLS;
        BufferingProvider bufferingProvider = BufferingProviderManager.getBufferingProvider(app_Server_Platform);
        BufferingManager bufferingManager = bufferingProvider.getBufferingManager();
        BufferingFeature bufferingFeature = bufferingManager.newBufferingFeature(BufferingFeature.BufferingFeatureUsers.WSRM, serverTubeAssemblerContext, bl, wSEndpoint, dispatchFactory);
        BufferUtil.setupBufferingFeature(bufferingFeature, wSEndpoint, destination);
        return bufferingFeature;
    }

    public static BufferingFeature setupBufferingFeature(ClientTubeAssemblerContext clientTubeAssemblerContext, WLSEndpoint wLSEndpoint, TubelineSpliceFactory.DispatchFactory dispatchFactory, boolean bl, WsrmConfig.Destination destination) throws BufferingException {
        if (destination.isNonBufferedDestination()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("setupBufferingFeature:  RM Destination is non-buffered.  Skip BufferingSetup.");
            }
            return null;
        }
        BufferingProviderManager.App_Server_Platform app_Server_Platform = BufferingProviderManager.App_Server_Platform.WLS;
        BufferingProvider bufferingProvider = BufferingProviderManager.getBufferingProvider(app_Server_Platform);
        BufferingManager bufferingManager = bufferingProvider.getBufferingManager();
        BufferingFeature bufferingFeature = bufferingManager.newBufferingFeature(BufferingFeature.BufferingFeatureUsers.WSRM, clientTubeAssemblerContext, bl, wLSEndpoint, dispatchFactory);
        BufferUtil.setupBufferingFeature(bufferingFeature, wLSEndpoint.getWSEndpoint(), destination);
        return bufferingFeature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setupBufferingFeature(BufferingFeature bufferingFeature, WSEndpoint wSEndpoint, WsrmConfig.Destination destination) throws BufferingException {
        Object object;
        BufferingProviderManager.App_Server_Platform app_Server_Platform = BufferingProviderManager.App_Server_Platform.WLS;
        WsrmSAFEndpointManager wsrmSAFEndpointManager = (WsrmSAFEndpointManager)SAFManagerImpl.getManager().getEndpointManager(3);
        assert (wsrmSAFEndpointManager != null);
        EnvironmentFactory environmentFactory = JAXRPCEnvironmentFeature.getFactory(wSEndpoint);
        WsDeploymentContext wsDeploymentContext = environmentFactory.getDeploymentContext();
        ServerUtil.QueueInfo queueInfo = new ServerUtil.QueueInfo(bufferingFeature.getQueueJndiName(), null);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "setupBufferingFeature created new BufferingFeature with Endpoint serviceName='" + wSEndpoint.getServiceName() + "', portName='" + wSEndpoint.getPortName() + "', " + " Queue JNDI Name= " + bufferingFeature.getQueueJndiName() + "'" + "  processing contextPath='" + wsDeploymentContext.getContextPath() + "', to BufferingFeature Id='" + bufferingFeature.getBufferingFeatureId() + "'");
        }
        List<String> list = BufferUtil.getTargetURIs(wSEndpoint);
        for (String object2 : list) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "setupBufferingFeature processing targetURI='" + object2 + "'");
            }
            BufferingFeature.addTargetURI(object2, bufferingFeature);
            object = new WsrmSAFEndpoint(object2);
            wsrmSAFEndpointManager.addEndpoint(object2, (SAFEndpoint)object);
        }
        boolean bl = BufferingFeature.isQueueRegistered(bufferingFeature.getQueueJndiName());
        if (app_Server_Platform == BufferingProviderManager.App_Server_Platform.WLS && !bl) {
            Object object2 = mdbPoolCreationLock;
            synchronized (object2) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("BufferingFeature: Set up dynamic MDB to queue: " + bufferingFeature.getQueueJndiName());
                }
                object = new DeployMDBAction(wsDeploymentContext, "", queueInfo, bufferingFeature.getBufferDispatch().getMDBClassName(), bufferingFeature);
                try {
                    SecurityServiceManager.runAs((AuthenticatedSubject)_kernelId, (AuthenticatedSubject)_kernelId, (PrivilegedExceptionAction)object);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Throwable throwable = privilegedActionException.getCause();
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    throw new RuntimeException(throwable.toString(), throwable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setupBuffering(WSEndpoint wSEndpoint, TubelineSpliceFactory.DispatchFactory dispatchFactory, boolean bl, WsrmConfig.Destination destination) {
        Object object;
        if (destination.isNonBufferedDestination()) {
            return;
        }
        WsrmSAFEndpointManager wsrmSAFEndpointManager = (WsrmSAFEndpointManager)SAFManagerImpl.getManager().getEndpointManager(3);
        assert (wsrmSAFEndpointManager != null);
        EnvironmentFactory environmentFactory = JAXRPCEnvironmentFeature.getFactory(wSEndpoint);
        WsDeploymentContext wsDeploymentContext = environmentFactory.getDeploymentContext();
        ServerUtil.QueueInfo queueInfo = new ServerUtil.QueueInfo(destination.getBufferingConfig().getRequestQueue().getJndiName(), null);
        StringBuffer stringBuffer = new StringBuffer();
        BufferMdbListener bufferMdbListener = new BufferMdbListener(wSEndpoint, dispatchFactory, bl);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "created new BufferMdbListener with Endpoint serviceName='" + wSEndpoint.getServiceName() + "', portName='" + wSEndpoint.getPortName() + "'");
        }
        boolean bl2 = true;
        for (int i = 0; i < wsDeploymentContext.getServiceURIs().length; ++i) {
            String string = wsDeploymentContext.getContextPath();
            object = wsDeploymentContext.getServiceURIs()[i];
            String string2 = AsyncUtil.calculateServiceTargetURI(string, (String)object);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "processing contextPath='" + string + "', serviceUri='" + (String)object + "', calculated targetUri='" + string2 + "'");
            }
            BufferManager bufferManager = BufferManager.instance();
            Object object2 = bufferManager;
            synchronized (object2) {
                if (bufferManager.getMessageListener(string2) != null) {
                    bl2 = false;
                    continue;
                }
                bufferManager.addMessageListener(string2, bufferMdbListener);
            }
            wsDeploymentContext.addBufferTargetURI(string2);
            bufferManager.setTargetQueue(string2, queueInfo);
            object2 = new WsrmSAFEndpoint(string2);
            wsrmSAFEndpointManager.addEndpoint(string2, (SAFEndpoint)object2);
            if (stringBuffer.length() == 0) {
                stringBuffer.append(AsyncUtil.getAsyncSelector(string2));
                continue;
            }
            stringBuffer.append(" OR (");
            stringBuffer.append(AsyncUtil.getAsyncSelector(string2));
            stringBuffer.append(")");
        }
        if (bl2) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Set up dynamic MDB to queue: " + queueInfo.getQueueName());
            }
            DeployMDBAction deployMDBAction = new DeployMDBAction(wsDeploymentContext, stringBuffer.toString(), queueInfo, "weblogic.wsee.server.jms.MdbWS");
            try {
                SecurityServiceManager.runAs((AuthenticatedSubject)_kernelId, (AuthenticatedSubject)_kernelId, (PrivilegedExceptionAction)deployMDBAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                object = privilegedActionException.getCause();
                if (object instanceof RuntimeException) {
                    throw (RuntimeException)object;
                }
                throw new RuntimeException(((Throwable)object).toString(), (Throwable)object);
            }
        }
    }

    public static List<String> getTargetURIs(WSEndpoint wSEndpoint) {
        ArrayList<String> arrayList = new ArrayList<String>();
        EnvironmentFactory environmentFactory = JAXRPCEnvironmentFeature.getFactory(wSEndpoint);
        WsDeploymentContext wsDeploymentContext = environmentFactory.getDeploymentContext();
        String string = wsDeploymentContext.getContextPath();
        for (int i = 0; i < wsDeploymentContext.getServiceURIs().length; ++i) {
            String string2 = wsDeploymentContext.getServiceURIs()[i];
            arrayList.add(AsyncUtil.calculateServiceTargetURI(string, string2));
        }
        return arrayList;
    }

    private static class DeployMDBAction
    implements PrivilegedExceptionAction {
        WsDeploymentContext _deployContext;
        String _messageSelector;
        ServerUtil.QueueInfo _queueInfo;
        String _mdbClassName;
        BufferingFeature _bufferingFeature;

        private DeployMDBAction(WsDeploymentContext wsDeploymentContext, String string, ServerUtil.QueueInfo queueInfo, String string2) {
            this._deployContext = wsDeploymentContext;
            this._messageSelector = string;
            this._queueInfo = queueInfo;
            this._mdbClassName = string2;
            this._bufferingFeature = null;
        }

        private DeployMDBAction(WsDeploymentContext wsDeploymentContext, String string, ServerUtil.QueueInfo queueInfo, String string2, BufferingFeature bufferingFeature) {
            this._deployContext = wsDeploymentContext;
            this._messageSelector = string;
            this._queueInfo = queueInfo;
            this._mdbClassName = string2;
            this._bufferingFeature = bufferingFeature;
        }

        public Object run() throws Exception {
            ApplicationContextImpl applicationContextImpl = (ApplicationContextImpl)ApplicationAccess.getApplicationAccess().getCurrentApplicationContext();
            AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)_kernelId);
            applicationContextImpl.setDeploymentInitiator(authenticatedSubject);
            AsyncUtil.setupDynamicMDB(this._deployContext, this._messageSelector, this._queueInfo.getQueueName(), this._queueInfo.getMdbRunAsPrincipalName(), this._mdbClassName, 180, this._bufferingFeature != null, "weblogic.wsee.jaxws.mdb.DispatchPolicy");
            return null;
        }
    }
}

