/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.saf;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.TransportBackChannel;
import java.io.Externalizable;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.xml.datatype.Duration;
import weblogic.kernel.KernelStatus;
import weblogic.messaging.saf.SAFConversationInfo;
import weblogic.messaging.saf.SAFException;
import weblogic.messaging.saf.SAFManager;
import weblogic.messaging.saf.SAFRequest;
import weblogic.messaging.saf.common.SAFConversationInfoImpl;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.store.PersistentStoreException;
import weblogic.wsee.WseeRmLogger;
import weblogic.wsee.jaxws.client.async.AsyncTransportProvider;
import weblogic.wsee.jaxws.framework.WsUtil;
import weblogic.wsee.jaxws.persistence.PersistentContext;
import weblogic.wsee.jaxws.persistence.PersistentMessage;
import weblogic.wsee.jaxws.persistence.PersistentMessageFactory;
import weblogic.wsee.jaxws.persistence.PersistentObject;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability2.api.SequenceState;
import weblogic.wsee.reliability2.property.WsrmPropertyBag;
import weblogic.wsee.reliability2.saf.SequenceSAFMap;
import weblogic.wsee.reliability2.sequence.DeliveryAssurance;
import weblogic.wsee.reliability2.sequence.DestinationMessageInfo;
import weblogic.wsee.reliability2.sequence.DestinationSequence;
import weblogic.wsee.reliability2.sequence.DestinationSequenceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DestinationSequenceSAFMap
extends SequenceSAFMap<DestinationSequence, DestinationMessageInfo> {
    private static final Logger LOGGER = Logger.getLogger(DestinationSequenceSAFMap.class.getName());
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public DestinationSequenceSAFMap() throws PersistentStoreException, NamingException {
        if (KernelStatus.isServer()) {
            MyConversationLifecycleListener myConversationLifecycleListener = new MyConversationLifecycleListener();
            this._safManager.addConversationLifecycleListener(myConversationLifecycleListener);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            // empty if block
        }
    }

    @Override
    public int size() {
        int n = 0;
        if (this._safManager != null) {
            n += this._safManager.getConversationNamesOnReceivingSide().size();
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object object) {
        return this._safManager != null && this._safManager.getConversationNamesOnReceivingSide().contains(object);
    }

    @Override
    public boolean containsValue(Object object) {
        throw new IllegalStateException("Not supported");
    }

    @Override
    public DestinationSequence get(Object object) {
        if (!(object instanceof String)) {
            return null;
        }
        String string = (String)object;
        if (this._safManager == null) {
            return null;
        }
        try {
            SAFConversationInfo sAFConversationInfo = this._safManager.getCachedConversationInfoOnReceivingSide(string);
            return DestinationSequenceSAFMap.getSequenceFromConversationInfo(sAFConversationInfo, DestinationSequence.class);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString(), exception);
        }
    }

    @Override
    public DestinationSequence put(String string, final DestinationSequence destinationSequence) {
        boolean bl;
        boolean bl2 = bl = string == null || !this.containsKey(string);
        if (this._safManager == null) {
            throw new IllegalStateException("Persistent DestinationSequence detected, but SAF is not available");
        }
        try {
            DestinationSequence destinationSequence2 = null;
            if (bl) {
                SAFConversationInfoImpl sAFConversationInfoImpl = new SAFConversationInfoImpl(3);
                sAFConversationInfoImpl.setTransportType(3);
                sAFConversationInfoImpl.setDestinationType(3);
                sAFConversationInfoImpl.setConversationName(string);
                sAFConversationInfoImpl.setDynamic(false);
                sAFConversationInfoImpl.setCreateConversationMessageID(null);
                sAFConversationInfoImpl.setConversationOffer(null);
                sAFConversationInfoImpl.setSourceURL(destinationSequence.getAcksToEpr().getAddress());
                sAFConversationInfoImpl.setDestinationURL(destinationSequence.getHostEpr().getAddress());
                this.setupSAFConversationQOS(destinationSequence, sAFConversationInfoImpl);
                this.setupSAFConversationTTL(destinationSequence.getExpires(), sAFConversationInfoImpl);
                this.setupSAFConversationIdleTimeout(destinationSequence.getIdleTimeout(), sAFConversationInfoImpl);
                final SequenceSAFMap.SequenceExternalizable<DestinationSequence> sequenceExternalizable = new SequenceSAFMap.SequenceExternalizable<DestinationSequence>(destinationSequence, true);
                sAFConversationInfoImpl.setContext(sequenceExternalizable);
                SAFManager.ConversationNameRefinementCallback conversationNameRefinementCallback = new SAFManager.ConversationNameRefinementCallback(){

                    public void conversationPreStore(SAFConversationInfo sAFConversationInfo, SAFManager.LocationInfo locationInfo) {
                        if (destinationSequence.getId() == null) {
                            String string = WsUtil.generateRoutableUUID(destinationSequence.getPhysicalStoreName());
                            sAFConversationInfo.setConversationName(string);
                            destinationSequence.setId(string);
                            String string2 = WsUtil.getStoreNameFromRoutableUUID(string);
                            if (string2 == null || !string2.equals(destinationSequence.getPhysicalStoreName())) {
                                throw new IllegalArgumentException("SAF attempted to put seq '" + string + " into physical store '" + string2 + "' but the sequence itself was expecting physical store '" + destinationSequence.getPhysicalStoreName() + "'");
                            }
                        }
                        try {
                            sequenceExternalizable.getBytes();
                        }
                        catch (Exception exception) {
                            throw new RuntimeException(exception.toString(), exception);
                        }
                    }
                };
                this._safManager.registerConversationOnReceivingSide(sAFConversationInfoImpl, conversationNameRefinementCallback, destinationSequence.getPhysicalStoreName());
            } else {
                Object object;
                destinationSequence2 = this.get(string);
                SAFConversationInfo sAFConversationInfo = this._safManager.getCachedConversationInfoOnReceivingSide(string);
                if (SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)DestinationSequenceSAFMap.getCurrentSubject())) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Bypassing update of requests in SAF for conversation: " + destinationSequence.getId() + " because we were invoked from a system thread, not a user thread. Only user threads can update the SAF conversation.");
                    }
                } else {
                    object = destinationSequence.getAndClearPendingRequests();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        DestinationMessageInfo destinationMessageInfo = (DestinationMessageInfo)iterator.next();
                        Packet packet = destinationMessageInfo.getRequestPacket();
                        if (packet == null) continue;
                        this.storeSAFRequest(destinationSequence, destinationMessageInfo);
                    }
                }
                object = (SequenceSAFMap.SequenceExternalizable)sAFConversationInfo.getContext();
                ((SequenceSAFMap.ExternalizableWrapper)object).getBytes();
                try {
                    this._safManager.storeConversationContextOnReceivingSide(string, (Externalizable)object);
                }
                catch (SAFException sAFException) {
                    if (SequenceState.isTerminalState(destinationSequence.getState()) || SequenceState.isClosedState(destinationSequence.getState())) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Destination sequence " + destinationSequence.getId() + " was terminated before we do update the sequence to store");
                        }
                    }
                    throw sAFException;
                }
            }
            return destinationSequence2;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString(), exception);
        }
    }

    private static AuthenticatedSubject getCurrentSubject() {
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID);
        return authenticatedSubject;
    }

    @Override
    protected Externalizable createSAFRequestPayload(Packet packet, DestinationMessageInfo destinationMessageInfo) {
        if (destinationMessageInfo.getSuspendedFiber() != null) {
            Object object;
            PersistentContext persistentContext = PersistentMessageFactory.getInstance().createContextFromPacket(destinationMessageInfo.getMessageId(), packet);
            if (LOGGER.isLoggable(Level.FINE)) {
                object = AsyncTransportProvider.dumpPersistentContextContextProps(persistentContext.getContextPropertyMap());
                LOGGER.fine("Storing SAFRequest as no-message PersistentContext for msg " + destinationMessageInfo.getMessageId() + " with persistContext: " + (String)object);
            }
            object = new PersistentObject(destinationMessageInfo, persistentContext);
            return new SequenceSAFMap.ExternalizableWrapper<Object>(object, false);
        }
        PersistentMessage persistentMessage = PersistentMessageFactory.getInstance().createMessageFromPacket(destinationMessageInfo.getMessageId(), packet);
        if (LOGGER.isLoggable(Level.FINE)) {
            String string = AsyncTransportProvider.dumpPersistentContextContextProps(persistentMessage.getContext().getContextPropertyMap());
            LOGGER.fine("Storing SAFRequest for msg " + destinationMessageInfo.getMessageId() + " with persistContext: " + string);
        }
        return new SequenceSAFMap.ExternalizableWrapper<PersistentMessage>(persistentMessage, false);
    }

    private void storeSAFRequest(DestinationSequence destinationSequence, DestinationMessageInfo destinationMessageInfo) throws IOException, SAFException {
        Packet packet = destinationMessageInfo.getRequestPacket();
        if (packet == null) {
            return;
        }
        if (packet.getMessage() == null) {
            throw new IllegalArgumentException("Message was null for msgId " + destinationMessageInfo.getMessageId());
        }
        DestinationSequence.preventRemovalOfAsyncRequestContext(destinationSequence, destinationMessageInfo, packet);
        WsrmPropertyBag wsrmPropertyBag = WsrmPropertyBag.propertySetRetriever.getFromPacket(packet);
        wsrmPropertyBag.setInternalReceive(true);
        SAFRequest sAFRequest = this.createSAFRequest(destinationSequence, destinationMessageInfo);
        if (sAFRequest == null) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Delivering SAFRequest for sequence " + destinationSequence.getId() + " msg num " + destinationMessageInfo.getMessageNum() + " msgID " + destinationMessageInfo.getMessageId());
        }
        this.restoreTransportBackChannelForRequest(packet, destinationSequence, destinationMessageInfo);
        SAFConversationInfo sAFConversationInfo = this._safManager.getCachedConversationInfoOnReceivingSide(destinationSequence.getId());
        this._safManager.deliver(sAFConversationInfo, sAFRequest);
    }

    private void restoreTransportBackChannelForRequest(Packet packet, DestinationSequence destinationSequence, DestinationMessageInfo destinationMessageInfo) {
        WsrmPropertyBag wsrmPropertyBag;
        if (packet != null && (wsrmPropertyBag = WsrmPropertyBag.propertySetRetriever.getFromPacket(packet)).getTransportBackChannel() != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("RM is returning the hijacked TransportBackChannel to the request packet ahead of final delivery of request sequence " + destinationSequence.getId() + " msg num " + destinationMessageInfo.getMessageNum() + " msgID " + destinationMessageInfo.getMessageId());
            }
            TransportBackChannel transportBackChannel = wsrmPropertyBag.getTransportBackChannel();
            wsrmPropertyBag.setTransportBackChannel(null);
            packet.transportBackChannel = transportBackChannel;
        }
    }

    private void setupSAFConversationQOS(DestinationSequence destinationSequence, SAFConversationInfo sAFConversationInfo) {
        DeliveryAssurance deliveryAssurance = destinationSequence.getDeliveryAssurance();
        if (deliveryAssurance.isInOrder()) {
            sAFConversationInfo.setInorder(true);
        }
        if (deliveryAssurance.getQos() == WsrmConstants.DeliveryQOS.ExactlyOnce) {
            sAFConversationInfo.setQOS(1);
        } else if (deliveryAssurance.getQos() == WsrmConstants.DeliveryQOS.AtLeastOnce) {
            sAFConversationInfo.setQOS(2);
        } else if (deliveryAssurance.getQos() == WsrmConstants.DeliveryQOS.AtMostOnce) {
            sAFConversationInfo.setQOS(3);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setupSAFConversationTTL(Duration duration, SAFConversationInfo sAFConversationInfo) {
        if (duration != null) {
            long l = duration.getTimeInMillis(new Date());
            if (l <= 0L) throw new RuntimeException("Invalid expiration time: " + duration.toString());
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Setting RM sequence timetolive to " + l + " on seq " + sAFConversationInfo.getConversationName());
            }
            sAFConversationInfo.setTimeToLive(l);
            return;
        } else {
            sAFConversationInfo.setTimeToLive(Long.MAX_VALUE);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setupSAFConversationIdleTimeout(Duration duration, SAFConversationInfo sAFConversationInfo) {
        if (duration != null) {
            try {
                long l = System.currentTimeMillis();
                long l2 = duration.getTimeInMillis(new Date(l));
                sAFConversationInfo.setMaximumIdleTime(l2);
                if (!LOGGER.isLoggable(Level.FINER)) return;
                LOGGER.finer("InactivityTimeout is " + duration + " on seq " + sAFConversationInfo.getConversationName());
                return;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString(), exception);
            }
        } else {
            sAFConversationInfo.setMaximumIdleTime(0L);
        }
    }

    @Override
    public DestinationSequence remove(Object object) {
        if (this._safManager == null || !(object instanceof String)) {
            return null;
        }
        String string = (String)object;
        try {
            SAFConversationInfo sAFConversationInfo = this._safManager.getCachedConversationInfoOnReceivingSide(string);
            if (sAFConversationInfo == null) {
                return null;
            }
            DestinationSequence destinationSequence = DestinationSequenceSAFMap.getSequenceFromConversationInfo(sAFConversationInfo, DestinationSequence.class);
            if (destinationSequence != null) {
                this._safManager.closeConversationOnReceivingSide(sAFConversationInfo);
                destinationSequence.destroy();
            }
            return destinationSequence;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString(), exception);
        }
    }

    @Override
    public void putAll(Map<? extends String, ? extends DestinationSequence> map) {
        throw new IllegalStateException("Not supported");
    }

    @Override
    public void clear() {
        throw new IllegalStateException("Not supported");
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> hashSet = new HashSet<String>();
        this.fillSeqIdSetFromSAF(hashSet);
        return hashSet;
    }

    protected void fillSeqIdSetFromSAF(Set<String> set) {
        if (this._safManager != null) {
            Set set2 = this._safManager.getConversationNamesOnReceivingSide();
            for (Object e : set2) {
                try {
                    DestinationSequence destinationSequence = this.get(e);
                    if (destinationSequence == null) continue;
                    set.add((String)e);
                }
                catch (Exception exception) {
                    WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                }
            }
        }
    }

    @Override
    public Collection<DestinationSequence> values() {
        Set<String> set = this.keySet();
        ArrayList<DestinationSequence> arrayList = new ArrayList<DestinationSequence>(set.size());
        for (String string : set) {
            DestinationSequence destinationSequence = this.get(string);
            if (destinationSequence == null) continue;
            arrayList.add(destinationSequence);
        }
        return arrayList;
    }

    @Override
    public Set<Map.Entry<String, DestinationSequence>> entrySet() {
        throw new IllegalStateException("Not supported");
    }

    private class MyConversationLifecycleListener
    implements SAFManager.ConversationLifecycleListener {
        private MyConversationLifecycleListener() {
        }

        public void ack(SAFConversationInfo sAFConversationInfo, long l, long l2) {
        }

        public void addToCache(boolean bl, String string, String string2, SAFConversationInfo sAFConversationInfo, int n) {
        }

        public void preClose(boolean bl, boolean bl2, SAFConversationInfo sAFConversationInfo) {
        }

        public void removeFromCache(boolean bl, String string, String string2, SAFConversationInfo sAFConversationInfo, int n) {
            if (bl) {
                return;
            }
            DestinationSequence destinationSequence = SequenceSAFMap.getSequenceFromConversationInfo(sAFConversationInfo, DestinationSequence.class);
            if (destinationSequence != null) {
                DestinationSequenceManager.getInstance().terminateSequence(destinationSequence.getId());
            }
        }
    }
}

