/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.saf;

import com.sun.istack.Nullable;
import com.sun.xml.ws.api.message.Packet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import weblogic.kernel.KernelStatus;
import weblogic.messaging.saf.SAFConversationInfo;
import weblogic.messaging.saf.SAFRequest;
import weblogic.messaging.saf.common.SAFRequestImpl;
import weblogic.messaging.saf.internal.SAFManagerImpl;
import weblogic.store.PersistentStoreException;
import weblogic.wsee.jaxws.framework.WsUtil;
import weblogic.wsee.persistence.StoreException;
import weblogic.wsee.reliability2.sequence.MessageInfo;
import weblogic.wsee.reliability2.sequence.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SequenceSAFMap<S extends Sequence, M extends MessageInfo>
implements Map<String, S> {
    private static final Logger LOGGER = Logger.getLogger(SequenceSAFMap.class.getName());
    protected SAFManagerImpl _safManager;

    @Nullable
    static <V extends Sequence> V getSequenceFromConversationInfo(SAFConversationInfo sAFConversationInfo, Class<V> clazz) {
        return SequenceSAFMap.getSequenceFromConversationInfo(sAFConversationInfo, clazz, true);
    }

    @Nullable
    static <V extends Sequence> V getSequenceFromConversationInfo(SAFConversationInfo sAFConversationInfo, Class<V> clazz, boolean bl) {
        if (sAFConversationInfo == null) {
            return null;
        }
        try {
            Externalizable externalizable = sAFConversationInfo.getContext();
            if (externalizable instanceof SequenceExternalizable) {
                SequenceExternalizable sequenceExternalizable = (SequenceExternalizable)externalizable;
                Sequence sequence = (Sequence)sequenceExternalizable.getObj();
                if (sequence.getPhysicalStoreName() == null) {
                    sequence.setPhysicalStoreName(sequenceExternalizable.getPhysicalStoreName());
                }
                if (sequence.getLogicalStoreName() == null) {
                    sequence.setLogicalStoreName(sequenceExternalizable.getLogicalStoreName());
                }
                return (V)sequence;
            }
            if (bl) {
                return null;
            }
            throw new RuntimeException("Programming error: SAF has called the JAX-WS RM SAF Transport with an invalid SAFConversationInfo containing context object: " + sAFConversationInfo.getContext() + ". Expected object of class ExternalizableWrapper<" + clazz + ">");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString(), exception);
        }
    }

    static Serializable getPayloadFromSAFRequest(SAFRequest sAFRequest) {
        try {
            return ((ExternalizableWrapper)sAFRequest.getPayload()).getObj();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString(), exception);
        }
    }

    static MessageInfo getMessageInfoFromSAFRequest(SAFRequest sAFRequest) {
        try {
            return (MessageInfo)((ExternalizableWrapper)sAFRequest.getPayloadContext()).getObj();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString(), exception);
        }
    }

    static ReadWriteTimings getPersistentMessageTimingsFromSAFRequest(SAFRequest sAFRequest) {
        ExternalizableWrapper externalizableWrapper = (ExternalizableWrapper)sAFRequest.getPayload();
        ReadWriteTimings readWriteTimings = new ReadWriteTimings();
        readWriteTimings.millisSinceLastReadObject = externalizableWrapper.millisSinceLastReadObject();
        readWriteTimings.millisSinceLastWriteObject = externalizableWrapper.millisSinceLastWriteObject();
        return readWriteTimings;
    }

    protected SequenceSAFMap() throws NamingException, PersistentStoreException {
        this.initSAFManager();
    }

    private void initSAFManager() throws NamingException, PersistentStoreException {
        this._safManager = KernelStatus.isServer() ? (SAFManagerImpl)SAFManagerImpl.getManager() : null;
    }

    public void recover() throws StoreException {
    }

    protected SAFRequest createSAFRequest(S s, M m) throws IOException {
        Packet packet = ((MessageInfo)m).getRequestPacket();
        if (packet == null) {
            return null;
        }
        SAFRequestImpl sAFRequestImpl = new SAFRequestImpl();
        sAFRequestImpl.setConversationName(((Sequence)s).getId());
        sAFRequestImpl.setSequenceNumber(((MessageInfo)m).getMessageNum());
        sAFRequestImpl.setDeliveryMode(2);
        sAFRequestImpl.setTimeToLive(0L);
        sAFRequestImpl.setTimestamp(System.currentTimeMillis());
        sAFRequestImpl.setEndOfConversation(false);
        if (((MessageInfo)m).getMessageId() != null) {
            sAFRequestImpl.setMessageId(((MessageInfo)m).getMessageId());
        }
        Externalizable externalizable = this.createSAFRequestPayload(packet, m);
        sAFRequestImpl.setPayload(externalizable);
        ExternalizableWrapper<M> externalizableWrapper = new ExternalizableWrapper<M>(m, false);
        sAFRequestImpl.setPayloadContext(externalizableWrapper);
        return sAFRequestImpl;
    }

    protected abstract Externalizable createSAFRequestPayload(Packet var1, M var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ExternalizableWrapper<T extends Serializable>
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private T _obj;
        private byte[] _bytes;
        private boolean _repeatSerializeAllowed;
        private transient long _lastReadObjectTime;
        private transient long _lastWriteObjectTime;

        public ExternalizableWrapper() {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Deserialized ExternalizableWrapper: " + this);
            }
        }

        public ExternalizableWrapper(T t, boolean bl) {
            this._obj = t;
            this._repeatSerializeAllowed = bl;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Created new ExternalizableWrapper " + this);
            }
        }

        public T getObj() {
            if (this._obj == null) {
                try {
                    return this.getObjFromBytes();
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.toString(), exception);
                }
            }
            return this._obj;
        }

        private T getObjFromBytes() throws ClassNotFoundException, IOException {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Getting object from bytes in ExternalizableWrapper " + this);
            }
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this._bytes);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                Serializable serializable = (Serializable)objectInputStream.readObject();
                if (this._repeatSerializeAllowed) {
                    this._bytes = null;
                    this._obj = serializable;
                }
                this._lastReadObjectTime = System.currentTimeMillis();
                return (T)serializable;
            }
            catch (IOException iOException) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, iOException.toString(), iOException);
                }
                throw iOException;
            }
        }

        public long millisSinceLastReadObject() {
            return System.currentTimeMillis() - this._lastReadObjectTime;
        }

        public long millisSinceLastWriteObject() {
            return System.currentTimeMillis() - this._lastWriteObjectTime;
        }

        public byte[] getBytes() throws IOException {
            if (this._bytes != null) {
                return this._bytes;
            }
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(this._obj);
                objectOutputStream.flush();
                byteArrayOutputStream.flush();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                if (!this._repeatSerializeAllowed) {
                    this._obj = null;
                    this._bytes = byArray;
                }
                this._lastWriteObjectTime = System.currentTimeMillis();
                return byArray;
            }
            catch (IOException iOException) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, iOException.toString(), iOException);
                }
                throw iOException;
            }
        }

        @Override
        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeBoolean(this._repeatSerializeAllowed);
            byte[] byArray = this.getBytes();
            objectOutput.writeInt(byArray.length);
            objectOutput.write(byArray);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Serialized ExternalizableWrapper " + this);
            }
        }

        @Override
        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this._repeatSerializeAllowed = objectInput.readBoolean();
            int n = objectInput.readInt();
            this._bytes = new byte[n];
            objectInput.readFully(this._bytes);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Deserialized ExternalizableWrapper " + this);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(super.toString());
            stringBuffer.append(" bytes[").append(this._bytes != null ? this._bytes.length : 0).append("]");
            stringBuffer.append(" obj: ").append(this._obj);
            stringBuffer.append(", repeatSerializeAllowed=").append(this._repeatSerializeAllowed);
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SequenceExternalizable<T extends Sequence>
    extends ExternalizableWrapper<T> {
        private static final long serialVersionUID = 1L;
        private String _seqId;
        private String _physicalStoreName;
        private String _logicalStoreName;

        public SequenceExternalizable() {
        }

        public SequenceExternalizable(T t, boolean bl) {
            super(t, bl);
        }

        public String getSeqId() {
            return this._seqId;
        }

        public String getPhysicalStoreName() {
            return this._physicalStoreName;
        }

        public String getLogicalStoreName() {
            return this._logicalStoreName;
        }

        private void grabDataFromSeq(T t) {
            this._seqId = ((Sequence)t).getId() == null ? "Standin-" + WsUtil.generateUUID() : ((Sequence)t).getId();
            if (((Sequence)t).getPhysicalStoreName() != null) {
                this._physicalStoreName = ((Sequence)t).getPhysicalStoreName();
            }
            if (((Sequence)t).getLogicalStoreName() != null) {
                this._logicalStoreName = ((Sequence)t).getLogicalStoreName();
            }
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(super.toString());
            stringBuffer.append(" - ").append(this._seqId);
            return stringBuffer.toString();
        }

        @Override
        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            if (this._seqId == null && LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("ExternalizableWrapper grabbing seq ID: " + this);
            }
            this.grabDataFromSeq((Sequence)this.getObj());
            objectOutput.writeObject(this._seqId);
            objectOutput.writeObject(this._physicalStoreName);
            objectOutput.writeObject(this._logicalStoreName);
            super.writeExternal(objectOutput);
        }

        @Override
        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this._seqId = (String)objectInput.readObject();
            this._physicalStoreName = (String)objectInput.readObject();
            this._logicalStoreName = (String)objectInput.readObject();
            super.readExternal(objectInput);
        }
    }

    static class ReadWriteTimings {
        long millisSinceLastReadObject;
        long millisSinceLastWriteObject;

        ReadWriteTimings() {
        }
    }
}

