/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.saf;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.messaging.saf.SAFConversationInfo;
import weblogic.messaging.saf.SAFEndpoint;
import weblogic.messaging.saf.SAFException;
import weblogic.messaging.saf.SAFRequest;
import weblogic.wsee.WseeRmLogger;
import weblogic.wsee.buffer.BufferManager;
import weblogic.wsee.buffer2.api.common.BufferingFeature;
import weblogic.wsee.buffer2.exception.BufferingException;
import weblogic.wsee.buffer2.utils.BufferingConstants;
import weblogic.wsee.reliability2.saf.SequenceSAFMap;

public final class WsrmSAFEndpoint
implements SAFEndpoint {
    private static final Logger LOGGER = Logger.getLogger(WsrmSAFEndpoint.class.getName());
    private static boolean USE_NEW_BUFFERING_FEATURE = true;
    private String _targetURI;

    public WsrmSAFEndpoint(String string) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Created WsrmSAFEndpoint for targetURI: " + string);
        }
        this._targetURI = string;
    }

    public void deliver(SAFConversationInfo sAFConversationInfo, SAFRequest sAFRequest) throws SAFException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("[WsrmSAFEndpoint.deliver()] sequence id " + sAFConversationInfo.getConversationName() + ": " + sAFRequest.getSequenceNumber() + " for targetURI: " + this._targetURI);
        }
        try {
            Serializable serializable = SequenceSAFMap.getPayloadFromSAFRequest(sAFRequest);
            int n = 3;
            long l = 10L;
            if (USE_NEW_BUFFERING_FEATURE) {
                BufferingConstants.MsgDirection msgDirection = BufferingConstants.MsgDirection.REQUEST;
                BufferingFeature bufferingFeature = BufferingFeature.getBufferingFeature(this._targetURI);
                if (bufferingFeature != null) {
                    n = bufferingFeature.getDeployedRetryCount();
                    String string = bufferingFeature.getDeployedRetryDelay();
                    if (string != null && string.length() > 0) {
                        long l2 = l;
                        try {
                            l = Long.parseLong(string);
                        }
                        catch (Exception exception) {
                            l = l2;
                        }
                    }
                    msgDirection = bufferingFeature.getDirection();
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("WsrmSAFEndpoint buffering message with request ID " + sAFRequest.getMessageId() + " to targetURI = " + this._targetURI + " direction " + (Object)((Object)msgDirection) + " seq " + sAFConversationInfo.getConversationName());
                }
                BufferingFeature.getBufferingManager().bufferMessage(this._targetURI, serializable, msgDirection, n, l, sAFConversationInfo.getConversationName(), sAFRequest.getSequenceNumber());
            } else {
                BufferManager.instance().bufferMessageUOO(this._targetURI, serializable, n, l, sAFConversationInfo.getConversationName(), sAFRequest.getSequenceNumber());
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("WsrmSAFEndpoint done buffering msg id " + sAFRequest.getMessageId() + " requestSeqNum " + sAFRequest.getSequenceNumber() + " on destination sequence " + sAFConversationInfo.getConversationName() + ". Will now proceed to ack this message back to the sender.");
            }
        }
        catch (Throwable throwable) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, throwable.toString(), throwable);
            }
            throw new SAFException(throwable.toString(), throwable);
        }
    }

    public String getTargetQueue() {
        String string;
        if (USE_NEW_BUFFERING_FEATURE) {
            try {
                string = BufferingFeature.getQueueJndiName(this._targetURI);
            }
            catch (BufferingException bufferingException) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Couldn't find buffering request queue JNDI name: " + bufferingException.toString(), bufferingException);
                }
                WseeRmLogger.logUnexpectedException((String)bufferingException.toString(), (Throwable)bufferingException);
                string = null;
            }
        } else {
            string = BufferManager.instance().getTargetQueue(this._targetURI).getQueueName();
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "WsrmSAFEndpoint.getTargetQueue returning targetQueueName for targetURI='" + this._targetURI + "', queueName is '" + string + "'");
        }
        return string;
    }

    public boolean isAvailable() {
        return true;
    }
}

