/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.saf;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.messaging.saf.SAFEndpoint;
import weblogic.messaging.saf.SAFErrorAwareEndpointManager;
import weblogic.messaging.saf.SAFErrorHandler;
import weblogic.messaging.saf.SAFRequest;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.wsee.reliability2.saf.WsrmSAFEndpoint;

public class WsrmSAFEndpointManager
implements SAFErrorAwareEndpointManager {
    private static final Logger LOGGER = Logger.getLogger(WsrmSAFEndpointManager.class.getName());
    private HashMap endpoints = new HashMap();
    private Map errorHandlers = Collections.synchronizedMap(new HashMap());
    private static RuntimeAccess _runtimeAccess;

    public WsrmSAFEndpointManager() {
        ServerStateChangeListener serverStateChangeListener = new ServerStateChangeListener();
        _runtimeAccess.getServerRuntime().addPropertyChangeListener(serverStateChangeListener);
    }

    public synchronized void addEndpoint(String string, SAFEndpoint sAFEndpoint) {
        this.endpoints.put(string, sAFEndpoint);
    }

    public synchronized void removeEndpoint(String string) {
        this.endpoints.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SAFEndpoint getEndpoint(String string) {
        SAFEndpoint sAFEndpoint;
        String string2;
        try {
            string2 = new URI(string).getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, uRISyntaxException.toString(), uRISyntaxException);
            }
            throw new RuntimeException("Could not parse destination URL", uRISyntaxException);
        }
        Object object = this;
        synchronized (object) {
            sAFEndpoint = (SAFEndpoint)this.endpoints.get(string2);
        }
        if (sAFEndpoint == null) {
            if (!string2.endsWith("/")) {
                object = string2 + "/";
                sAFEndpoint = (SAFEndpoint)this.endpoints.get(object);
            } else if (string2.endsWith("/")) {
                object = string2.substring(0, string2.length() - 1);
                sAFEndpoint = (SAFEndpoint)this.endpoints.get(object);
            }
            if (sAFEndpoint == null) {
                sAFEndpoint = new WsrmSAFEndpoint(string2);
                this.addEndpoint(string2, sAFEndpoint);
            }
        }
        return sAFEndpoint;
    }

    public void handleFailure(SAFErrorHandler sAFErrorHandler, SAFRequest sAFRequest, ArrayList arrayList) {
        this.handleFailure(sAFErrorHandler, sAFRequest, arrayList, new ArrayList());
    }

    public void handleFailure(SAFErrorHandler sAFErrorHandler, SAFRequest sAFRequest, ArrayList arrayList, ArrayList arrayList2) {
    }

    public SAFErrorHandler createErrorHandlerInstance() {
        return null;
    }

    public SAFErrorHandler getErrorHandler(String string) {
        return (SAFErrorHandler)this.errorHandlers.get(string);
    }

    static {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        _runtimeAccess = ManagementService.getRuntimeAccess(authenticatedSubject);
    }

    private class ServerStateChangeListener
    implements PropertyChangeListener {
        boolean _serverUp;

        public ServerStateChangeListener() {
            this.interpretState(_runtimeAccess.getServerRuntime().getState());
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("State".equals(propertyChangeEvent.getPropertyName())) {
                this.interpretState((String)propertyChangeEvent.getNewValue());
            }
        }

        private void interpretState(String string) {
            if ("RUNNING".equals(string)) {
                this.setServerUp();
            } else {
                this.setServerDown();
            }
        }

        private void setServerDown() {
            this._serverUp = false;
        }

        private void setServerUp() {
            if (!this._serverUp) {
                this._serverUp = true;
            }
            this._serverUp = true;
        }

        public boolean isServerUp() {
            return this._serverUp;
        }
    }
}

