/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.saf;

import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Packet;
import java.io.Externalizable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLHandshakeException;
import weblogic.messaging.saf.SAFConversationHandle;
import weblogic.messaging.saf.SAFConversationInfo;
import weblogic.messaging.saf.SAFErrorAwareTransport;
import weblogic.messaging.saf.SAFRequest;
import weblogic.messaging.saf.SAFResult;
import weblogic.messaging.saf.SAFTransportException;
import weblogic.messaging.saf.common.SAFConversationHandleImpl;
import weblogic.wsee.WseeRmLogger;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.WsrmPermanentTransportException;
import weblogic.wsee.reliability.faults.SequenceFaultException;
import weblogic.wsee.reliability.headers.SequenceHeader;
import weblogic.wsee.reliability2.api_internal.WsrmLifecycleEvent;
import weblogic.wsee.reliability2.api_internal.WsrmLifecycleEventListenerRegistry;
import weblogic.wsee.reliability2.exception.WsrmException;
import weblogic.wsee.reliability2.headers.WsrmHeaderFactory;
import weblogic.wsee.reliability2.property.WsrmPropertyBag;
import weblogic.wsee.reliability2.sequence.DestinationMessageInfo;
import weblogic.wsee.reliability2.sequence.DestinationOfferSequence;
import weblogic.wsee.reliability2.sequence.DestinationSequence;
import weblogic.wsee.reliability2.sequence.DestinationSequenceManager;
import weblogic.wsee.reliability2.sequence.SourceOfferSequence;
import weblogic.wsee.reliability2.sequence.SourceSequence;
import weblogic.wsee.reliability2.sequence.SourceSequenceManager;
import weblogic.wsee.util.AccessException;

public final class WsrmSAFTransport
implements SAFErrorAwareTransport {
    private static final Logger LOGGER = Logger.getLogger(WsrmSAFTransport.class.getName());
    private int type = 3;
    private static Set<String> _deliveredMsgIds = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResult(SAFResult sAFResult) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Received SAFResult successful=" + sAFResult.isSuccessful() + " duplicate=" + sAFResult.isDuplicate() + " error=" + sAFResult.getSAFException() + " sequence=" + sAFResult.getConversationInfo().getConversationName());
        }
        if (sAFResult.isSuccessful() && !sAFResult.isDuplicate()) {
            DestinationSequence destinationSequence = null;
            try {
                destinationSequence = DestinationSequenceManager.getInstance().getSequence(WsrmConstants.RMVersion.latest(), sAFResult.getConversationInfo().getConversationName(), false);
                List list = sAFResult.getSequenceNumbers();
                for (int i = 0; i < list.size(); i += 2) {
                    long l = (Long)list.get(i);
                    long l2 = i + 1 < list.size() ? (Long)list.get(i + 1) : l;
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("SAFResult indicated message range lower=" + l + " upper=" + l2 + ". We're now marking all the indicated requests as 'accepted'.");
                    }
                    for (long j = l; j <= l2; ++j) {
                        DestinationMessageInfo destinationMessageInfo = (DestinationMessageInfo)destinationSequence.getRequest(j);
                        DestinationSequenceManager.getInstance().markRequestAccepted(destinationSequence, destinationMessageInfo);
                    }
                }
                if (destinationSequence instanceof DestinationOfferSequence) {
                    WsrmLifecycleEventListenerRegistry.getInstance().notifyEventType(WsrmLifecycleEvent.Type.CLIENT_IN_MSG_AFTER_BUFFERING);
                } else {
                    WsrmLifecycleEventListenerRegistry.getInstance().notifyEventType(WsrmLifecycleEvent.Type.SERV_IN_MSG_AFTER_BUFFERING);
                }
            }
            catch (Exception exception) {
                WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            }
            finally {
                try {
                    if (destinationSequence != null) {
                        DestinationSequenceManager.getInstance().updateSequence(destinationSequence);
                    }
                }
                catch (Exception exception) {
                    WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                }
            }
        }
    }

    public int getType() {
        return this.type;
    }

    public boolean isGapsAllowed() {
        return false;
    }

    public Externalizable send(SAFConversationInfo sAFConversationInfo, SAFRequest sAFRequest) throws SAFTransportException {
        return null;
    }

    private void updatePacket(SourceSequence sourceSequence, WsrmPropertyBag wsrmPropertyBag, Packet packet) throws WsrmException {
        if (wsrmPropertyBag.getOutboundMsgNeedsDestSeqId()) {
            SequenceHeader sequenceHeader = WsrmHeaderFactory.getInstance().getHeaderFromPacket(SequenceHeader.class, packet);
            sequenceHeader.setSequenceId(sourceSequence.getDestinationId());
            wsrmPropertyBag.setOutboundMsgNeedsDestSeqId(false);
            packet.getMessage().getHeaders().addOrReplace((Header)sequenceHeader);
        }
    }

    public SAFConversationHandle createConversation(SAFConversationInfo sAFConversationInfo) throws SAFTransportException {
        return null;
    }

    private SAFConversationHandle finishOfferSequenceCreation(SourceOfferSequence sourceOfferSequence, SAFConversationInfo sAFConversationInfo) {
        sourceOfferSequence.setDestinationId(sourceOfferSequence.getId());
        SAFConversationHandleImpl sAFConversationHandleImpl = new SAFConversationHandleImpl(sourceOfferSequence.getId(), sourceOfferSequence.getDestinationId(), sAFConversationInfo.getTimeToLive(), sAFConversationInfo.getMaximumIdleTime(), null, null, sAFConversationInfo.getContext());
        return sAFConversationHandleImpl;
    }

    public void terminateConversation(SAFConversationInfo sAFConversationInfo) throws SAFTransportException {
        assert (sAFConversationInfo != null);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Sending SAF-generated terminateConversation on conversation: " + sAFConversationInfo.getConversationName());
        }
        try {
            SourceSequenceManager.getInstance().terminateSequence(sAFConversationInfo.getConversationName());
        }
        catch (Exception exception) {
            throw new SAFTransportException(exception.toString(), exception);
        }
    }

    public Externalizable createSecurityToken(SAFConversationInfo sAFConversationInfo) throws SAFTransportException {
        return null;
    }

    public boolean isPermanentError(Throwable throwable) {
        boolean bl = false;
        for (Throwable throwable2 = throwable; throwable2 != null && !bl; throwable2 = throwable2.getCause()) {
            bl = throwable2 instanceof WsrmPermanentTransportException || throwable2 instanceof AccessException || throwable2 instanceof SSLHandshakeException || throwable2 instanceof SequenceFaultException || throwable2 instanceof IllegalStateException || throwable2 instanceof IllegalArgumentException;
        }
        return bl;
    }
}

