/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.sequence;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import weblogic.wsee.reliability.WsrmSecurityContext;
import weblogic.wsee.reliability2.api_internal.WsrmLifecycleEvent;
import weblogic.wsee.reliability2.api_internal.WsrmLifecycleEventListenerRegistry;
import weblogic.wsee.reliability2.exception.WsrmException;
import weblogic.wsee.security.wssc.base.sct.SCTokenBase;
import weblogic.wsee.security.wssc.base.sct.SCTokenHandlerBase;
import weblogic.wsee.security.wssc.sct.SCCredential;
import weblogic.wsee.security.wssc.v200502.sct.SCTokenHandler;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;

public class CreateSequencePostSecurityTokenCallback {
    public static String PROPERTY_NAME = "CreateSequencePostSecurityTokenCallback";
    private static final Logger LOGGER = Logger.getLogger(CreateSequencePostSecurityTokenCallback.class.getName());
    private WsrmSecurityContext seqCtx;

    private CreateSequencePostSecurityTokenCallback(WsrmSecurityContext wsrmSecurityContext) {
        this.seqCtx = wsrmSecurityContext;
    }

    public static void addCallbackToMap(WsrmSecurityContext wsrmSecurityContext, Map map) {
        if (map == null || wsrmSecurityContext == null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Ouch, got null map or seqCtx in addCallbackToMap");
            }
            return;
        }
        if (wsrmSecurityContext.isSecureWithWssc()) {
            CreateSequencePostSecurityTokenCallback createSequencePostSecurityTokenCallback = new CreateSequencePostSecurityTokenCallback(wsrmSecurityContext);
            map.put(PROPERTY_NAME, createSequencePostSecurityTokenCallback);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("added CreateSequencePostSecurityTokenCallback to map");
            }
            wsrmSecurityContext.setJaxWsSecurityTokenCallback(createSequencePostSecurityTokenCallback);
        }
    }

    public static void processCallback(MessageContext messageContext) throws WsrmException {
        CreateSequencePostSecurityTokenCallback createSequencePostSecurityTokenCallback = (CreateSequencePostSecurityTokenCallback)messageContext.getProperty(PROPERTY_NAME);
        if (createSequencePostSecurityTokenCallback == null) {
            return;
        }
        createSequencePostSecurityTokenCallback.execute(messageContext);
        WsrmLifecycleEventListenerRegistry.getInstance().notifyEventType(WsrmLifecycleEvent.Type.AFTER_RSTR_BEFORE_CREATE_SEQ);
        messageContext.removeProperty(PROPERTY_NAME);
        createSequencePostSecurityTokenCallback.seqCtx.removeCreateSequencePostSecurityTokenCallback();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(MessageContext messageContext) throws WsrmException {
        SOAPBody sOAPBody;
        SecurityTokenReference securityTokenReference;
        if (!this.seqCtx.isSecureWithWssc()) return;
        SCTokenHandlerBase sCTokenHandlerBase = this.seqCtx.isSecureWithWssp12Wssc13() ? new weblogic.wsee.security.wssc.v13.sct.SCTokenHandler() : new SCTokenHandler();
        SCCredential sCCredential = (SCCredential)messageContext.getProperty("weblogic.wsee.wssc.sct");
        if (LOGGER.isLoggable(Level.FINER)) {
            if (sCCredential != null) {
                LOGGER.finer("Got SCCredential from MessageContext '" + sCCredential.toString() + "'");
            } else {
                LOGGER.finer("Could not find SCCredential in MessageContext, skipping insert of SecurityTokenReference in CreateSequence message");
            }
        }
        if (sCCredential == null) {
            return;
        }
        try {
            SCTokenBase sCTokenBase = (SCTokenBase)sCTokenHandlerBase.getSecurityToken("NO-VALUE-TYPE", sCCredential, null);
            securityTokenReference = sCTokenHandlerBase.getSTR(WSSConstants.REFERENCE_QNAME, sCTokenBase.getValueType(), sCTokenBase);
        }
        catch (WSSecurityException wSSecurityException) {
            throw new WsrmException(wSSecurityException.getMessage(), wSSecurityException);
        }
        SOAPMessage sOAPMessage = ((SOAPMessageContext)messageContext).getMessage();
        try {
            sOAPBody = sOAPMessage.getSOAPBody();
        }
        catch (Exception exception) {
            throw new WsrmException("Error getting SOAPBody for <CreateSequence> Element", exception);
        }
        Iterator iterator = sOAPBody.getChildElements();
        SOAPElement sOAPElement = (SOAPElement)iterator.next();
        if (sOAPElement == null) throw new WsrmException("Expected a SOAPMessage with a SOAPBody that contains <CreateSequence>.   SOAPBody has no children !");
        QName qName = sOAPElement.getElementQName();
        if (!qName.getLocalPart().equals("CreateSequence")) throw new WsrmException("Expected SOAPBody Child to be <CreateSequence>, instead we found QName='" + qName.toString() + "'");
        try {
            securityTokenReference.marshal((Element)sOAPElement, null, new HashMap());
        }
        catch (Exception exception) {
            throw new WsrmException("Error adding SecurityTokenReference to CreateSequence Message", exception);
        }
        ((SOAPMessageContext)messageContext).setMessage(sOAPMessage);
    }
}

