/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.sequence;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.jws.jaxws.client.async.FiberBox;
import weblogic.wsee.jaxws.framework.WsUtil;
import weblogic.wsee.reliability2.sequence.MessageInfo;

public class DestinationMessageInfo
extends MessageInfo
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(DestinationMessageInfo.class.getName());
    private static final long serialVersionUID = 1L;
    private static final long NEW_MSG_NUM = Long.MIN_VALUE;
    private static final long RECEIVED_MSG_NUM = -2L;
    private static final long IN_PROCESS_MSG_NUM = -1L;
    private static final long NO_RESPONSE_MSG_NUM = 0L;
    private long _responseMsgNum;
    private String _relatesTo;
    private transient FiberBox _suspendedFiber;
    private String _suspendedFiberId;
    private boolean _suspendedFiberAddedToMap = false;
    private static ConcurrentHashMap<String, FiberBox> _suspendedFiberMap = new ConcurrentHashMap(60000);

    private void initTransients() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            this.getLock().readLock().lock();
            objectOutputStream.defaultWriteObject();
            if (this._suspendedFiber != null && !this._suspendedFiberAddedToMap) {
                Fiber fiber = this._suspendedFiber.peek();
                final Fiber.CompletionCallback completionCallback = fiber.getCompletionCallback();
                fiber.setCompletionCallback(new Fiber.CompletionCallback(){

                    public void onCompletion(@NotNull Packet packet) {
                        this.finish();
                        if (completionCallback != null) {
                            completionCallback.onCompletion(packet);
                        }
                    }

                    public void onCompletion(@NotNull Throwable throwable) {
                        this.finish();
                        if (completionCallback != null) {
                            completionCallback.onCompletion(throwable);
                        }
                    }

                    private void finish() {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Removing fiber " + DestinationMessageInfo.this._suspendedFiber.peek().toString() + " from suspendedFiberMap. Remaining count: " + _suspendedFiberMap.size());
                        }
                        _suspendedFiberMap.remove(DestinationMessageInfo.this._suspendedFiberId);
                    }
                });
                _suspendedFiberMap.put(this._suspendedFiberId, this._suspendedFiber);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Added fiber " + this._suspendedFiber.peek().toString() + " to suspendedFiberMap. Current count: " + _suspendedFiberMap.size());
                }
                this._suspendedFiberAddedToMap = true;
            }
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.initTransients();
        try {
            this.getLock().writeLock().lock();
            objectInputStream.defaultReadObject();
            if (this._suspendedFiberId != null) {
                this._suspendedFiber = _suspendedFiberMap.get(this._suspendedFiberId);
                if (this._suspendedFiber == null) {
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.info("Unable to find suspended fiber for serialized (and likely buffered) DestinationMessageInfo for msgId: " + this.getMessageId() + ". This message cannot be processed further.");
                    }
                    this._suspendedFiberId = null;
                } else if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Got fiber " + this._suspendedFiber.peek().toString() + " from suspendedFiberMap. Current count: " + _suspendedFiberMap.size());
                }
            }
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public DestinationMessageInfo(String string, String string2, long l, String string3) {
        super(string, string2, l, string3);
        this._responseMsgNum = Long.MIN_VALUE;
        this._suspendedFiber = null;
        this._suspendedFiberId = null;
        this.initTransients();
    }

    public DestinationMessageInfo(DestinationMessageInfo destinationMessageInfo) {
        super(destinationMessageInfo);
        this._responseMsgNum = destinationMessageInfo._responseMsgNum;
        this._suspendedFiber = destinationMessageInfo._suspendedFiber;
        this._suspendedFiberId = destinationMessageInfo._suspendedFiberId;
        this.initTransients();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getResponseMsgNum() {
        try {
            this.getLock().readLock().lock();
            long l = this._responseMsgNum;
            return l;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    public void setResponseMsgNum(long l) {
        if (this.internalSetResponseMsgNum(l) && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Set destination message " + this.getMessageId() + " seq: " + this.getSequenceId() + " msgNum: " + this.getMessageNum() + " with response message num " + l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRelatesTo() {
        try {
            this.getLock().readLock().lock();
            String string = this._relatesTo;
            return string;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRelatesTo(String string) {
        try {
            this.getLock().writeLock().lock();
            this._relatesTo = string;
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNew() {
        try {
            this.getLock().readLock().lock();
            boolean bl = this._responseMsgNum == Long.MIN_VALUE;
            return bl;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    public void setReceived() {
        if (this.internalSetResponseMsgNum(-2L) && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Set destination message " + this.getMessageId() + " seq: " + this.getSequenceId() + " msgNum: " + this.getMessageNum() + " RECEIVED");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReceived() {
        try {
            this.getLock().readLock().lock();
            boolean bl = this._responseMsgNum == -2L;
            return bl;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    public void setInProcess() {
        if (this.internalSetResponseMsgNum(-1L) && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Set destination message " + this.getMessageId() + " seq: " + this.getSequenceId() + " msgNum: " + this.getMessageNum() + " IN_PROCESS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalSetResponseMsgNum(long l) {
        PropertyChangeEvent propertyChangeEvent = null;
        try {
            this.getLock().writeLock().lock();
            if (l > this._responseMsgNum) {
                propertyChangeEvent = new PropertyChangeEvent(this, "responseMessageNum", this._responseMsgNum, l);
                this._responseMsgNum = l;
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Bypassing set of responseMsgNum on seq " + this.getSequenceId() + " msg num " + this.getMessageNum() + " msg id " + this.getMessageId() + " to " + l + " because this is less than the current value of " + this._responseMsgNum);
            }
        }
        finally {
            this.getLock().writeLock().unlock();
        }
        if (propertyChangeEvent != null) {
            this.fireEvent(propertyChangeEvent);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInProcess() {
        try {
            this.getLock().readLock().lock();
            boolean bl = this._responseMsgNum == -1L;
            return bl;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    public void setNoResponse() {
        if (this.internalSetResponseMsgNum(0L) && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Set destination message " + this.getMessageId() + " seq: " + this.getSequenceId() + " msgNum: " + this.getMessageNum() + " NO_RESPONSE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNoResponse() {
        try {
            this.getLock().readLock().lock();
            boolean bl = this._responseMsgNum == 0L;
            return bl;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FiberBox getSuspendedFiber() {
        try {
            this.getLock().readLock().lock();
            FiberBox fiberBox = this._suspendedFiber;
            return fiberBox;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSuspendedFiber(FiberBox fiberBox) {
        try {
            this.getLock().writeLock().lock();
            this._suspendedFiber = fiberBox;
            this._suspendedFiberAddedToMap = false;
            this._suspendedFiberId = WsUtil.generateUUID();
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }
}

