/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.sequence;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.message.RelatesToHeader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import weblogic.jws.jaxws.client.async.FiberBox;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.wsee.WseeRmLogger;
import weblogic.wsee.jaxws.client.async.AsyncTransportProvider;
import weblogic.wsee.jaxws.client.async.AsyncTransportProviderPropertyBag;
import weblogic.wsee.jaxws.framework.WsUtil;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.WsrmSecurityContext;
import weblogic.wsee.reliability.headers.AcknowledgementHeader;
import weblogic.wsee.reliability.headers.WsrmHeader;
import weblogic.wsee.reliability2.api.SequenceState;
import weblogic.wsee.reliability2.api_internal.WsrmLifecycleEvent;
import weblogic.wsee.reliability2.api_internal.WsrmLifecycleEventListenerRegistry;
import weblogic.wsee.reliability2.exception.WsrmExceptionUtil;
import weblogic.wsee.reliability2.property.WsrmPropertyBag;
import weblogic.wsee.reliability2.sequence.DestinationMessageInfo;
import weblogic.wsee.reliability2.sequence.DestinationOfferSequence;
import weblogic.wsee.reliability2.sequence.DestinationSequenceManager;
import weblogic.wsee.reliability2.sequence.MessageInfo;
import weblogic.wsee.reliability2.sequence.Sequence;
import weblogic.wsee.reliability2.sequence.SourceOfferSequence;
import weblogic.wsee.reliability2.sequence.SourceSequenceManager;
import weblogic.wsee.reliability2.tube.DispatchFactory;
import weblogic.wsee.reliability2.tube.DispatchFactoryNotReadyException;
import weblogic.wsee.reliability2.tube.DispatchFactoryResolver;
import weblogic.wsee.reliability2.tube.Sender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DestinationSequence
extends Sequence<DestinationMessageInfo>
implements DispatchFactoryResolver.LifecycleListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(DestinationSequence.class.getName());
    private transient WSEndpointReference _acksToEpr;
    private transient WSEndpointReference _hostEpr;
    private String _offerSequenceId;
    private transient SourceOfferSequence _offerSequence;
    private DispatchFactoryResolver.Key _dispatchKey;
    private Duration _ackInterval;
    private transient TimerManager _timerMgr;
    private transient Timer _ackTimer = null;
    private transient LinkedBlockingQueue<DispatchItem> _dispatchQueue;
    private transient DispatchThread _dispatchThread;

    private void initTransients() {
        if (this.isUsingDispatchQueue()) {
            this._dispatchQueue = new LinkedBlockingQueue();
            this._dispatchThread = new DispatchThread();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject("10.3.6");
        WsUtil.serializeWSEndpointReference(this._acksToEpr, objectOutputStream);
        WsUtil.serializeWSEndpointReference(this._hostEpr, objectOutputStream);
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.initTransients();
        objectInputStream.readObject();
        this._acksToEpr = WsUtil.deserializeWSEndpointReference(objectInputStream, this.getAddressingVersion());
        this._hostEpr = WsUtil.deserializeWSEndpointReference(objectInputStream, this.getAddressingVersion());
        objectInputStream.defaultReadObject();
    }

    public DestinationSequence(String string, String string2, WsrmConstants.RMVersion rMVersion, AddressingVersion addressingVersion, SOAPVersion sOAPVersion, WsrmSecurityContext wsrmSecurityContext, boolean bl) {
        super(string, string2, rMVersion, addressingVersion, sOAPVersion, wsrmSecurityContext, bl);
        this.initTransients();
        try {
            this._ackInterval = DatatypeFactory.newInstance().newDuration("P0DT0.2S");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString(), exception);
        }
    }

    @Override
    public void startup() {
        super.startup();
        if (this.isNonBuffered() && this.isUsingDispatchQueue()) {
            this._dispatchThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        SequenceState sequenceState = this.getState();
        try {
            this.getPiggybackLock().writeLock().lock();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Shutting down: " + this + " in state " + (Object)((Object)sequenceState));
            }
            if (this.isNonBuffered()) {
                if (this._ackTimer != null) {
                    this._ackTimer.cancel();
                    this._ackTimer = null;
                }
                if (this.isUsingDispatchQueue()) {
                    this._dispatchThread.quit();
                    this._dispatchThread = null;
                    this._dispatchQueue = null;
                }
            }
            super.shutdown();
        }
        finally {
            this.getPiggybackLock().writeLock().unlock();
        }
    }

    @Override
    public DestinationMessageInfo copyMessageInfo(DestinationMessageInfo destinationMessageInfo) {
        return new DestinationMessageInfo(destinationMessageInfo);
    }

    public boolean isUsingDispatchQueue() {
        return this.isNonBuffered() && this.getDeliveryAssurance().isInOrder();
    }

    public WSEndpointReference getAcksToEpr() {
        return this._acksToEpr;
    }

    public WSEndpointReference getHostEpr() {
        return this._hostEpr;
    }

    @Override
    public WSEndpointReference getPiggybackEpr() {
        return this.getAcksToEpr();
    }

    public SourceOfferSequence getOffer() {
        if (this._offerSequence != null && this._offerSequenceId == null) {
            return this._offerSequence;
        }
        this._offerSequence = null;
        if (this._offerSequenceId == null) {
            return null;
        }
        try {
            return (SourceOfferSequence)SourceSequenceManager.getInstance().getSequence(this.getRmVersion(), this._offerSequenceId, true);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString(), exception);
        }
    }

    public DispatchFactoryResolver.Key getDispatchKey() {
        return this._dispatchKey;
    }

    public void setDispatchKey(DispatchFactoryResolver.Key key) {
        this.stopListeningOnDispatchKey();
        this._dispatchKey = key;
        this.markChanged();
        if (this.isMasterInstance()) {
            this.startListeningOnDispatchKey();
        }
    }

    private void startListeningOnDispatchKey() {
        if (this._dispatchKey != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("DestinationSequence " + this + " starting listen on dispatch key: " + this._dispatchKey);
            }
            this._dispatchKey.addLifecycleListener(this);
        }
    }

    private void stopListeningOnDispatchKey() {
        if (this._dispatchKey != null) {
            this._dispatchKey.removeLifecycleListener(this);
        }
    }

    @Override
    public void onDispatchFactoryDispose(DispatchFactory dispatchFactory) {
        if (this._dispatchKey == null) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(this.getClass().getName() + " " + this.getId() + " detected its DispatchFactory key is being disposed. Delivering any pending acks before the key becomes invalid");
        }
        this.deliverPendingAcks(dispatchFactory);
        this._dispatchKey.removeLifecycleListener(this);
        this._dispatchKey = null;
    }

    @Override
    public boolean setState(SequenceState sequenceState) {
        boolean bl = super.setState(sequenceState);
        if (sequenceState == SequenceState.TERMINATED) {
            this.dispose();
        }
        return bl;
    }

    void dispose() {
        if (this._dispatchKey != null) {
            this._dispatchKey.removeLifecycleListener(this);
            this._dispatchKey = null;
        }
    }

    public void setAcksToEpr(WSEndpointReference wSEndpointReference) {
        this._acksToEpr = wSEndpointReference;
        this.markChanged();
    }

    public void setHostEpr(WSEndpointReference wSEndpointReference) {
        this._hostEpr = wSEndpointReference;
        this.setUsingSsl(HeaderList.isUsingSsl((WSEndpointReference)wSEndpointReference));
        this.markChanged();
    }

    public void setOffer(SourceOfferSequence sourceOfferSequence) {
        this._offerSequenceId = sourceOfferSequence != null ? sourceOfferSequence.getId() : null;
        this.markChanged();
    }

    public Duration getAckInterval() {
        return this._ackInterval;
    }

    public void setAckInterval(Duration duration) {
        this._ackInterval = duration;
        this.markChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long calculateFinalResponseMessageNum() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("*** Calculating final response message number for sequence " + this);
        }
        if (this.hasFinalMessageNum()) {
            long l = -1L;
            StringBuffer stringBuffer = new StringBuffer();
            try {
                this.getMessageLock().readLock().lock();
                for (DestinationMessageInfo destinationMessageInfo : this.getRequests().values()) {
                    long l2 = destinationMessageInfo.getResponseMsgNum();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        stringBuffer.append("    message id ");
                        stringBuffer.append(destinationMessageInfo.getMessageId());
                        stringBuffer.append(" msgNum ");
                        stringBuffer.append(destinationMessageInfo.getMessageNum());
                        stringBuffer.append(" responseMsgNum ");
                        stringBuffer.append(l2);
                        stringBuffer.append("\n");
                    }
                    if (l2 < 0L) {
                        l = -1L;
                        break;
                    }
                    if (l2 <= l) continue;
                    l = l2;
                }
            }
            finally {
                this.getMessageLock().readLock().unlock();
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Dump of message info for sequence: " + this + "\n" + stringBuffer.toString());
            }
            if (l >= 0L) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("*** Final response message number for sequence " + this + " is: " + l);
                }
                return l;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("*** Final response message number could not be determined for sequence " + this);
            }
            return -1L;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("*** Final request message hasn't been indicated for sequence " + this + " so final response message number could not be determined");
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence.AddResult addRequest(DestinationMessageInfo destinationMessageInfo) {
        DestinationSequenceAddResult destinationSequenceAddResult;
        block19: {
            if (!this.isNonBuffered()) {
                WsrmPropertyBag wsrmPropertyBag = WsrmPropertyBag.propertySetRetriever.getFromPacket(destinationMessageInfo.getRequestPacket());
                FiberBox fiberBox = null;
                if (wsrmPropertyBag.getResponseToSuspendedFiber()) {
                    fiberBox = new FiberBox(Fiber.current());
                    destinationMessageInfo.setSuspendedFiber(fiberBox);
                }
                DestinationSequenceAddResult destinationSequenceAddResult2 = new DestinationSequenceAddResult(super.addRequest(destinationMessageInfo));
                if (wsrmPropertyBag.getResponseToSuspendedFiber()) {
                    destinationSequenceAddResult2.needSuspendOnCurrentFiber = true;
                    destinationSequenceAddResult2.currentFiberSuspendingCallback = this.createCurrentFiberSuspendedingCallbackImpl(fiberBox);
                }
                return destinationSequenceAddResult2;
            }
            destinationSequenceAddResult = new DestinationSequenceAddResult();
            destinationSequenceAddResult.added = true;
            destinationSequenceAddResult.notAddedReason = null;
            try {
                this.getMessageLock().writeLock().lock();
                if ((this.getDeliveryAssurance().getQos() == WsrmConstants.DeliveryQOS.AtMostOnce || this.getDeliveryAssurance().getQos() == WsrmConstants.DeliveryQOS.ExactlyOnce) && this.getRequests().containsKey(destinationMessageInfo.getMessageNum())) {
                    destinationSequenceAddResult.added = false;
                    destinationSequenceAddResult.notAddedReason = Sequence.NotAddedReason.DUPLICATE;
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("*** Destination message number " + destinationMessageInfo.getMessageNum() + " not added to sequence " + this.getId() + ". Reason: " + (Object)((Object)destinationSequenceAddResult.notAddedReason));
                    }
                }
                if (destinationSequenceAddResult.added && this.getDeliveryAssurance().isInOrder() && destinationMessageInfo.getMessageNum() != this.getMaxMessageNum() + 1L) {
                    destinationSequenceAddResult.added = false;
                    destinationSequenceAddResult.notAddedReason = Sequence.NotAddedReason.OUT_OF_ORDER;
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("*** Request message msgId " + destinationMessageInfo.getMessageId() + " and msgNum " + destinationMessageInfo.getMessageNum() + " not added to sequence " + this.getId() + ". Reason: " + (Object)((Object)destinationSequenceAddResult.notAddedReason));
                    }
                }
                if (!destinationSequenceAddResult.added) break block19;
                super.addRequestInternal(destinationMessageInfo);
                if (!this.isUsingDispatchQueue()) break block19;
                try {
                    FiberBox fiberBox = new FiberBox(Fiber.current());
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(this + " adding request msgId " + destinationMessageInfo.getMessageId() + " msgNum " + destinationMessageInfo.getMessageNum() + " to DispatchQueue by storing FiberBox: " + fiberBox);
                    }
                    DispatchItem dispatchItem = new DispatchItem(fiberBox, destinationMessageInfo);
                    this._dispatchQueue.put(dispatchItem);
                    destinationSequenceAddResult.needSuspendOnCurrentFiber = true;
                    destinationSequenceAddResult.currentFiberSuspendingCallback = this.createCurrentFiberSuspendedingCallbackImpl(fiberBox);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.toString(), exception);
                }
            }
            finally {
                block20: {
                    this.getMessageLock().writeLock().unlock();
                    if (destinationSequenceAddResult.added) {
                        this.markChanged();
                    } else {
                        try {
                            DestinationSequence.preventRemovalOfAsyncRequestContext(this, destinationMessageInfo, destinationMessageInfo.getRequestPacket());
                        }
                        catch (Exception exception) {
                            if (!LOGGER.isLoggable(Level.INFO)) break block20;
                            LOGGER.log(Level.INFO, "Couldn't prevent the removal of async request context for msgId: " + destinationMessageInfo.getMessageId() + ": " + exception.toString(), exception);
                        }
                    }
                }
            }
        }
        return destinationSequenceAddResult;
    }

    private Fiber.Listener createCurrentFiberSuspendedingCallbackImpl(final FiberBox fiberBox) {
        return new Fiber.Listener(){

            public void fiberSuspended(Fiber fiber) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(this + " detected suspension of fiber in FiberBox: " + fiberBox);
                }
                fiberBox.open();
                fiber.removeListener((Fiber.Listener)this);
            }

            public void fiberResumed(Fiber fiber) {
                fiber.removeListener((Fiber.Listener)this);
            }
        };
    }

    public boolean isAnonymous() {
        return this._acksToEpr == null || this._acksToEpr.isAnonymous();
    }

    public void addPiggybackAckHeader() {
        this.flagPiggybackAck();
        this.resetAckTimer();
    }

    @Override
    @NotNull
    public void putBackUnusedPiggybackHeaders(List<WsrmHeader> list) {
        if (super.putBackUnusedPiggybackHeadersInternal(list)) {
            this.resetAckTimer();
            this.markChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean flagPiggybackAck() {
        boolean bl = false;
        try {
            this.getPiggybackLock().writeLock().lock();
            if (super.flagPiggybackAckInternal()) {
                this.resetAckTimer();
                bl = true;
            } else {
                bl = false;
            }
        }
        finally {
            this.getPiggybackLock().writeLock().unlock();
            if (bl) {
                this.markChanged();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPiggybackHeader(WsrmHeader wsrmHeader) {
        boolean bl = false;
        try {
            this.getPiggybackLock().writeLock().lock();
            bl = super.addPiggybackHeaderInternal(wsrmHeader);
            this.resetAckTimer();
        }
        finally {
            this.getPiggybackLock().writeLock().unlock();
            if (bl) {
                this.markChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPiggybackHeaders(List<WsrmHeader> list) {
        try {
            this.getPiggybackLock().writeLock().lock();
            super.addPiggybackHeaders(list);
            this.resetAckTimer();
        }
        finally {
            this.getPiggybackLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WsrmHeader> getAndClearPiggybackHeaders() {
        List<WsrmHeader> list = null;
        SequenceState sequenceState = this.getState();
        try {
            this.getPiggybackLock().writeLock().lock();
            list = this.getAndClearPiggybackHeadersLocal(sequenceState == SequenceState.CLOSED);
            if (sequenceState == SequenceState.CLOSED) {
                this.addPiggybackAckHeader();
            } else {
                this.resetAckTimer();
            }
            if (list.size() > 0) {
                if (this instanceof DestinationOfferSequence) {
                    WsrmLifecycleEventListenerRegistry.getInstance().notifyEventType(WsrmLifecycleEvent.Type.CLIENT_IN_MSG_AFTER_ACK);
                } else {
                    WsrmLifecycleEventListenerRegistry.getInstance().notifyEventType(WsrmLifecycleEvent.Type.SERV_IN_MSG_AFTER_ACK);
                }
            }
            List<WsrmHeader> list2 = list;
            return list2;
        }
        finally {
            this.getPiggybackLock().writeLock().unlock();
            if (list != null && list.size() > 0) {
                this.markChanged();
            }
        }
    }

    public void forceDeliverPendingAcks() {
        this.deliverPendingAcks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAckTimer() {
        try {
            boolean bl;
            this.getPiggybackLock().writeLock().lock();
            if (this._timerMgr == null) {
                TimerManagerFactory timerManagerFactory = TimerManagerFactory.getTimerManagerFactory();
                this._timerMgr = timerManagerFactory.getDefaultTimerManager();
            }
            boolean bl2 = bl = !this.isAnonymous() && this.hasPiggybackHeaders();
            if (this._ackTimer != null && !bl) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Cancelling ack timer (no acks) for sequence: " + this.getId());
                }
                this._ackTimer.cancel();
                this._ackTimer = null;
            }
            if (bl && this._ackTimer == null) {
                long l = this._ackInterval.getTimeInMillis(new Date());
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Scheduling ack timer (" + l + " ms timer) for sequence: " + this.getId());
                }
                this._ackTimer = this._timerMgr.schedule(new TimerListener(){

                    public void timerExpired(Timer timer) {
                        DestinationSequence.this.deliverPendingAcks();
                    }
                }, l);
            }
        }
        finally {
            this.getPiggybackLock().writeLock().unlock();
        }
    }

    private void deliverPendingAcks() {
        try {
            if (this.getDispatchKey() == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("We were asked to deliver pending acks on seq " + this + " but have no dispatch key to do so. Aborting.");
                }
                return;
            }
            DispatchFactory dispatchFactory = this.getDispatchKey().resolve();
            this.deliverPendingAcks(dispatchFactory);
        }
        catch (DispatchFactoryNotReadyException dispatchFactoryNotReadyException) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(dispatchFactoryNotReadyException.toString());
            }
        }
        catch (Exception exception) {
            WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
        }
    }

    @NotNull
    private List<WsrmHeader> getAndClearPiggybackHeadersLocal(boolean bl) {
        List<WsrmHeader> list = this.getAndClearPiggybackHeadersInternal();
        for (WsrmHeader wsrmHeader : list) {
            if (!(wsrmHeader instanceof AcknowledgementHeader)) continue;
            ((AcknowledgementHeader)wsrmHeader).setFinal(bl);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverPendingAcks(DispatchFactory dispatchFactory) {
        block11: {
            List<WsrmHeader> list = null;
            SequenceState sequenceState = this.getState();
            if (sequenceState == SequenceState.CLOSING || sequenceState == SequenceState.CLOSED || sequenceState == SequenceState.TERMINATING || sequenceState == SequenceState.TERMINATED) {
                return;
            }
            try {
                this.getPiggybackLock().writeLock().lock();
                list = this.getAndClearPiggybackHeadersLocal(sequenceState == SequenceState.CLOSED);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Explicitly delivering pending ack (" + list.size() + " total headers) for sequence: " + this.getId());
                }
                this.resetAckTimer();
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Done getting piggyback headers, and resetting ack timer, proceeding to send explicit ack");
                }
            }
            finally {
                this.getPiggybackLock().writeLock().unlock();
                if (list != null && list.size() > 0) {
                    this.markChanged();
                }
            }
            try {
                this.internalDeliverAcks(dispatchFactory, list, null);
            }
            catch (Exception exception) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Failed to deliver pending acks for " + this + ": " + exception.toString());
                }
                if (!WsrmExceptionUtil.isPermanentSendFailure(exception)) break block11;
                WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            }
        }
    }

    public void deliverAckForAckRequest(WsrmHeader wsrmHeader, String string) throws Exception {
        if (this._acksToEpr == null || this._acksToEpr.isAnonymous()) {
            this.flagPiggybackAck();
        } else {
            DispatchFactoryResolver.Key key = this.getDispatchKey();
            if (key == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Failed to deliver ack for " + this + ": dispatchKey has been disposed");
                }
                return;
            }
            DispatchFactory dispatchFactory = key.resolve();
            ArrayList<WsrmHeader> arrayList = new ArrayList<WsrmHeader>();
            arrayList.add(wsrmHeader);
            this.internalDeliverAcks(dispatchFactory, arrayList, string);
        }
    }

    private void internalDeliverAcks(DispatchFactory dispatchFactory, List<WsrmHeader> list, String string) throws Exception {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Internally sending explicit ack with " + list.size() + " headers");
        }
        if (list.isEmpty()) {
            return;
        }
        if (this._acksToEpr == null || this._acksToEpr.isAnonymous()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Aborting request to send explicit/standalone ack for sequence " + this + " because the target endpoint is anonymous");
            }
            return;
        }
        Sender sender = new Sender(dispatchFactory);
        String string2 = WsrmConstants.Action.ACK.getActionURI(this.getRmVersion());
        Message message = WsUtil.createEmptyMessage(string2, this._acksToEpr.getVersion(), this.getSoapVersion());
        this.addHeadersForAckMsg(list, string, message);
        Map<String, Object> map = DestinationSequenceManager.getInstance().getSenderInvokeProperties(this, (Packet)null);
        sender.send(message, string2, this._acksToEpr, this.getHostEpr(), map, false, true);
    }

    private void addHeadersForAckMsg(List<WsrmHeader> list, String string, Message message) {
        for (WsrmHeader wsrmHeader : list) {
            message.getHeaders().add((Header)wsrmHeader);
        }
        if (string != null && this.getAddressingVersion() != null) {
            RelatesToHeader relatesToHeader = new RelatesToHeader(this.getAddressingVersion().relatesToTag, string);
            message.getHeaders().addOrReplace((Header)relatesToHeader);
        }
    }

    @Override
    protected void handleMasterInstanceChange(boolean bl, boolean bl2) {
        if (bl && !bl2) {
            this.stopListening();
        } else if (bl2 && !bl) {
            this.startListening();
        }
    }

    private void startListening() {
        this.startListeningOnDispatchKey();
    }

    private void stopListening() {
        this.stopListeningOnDispatchKey();
    }

    public static void preventRemovalOfAsyncRequestContext(DestinationSequence destinationSequence, DestinationMessageInfo destinationMessageInfo, Packet packet) {
        AsyncTransportProviderPropertyBag asyncTransportProviderPropertyBag;
        AsyncTransportProvider.RequestContextRemovalCallback requestContextRemovalCallback;
        if (packet.getSatellite(AsyncTransportProviderPropertyBag.class) != null && (requestContextRemovalCallback = (asyncTransportProviderPropertyBag = AsyncTransportProviderPropertyBag.propertySetRetriever.getFromPacket(packet)).getRequestContextRemovalCallback()) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(destinationSequence + " is preventing the removal of async request context for request msgId " + destinationMessageInfo.getRelatesTo() + " by removing the removal callback from AsyncTransportProviderPropertyBag");
            }
            requestContextRemovalCallback.stopUsingAsyncRequestContext();
            asyncTransportProviderPropertyBag.setRequestContextRemovalCallback(null);
        }
    }

    private class DispatchThread
    extends Thread {
        private boolean _quit;
        private Object _monitor = "DispatchThreadMonitor" + this.getName();
        private boolean _fiberDone;

        private DispatchThread() {
            this.setDaemon(true);
            this._quit = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void quit() {
            DispatchThread dispatchThread = this;
            synchronized (dispatchThread) {
                this._quit = true;
            }
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("DispatchThread starting up: " + this);
            }
            DispatchThread dispatchThread = this;
            synchronized (dispatchThread) {
                bl = this._quit;
            }
            while (!bl) {
                Object object;
                DispatchThread dispatchThread2;
                Object object2;
                dispatchThread = null;
                String string = null;
                while (dispatchThread == null && !bl) {
                    try {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine(this + " taking next FiberBox from dispatch queue (this call may block)");
                        }
                        object2 = (DispatchItem)DestinationSequence.this._dispatchQueue.take();
                        dispatchThread2 = object2.fiberBox;
                        object = object2.msgInfo;
                        String string2 = ((MessageInfo)object).getMessageId();
                        string = "msgId=" + string2 + " msgNum=" + ((MessageInfo)object).getMessageNum() + " fiber=(" + dispatchThread2 + ")";
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine(this + " got next item from dispatch queue " + string + ". Getting fiber from it (this call may block)");
                        }
                        dispatchThread = dispatchThread2.get();
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine(this + " got " + string + " from dispatch queue.");
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    object2 = this;
                    synchronized (object2) {
                        bl = this._quit;
                    }
                }
                if (!bl) {
                    object2 = dispatchThread.getCompletionCallback();
                    dispatchThread2 = dispatchThread;
                    object = new Fiber.CompletionCallback((Fiber.CompletionCallback)object2, (Fiber)dispatchThread2){
                        final /* synthetic */ Fiber.CompletionCallback val$originalFiberCallback;
                        final /* synthetic */ Fiber val$useFiber;
                        {
                            this.val$originalFiberCallback = completionCallback;
                            this.val$useFiber = fiber;
                        }

                        public void onCompletion(@NotNull Packet packet) {
                            if (this.val$originalFiberCallback != null) {
                                this.val$originalFiberCallback.onCompletion(packet);
                            }
                            if (!this.val$useFiber.isStartedSync()) {
                                this.signalDone();
                            }
                        }

                        public void onCompletion(@NotNull Throwable throwable) {
                            if (this.val$originalFiberCallback != null) {
                                this.val$originalFiberCallback.onCompletion(throwable);
                            }
                            if (!this.val$useFiber.isStartedSync()) {
                                this.signalDone();
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        private void signalDone() {
                            Object object = DispatchThread.this._monitor;
                            synchronized (object) {
                                DispatchThread.this._fiberDone = true;
                                DispatchThread.this._monitor.notify();
                            }
                        }
                    };
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(this + " resuming " + string + " from dispatch queue");
                    }
                    Object object3 = this._monitor;
                    synchronized (object3) {
                        this._fiberDone = false;
                        dispatchThread.resume(dispatchThread.getPacket(), false, (Fiber.CompletionCallback)object);
                        if (dispatchThread.isStartedSync()) {
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.fine(this + " completed execution of " + string + " from dispatch queue. Getting the next one...");
                            }
                        } else {
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.fine(this + " going inactive to allow completion callback to call us when it is ready");
                            }
                            while (!this._fiberDone) {
                                try {
                                    this._monitor.wait();
                                }
                                catch (Exception exception) {}
                            }
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.fine(this + " detected the completion of " + string + " from dispatch queue. Getting the next one...");
                            }
                        }
                    }
                }
                object2 = this;
                synchronized (object2) {
                    bl = this._quit;
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(this + " quiting: " + DestinationSequence.this);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" - seqId=").append(DestinationSequence.this.getId());
            return stringBuffer.toString();
        }
    }

    public static interface CurrentFiberSuspendingCallback {
        public void currentFiberSuspending();
    }

    public static class DestinationSequenceAddResult
    extends Sequence.AddResult {
        public boolean needSuspendOnCurrentFiber;
        public Fiber.Listener currentFiberSuspendingCallback;

        DestinationSequenceAddResult() {
        }

        DestinationSequenceAddResult(Sequence.AddResult addResult) {
            super(addResult);
        }
    }

    private class DispatchItem {
        FiberBox fiberBox;
        DestinationMessageInfo msgInfo;

        private DispatchItem(FiberBox fiberBox, DestinationMessageInfo destinationMessageInfo) {
            this.fiberBox = fiberBox;
            this.msgInfo = destinationMessageInfo;
        }
    }
}

