/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.sequence;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import weblogic.store.PersistentStoreException;
import weblogic.wsee.WseeRmLogger;
import weblogic.wsee.jaxws.persistence.PersistentContext;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.faults.IllegalRMVersionFaultException;
import weblogic.wsee.reliability.faults.SequenceClosedFaultException;
import weblogic.wsee.reliability.faults.SequenceClosedFaultMsg;
import weblogic.wsee.reliability.faults.WsrmFaultMsg;
import weblogic.wsee.reliability.headers.AckRequestedHeader;
import weblogic.wsee.reliability.headers.AcknowledgementHeader;
import weblogic.wsee.reliability.headers.SequenceHeader;
import weblogic.wsee.reliability2.api.SequenceState;
import weblogic.wsee.reliability2.api_internal.WsrmLifecycleEvent;
import weblogic.wsee.reliability2.api_internal.WsrmLifecycleEventListenerRegistry;
import weblogic.wsee.reliability2.exception.WsrmException;
import weblogic.wsee.reliability2.headers.WsrmHeaderFactory;
import weblogic.wsee.reliability2.property.WsrmPropertyBag;
import weblogic.wsee.reliability2.sequence.DestinationMessageInfo;
import weblogic.wsee.reliability2.sequence.DestinationOfferSequence;
import weblogic.wsee.reliability2.sequence.DestinationSequence;
import weblogic.wsee.reliability2.sequence.Sequence;
import weblogic.wsee.reliability2.sequence.SequenceManager;
import weblogic.wsee.reliability2.sequence.SourceMessageInfo;
import weblogic.wsee.reliability2.sequence.SourceSequence;
import weblogic.wsee.reliability2.sequence.SourceSequenceManager;
import weblogic.wsee.reliability2.sequence.UnknownDestinationSequenceException;
import weblogic.wsee.reliability2.sequence.UnknownSequenceException;
import weblogic.wsee.reliability2.sequence.UnknownSourceSequenceException;
import weblogic.wsee.reliability2.store.DestinationSequenceMap;
import weblogic.wsee.reliability2.store.TimedSequenceMap;
import weblogic.wsee.reliability2.tube.processors.TerminateSequenceProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DestinationSequenceManager
extends SequenceManager<DestinationSequence>
implements TimedSequenceMap.SequenceTimerListener {
    private static final Logger LOGGER = Logger.getLogger(DestinationSequenceManager.class.getName());
    private static DestinationSequenceManager _instance;

    public static DestinationSequenceManager getInstance() {
        return _instance;
    }

    private DestinationSequenceManager() throws PersistentStoreException, NamingException, WsrmException {
        super(new DestinationSequenceMap());
        this.recoverMap();
    }

    @Override
    protected void recoverMap() throws WsrmException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("DestinationSequenceManager recovering destination sequences now");
        }
        ((TimedSequenceMap)this._seqIdToSeqMap).setSequenceTimerListener(this);
        super.recoverMap();
    }

    @Override
    public void sequenceExpiration(String string) {
        DestinationSequence destinationSequence = (DestinationSequence)this.getSequence(WsrmConstants.RMVersion.latest(), string);
        if (destinationSequence == null) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("** DestinationSequence reached its maximum lifetime. Seq id: " + string);
        }
        this.terminateSequence(string);
    }

    @Override
    public void idleTimeout(String string) {
        DestinationSequence destinationSequence = (DestinationSequence)this.getSequence(WsrmConstants.RMVersion.latest(), string);
        if (destinationSequence == null) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("** DestinationSequence timed out on idle timeout. Seq id: " + string);
        }
        this.terminateSequence(string);
    }

    public void terminateSequence(String string) {
        try {
            DestinationSequence destinationSequence = this.getSequence(WsrmConstants.RMVersion.latest(), string, true);
            if (destinationSequence == null) {
                return;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("** DestinationSequence being forcibly terminated. Seq id: " + string);
            }
            TerminateSequenceProcessor.forceTerminateSequence(destinationSequence, destinationSequence.getRmVersion(), destinationSequence.getMaxMessageNum());
        }
        catch (Exception exception) {
            WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
        }
    }

    @Override
    public void handleRmFault(WsrmFaultMsg wsrmFaultMsg) {
        try {
            wsrmFaultMsg.hashCode();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void handleAckRequest(AckRequestedHeader ackRequestedHeader, String string) throws WsrmException {
        DestinationSequence destinationSequence = this.getSequence(ackRequestedHeader.getRmVersion(), ackRequestedHeader.getSequenceId(), true);
        if (destinationSequence == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("** IGNORING ackRequested header for unknown destination sequence " + ackRequestedHeader.getSequenceId());
            }
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("** Handling Ack Request on destination sequence " + destinationSequence.getId());
        }
        AcknowledgementHeader acknowledgementHeader = WsrmHeaderFactory.getInstance().createEmptyWsrmHeader(AcknowledgementHeader.class, destinationSequence.getRmVersion());
        acknowledgementHeader.setSequenceId(destinationSequence.getId());
        acknowledgementHeader.setFinal(destinationSequence.getState() == SequenceState.CLOSED);
        long l = -1L;
        Range range = null;
        for (Long l2 : destinationSequence.getRequests().keySet()) {
            DestinationMessageInfo destinationMessageInfo = (DestinationMessageInfo)destinationSequence.getRequest(l2);
            if (!destinationMessageInfo.isAck()) continue;
            range = this.checkForNewRange(l2, l, range, acknowledgementHeader);
            l = l2;
        }
        this.checkForNewRange(Long.MAX_VALUE, l, range, acknowledgementHeader);
        try {
            destinationSequence.deliverAckForAckRequest(acknowledgementHeader, string);
        }
        catch (WsrmException wsrmException) {
            throw wsrmException;
        }
        catch (Exception exception) {
            throw new WsrmException(exception.toString(), exception);
        }
    }

    private Range checkForNewRange(Long l, long l2, Range range, AcknowledgementHeader acknowledgementHeader) {
        if (l > l2 + 1L) {
            if (range != null) {
                range.upper = l2;
                acknowledgementHeader.acknowledgeMessages(range.lower, range.upper);
            }
            range = new Range();
            range.lower = l;
        }
        return range;
    }

    public HandleSequenceMessageResult handleSequenceMessage(SequenceHeader sequenceHeader, Packet packet, AddressingVersion addressingVersion, SOAPVersion sOAPVersion, boolean bl) throws WsrmException {
        Message message = packet.getMessage();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("DestinationSequenceManager processing inbound sequence message with msg id " + message.getHeaders().getMessageID(addressingVersion, sOAPVersion) + ", seq " + sequenceHeader.getSequenceId() + " and msg num " + sequenceHeader.getMessageNumber());
        }
        String string = sequenceHeader.getSequenceId();
        DestinationSequence destinationSequence = DestinationSequenceManager.getInstance().getSequence(sequenceHeader.getRmVersion(), string, false);
        if (destinationSequence instanceof DestinationOfferSequence) {
            WsrmLifecycleEventListenerRegistry.getInstance().notifyEventType(WsrmLifecycleEvent.Type.CLIENT_IN_MSG_BEFORE_ACCEPT);
        } else {
            WsrmLifecycleEventListenerRegistry.getInstance().notifyEventType(WsrmLifecycleEvent.Type.SERV_IN_MSG_BEFORE_ACCEPT);
        }
        if (sequenceHeader.getRmVersion() != destinationSequence.getRmVersion()) {
            throw new IllegalRMVersionFaultException(string, destinationSequence.getRmVersion(), Arrays.asList(sequenceHeader.getRmVersion()));
        }
        SequenceState sequenceState = destinationSequence.getState();
        if (sequenceState == SequenceState.CLOSING || sequenceState == SequenceState.CLOSED) {
            SequenceClosedFaultMsg sequenceClosedFaultMsg = new SequenceClosedFaultMsg(destinationSequence.getRmVersion());
            sequenceClosedFaultMsg.setSequenceId(destinationSequence.getId());
            throw new SequenceClosedFaultException(sequenceClosedFaultMsg);
        }
        return this.internalHandleSequenceMessage(destinationSequence, sequenceHeader, packet, addressingVersion, sOAPVersion, bl);
    }

    private HandleSequenceMessageResult internalHandleSequenceMessage(DestinationSequence destinationSequence, SequenceHeader sequenceHeader, Packet packet, AddressingVersion addressingVersion, SOAPVersion sOAPVersion, boolean bl) throws WsrmException {
        WsrmPropertyBag wsrmPropertyBag;
        DestinationSequence.DestinationSequenceAddResult destinationSequenceAddResult;
        long l;
        DestinationMessageInfo destinationMessageInfo;
        HandleSequenceMessageResult handleSequenceMessageResult = new HandleSequenceMessageResult();
        Message message = packet.getMessage();
        String string = message.getID(addressingVersion, sOAPVersion);
        String string2 = message.getHeaders().getAction(addressingVersion, sOAPVersion);
        String string3 = message.getHeaders().getRelatesTo(destinationSequence.getAddressingVersion(), destinationSequence.getSoapVersion());
        if (!destinationSequence.isNonBuffered() && string3 == null) {
            boolean bl2;
            Header header = message.getHeaders().get(destinationSequence.getAddressingVersion().replyToTag, false);
            boolean bl3 = header == null ? bl : (bl2 = !String.valueOf(header.getStringContent()).startsWith(destinationSequence.getAddressingVersion().anonymousUri));
            if (!bl2) {
                throw new WsrmException("Request message " + string + " cannot have anonymous ReplyTo for buffered sequence " + destinationSequence.getId());
            }
        }
        if ((destinationMessageInfo = (DestinationMessageInfo)destinationSequence.getRequest(l = sequenceHeader.getMessageNumber())) != null && !destinationMessageInfo.isNew()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Directly rejecting duplicate request msgId " + string + " msgNum " + l + " because we've already accepted this message (either via SAF or directly if non-buffered). This check was put in to avoid an infrequent issue with SAF where SAF gives us a successful 'ack' before it really knows if the message is duplicate or out-of-order.");
            }
            destinationSequenceAddResult = new DestinationSequence.DestinationSequenceAddResult();
            destinationSequenceAddResult.added = false;
            destinationSequenceAddResult.notAddedReason = Sequence.NotAddedReason.DUPLICATE;
        } else {
            destinationMessageInfo = new DestinationMessageInfo(destinationSequence.getId(), string, l, string2);
            destinationMessageInfo.setRelatesTo(string3);
            if (destinationSequence.getRmVersion() == WsrmConstants.RMVersion.RM_10) {
                destinationMessageInfo.setLastMessage(sequenceHeader.isLastMessage());
                if (destinationMessageInfo.isLastMessage() && (packet.getMessage() == null || !packet.getMessage().hasPayload())) {
                    destinationMessageInfo.setEmptyLastMessage(true);
                }
            }
            destinationMessageInfo.setRequestPacket(packet);
            wsrmPropertyBag = WsrmPropertyBag.propertySetRetriever.getFromPacket(packet);
            wsrmPropertyBag.setDestMessageInfoFromRequest(destinationMessageInfo);
            destinationSequenceAddResult = (DestinationSequence.DestinationSequenceAddResult)destinationSequence.addRequest(destinationMessageInfo);
            handleSequenceMessageResult.needSuspendOnCurrentFiber = destinationSequenceAddResult.needSuspendOnCurrentFiber;
            handleSequenceMessageResult.currentFiberSuspendingCallback = destinationSequenceAddResult.currentFiberSuspendingCallback;
        }
        destinationMessageInfo.setRequestPacket(null);
        if (destinationSequenceAddResult.added) {
            if (destinationSequence.isNonBuffered()) {
                destinationMessageInfo.setInProcess();
                this.markRequestAccepted(destinationSequence, destinationMessageInfo);
            }
        } else {
            if (destinationSequenceAddResult.notAddedReason == Sequence.NotAddedReason.DUPLICATE) {
                destinationSequence.addPiggybackAckHeader();
                if (!bl && (wsrmPropertyBag = message.getHeaders().getReplyTo(addressingVersion, sOAPVersion)).isAnonymous()) {
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.info("Cannot accept message with msgId '" + string + "' and action '" + string2 + "' due to (" + (Object)((Object)destinationSequenceAddResult.notAddedReason) + ")");
                    }
                    throw new WsrmException(WseeRmLogger.logCannotAcceptDestinationSideRequestLoggable().getMessage());
                }
            } else if (destinationSequenceAddResult.notAddedReason == Sequence.NotAddedReason.OUT_OF_ORDER) {
                // empty if block
            }
            destinationMessageInfo = null;
        }
        this.updateSequence(destinationSequence);
        handleSequenceMessageResult.msgInfo = destinationMessageInfo;
        return handleSequenceMessageResult;
    }

    private void updateLinkedSourceSequenceIfNeeded(DestinationMessageInfo destinationMessageInfo, DestinationSequence destinationSequence) throws UnknownSourceSequenceException {
        SourceMessageInfo sourceMessageInfo;
        DestinationOfferSequence destinationOfferSequence;
        SourceSequence sourceSequence;
        if (destinationMessageInfo.getRelatesTo() != null && destinationSequence instanceof DestinationOfferSequence && (sourceSequence = (destinationOfferSequence = (DestinationOfferSequence)destinationSequence).getMainSequence()) != null && (sourceMessageInfo = (SourceMessageInfo)sourceSequence.getRequestByMessageId(destinationMessageInfo.getRelatesTo())) != null) {
            sourceMessageInfo.setResponseMessageNum(destinationMessageInfo.getMessageNum());
            SourceSequenceManager.getInstance().updateSequence(sourceSequence);
        }
    }

    public void markRequestAccepted(DestinationSequence destinationSequence, DestinationMessageInfo destinationMessageInfo) {
        Object object;
        String string;
        block12: {
            if (destinationMessageInfo.isAck()) {
                return;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Marking request msgId=" + destinationMessageInfo.getMessageId() + " msgNum=" + destinationMessageInfo.getMessageNum() + " 'accepted' on sequence: " + destinationSequence.getId());
            }
            destinationMessageInfo.setReceived();
            destinationMessageInfo.setAck(true);
            if (destinationSequence.getRmVersion() == WsrmConstants.RMVersion.RM_10 && destinationMessageInfo.isLastMessage()) {
                if (destinationMessageInfo.isEmptyLastMessage()) {
                    destinationMessageInfo.setNoResponse();
                }
                destinationSequence.setFinalMessageNum(destinationMessageInfo.getMessageNum());
            }
            destinationSequence.addPiggybackAckHeader();
            try {
                this.updateLinkedSourceSequenceIfNeeded(destinationMessageInfo, destinationSequence);
            }
            catch (UnknownSourceSequenceException unknownSourceSequenceException) {
                string = "Unknown";
                if (destinationSequence instanceof DestinationOfferSequence) {
                    object = (DestinationOfferSequence)destinationSequence;
                    string = ((DestinationOfferSequence)object).getMainSequenceId();
                }
                if (!LOGGER.isLoggable(Level.FINE)) break block12;
                LOGGER.fine("Failed to update source sequence " + string + " to reflect the response to msgId: " + destinationMessageInfo.getRelatesTo() + " with response msgId " + destinationMessageInfo.getMessageId() + ": " + unknownSourceSequenceException.toString());
            }
        }
        if (destinationSequence instanceof DestinationOfferSequence) {
            DestinationOfferSequence destinationOfferSequence = (DestinationOfferSequence)destinationSequence;
            string = destinationMessageInfo.getRelatesTo();
            if (string != null) {
                object = destinationSequence.getLogicalStoreName();
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(this + " removing async request context for msgId " + string + " related to response msgId " + destinationMessageInfo.getMessageId() + " and seq: " + destinationOfferSequence.getMainSequenceId());
                }
                PersistentContext.getStoreMap((String)object).remove(string);
            }
        }
        if (destinationSequence instanceof DestinationOfferSequence) {
            WsrmLifecycleEventListenerRegistry.getInstance().notifyEventType(WsrmLifecycleEvent.Type.CLIENT_IN_MSG_AFTER_ACCEPT);
        } else {
            WsrmLifecycleEventListenerRegistry.getInstance().notifyEventType(WsrmLifecycleEvent.Type.SERV_IN_MSG_AFTER_ACCEPT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNoResponseSequenceMessage(DestinationMessageInfo destinationMessageInfo) throws WsrmException {
        block14: {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("** Found NO RESPONSE destination message info for message number " + destinationMessageInfo.getMessageNum() + " message id " + destinationMessageInfo.getMessageId() + " and seq " + destinationMessageInfo.getSequenceId());
            }
            DestinationSequence destinationSequence = DestinationSequenceManager.getInstance().getSequence(WsrmConstants.RMVersion.latest(), destinationMessageInfo.getSequenceId(), true);
            boolean bl = false;
            if (destinationSequence != null) {
                try {
                    destinationMessageInfo = (DestinationMessageInfo)destinationSequence.getRequestByMessageId(destinationMessageInfo.getMessageId());
                    if (destinationMessageInfo != null) {
                        destinationMessageInfo.setNoResponse();
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("** Writing NO RESPONSE destination message info for seq " + destinationMessageInfo.getSequenceId() + " and message number " + destinationMessageInfo.getMessageNum());
                        }
                        bl = true;
                    }
                    Object var5_4 = null;
                    if (!bl) break block14;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (bl) {
                        try {
                            this.updateSequence(destinationSequence);
                        }
                        catch (UnknownDestinationSequenceException unknownDestinationSequenceException) {
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.fine("Destination sequence " + destinationMessageInfo.getSequenceId() + " was terminated before we could update NoResponse into msg info for msg: " + destinationMessageInfo.getMessageId() + " msg num " + destinationMessageInfo.getMessageNum());
                            }
                        }
                        catch (Exception exception) {
                            WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                        }
                    }
                    throw throwable;
                }
                try {
                    this.updateSequence(destinationSequence);
                }
                catch (UnknownDestinationSequenceException unknownDestinationSequenceException) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Destination sequence " + destinationMessageInfo.getSequenceId() + " was terminated before we could update NoResponse into msg info for msg: " + destinationMessageInfo.getMessageId() + " msg num " + destinationMessageInfo.getMessageNum());
                    }
                }
                catch (Exception exception) {
                    WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                }
            }
        }
    }

    @Override
    public void addSequence(DestinationSequence destinationSequence) throws WsrmException {
        super.addSequence(destinationSequence);
        destinationSequence.resetAckTimer();
    }

    @Override
    public void updateSequence(DestinationSequence destinationSequence) throws UnknownDestinationSequenceException {
        try {
            super.updateSequence(destinationSequence);
        }
        catch (UnknownSequenceException unknownSequenceException) {
            throw new UnknownDestinationSequenceException(unknownSequenceException);
        }
    }

    @Override
    public DestinationSequence getSequence(WsrmConstants.RMVersion rMVersion, String string, boolean bl) throws UnknownDestinationSequenceException {
        try {
            DestinationSequence destinationSequence = (DestinationSequence)super.getSequence(rMVersion, string, bl);
            if (destinationSequence instanceof DestinationOfferSequence) {
                ((DestinationOfferSequence)destinationSequence).takeSecurityContextFromMainSequence();
            }
            return destinationSequence;
        }
        catch (UnknownSequenceException unknownSequenceException) {
            throw new UnknownDestinationSequenceException(rMVersion, string);
        }
    }

    @Override
    public Map<String, Object> getSenderInvokeProperties(DestinationSequence destinationSequence, Packet packet) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (destinationSequence instanceof DestinationOfferSequence) {
            ((DestinationOfferSequence)destinationSequence).getMainSequenceFirstRequestContext().loadRequestContext(hashMap);
        }
        hashMap.putAll(super.getSenderInvokeProperties(destinationSequence, packet));
        return hashMap;
    }

    static {
        try {
            _instance = new DestinationSequenceManager();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString(), exception);
        }
    }

    public class HandleSequenceMessageResult {
        public DestinationMessageInfo msgInfo;
        public boolean needSuspendOnCurrentFiber;
        public Fiber.Listener currentFiberSuspendingCallback;
    }

    private class Range {
        long lower;
        long upper;

        private Range() {
        }
    }
}

