/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.sequence;

import com.sun.xml.ws.api.message.Packet;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class MessageInfo
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private transient List<PropertyChangeListener> _listeners;
    private String _seqId;
    private long _msgNum;
    private long _timestamp;
    private boolean _ack;
    private String _msgId;
    private boolean _lastMessage;
    private boolean _emptyLastMessage;
    private String _soapAction;
    private transient Packet _requestPacket;
    private transient ReentrantReadWriteLock _lock;

    private void initTransients() {
        this._lock = new ReentrantReadWriteLock(false);
        this._listeners = new ArrayList<PropertyChangeListener>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            this._lock.readLock().lock();
            objectOutputStream.writeObject("10.3.6");
            objectOutputStream.defaultWriteObject();
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.initTransients();
        try {
            this._lock.writeLock().lock();
            objectInputStream.readObject();
            objectInputStream.defaultReadObject();
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    protected MessageInfo(String string, String string2, long l, String string3) {
        this._seqId = string;
        this._msgId = string2;
        this._msgNum = l;
        this._soapAction = string3;
        this.commonConstructorCode();
    }

    protected MessageInfo(MessageInfo messageInfo) {
        this._seqId = messageInfo._seqId;
        this._msgNum = messageInfo._msgNum;
        this._timestamp = messageInfo._timestamp;
        this._ack = messageInfo._ack;
        this._msgId = messageInfo._msgId;
        this._soapAction = messageInfo._soapAction;
        this._lastMessage = messageInfo._lastMessage;
        this._requestPacket = messageInfo._requestPacket;
        this.commonConstructorCode();
    }

    private void commonConstructorCode() {
        this.initTransients();
    }

    public Object clone() throws CloneNotSupportedException {
        MessageInfo messageInfo = (MessageInfo)super.clone();
        messageInfo._listeners.clear();
        return messageInfo;
    }

    protected ReentrantReadWriteLock getLock() {
        return this._lock;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (!this._listeners.contains(propertyChangeListener)) {
            this._listeners.add(propertyChangeListener);
        }
    }

    public boolean removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        return this._listeners.remove(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSequenceId() {
        try {
            this._lock.readLock().lock();
            String string = this._seqId;
            return string;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMessageNum() {
        try {
            this._lock.readLock().lock();
            long l = this._msgNum;
            return l;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public void setTimestamp(long l) {
        if (l != this._timestamp) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "timestamp", this._timestamp, l);
            this._timestamp = l;
            this.fireEvent(propertyChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEvent(PropertyChangeEvent propertyChangeEvent) {
        PropertyChangeListener[] propertyChangeListenerArray = this._listeners;
        synchronized (this._listeners) {
            PropertyChangeListener[] propertyChangeListenerArray2 = this._listeners.toArray(new PropertyChangeListener[this._listeners.size()]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (PropertyChangeListener propertyChangeListener : propertyChangeListenerArray2) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessageId() {
        try {
            this._lock.readLock().lock();
            String string = this._msgId;
            return string;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSOAPAction() {
        try {
            this._lock.readLock().lock();
            String string = this._soapAction;
            return string;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAck() {
        try {
            this._lock.readLock().lock();
            boolean bl = this._ack;
            return bl;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAck(boolean bl) {
        PropertyChangeEvent propertyChangeEvent = null;
        try {
            this._lock.writeLock().lock();
            if (this._ack != bl) {
                propertyChangeEvent = new PropertyChangeEvent(this, "ack", this._ack, bl);
                this._ack = bl;
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
        if (propertyChangeEvent != null) {
            this.fireEvent(propertyChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmptyLastMessage() {
        try {
            this._lock.readLock().lock();
            boolean bl = this._emptyLastMessage;
            return bl;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEmptyLastMessage(boolean bl) {
        PropertyChangeEvent propertyChangeEvent = null;
        try {
            this._lock.writeLock().lock();
            if (this._emptyLastMessage != bl) {
                propertyChangeEvent = new PropertyChangeEvent(this, "emptyLastMessage", this._emptyLastMessage, bl);
                this._emptyLastMessage = bl;
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
        if (propertyChangeEvent != null) {
            this.fireEvent(propertyChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLastMessage() {
        try {
            this._lock.readLock().lock();
            boolean bl = this._lastMessage;
            return bl;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastMessage(boolean bl) {
        PropertyChangeEvent propertyChangeEvent = null;
        try {
            this._lock.writeLock().lock();
            if (this._lastMessage != bl) {
                propertyChangeEvent = new PropertyChangeEvent(this, "lastMessage", this._lastMessage, bl);
                this._lastMessage = bl;
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
        if (propertyChangeEvent != null) {
            this.fireEvent(propertyChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet getRequestPacket() {
        try {
            this._lock.readLock().lock();
            Packet packet = this._requestPacket;
            return packet;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRequestPacket(Packet packet) {
        try {
            this._lock.writeLock().lock();
            Packet packet2 = this._requestPacket = packet != null ? packet.copy(false) : null;
            if (packet != null) {
                this._requestPacket.setMessage(packet.getMessage());
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }
}

