/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.sequence;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Message;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import weblogic.wsee.persistence.Storable;
import weblogic.wsee.reliability.MessageRange;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.WsrmSecurityContext;
import weblogic.wsee.reliability.headers.AckRequestedHeader;
import weblogic.wsee.reliability.headers.AcknowledgementHeader;
import weblogic.wsee.reliability.headers.WsrmHeader;
import weblogic.wsee.reliability2.api.SequenceState;
import weblogic.wsee.reliability2.compat.Rpc2WsUtil;
import weblogic.wsee.reliability2.sequence.DeliveryAssurance;
import weblogic.wsee.reliability2.sequence.MessageInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Sequence<M extends MessageInfo>
implements Storable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(Sequence.class.getName());
    private static final boolean LOCK_FAIRNESS = false;
    private transient ReentrantReadWriteLock _objectLock;
    private transient boolean _changed;
    private long _lastActivityTime;
    private String _id;
    private String _type;
    private WsrmConstants.RMVersion _rmVersion;
    private transient String _logicalStoreName;
    private transient String _physicalStoreName;
    private transient boolean _active;
    private WsrmSecurityContext _securityCtx;
    @NotNull
    private Duration _expires;
    private long _timestamp;
    @Nullable
    private Duration _idleTimeout;
    @NotNull
    private WsrmConstants.IncompleteSequenceBehavior _incompleteSequenceBehavior;
    @NotNull
    private DeliveryAssurance _deliveryAssurance;
    private transient ReentrantReadWriteLock _messageLock;
    private transient long _maxMessageNum;
    private transient long _finalMessageNum;
    private transient long _unackdCount;
    private transient Map<Long, M> _requests;
    private transient RequestListener _requestListener;
    private transient List<M> _pendingRequests;
    private transient ReentrantReadWriteLock _stateLock;
    private transient SequenceState _state;
    private transient SequenceState _previousState;
    private transient ReentrantReadWriteLock _piggybackLock;
    private transient boolean _piggybackAck;
    private transient boolean _piggybackAckRequest;
    @NotNull
    private transient List<WsrmHeader> _piggybackHeaders;
    private transient AddressingVersion _addressingVersion;
    private transient SOAPVersion _soapVersion;
    private boolean _nonBuffered;
    private String _createSeqMsgId;
    private boolean _usingSsl;
    private transient boolean _masterInstance;
    private transient List<PropertyChangeListener> _listeners;

    public abstract M copyMessageInfo(M var1);

    private void initTransients() {
        this._objectLock = new ReentrantReadWriteLock(false);
        this._changed = false;
        this._messageLock = new ReentrantReadWriteLock(false);
        this._stateLock = new ReentrantReadWriteLock(false);
        this._requestListener = new RequestListener();
        this._pendingRequests = new ArrayList<M>(1);
        this._piggybackLock = new ReentrantReadWriteLock(false);
        this._piggybackHeaders = new ArrayList<WsrmHeader>();
        this._addressingVersion = AddressingVersion.W3C;
        this._soapVersion = SOAPVersion.SOAP_11;
        this._listeners = new ArrayList<PropertyChangeListener>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject("10.3.6");
        objectOutputStream.writeObject(this._addressingVersion.nsUri);
        objectOutputStream.writeObject(this._soapVersion.nsUri);
        try {
            this._objectLock.writeLock().lock();
            try {
                this._messageLock.readLock().lock();
                objectOutputStream.writeLong(this._lastActivityTime);
                objectOutputStream.writeLong(this._maxMessageNum);
                objectOutputStream.writeLong(this._finalMessageNum);
                objectOutputStream.writeLong(this._unackdCount);
                objectOutputStream.writeObject(this._requests);
            }
            finally {
                this._messageLock.readLock().unlock();
            }
            try {
                this._stateLock.readLock().lock();
                objectOutputStream.writeObject((Object)this._state);
                objectOutputStream.writeObject((Object)this._previousState);
            }
            finally {
                this._stateLock.readLock().unlock();
            }
            try {
                this._piggybackLock.readLock().lock();
                objectOutputStream.writeBoolean(this._piggybackAck);
                objectOutputStream.writeBoolean(this._piggybackAckRequest);
                ArrayList<Header> arrayList = new ArrayList<Header>(this._piggybackHeaders);
                Rpc2WsUtil.serializeHeaderList(arrayList, objectOutputStream);
            }
            finally {
                this._piggybackLock.readLock().unlock();
            }
            this._changed = false;
        }
        finally {
            this._objectLock.writeLock().unlock();
        }
        objectOutputStream.defaultWriteObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.initTransients();
        objectInputStream.readObject();
        String string = (String)objectInputStream.readObject();
        this._addressingVersion = AddressingVersion.fromNsUri((String)string);
        String string2 = (String)objectInputStream.readObject();
        this._soapVersion = SOAPVersion.fromNsUri((String)string2);
        this._lastActivityTime = objectInputStream.readLong();
        try {
            this._messageLock.writeLock().lock();
            this._maxMessageNum = objectInputStream.readLong();
            this._finalMessageNum = objectInputStream.readLong();
            this._unackdCount = objectInputStream.readLong();
            this._requests = (Map)objectInputStream.readObject();
            for (Object object : this._requests.values()) {
                ((MessageInfo)object).addPropertyChangeListener(this._requestListener);
            }
        }
        finally {
            this._messageLock.writeLock().unlock();
        }
        try {
            this._stateLock.writeLock().lock();
            this._state = (SequenceState)((Object)objectInputStream.readObject());
            this._previousState = (SequenceState)((Object)objectInputStream.readObject());
        }
        finally {
            this._stateLock.writeLock().unlock();
        }
        try {
            Object object;
            this._piggybackLock.writeLock().lock();
            this._piggybackAck = objectInputStream.readBoolean();
            this._piggybackAckRequest = objectInputStream.readBoolean();
            List<Header> list = Rpc2WsUtil.deserializeHeaderList(objectInputStream, this._soapVersion);
            object = list.iterator();
            while (object.hasNext()) {
                Header header = (Header)object.next();
                if (!(header instanceof WsrmHeader)) continue;
                this._piggybackHeaders.add((WsrmHeader)header);
            }
        }
        finally {
            this._piggybackLock.writeLock().unlock();
        }
        objectInputStream.defaultReadObject();
    }

    protected Sequence(String string, String string2, WsrmConstants.RMVersion rMVersion, AddressingVersion addressingVersion, SOAPVersion sOAPVersion, WsrmSecurityContext wsrmSecurityContext, boolean bl) {
        this.initTransients();
        this._logicalStoreName = string2;
        this._id = string;
        this.parseType();
        this._rmVersion = rMVersion;
        this._addressingVersion = addressingVersion;
        this._soapVersion = sOAPVersion;
        this._securityCtx = wsrmSecurityContext;
        try {
            this._expires = DatatypeFactory.newInstance().newDuration("P1D");
            this._timestamp = System.currentTimeMillis();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._incompleteSequenceBehavior = WsrmConstants.IncompleteSequenceBehavior.NoDiscard;
        this._deliveryAssurance = new DeliveryAssurance();
        this._state = SequenceState.NEW;
        this._requests = new TreeMap<Long, M>();
        this._finalMessageNum = -1L;
        this._unackdCount = 0L;
        this._nonBuffered = bl;
        this._changed = true;
        this._lastActivityTime = this._timestamp;
    }

    private void parseType() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        this._type = string.substring(n + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChanged() {
        try {
            this._objectLock.readLock().lock();
            boolean bl = this._changed;
            return bl;
        }
        finally {
            this._objectLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markChanged() {
        boolean bl = false;
        try {
            if (this._messageLock.isWriteLocked() && this._messageLock.isWriteLockedByCurrentThread() || this._stateLock.isWriteLocked() && this._stateLock.isWriteLockedByCurrentThread() || this._piggybackLock.isWriteLocked() && this._piggybackLock.isWriteLockedByCurrentThread()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Bypassing markChanged for " + this + " because one of our other sub-locks is already locked for write");
                }
                return;
            }
            this._objectLock.writeLock().lock();
            bl = true;
            this._changed = true;
            this._lastActivityTime = System.currentTimeMillis();
        }
        finally {
            if (bl) {
                this._objectLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastActivityTime() {
        try {
            this._objectLock.readLock().lock();
            long l = this._lastActivityTime;
            return l;
        }
        finally {
            this._objectLock.readLock().unlock();
        }
    }

    public String getId() {
        return this._id;
    }

    @Override
    public Serializable getObjectId() {
        return this.getId();
    }

    @Override
    public boolean isExpired() {
        return this._expires != null && this._expires.getTimeInMillis(new Date(this._timestamp)) > System.currentTimeMillis();
    }

    @Override
    public boolean hasExplicitExpiration() {
        return this._expires != null;
    }

    @Override
    public String getPhysicalStoreName() {
        return this._physicalStoreName;
    }

    @Override
    public void setPhysicalStoreName(String string) {
        this._physicalStoreName = string;
    }

    @Override
    public Long getCreationTime() {
        return this._timestamp;
    }

    @Override
    public Long getLastUpdatedTime() {
        return this._lastActivityTime;
    }

    @Override
    public void touch() {
        this.markChanged();
    }

    public void setId(String string) {
        this._id = string;
    }

    public WsrmConstants.RMVersion getRmVersion() {
        return this._rmVersion;
    }

    public String getLogicalStoreName() {
        return this._logicalStoreName;
    }

    public void setLogicalStoreName(String string) {
        this._logicalStoreName = string;
    }

    public String getCreateSequenceMsgId() {
        return this._createSeqMsgId;
    }

    public void setCreateSequenceMsgId(String string) {
        this._createSeqMsgId = string;
        this.markChanged();
    }

    public boolean isUsingSsl() {
        return this._usingSsl;
    }

    public void setUsingSsl(boolean bl) {
        this._usingSsl = bl;
    }

    protected abstract WSEndpointReference getPiggybackEpr();

    public WsrmSecurityContext getSecurityContext() {
        return this._securityCtx;
    }

    void setSecurityContext(WsrmSecurityContext wsrmSecurityContext) {
        this._securityCtx = wsrmSecurityContext;
    }

    public Duration getExpires() {
        return this._expires;
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public Duration getIdleTimeout() {
        return this._idleTimeout;
    }

    public WsrmConstants.IncompleteSequenceBehavior getIncompleteSequenceBehavior() {
        return this._incompleteSequenceBehavior;
    }

    public DeliveryAssurance getDeliveryAssurance() {
        return this._deliveryAssurance;
    }

    protected ReentrantReadWriteLock getMessageLock() {
        return this._messageLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxMessageNum() {
        try {
            this.getMessageLock().readLock().lock();
            long l = this._maxMessageNum;
            return l;
        }
        finally {
            this.getMessageLock().readLock().unlock();
        }
    }

    public boolean hasFinalMessageNum() {
        return this.getFinalMessageNum() > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFinalMessageNum() {
        try {
            this.getMessageLock().readLock().lock();
            long l = this._finalMessageNum;
            return l;
        }
        finally {
            this.getMessageLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUnackdCount() {
        try {
            this.getMessageLock().readLock().lock();
            long l = this._unackdCount;
            return l;
        }
        finally {
            this.getMessageLock().readLock().unlock();
        }
    }

    protected ReentrantReadWriteLock getStateLock() {
        return this._stateLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceState getState() {
        try {
            this.getStateLock().readLock().lock();
            SequenceState sequenceState = this._state;
            return sequenceState;
        }
        finally {
            this.getStateLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceState getPreviousState() {
        try {
            this.getStateLock().readLock().lock();
            SequenceState sequenceState = this._previousState;
            return sequenceState;
        }
        finally {
            this.getStateLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<M> getAndClearPendingRequests() {
        boolean bl = false;
        try {
            this.getMessageLock().writeLock().lock();
            ArrayList<M> arrayList = new ArrayList<M>(this._pendingRequests);
            this._pendingRequests.clear();
            if (arrayList.size() > 0) {
                bl = true;
            }
            ArrayList<M> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.getMessageLock().writeLock().unlock();
            if (bl) {
                this.markChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, M> getRequests() {
        try {
            this.getMessageLock().readLock().lock();
            TreeMap<Long, M> treeMap = new TreeMap<Long, M>(this._requests);
            return treeMap;
        }
        finally {
            this.getMessageLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public M getRequest(long l) {
        try {
            this.getMessageLock().readLock().lock();
            MessageInfo messageInfo = (MessageInfo)this._requests.get(l);
            return (M)messageInfo;
        }
        finally {
            this.getMessageLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public M getRequestByMessageId(String string) {
        try {
            this.getMessageLock().readLock().lock();
            for (MessageInfo messageInfo : this._requests.values()) {
                if (!messageInfo.getMessageId().equals(string)) continue;
                MessageInfo messageInfo2 = messageInfo;
                return (M)messageInfo2;
            }
            Iterator<M> iterator = null;
            return (M)iterator;
        }
        finally {
            this.getMessageLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddResult addRequest(M m) {
        try {
            this.getMessageLock().writeLock().lock();
            AddResult addResult = this.addRequestInternal(m);
            return addResult;
        }
        finally {
            this.getMessageLock().writeLock().unlock();
            this.markChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AddResult addRequestInternal(M m) {
        AddResult addResult = new AddResult();
        addResult.added = true;
        addResult.notAddedReason = null;
        try {
            this.getMessageLock().writeLock().lock();
            ((MessageInfo)m).setTimestamp(System.currentTimeMillis());
            MessageInfo messageInfo = (MessageInfo)this._requests.put(((MessageInfo)m).getMessageNum(), m);
            if (messageInfo != null && !messageInfo.isAck()) {
                this.setUnackedCount(this._unackdCount - 1L);
            }
            if (!((MessageInfo)m).isAck()) {
                this.setUnackedCount(this._unackdCount + 1L);
            }
            this._pendingRequests.add(this.copyMessageInfo(m));
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("*** Message number " + ((MessageInfo)m).getMessageNum() + (messageInfo != null ? " replaced within " : " added to ") + this._type + " " + this.getId());
            }
            if (((MessageInfo)m).getMessageNum() > this._maxMessageNum) {
                this._maxMessageNum = ((MessageInfo)m).getMessageNum();
            }
        }
        finally {
            this.getMessageLock().writeLock().unlock();
            ((MessageInfo)m).addPropertyChangeListener(this._requestListener);
        }
        return addResult;
    }

    protected void setUnackedCount(long l) {
        this._unackdCount = l;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Unack'd count for seq " + this + " has been set to: " + l);
        }
    }

    protected ReentrantReadWriteLock getPiggybackLock() {
        return this._piggybackLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPiggybackHeaders() {
        try {
            this._piggybackLock.readLock().lock();
            boolean bl = this._piggybackAck || this._piggybackAckRequest || !this._piggybackHeaders.isEmpty();
            return bl;
        }
        finally {
            this._piggybackLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean flagPiggybackAck() {
        boolean bl = false;
        try {
            bl = this.flagPiggybackAckInternal();
        }
        finally {
            if (bl) {
                this.markChanged();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean flagPiggybackAckInternal() {
        boolean bl = false;
        try {
            this._piggybackLock.writeLock().lock();
            if (!this._piggybackAck) {
                this._piggybackAck = true;
                bl = true;
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            this._piggybackLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean flagPiggybackAckRequest() {
        boolean bl = false;
        try {
            boolean bl2 = bl = this.flagPiggybackAckRequestInternal();
            return bl2;
        }
        finally {
            if (bl) {
                this.markChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean flagPiggybackAckRequestInternal() {
        boolean bl = false;
        try {
            this._piggybackLock.writeLock().lock();
            if (!this._piggybackAckRequest) {
                this._piggybackAckRequest = true;
                bl = true;
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            this._piggybackLock.writeLock().unlock();
        }
    }

    public void addFinalAckToMessage(Message message) {
        AcknowledgementHeader acknowledgementHeader = this.createPiggybackAckHeader();
        acknowledgementHeader.setFinal(true);
        message.getHeaders().add((Header)acknowledgementHeader);
    }

    @NotNull
    public List<WsrmHeader> getAndClearPiggybackHeaders() {
        List<WsrmHeader> list = this.getAndClearPiggybackHeadersInternal();
        if (list.size() > 0) {
            this.markChanged();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected List<WsrmHeader> getAndClearPiggybackHeadersInternal() {
        try {
            this._piggybackLock.writeLock().lock();
            ArrayList<WsrmHeader> arrayList = new ArrayList<WsrmHeader>(this._piggybackHeaders);
            this._piggybackHeaders.clear();
            if (this._piggybackAck) {
                arrayList.add(this.createPiggybackAckHeader());
                this._piggybackAck = false;
            }
            if (this._piggybackAckRequest) {
                arrayList.add(this.createPiggybackAckRequestHeader());
                this._piggybackAckRequest = false;
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this._type + " sequence " + this.getId() + " getting/clearing all piggyback headers for delivery on outgoing message. Piggybacking " + arrayList.size() + " headers");
            }
            ArrayList<WsrmHeader> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this._piggybackLock.writeLock().unlock();
        }
    }

    @NotNull
    public void putBackUnusedPiggybackHeaders(List<WsrmHeader> list) {
        if (this.putBackUnusedPiggybackHeadersInternal(list)) {
            this.markChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected boolean putBackUnusedPiggybackHeadersInternal(List<WsrmHeader> list) {
        boolean bl = false;
        try {
            this._piggybackLock.writeLock().lock();
            for (WsrmHeader wsrmHeader : list) {
                if (wsrmHeader instanceof AcknowledgementHeader) {
                    bl |= this.flagPiggybackAckInternal();
                    continue;
                }
                if (!(wsrmHeader instanceof AckRequestedHeader)) continue;
                bl |= this.flagPiggybackAckRequestInternal();
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this._type + " sequence " + this.getId() + " accepted back " + list.size() + " unused piggyback headers");
            }
        }
        finally {
            this._piggybackLock.writeLock().unlock();
        }
        return bl;
    }

    protected AcknowledgementHeader createPiggybackAckHeader() {
        AcknowledgementHeader acknowledgementHeader = new AcknowledgementHeader(this.getRmVersion());
        acknowledgementHeader.setSequenceId(this.getId());
        SortedSet<MessageRange> sortedSet = this.getAckRanges();
        acknowledgementHeader.setAcknowledgementRanges(sortedSet);
        return acknowledgementHeader;
    }

    protected AckRequestedHeader createPiggybackAckRequestHeader() {
        AckRequestedHeader ackRequestedHeader = new AckRequestedHeader(this.getRmVersion());
        ackRequestedHeader.setSequenceId(this.getId());
        return ackRequestedHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPiggybackHeader(WsrmHeader wsrmHeader) {
        boolean bl = false;
        try {
            this._piggybackLock.writeLock().lock();
            bl = this.addPiggybackHeaderInternal(wsrmHeader);
        }
        finally {
            this._piggybackLock.writeLock().unlock();
            if (bl) {
                this.markChanged();
            }
        }
    }

    protected boolean addPiggybackHeaderInternal(WsrmHeader wsrmHeader) {
        boolean bl = false;
        if (WsrmHeader.getQName(AcknowledgementHeader.class, this.getRmVersion()).equals(wsrmHeader.getName())) {
            if (!this._piggybackAck) {
                this._piggybackAck = true;
                bl = true;
            }
            return bl;
        }
        if (WsrmHeader.getQName(AckRequestedHeader.class, this.getRmVersion()).equals(wsrmHeader.getName())) {
            if (!this._piggybackAckRequest) {
                this._piggybackAckRequest = true;
                bl = true;
            }
            return bl;
        }
        ArrayList<WsrmHeader> arrayList = new ArrayList<WsrmHeader>();
        for (WsrmHeader wsrmHeader2 : this._piggybackHeaders) {
            if (!wsrmHeader2.getName().equals(wsrmHeader.getName())) continue;
            arrayList.add(wsrmHeader2);
        }
        for (WsrmHeader wsrmHeader2 : arrayList) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this._type + " sequence " + this.getId() + " removing old piggyback header of type " + wsrmHeader2.getName());
            }
            this._piggybackHeaders.remove(wsrmHeader2);
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(this._type + " sequence " + this.getId() + " adding new piggyback header of type " + wsrmHeader.getName() + ". Total piggyback count: " + (this._piggybackHeaders.size() + 1));
        }
        this._piggybackHeaders.add(wsrmHeader);
        bl = true;
        return bl;
    }

    public void addPiggybackHeaders(List<WsrmHeader> list) {
        for (WsrmHeader wsrmHeader : list) {
            this.addPiggybackHeader(wsrmHeader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFinalMessageNum(long l) {
        boolean bl = false;
        try {
            this.getMessageLock().writeLock().lock();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("*** Final message num for " + this._type + " " + this.getId() + " set to " + l);
            }
            this._finalMessageNum = l;
            bl = true;
        }
        finally {
            this.getMessageLock().writeLock().unlock();
            if (bl) {
                this.markChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setState(SequenceState sequenceState) {
        boolean bl = false;
        try {
            if (this._state.isValidTransition(sequenceState)) {
                bl = this.setStateInternal(sequenceState);
                boolean bl2 = true;
                return bl2;
            }
            boolean bl3 = false;
            return bl3;
        }
        finally {
            if (bl) {
                this.markChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setStateInternal(SequenceState sequenceState) {
        SequenceState sequenceState2;
        SequenceState sequenceState3;
        boolean bl = false;
        try {
            this.getStateLock().writeLock().lock();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("*** " + this._type + " " + this.getId() + " moving to state " + (Object)((Object)sequenceState));
            }
            this._previousState = this._state;
            this._state = sequenceState;
            bl = true;
            sequenceState3 = this._state;
            sequenceState2 = this._previousState;
        }
        finally {
            this.getStateLock().writeLock().unlock();
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "State", (Object)sequenceState2, (Object)sequenceState3);
        this.firePropertyChangeEvent(propertyChangeEvent);
        return bl;
    }

    public void setExpires(Duration duration) {
        if (this._expires == null) {
            throw new IllegalArgumentException("Null Expires not allowed");
        }
        this._expires = duration;
        this.markChanged();
    }

    public void setIdleTimeout(Duration duration) {
        this._idleTimeout = duration;
        this.markChanged();
    }

    public void setIncompleteSequenceBehavior(@NotNull WsrmConstants.IncompleteSequenceBehavior incompleteSequenceBehavior) {
        if (incompleteSequenceBehavior == null) {
            throw new IllegalArgumentException("Null IncompleteSequenceBehavior not allowed");
        }
        this._incompleteSequenceBehavior = incompleteSequenceBehavior;
        this.markChanged();
    }

    public void setDeliveryAssurance(@NotNull DeliveryAssurance deliveryAssurance) {
        if (deliveryAssurance == null) {
            throw new IllegalArgumentException("Null DeliveryAssurance not allowed");
        }
        this._deliveryAssurance = deliveryAssurance;
        this.markChanged();
    }

    public AddressingVersion getAddressingVersion() {
        return this._addressingVersion;
    }

    public void setAddressingVersion(AddressingVersion addressingVersion) {
        this._addressingVersion = addressingVersion;
        this.markChanged();
    }

    public SOAPVersion getSoapVersion() {
        return this._soapVersion;
    }

    public void setSoapVersion(SOAPVersion sOAPVersion) {
        this._soapVersion = sOAPVersion;
        this.markChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<MessageRange> getAckRanges() {
        TreeSet<MessageRange> treeSet = new TreeSet<MessageRange>();
        try {
            this.getMessageLock().readLock().lock();
            long l = -1L;
            long l2 = -1L;
            Object object = this._requests.keySet().iterator();
            while (object.hasNext()) {
                long l3 = object.next();
                MessageInfo messageInfo = (MessageInfo)this._requests.get(l3);
                if (!messageInfo.isAck()) continue;
                if (l == -1L) {
                    l2 = l = l3;
                    continue;
                }
                if (l3 > l2 + 1L) {
                    MessageRange messageRange = new MessageRange(l, l2);
                    treeSet.add(messageRange);
                    l2 = l = l3;
                    continue;
                }
                l2 = l3;
            }
            if (l != -1L) {
                object = new MessageRange(l, l2);
                treeSet.add((MessageRange)object);
            }
        }
        finally {
            this.getMessageLock().readLock().unlock();
        }
        return treeSet;
    }

    public boolean isNonBuffered() {
        return this._nonBuffered;
    }

    public boolean isMasterInstance() {
        return this._masterInstance;
    }

    public void setMasterInstance(boolean bl) {
        boolean bl2 = this._masterInstance;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(this._type + " " + this + " was just made the " + this.getMasterString(bl) + " instance (used to be " + this.getMasterString(bl2) + ") for sequence ID: " + this.getId());
        }
        this._masterInstance = bl;
        this.handleMasterInstanceChange(bl2, bl);
    }

    private String getMasterString(boolean bl) {
        return bl ? "master" : "slave";
    }

    protected abstract void handleMasterInstanceChange(boolean var1, boolean var2);

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (!this._masterInstance) {
            throw new IllegalStateException("Attempt to add listener to " + this + " when it is not the master instance");
        }
        if (!this._listeners.contains(propertyChangeListener)) {
            this._listeners.add(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (!this._masterInstance) {
            throw new IllegalStateException("Attempt to remove listener from " + this + " when it is not the master instance");
        }
        this._listeners.remove(propertyChangeListener);
    }

    public void copyPropertyChangeListeners(Sequence sequence) {
        if (!this._masterInstance) {
            throw new IllegalStateException("Attempt to add listener to " + this + " when it is not the master instance");
        }
        this._listeners.clear();
        this._listeners.addAll(sequence._listeners);
    }

    private void firePropertyChangeEvent(PropertyChangeEvent propertyChangeEvent) {
        PropertyChangeListener[] propertyChangeListenerArray;
        if (this.objectsEqual(propertyChangeEvent.getNewValue(), propertyChangeEvent.getOldValue())) {
            return;
        }
        for (PropertyChangeListener propertyChangeListener : propertyChangeListenerArray = this._listeners.toArray(new PropertyChangeListener[this._listeners.size()])) {
            try {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
            catch (Exception exception) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, exception.toString(), exception);
            }
        }
    }

    private boolean objectsEqual(Object object, Object object2) {
        return object == null && object2 == null || object2.equals(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup() {
        PropertyChangeEvent propertyChangeEvent = null;
        try {
            this._stateLock.writeLock().lock();
            boolean bl = this._active;
            if (!bl) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Starting up " + this._type + " seq " + this._id);
                }
                this._active = true;
                propertyChangeEvent = new PropertyChangeEvent(this, "Active", bl, true);
            }
        }
        finally {
            this._stateLock.writeLock().unlock();
        }
        if (propertyChangeEvent != null) {
            this.firePropertyChangeEvent(propertyChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Shutting down " + this._type + " seq " + this._id);
        }
        PropertyChangeEvent propertyChangeEvent = null;
        try {
            this._stateLock.writeLock().lock();
            boolean bl = this._active;
            if (bl) {
                this._active = false;
                propertyChangeEvent = new PropertyChangeEvent(this, "Active", bl, false);
            }
        }
        finally {
            this._stateLock.writeLock().unlock();
        }
        if (propertyChangeEvent != null) {
            this.firePropertyChangeEvent(propertyChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Destroying " + this._type + " seq " + this._id);
            }
            this._stateLock.writeLock().lock();
            if (this._active) {
                this.shutdown();
            }
        }
        finally {
            this._stateLock.writeLock().unlock();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(" - ");
        String string = this.getId() != null ? this.getId() : "<Unset pending first save>";
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private class RequestListener
    implements Serializable,
    PropertyChangeListener {
        private static final long serialVersionUID = 1L;

        private RequestListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Sequence.this.markChanged();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("*** " + Sequence.this._type + " " + Sequence.this.getId() + " detected change to MessageInfo " + ((MessageInfo)propertyChangeEvent.getSource()).getMessageNum() + "/" + propertyChangeEvent.getPropertyName() + " and is now marked 'changed'");
            }
            if (propertyChangeEvent.getPropertyName().equals("ack")) {
                try {
                    Sequence.this._messageLock.writeLock().lock();
                    if (!((Boolean)propertyChangeEvent.getOldValue()).booleanValue() && ((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                        Sequence.this.setUnackedCount(Sequence.this._unackdCount - 1L);
                    } else if (((Boolean)propertyChangeEvent.getOldValue()).booleanValue() && !((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                        Sequence.this.setUnackedCount(Sequence.this._unackdCount + 1L);
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("UnAck'd Request Count in " + Sequence.this._type + " " + Sequence.this.getId() + " is currently: " + Sequence.this._unackdCount);
                    }
                }
                finally {
                    Sequence.this._messageLock.writeLock().unlock();
                }
            }
        }
    }

    public static class AddResult {
        public boolean added;
        public NotAddedReason notAddedReason;

        public AddResult() {
        }

        public AddResult(AddResult addResult) {
            this.added = addResult.added;
            this.notAddedReason = addResult.notAddedReason;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NotAddedReason {
        DUPLICATE,
        OUT_OF_ORDER;

    }
}

