/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.sequence;

import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Packet;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.wsee.WseeRmLogger;
import weblogic.wsee.persistence.StoreException;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.WsrmSecurityContext;
import weblogic.wsee.reliability.faults.WsrmFaultMsg;
import weblogic.wsee.reliability2.exception.WsrmException;
import weblogic.wsee.reliability2.property.WsrmInvocationPropertyBag;
import weblogic.wsee.reliability2.sequence.DuplicateSequenceException;
import weblogic.wsee.reliability2.sequence.Sequence;
import weblogic.wsee.reliability2.sequence.SourceSequence;
import weblogic.wsee.reliability2.sequence.UnknownSequenceException;
import weblogic.wsee.reliability2.store.SequenceMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SequenceManager<T extends Sequence> {
    private static final Logger LOGGER = Logger.getLogger(SequenceManager.class.getName());
    public static final boolean STRESS_SAFE_DISABLE = false;
    protected SequenceMap<T> _seqIdToSeqMap;
    private Map<String, T> _createSeqMsgIdToSeqMap;
    private ReentrantReadWriteLock _mapLock = new ReentrantReadWriteLock(false);
    private String _type;

    protected SequenceManager(SequenceMap<T> sequenceMap) throws WsrmException {
        this._seqIdToSeqMap = sequenceMap;
        this.parseType();
        this._createSeqMsgIdToSeqMap = new HashMap<String, T>();
    }

    protected void recoverMap() throws WsrmException {
        try {
            this._seqIdToSeqMap.setSequenceListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("Active") && propertyChangeEvent.getSource() instanceof SourceSequence) {
                        SequenceManager.this.handleSequenceActiveChange((Sequence)propertyChangeEvent.getSource(), (Boolean)propertyChangeEvent.getOldValue(), (Boolean)propertyChangeEvent.getNewValue());
                    }
                }
            });
            this._seqIdToSeqMap.recover();
        }
        catch (StoreException storeException) {
            throw new WsrmException(storeException.toString(), storeException);
        }
    }

    private void parseType() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        this._type = string.substring(n + 1);
    }

    public abstract void handleRmFault(WsrmFaultMsg var1);

    public void addSequence(T t) throws WsrmException {
        if (((Sequence)t).getId() != null && this._seqIdToSeqMap.containsKey(((Sequence)t).getId())) {
            throw new DuplicateSequenceException(WseeRmLogger.logAddingNullOrDuplicateSequenceLoggable((String)((Sequence)t).getId()).getMessage());
        }
        this.updateSequenceInternal(t);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("** Added  " + this._type + " sequence " + ((Sequence)t).getId() + ". Current sequence count: " + this._seqIdToSeqMap.size());
            this.dumpSequences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSequence(T t) throws UnknownSequenceException {
        if (t == null || !this._seqIdToSeqMap.containsKey(((Sequence)t).getId())) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("** Sequence has been unavaliable or closed by another thread. seqId: " + (t != null ? ((Sequence)t).getId() : "unknown"));
            }
            return;
        }
        if (((Sequence)t).isChanged()) {
            this.updateSequenceInternal(t);
            if (((Sequence)t).getCreateSequenceMsgId() != null) {
                try {
                    this._mapLock.writeLock().lock();
                    this._createSeqMsgIdToSeqMap.put(((Sequence)t).getCreateSequenceMsgId(), t);
                }
                finally {
                    this._mapLock.writeLock().unlock();
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("** Updated  " + this._type + " sequence " + ((Sequence)t).getId() + ".");
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("** " + this._type + " sequence " + ((Sequence)t).getId() + " was not changed. Skipping update.");
        }
    }

    private void updateSequenceInternal(T t) {
        this._seqIdToSeqMap.put(((Sequence)t).getId(), t);
    }

    public T getSequence(WsrmConstants.RMVersion rMVersion, String string) {
        try {
            return this.getSequence(rMVersion, string, true);
        }
        catch (UnknownSequenceException unknownSequenceException) {
            unknownSequenceException.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getSequence(WsrmConstants.RMVersion rMVersion, String string, boolean bl) throws UnknownSequenceException {
        if (string == null || string.length() < 1) {
            throw new UnknownSequenceException(WseeRmLogger.logNullSequenceIDLoggable().getMessage(), rMVersion, true, string);
        }
        Object object = this._seqIdToSeqMap.get(string);
        if (object == null) {
            try {
                this._mapLock.readLock().lock();
                object = (Sequence)this._createSeqMsgIdToSeqMap.get(string);
            }
            finally {
                this._mapLock.readLock().unlock();
            }
        }
        if (object == null && !bl) {
            throw new UnknownSequenceException(rMVersion, true, string);
        }
        return (T)object;
    }

    public Iterator<T> listSequences() {
        return this._seqIdToSeqMap.values().iterator();
    }

    public List<T> getSequencesForPiggybackEndpoint(String string) {
        ArrayList<Sequence> arrayList = new ArrayList<Sequence>();
        Iterator<T> iterator = this.listSequences();
        while (iterator.hasNext()) {
            Sequence sequence = (Sequence)iterator.next();
            WSEndpointReference wSEndpointReference = sequence.getPiggybackEpr();
            if (wSEndpointReference == null || wSEndpointReference.isAnonymous() || !wSEndpointReference.getAddress().equals(string)) continue;
            arrayList.add(sequence);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSequence(T t) {
        this._seqIdToSeqMap.remove(((Sequence)t).getId());
        if (((Sequence)t).getCreateSequenceMsgId() != null) {
            try {
                this._mapLock.writeLock().lock();
                this._createSeqMsgIdToSeqMap.remove(((Sequence)t).getCreateSequenceMsgId());
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("** Removed  " + this._type + " sequence " + ((Sequence)t).getId() + "'s CreateSequence Msg ID mapping. Remaining sequence count: " + this._createSeqMsgIdToSeqMap.size());
                }
            }
            finally {
                this._mapLock.writeLock().unlock();
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("** Removed  " + this._type + " sequence " + ((Sequence)t).getId() + ". Remaining sequence count: " + this._seqIdToSeqMap.size());
            this.dumpSequences();
        }
    }

    private void dumpSequences() {
        if (LOGGER.isLoggable(Level.FINER)) {
            Set<String> set = this._seqIdToSeqMap.keySet();
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : set) {
                T t = this.getSequence(WsrmConstants.RMVersion.RM_11, string);
                if (t == null) continue;
                stringBuffer.append("   ").append(this._type).append(": ").append(string).append(" - ").append((Object)((Sequence)t).getState()).append("\n");
            }
            LOGGER.finer("Current " + this._type + " Sequences:\n" + stringBuffer.toString());
        }
    }

    public Map<String, Object> getSenderInvokeProperties(T t, Packet packet) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (packet == null) {
            packet = new Packet();
        }
        WsrmInvocationPropertyBag wsrmInvocationPropertyBag = new WsrmInvocationPropertyBag(packet);
        hashMap.put(WsrmInvocationPropertyBag.key, wsrmInvocationPropertyBag);
        wsrmInvocationPropertyBag.setSequenceId(((Sequence)t).getId());
        wsrmInvocationPropertyBag.setWsrmVersion(((Sequence)t).getRmVersion());
        wsrmInvocationPropertyBag.setMostRecentMsgNum(((Sequence)t).getMaxMessageNum());
        if (packet.invocationProperties.containsKey(WsrmInvocationPropertyBag.key)) {
            WsrmInvocationPropertyBag wsrmInvocationPropertyBag2 = (WsrmInvocationPropertyBag)packet.invocationProperties.get(WsrmInvocationPropertyBag.key);
            wsrmInvocationPropertyBag.setFinalMsgFlag(wsrmInvocationPropertyBag2.getFinalMsgFlag());
        }
        wsrmInvocationPropertyBag.setForceWsrm10Client(((Sequence)t).getRmVersion() == WsrmConstants.RMVersion.RM_10);
        wsrmInvocationPropertyBag.setLogicalStoreName(((Sequence)t).getLogicalStoreName());
        hashMap.putAll(this.getPacketInvokeProperties(t));
        return hashMap;
    }

    protected Map<String, Object> getPacketInvokeProperties(T t) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        WsrmSecurityContext wsrmSecurityContext = ((Sequence)t).getSecurityContext();
        if (wsrmSecurityContext != null) {
            Map map;
            try {
                map = wsrmSecurityContext.newInitializedMap();
            }
            catch (PolicyException policyException) {
                throw new RuntimeException(policyException);
            }
            hashMap.putAll(map);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Extracted invocationProperties from WsrmSecurityProperties: " + t);
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("No WsrmSecurityProperty from Sequence: " + t);
            }
        }
        return hashMap;
    }

    public void setInvokePropertiesOntoPacket(T t, Packet packet) {
        Map<String, Object> map = this.getPacketInvokeProperties(t);
        packet.invocationProperties.putAll(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSequenceActiveChange(T t, boolean bl, boolean bl2) {
        if (bl && !bl2) {
            if (((Sequence)t).getCreateSequenceMsgId() != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Seq Deactivation. Removing mapping of create seq msg ID " + ((Sequence)t).getCreateSequenceMsgId() + " to seq " + ((Sequence)t).getId());
                }
                try {
                    this._mapLock.writeLock().lock();
                    this._createSeqMsgIdToSeqMap.remove(((Sequence)t).getCreateSequenceMsgId());
                }
                finally {
                    this._mapLock.writeLock().unlock();
                }
            }
        } else if (!bl && bl2 && ((Sequence)t).getCreateSequenceMsgId() != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Seq Activation. Adding mapping for create seq msg ID " + ((Sequence)t).getCreateSequenceMsgId() + " to seq " + ((Sequence)t).getId());
            }
            try {
                this._mapLock.writeLock().lock();
                this._createSeqMsgIdToSeqMap.put(((Sequence)t).getCreateSequenceMsgId(), t);
            }
            finally {
                this._mapLock.writeLock().unlock();
            }
        }
    }
}

