/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.sequence;

import com.sun.xml.ws.api.pipe.Fiber;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.wsee.reliability2.sequence.MessageInfo;

public class SourceMessageInfo
extends MessageInfo
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(SourceMessageInfo.class.getName());
    private static final long serialVersionUID = 1L;
    long _responseMsgNum;
    private ClientInvokeInfo _clientInvokeInfo;

    public SourceMessageInfo(String string, String string2, long l, String string3) {
        super(string, string2, l, string3);
    }

    public SourceMessageInfo(SourceMessageInfo sourceMessageInfo) {
        super(sourceMessageInfo);
        this._responseMsgNum = sourceMessageInfo._responseMsgNum;
        this._clientInvokeInfo = sourceMessageInfo._clientInvokeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getResponseMessageNum() {
        try {
            this.getLock().readLock().lock();
            long l = this._responseMsgNum;
            return l;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponseMessageNum(long l) {
        PropertyChangeEvent propertyChangeEvent = null;
        try {
            this.getLock().writeLock().lock();
            if (this._responseMsgNum != l) {
                propertyChangeEvent = new PropertyChangeEvent(this, "responseMessageNum", this._responseMsgNum, l);
                this._responseMsgNum = l;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Set source message " + this.getMessageId() + " seq: " + this.getSequenceId() + " msgNum: " + this.getMessageNum() + " with response message num " + l);
                }
            }
        }
        finally {
            this.getLock().writeLock().unlock();
        }
        if (propertyChangeEvent != null) {
            this.fireEvent(propertyChangeEvent);
        }
    }

    public ClientInvokeInfo getClientInvokeInfo() {
        return this._clientInvokeInfo;
    }

    public void setClientInvokeInfo(ClientInvokeInfo clientInvokeInfo) {
        this._clientInvokeInfo = clientInvokeInfo;
    }

    public static class ClientInvokeInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient Fiber _suspendedRequestFiber;
        private boolean _syncMEP;
        private boolean _oneWay;
        private boolean _usingAsyncClientHandlerFeature;

        public ClientInvokeInfo(Fiber fiber, boolean bl, boolean bl2, boolean bl3) {
            this._suspendedRequestFiber = fiber;
            this._syncMEP = bl;
            this._oneWay = bl2;
            this._usingAsyncClientHandlerFeature = bl3;
        }

        public boolean impliesSuspendedRequestFiber() {
            return this._syncMEP || !this._usingAsyncClientHandlerFeature;
        }

        public Fiber getSuspendedRequestFiber() {
            return this._suspendedRequestFiber;
        }

        public Fiber getAndClearSuspendedRequestFiber() {
            Fiber fiber = this.getSuspendedRequestFiber();
            this._suspendedRequestFiber = null;
            return fiber;
        }

        public boolean isSyncMEP() {
            return this._syncMEP;
        }

        public boolean isOneWay() {
            return this._oneWay;
        }

        public boolean isUsingAsyncClientHandlerFeature() {
            return this._usingAsyncClientHandlerFeature;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" Fiber=").append(this.getSuspendedRequestFiber());
            stringBuffer.append(" SyncMEP=").append(this._syncMEP);
            stringBuffer.append(" OneWay=").append(this._oneWay);
            stringBuffer.append(" AsyncClientHandler=").append(this._usingAsyncClientHandlerFeature);
            return stringBuffer.toString();
        }
    }
}

