/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.sequence;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;
import weblogic.wsee.WseeRmLogger;
import weblogic.wsee.jaxws.framework.RetryDelayCalculator;
import weblogic.wsee.jaxws.framework.WsUtil;
import weblogic.wsee.jaxws.persistence.PersistentRequestContext;
import weblogic.wsee.jaxws.spi.ClientInstanceIdentity;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.WsrmSecurityContext;
import weblogic.wsee.reliability.headers.AckRequestedHeader;
import weblogic.wsee.reliability.headers.SequenceHeader;
import weblogic.wsee.reliability2.api.SequenceState;
import weblogic.wsee.reliability2.exception.WsrmExceptionUtil;
import weblogic.wsee.reliability2.sequence.DestinationOfferSequence;
import weblogic.wsee.reliability2.sequence.DestinationSequenceManager;
import weblogic.wsee.reliability2.sequence.Sequence;
import weblogic.wsee.reliability2.sequence.SourceMessageInfo;
import weblogic.wsee.reliability2.sequence.SourceSequenceManager;
import weblogic.wsee.reliability2.store.SenderDispatchFactory;
import weblogic.wsee.reliability2.tube.DispatchFactory;
import weblogic.wsee.reliability2.tube.DispatchFactoryNotReadyException;
import weblogic.wsee.reliability2.tube.DispatchFactoryResolver;
import weblogic.wsee.reliability2.tube.Sender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceSequence
extends Sequence<SourceMessageInfo>
implements Serializable,
DispatchFactoryResolver.LifecycleListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(SourceSequence.class.getName());
    private String _destinationId;
    private transient WSEndpointReference _endpointEpr;
    private transient WSEndpointReference _acksToEpr;
    private String _offerSequenceId;
    private DestinationOfferSequence _offerSequence;
    private long _lastAllocatedMessageNum;
    private boolean _complete;
    private SenderDispatchFactory.Key _senderDispatchKey;
    private ClientInstanceIdentity _creatingClientInstanceId;
    private Duration _baseRetransmissionInterval;
    private boolean _exponentialBackoffEnabled;
    private PersistentRequestContext _firstRequestContext;
    private transient TimerManager _timerMgr;
    private transient Timer _ackTimer = null;
    private transient RetryDelayCalculator _ackRequestDelayCalculator;

    private void initTransients() {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject("10.3.6");
        WsUtil.serializeWSEndpointReference(this._endpointEpr, objectOutputStream);
        WsUtil.serializeWSEndpointReference(this._acksToEpr, objectOutputStream);
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.initTransients();
        objectInputStream.readObject();
        this._endpointEpr = WsUtil.deserializeWSEndpointReference(objectInputStream, this.getAddressingVersion());
        this._acksToEpr = WsUtil.deserializeWSEndpointReference(objectInputStream, this.getAddressingVersion());
        objectInputStream.defaultReadObject();
        this.initAckRequestDelayCalculator();
    }

    public SourceSequence(String string, String string2, WsrmConstants.RMVersion rMVersion, AddressingVersion addressingVersion, SOAPVersion sOAPVersion, WsrmSecurityContext wsrmSecurityContext, boolean bl, PersistentRequestContext persistentRequestContext) {
        super(string, string2, rMVersion, addressingVersion, sOAPVersion, wsrmSecurityContext, bl);
        this.initTransients();
        this._firstRequestContext = persistentRequestContext;
        try {
            Duration duration = DatatypeFactory.newInstance().newDuration("PT3S");
            this.setBaseRetransmissionInterval(duration);
        }
        catch (Exception exception) {
            WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
        }
        this._destinationId = null;
        this._endpointEpr = null;
        this._acksToEpr = null;
        this._offerSequenceId = null;
        this._complete = false;
    }

    @Override
    public SourceMessageInfo copyMessageInfo(SourceMessageInfo sourceMessageInfo) {
        return new SourceMessageInfo(sourceMessageInfo);
    }

    public boolean markMessageAckd(SourceMessageInfo sourceMessageInfo, boolean bl) {
        boolean bl2 = false;
        if (sourceMessageInfo.isAck() != bl) {
            sourceMessageInfo.setAck(bl);
            this.markChanged();
            bl2 = true;
        }
        this._ackRequestDelayCalculator.reset();
        return bl2;
    }

    public String getSourceId() {
        return this.getId();
    }

    public String getDestinationId() {
        return this._destinationId;
    }

    public WSEndpointReference getEndpointEpr() {
        return this._endpointEpr;
    }

    public WSEndpointReference getAcksToEpr() {
        return this._acksToEpr;
    }

    @Override
    public WSEndpointReference getPiggybackEpr() {
        return this.getEndpointEpr();
    }

    public DestinationOfferSequence getOffer() {
        if (this._offerSequence != null && this._offerSequenceId == null) {
            return this._offerSequence;
        }
        this._offerSequence = null;
        if (this._offerSequenceId == null) {
            return null;
        }
        try {
            return (DestinationOfferSequence)DestinationSequenceManager.getInstance().getSequence(this.getRmVersion(), this._offerSequenceId, true);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextMessageNum(SequenceHeader sequenceHeader) {
        boolean bl = false;
        try {
            this.getMessageLock().writeLock().lock();
            ++this._lastAllocatedMessageNum;
            bl = true;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("*** Last allocated message num for sequence " + this.getId() + " increased to " + this._lastAllocatedMessageNum);
            }
            sequenceHeader.setMessageNumber(this._lastAllocatedMessageNum);
            long l = this._lastAllocatedMessageNum;
            return l;
        }
        finally {
            this.getMessageLock().writeLock().unlock();
            if (bl) {
                this.markChanged();
            }
        }
    }

    public boolean isComplete() {
        return this._complete;
    }

    public void setDestinationId(String string) {
        this._destinationId = string;
        this.markChanged();
    }

    public void setEndpointEpr(WSEndpointReference wSEndpointReference) {
        this._endpointEpr = wSEndpointReference;
        this.setUsingSsl(HeaderList.isUsingSsl((WSEndpointReference)wSEndpointReference));
        this.markChanged();
    }

    public void setAcksToEpr(WSEndpointReference wSEndpointReference) {
        this._acksToEpr = wSEndpointReference;
        this.markChanged();
    }

    public void setOffer(DestinationOfferSequence destinationOfferSequence) {
        this._offerSequenceId = destinationOfferSequence != null ? destinationOfferSequence.getId() : null;
        this.markChanged();
    }

    void setComplete(boolean bl) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Marking sequence COMPLETE: " + this);
        }
        this._complete = bl;
        this.markChanged();
    }

    public PersistentRequestContext getFirstRequestContext() {
        return this._firstRequestContext;
    }

    public SenderDispatchFactory.Key getSenderDispatchKey() {
        return this._senderDispatchKey;
    }

    public void setSenderDispatchKey(SenderDispatchFactory.Key key) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Setting sender dispatch key to '" + key + "' for seq: " + this);
        }
        this._senderDispatchKey = key;
        this.markChanged();
    }

    public ClientInstanceIdentity getCreatingClientInstanceId() {
        return this._creatingClientInstanceId;
    }

    public void setCreatingClientInstanceId(ClientInstanceIdentity clientInstanceIdentity) {
        this._creatingClientInstanceId = clientInstanceIdentity;
    }

    public Duration getBaseRetransmissionInterval() {
        return this._baseRetransmissionInterval;
    }

    public void setBaseRetransmissionInterval(Duration duration) {
        this._baseRetransmissionInterval = duration;
        this.initAckRequestDelayCalculator();
        this.markChanged();
    }

    private void initAckRequestDelayCalculator() {
        long l = this._baseRetransmissionInterval.getTimeInMillis(new Date());
        long l2 = (l *= 3L) << 10;
        long l3 = this._exponentialBackoffEnabled ? 2L : 1L;
        this._ackRequestDelayCalculator = new RetryDelayCalculator(l, l2, l3);
    }

    public boolean isExponentialBackoffEnabled() {
        return this._exponentialBackoffEnabled;
    }

    public void setExponentialBackoffEnabled(boolean bl) {
        this._exponentialBackoffEnabled = bl;
        this.initAckRequestDelayCalculator();
        this.markChanged();
    }

    @Override
    protected void handleMasterInstanceChange(boolean bl, boolean bl2) {
        if (bl && !bl2) {
            this.stopListening();
            this.cancelAckTimer();
        } else if (bl2 && !bl) {
            this.startListening();
            this.resetAckTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAckTimer() {
        try {
            this.getMessageLock().writeLock().lock();
            if (this._ackTimer != null) {
                this._ackTimer.cancel();
                this._ackTimer = null;
            }
        }
        finally {
            this.getMessageLock().writeLock().unlock();
        }
    }

    private void startListening() {
        this.startListeningOnDispatchKey();
    }

    private void stopListening() {
        this.stopListeningOnDispatchKey();
    }

    private void startListeningOnDispatchKey() {
        if (this._senderDispatchKey != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("SourceSequence " + this + " starting listen on dispatch key: " + this._senderDispatchKey);
            }
            this._senderDispatchKey.addLifecycleListener(this);
        }
    }

    private void stopListeningOnDispatchKey() {
        if (this._senderDispatchKey != null) {
            this._senderDispatchKey.removeLifecycleListener(this);
        }
    }

    @Override
    public void onDispatchFactoryDispose(DispatchFactory dispatchFactory) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(this.getClass().getName() + " " + this.getId() + " detected its DispatchFactory key is being disposed. Making any necessary ack requests before the key becomes invalid");
        }
        if (this.getUnackdCount() > 0L) {
            try {
                this.deliverAckRequest();
            }
            catch (Exception exception) {
                WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            }
        }
        this._senderDispatchKey.removeLifecycleListener(this);
        this.setSenderDispatchKey(null);
    }

    @Override
    protected void setUnackedCount(long l) {
        super.setUnackedCount(l);
        this.resetAckTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startup() {
        SequenceState sequenceState = this.getState();
        try {
            this.getMessageLock().writeLock().lock();
            if (LOGGER.isLoggable(Level.FINE)) {
                long l = this.getUnackdCount();
                LOGGER.fine("Starting up " + this + " in state " + (Object)((Object)sequenceState) + (l > 0L ? " WITH " + l + " UNACK'D REQUESTS" : ""));
            }
            super.startup();
            this.resetAckTimer();
        }
        finally {
            this.getMessageLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        SequenceState sequenceState = this.getState();
        try {
            this.getMessageLock().writeLock().lock();
            if (LOGGER.isLoggable(Level.FINE)) {
                long l = this.getUnackdCount();
                LOGGER.fine("Shutting down " + this + " in state " + (Object)((Object)sequenceState) + (l > 0L ? " WITH " + l + " UNACK'D REQUESTS" : ""));
            }
            this.cancelAckTimer();
            super.shutdown();
        }
        finally {
            this.getMessageLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAckTimer() {
        try {
            SequenceState sequenceState = this.getState();
            this.getMessageLock().writeLock().lock();
            if (sequenceState != SequenceState.CREATING && sequenceState != SequenceState.CREATED) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Aborting request to reset ack request timer for sequence " + this + " to endpoint " + this._endpointEpr + " using dispatch key: " + this._senderDispatchKey + " because the sequence is not ready (state=" + (Object)((Object)sequenceState) + ")");
                }
                return;
            }
            if (this._timerMgr == null) {
                TimerManagerFactory timerManagerFactory = TimerManagerFactory.getTimerManagerFactory();
                this._timerMgr = timerManagerFactory.getDefaultTimerManager();
            }
            long l = this.getUnackdCount();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Found unack'd request count for source sequence " + this + " as: " + l);
            }
            boolean bl = l > 0L;
            this.cancelAckTimer();
            if (bl) {
                if (this._endpointEpr != null && !this._endpointEpr.isAnonymous()) {
                    this.scheduleAckTimer();
                } else if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Cancelling ack request timer (anonymous endpoint EPR)");
                }
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Cancelled ack request timer (no unack'd requests) for sequence: " + this.getId());
            }
        }
        finally {
            this.getMessageLock().writeLock().unlock();
        }
    }

    private void scheduleAckTimer() {
        long l = this._ackRequestDelayCalculator.getNextRetryDelayMillis();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Scheduling ack request timer (" + l + " ms timer) for sequence: " + this.getId());
        }
        this._ackTimer = this._timerMgr.schedule(new TimerListener(){

            public void timerExpired(Timer timer) {
                try {
                    final WorkManager workManager = WorkManagerFactory.getInstance().getSystem();
                    workManager.schedule(new Runnable(){

                        public void run() {
                            block3: {
                                try {
                                    SourceSequence.this.deliverAckRequest();
                                }
                                catch (Exception exception) {
                                    if (LOGGER.isLoggable(Level.FINE)) {
                                        LOGGER.fine("Failed to deliver ack request message: " + exception.toString());
                                        LOGGER.log(Level.FINE, exception.toString(), exception);
                                    }
                                    if (!WsrmExceptionUtil.isPermanentSendFailure(exception)) break block3;
                                    WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                                }
                            }
                            workManager.schedule(new Runnable(){

                                public void run() {
                                    SourceSequence.this.resetAckTimer();
                                }
                            });
                        }
                    });
                }
                catch (Exception exception) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Failed to deliver ack request message: " + exception.toString());
                        LOGGER.log(Level.FINE, exception.toString(), exception);
                    }
                    WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                }
            }
        }, l);
    }

    private void deliverAckRequest() throws Exception {
        SequenceState sequenceState;
        if ((this._endpointEpr == null || this._endpointEpr.isAnonymous()) && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Aborting request to send ack request message for sequence " + this + " because the target endpoint is anonymous");
        }
        if (((sequenceState = this.getState()) == SequenceState.CREATED || sequenceState == SequenceState.CLOSING || sequenceState == SequenceState.CLOSED) && this.getDestinationId() != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Sending ack request message for sequence " + this + " dest ID: " + this.getDestinationId() + " to endpoint " + this._endpointEpr + " using dispatch key: " + this._senderDispatchKey);
            }
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Aborting request to send ack request message for sequence " + this + " to endpoint " + this._endpointEpr + " using dispatch key: " + this._senderDispatchKey + " because the sequence is not ready (state=" + (Object)((Object)sequenceState) + ")");
            }
            return;
        }
        if (this._senderDispatchKey != null) {
            DispatchFactory dispatchFactory;
            try {
                dispatchFactory = this._senderDispatchKey.resolve();
            }
            catch (DispatchFactoryNotReadyException dispatchFactoryNotReadyException) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(dispatchFactoryNotReadyException.toString());
                }
                return;
            }
            String string = WsrmConstants.Action.ACK_REQUESTED.getActionURI(this.getRmVersion());
            Message message = WsUtil.createEmptyMessage(string, this._endpointEpr.getVersion(), this.getSoapVersion());
            AckRequestedHeader ackRequestedHeader = new AckRequestedHeader(this.getRmVersion());
            ackRequestedHeader.setSequenceId(this.getDestinationId());
            message.getHeaders().addOrReplace((Header)ackRequestedHeader);
            Sender sender = new Sender(dispatchFactory);
            Map<String, Object> map = SourceSequenceManager.getInstance().getSenderInvokeProperties(this, (Packet)null);
            sender.send(message, string, this._endpointEpr, this._acksToEpr, map);
        }
    }
}

