/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.sequence;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import weblogic.jws.jaxws.client.async.AsyncClientHandlerFeature;
import weblogic.store.PersistentStoreException;
import weblogic.wsee.WseeRmLogger;
import weblogic.wsee.jaxws.client.async.AsyncClientHandlerMarkerFeature;
import weblogic.wsee.reliability.MessageRange;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.WsrmPermanentTransportException;
import weblogic.wsee.reliability.faults.SequenceTerminatedFaultMsg;
import weblogic.wsee.reliability.faults.UnknownSequenceFaultMsg;
import weblogic.wsee.reliability.faults.WsrmFaultMsg;
import weblogic.wsee.reliability.headers.AcknowledgementHeader;
import weblogic.wsee.reliability.headers.SequenceHeader;
import weblogic.wsee.reliability2.api.SequenceState;
import weblogic.wsee.reliability2.api_internal.WsrmLifecycleEvent;
import weblogic.wsee.reliability2.api_internal.WsrmLifecycleEventListenerRegistry;
import weblogic.wsee.reliability2.exception.WsrmException;
import weblogic.wsee.reliability2.property.WsrmInvocationPropertyBag;
import weblogic.wsee.reliability2.property.WsrmPropertyBag;
import weblogic.wsee.reliability2.sequence.DestinationMessageInfo;
import weblogic.wsee.reliability2.sequence.DestinationSequence;
import weblogic.wsee.reliability2.sequence.DestinationSequenceManager;
import weblogic.wsee.reliability2.sequence.SequenceManager;
import weblogic.wsee.reliability2.sequence.SourceMessageInfo;
import weblogic.wsee.reliability2.sequence.SourceOfferSequence;
import weblogic.wsee.reliability2.sequence.SourceSequence;
import weblogic.wsee.reliability2.sequence.UnknownSequenceException;
import weblogic.wsee.reliability2.sequence.UnknownSourceSequenceException;
import weblogic.wsee.reliability2.store.SourceSequenceMap;
import weblogic.wsee.reliability2.store.TimedSequenceMap;
import weblogic.wsee.reliability2.tube.DispatchFactory;
import weblogic.wsee.reliability2.tube.DispatchFactoryNotReadyException;
import weblogic.wsee.reliability2.tube.WsrmTubeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceSequenceManager
extends SequenceManager<SourceSequence>
implements TimedSequenceMap.SequenceTimerListener {
    private static final Logger LOGGER = Logger.getLogger(SourceSequenceManager.class.getName());
    private static SourceSequenceManager _instance;
    private Map<String, SourceSequence> _destSeqIdToSeqMap;
    private ReentrantReadWriteLock _mapLock = new ReentrantReadWriteLock(false);

    public static SourceSequenceManager getInstance() {
        return _instance;
    }

    private SourceSequenceManager() throws PersistentStoreException, NamingException, WsrmException {
        super(new SourceSequenceMap());
        this._destSeqIdToSeqMap = new HashMap<String, SourceSequence>();
        this.recoverMap();
    }

    @Override
    protected void recoverMap() throws WsrmException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("SourceSequenceManager recovering source sequences now");
        }
        ((TimedSequenceMap)this._seqIdToSeqMap).setSequenceTimerListener(this);
        super.recoverMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleSequenceActiveChange(SourceSequence sourceSequence, boolean bl, boolean bl2) {
        if (bl && !bl2) {
            if (sourceSequence.getDestinationId() != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Seq Deactivation. Removing mapping of dest seq ID " + sourceSequence.getDestinationId() + " to seq " + sourceSequence.getId());
                }
                try {
                    this._mapLock.writeLock().lock();
                    this._destSeqIdToSeqMap.remove(sourceSequence.getDestinationId());
                }
                finally {
                    this._mapLock.writeLock().unlock();
                }
            }
        } else if (!bl && bl2 && sourceSequence.getDestinationId() != null && !sourceSequence.getDestinationId().equals(sourceSequence.getId())) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Seq Activation. Adding mapping for dest seq ID " + sourceSequence.getDestinationId() + " to seq " + sourceSequence.getId());
            }
            try {
                this._mapLock.writeLock().lock();
                this._destSeqIdToSeqMap.put(sourceSequence.getDestinationId(), sourceSequence);
            }
            finally {
                this._mapLock.writeLock().unlock();
            }
        }
        super.handleSequenceActiveChange(sourceSequence, bl, bl2);
    }

    @Override
    public void sequenceExpiration(String string) {
        SourceSequence sourceSequence = (SourceSequence)this.getSequence(WsrmConstants.RMVersion.latest(), string);
        if (sourceSequence == null) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("** SourceSequence reached its maximum lifetime. Seq id: " + string);
        }
        this.terminateSequence(string);
    }

    @Override
    public void idleTimeout(String string) {
        SourceSequence sourceSequence = (SourceSequence)this.getSequence(WsrmConstants.RMVersion.latest(), string);
        if (sourceSequence == null) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("** SourceSequence timed out on idle timeout. Seq id: " + string);
        }
        this.terminateSequence(string);
    }

    public void terminateSequence(String string) {
        try {
            SourceSequence sourceSequence = this.getSequence(WsrmConstants.RMVersion.latest(), string, false);
            if (sourceSequence.getSenderDispatchKey() == null) {
                throw new WsrmPermanentTransportException("No WS-RM SAF Dispatch Factory key found in SourceSequence");
            }
            DispatchFactory dispatchFactory = sourceSequence.getSenderDispatchKey().resolve();
            WsrmTubeUtils.sendTerminateSequence(sourceSequence, dispatchFactory);
        }
        catch (DispatchFactoryNotReadyException dispatchFactoryNotReadyException) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(dispatchFactoryNotReadyException.toString());
            }
        }
        catch (Exception exception) {
            WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
        }
    }

    @Override
    public void handleRmFault(WsrmFaultMsg wsrmFaultMsg) {
        try {
            SourceSequence sourceSequence;
            String string = null;
            boolean bl = false;
            if (wsrmFaultMsg instanceof SequenceTerminatedFaultMsg) {
                bl = true;
                string = ((SequenceTerminatedFaultMsg)wsrmFaultMsg).getSequenceId();
            }
            if (wsrmFaultMsg instanceof UnknownSequenceFaultMsg) {
                bl = true;
                string = ((UnknownSequenceFaultMsg)wsrmFaultMsg).getSequenceId();
            }
            if (bl && (sourceSequence = this.getSequence(wsrmFaultMsg.getRmVersion(), string, true)) != null && sourceSequence.getState() != SequenceState.TERMINATING && sourceSequence.getState() != SequenceState.TERMINATED) {
                this.terminateSequence(string);
            }
        }
        catch (Exception exception) {
            WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAck(AcknowledgementHeader acknowledgementHeader, SourceSequence sourceSequence) throws WsrmException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Handling ack header on sequence " + sourceSequence.getId() + ". Ack header toString() is: " + acknowledgementHeader);
        }
        if (sourceSequence instanceof SourceOfferSequence) {
            WsrmLifecycleEventListenerRegistry.getInstance().notifyEventType(WsrmLifecycleEvent.Type.SERV_OUT_FOUND_ACK);
        } else {
            WsrmLifecycleEventListenerRegistry.getInstance().notifyEventType(WsrmLifecycleEvent.Type.CLIENT_OUT_FOUND_ACK);
        }
        SourceSequence sourceSequence2 = sourceSequence;
        synchronized (sourceSequence2) {
            boolean bl = false;
            if (acknowledgementHeader.getNack() > 0L) {
                SourceMessageInfo sourceMessageInfo = (SourceMessageInfo)sourceSequence.getRequest(acknowledgementHeader.getNack());
                if (sourceMessageInfo != null) {
                    sourceSequence.markMessageAckd(sourceMessageInfo, false);
                }
                bl = this.syncUpWithAcks(sourceSequence);
            } else if (!acknowledgementHeader.getNone()) {
                SortedSet<MessageRange> sortedSet = acknowledgementHeader.getAcknowledgementRanges();
                bl = this.syncUpWithAcks(sourceSequence, sortedSet);
            }
            if (bl) {
                this.updateSequence(sourceSequence);
            }
        }
    }

    public boolean syncUpWithAcks(SourceSequence sourceSequence) {
        return this.syncUpWithAcks(sourceSequence, sourceSequence.getAckRanges());
    }

    public boolean syncUpWithAcks(SourceSequence sourceSequence, SortedSet<MessageRange> sortedSet) {
        boolean bl = false;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Sync'ing up with acks on seq: " + sourceSequence);
        }
        ArrayList<Gap> arrayList = new ArrayList<Gap>();
        MessageRange messageRange = null;
        for (MessageRange messageRange2 : sortedSet) {
            for (long i = messageRange2.lowerBounds; i <= messageRange2.upperBounds; ++i) {
                SourceMessageInfo sourceMessageInfo = (SourceMessageInfo)sourceSequence.getRequest(i);
                if (sourceMessageInfo == null) continue;
                bl |= sourceSequence.markMessageAckd(sourceMessageInfo, true);
            }
            if (messageRange != null && messageRange2.lowerBounds > messageRange.upperBounds) {
                Gap gap = new Gap();
                gap.lower = messageRange.upperBounds + 1L;
                gap.upper = messageRange2.lowerBounds - 1L;
                arrayList.add(gap);
            }
            messageRange = messageRange2;
        }
        if (sourceSequence.hasFinalMessageNum() && messageRange != null && messageRange.upperBounds == sourceSequence.getFinalMessageNum() && arrayList.isEmpty() && !sourceSequence.isComplete()) {
            sourceSequence.setComplete(true);
            bl = true;
        }
        return bl;
    }

    public SourceMessageInfo processSequenceMessage(SequenceHeader sequenceHeader, Packet packet, AddressingVersion addressingVersion, SOAPVersion sOAPVersion) throws WsrmException {
        Serializable serializable;
        if (packet == null || packet.getMessage() == null) {
            throw new IllegalArgumentException("Attempt to send a sequence message with a null/empty body");
        }
        long l = sequenceHeader.getMessageNumber();
        SourceSequence sourceSequence = this.getSequence(sequenceHeader.getRmVersion(), sequenceHeader.getSequenceId(), false);
        WsrmInvocationPropertyBag wsrmInvocationPropertyBag = (WsrmInvocationPropertyBag)packet.invocationProperties.get(WsrmInvocationPropertyBag.key);
        if (wsrmInvocationPropertyBag == null) {
            wsrmInvocationPropertyBag = new WsrmInvocationPropertyBag(packet);
            packet.invocationProperties.put(WsrmInvocationPropertyBag.key, wsrmInvocationPropertyBag);
        }
        WsrmPropertyBag wsrmPropertyBag = WsrmPropertyBag.propertySetRetriever.getFromPacket(packet);
        if (wsrmInvocationPropertyBag.getFinalMsgFlag()) {
            if (sourceSequence.getRmVersion() == WsrmConstants.RMVersion.RM_10) {
                sequenceHeader.setLastMessage(true);
                sourceSequence.setFinalMessageNum(l);
            } else {
                sourceSequence.setFinalMessageNum(l);
            }
        }
        Message message = packet.getMessage();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("SourceSequenceManager processing outbound sequence message with msg id " + message.getHeaders().getMessageID(addressingVersion, sOAPVersion) + ", seq " + sequenceHeader.getSequenceId() + " and msg num " + sequenceHeader.getMessageNumber());
        }
        String string = message.getHeaders().getMessageID(addressingVersion, sOAPVersion);
        String string2 = message.getHeaders().getAction(addressingVersion, sOAPVersion);
        SourceMessageInfo sourceMessageInfo = new SourceMessageInfo(sourceSequence.getId(), string, l, string2);
        Packet packet2 = packet.copy(false);
        packet2.setMessage(packet.getMessage());
        packet2.soapAction = packet.soapAction;
        sourceMessageInfo.setRequestPacket(packet2);
        if (!sourceSequence.isNonBuffered()) {
            boolean bl = packet.getBinding().getFeature(AsyncClientHandlerFeature.class) != null || packet.getBinding().getFeature(AsyncClientHandlerMarkerFeature.class) != null;
            serializable = new SourceMessageInfo.ClientInvokeInfo(Fiber.current(), Boolean.TRUE.equals(packet.isSynchronousMEP), Boolean.FALSE.equals(packet.expectReply), bl);
            sourceMessageInfo.setClientInvokeInfo((SourceMessageInfo.ClientInvokeInfo)serializable);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Stored ClientInvokeInfo for source msgId " + sourceMessageInfo.getMessageId() + " ClientInvokeInfo: " + sourceMessageInfo.getClientInvokeInfo());
            }
        }
        sourceSequence.addRequest(sourceMessageInfo);
        sourceMessageInfo.setRequestPacket(null);
        if (sourceSequence instanceof SourceOfferSequence) {
            DestinationMessageInfo destinationMessageInfo;
            DestinationSequence destinationSequence;
            String string3 = wsrmPropertyBag.getInboundMessageId();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("SourceSequenceManager processing response msg " + string + " as a response to reliable service-side request msg " + string3 + ". Attempting to correlate them in sequence state");
            }
            if ((destinationSequence = ((SourceOfferSequence)(serializable = (SourceOfferSequence)sourceSequence)).getMainSequence()) != null) {
                destinationMessageInfo = (DestinationMessageInfo)destinationSequence.getRequestByMessageId(string3);
                destinationMessageInfo.setResponseMsgNum(l);
                DestinationSequenceManager.getInstance().updateSequence(destinationSequence);
            }
            destinationMessageInfo = wsrmPropertyBag.getDestMessageInfoFromRequest();
            if (sourceSequence.getRmVersion() == WsrmConstants.RMVersion.RM_10 && destinationMessageInfo.isLastMessage()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("** SourceSequenceManager found it is sending a response on sequence " + sourceSequence.getId() + " to the 'last' message on the request sequence " + ((SourceOfferSequence)serializable).getMainSequenceId() + ". Marking this response 'last' too");
                }
                sequenceHeader.setLastMessage(true);
                sourceSequence.setFinalMessageNum(l);
            }
        }
        this.updateSequence(sourceSequence);
        return sourceMessageInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSequence(SourceSequence sourceSequence) throws UnknownSourceSequenceException {
        try {
            super.updateSequence(sourceSequence);
        }
        catch (UnknownSequenceException unknownSequenceException) {
            throw new UnknownSourceSequenceException(unknownSequenceException);
        }
        if (sourceSequence.getDestinationId() != null && !sourceSequence.getDestinationId().equals(sourceSequence.getId())) {
            try {
                this._mapLock.writeLock().lock();
                this._destSeqIdToSeqMap.put(sourceSequence.getDestinationId(), sourceSequence);
            }
            finally {
                this._mapLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SourceSequence getSequence(WsrmConstants.RMVersion rMVersion, String string, boolean bl) throws UnknownSourceSequenceException {
        SourceSequence sourceSequence = null;
        try {
            sourceSequence = (SourceSequence)super.getSequence(rMVersion, string, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (sourceSequence == null) {
            try {
                this._mapLock.readLock().lock();
                sourceSequence = this._destSeqIdToSeqMap.get(string);
            }
            finally {
                this._mapLock.readLock().unlock();
            }
        }
        if (sourceSequence == null && !bl) {
            throw new UnknownSourceSequenceException(rMVersion, string);
        }
        return sourceSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSequence(SourceSequence sourceSequence) {
        if (sourceSequence.getDestinationId() != null) {
            try {
                this._mapLock.writeLock().lock();
                this._destSeqIdToSeqMap.remove(sourceSequence.getDestinationId());
            }
            finally {
                this._mapLock.writeLock().unlock();
            }
        }
        super.removeSequence(sourceSequence);
    }

    @Override
    public Map<String, Object> getSenderInvokeProperties(SourceSequence sourceSequence, Packet packet) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        sourceSequence.getFirstRequestContext().loadRequestContext(hashMap);
        Map<String, Object> map = super.getSenderInvokeProperties(sourceSequence, packet);
        HashMap hashMap2 = new HashMap();
        for (String string : hashMap.keySet()) {
            if (map.containsKey(string)) continue;
            hashMap2.put(string, hashMap.get(string));
        }
        map.putAll(hashMap2);
        return map;
    }

    static {
        try {
            _instance = new SourceSequenceManager();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString(), exception);
        }
    }

    private static class Gap {
        long lower;
        long upper;

        private Gap() {
        }
    }
}

